<!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php wp_title('-','true','right'); bloginfo('name'); ?></title>
    <link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/assets/css/all.css">
    <link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/assets/css/swiper-bundle.min.css">
    <link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/assets/css/bootstrap.rtl.min.css">
    <link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/assets/fonts/iranyekan.css">
    <link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/assets/fonts/dana/dana.css">
    <link rel="icon" href="<?php bloginfo('template_url'); ?>/assets/images/icon.png">
    <link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/style.css">
    <link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/assets/css/style.css">
    <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>

<div class="error-404-container">
    <!-- Decorative elements -->
    <div class="error-404-decoration"></div>
    <div class="error-404-decoration"></div>
    <div class="error-404-decoration"></div>
    <div class="error-404-decoration"></div>
    
    <div class="error-404-content">
        <div class="error-404-image">
            <img src="<?php echo esc_url(get_theme_mod('skill_404_image', get_template_directory_uri() . '/assets/images/404.png')); ?>" alt="404 Error" class="error-image">
        </div>
        
        <div class="error-404-text">
            <h1 class="error-404-title"><?php echo get_theme_mod('skill_404_title', __('متاسفانه صفحه مورد نظر یافت نشد!', 'skill')); ?></h1>
            <p class="error-404-subtitle"><?php echo get_theme_mod('skill_404_subtitle', __('صفحه‌ای که به دنبال آن هستید وجود ندارد یا منتقل شده است.', 'skill')); ?></p>
        </div>
        
        <a href="<?php echo esc_url(home_url('/')); ?>" class="error-404-button">
            <?php echo get_theme_mod('skill_404_button_text', __('بازگشت به صفحه اصلی', 'skill')); ?>
        </a>
    </div>
</div>