<?php
/**
 * Template for displaying project archive
 * 
 * @package Skill
 */

get_header(); ?>

<div class="container">
    <div class="row">
        <div class="col-12">
            <header class="page-header">
                <h1 class="page-title"><?php _e('پروژه های من', 'skill'); ?></h1>
                <?php if (get_the_archive_description()): ?>
                    <div class="archive-description">
                        <?php the_archive_description(); ?>
                    </div>
                <?php endif; ?>
            </header>

            <?php if (have_posts()): ?>
                <div class="projects-grid">
                    <?php while (have_posts()): the_post(); ?>
                        <article id="post-<?php the_ID(); ?>" <?php post_class('project-card'); ?>>
                            
                            <!-- Project Thumbnail -->
                            <?php if (has_post_thumbnail()): ?>
                                <div class="project-thumbnail">
                                    <a href="<?php the_permalink(); ?>">
                                        <?php the_post_thumbnail('medium', array('class' => 'project-image')); ?>
                                    </a>
                                </div>
                            <?php endif; ?>

                            <!-- Project Content -->
                            <div class="project-content">
                                <h2 class="project-title">
                                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                </h2>

                                <!-- Project Excerpt -->
                                <div class="project-excerpt">
                                    <?php the_excerpt(); ?>
                                </div>

                                <!-- Project Meta Information -->
                                <?php
                                $project_meta = skill_get_project_meta();
                                if ($project_meta['client_name'] || $project_meta['project_status'] || $project_meta['technologies']):
                                ?>
                                    <div class="project-meta">
                                        <?php if ($project_meta['client_name']): ?>
                                            <span class="meta-item">
                                                <i class="fas fa-user-tie"></i>
                                                <?php echo esc_html($project_meta['client_name']); ?>
                                            </span>
                                        <?php endif; ?>

                                        <?php if ($project_meta['project_status']): ?>
                                            <span class="meta-item status-<?php echo esc_attr($project_meta['project_status']); ?>">
                                                <i class="fas fa-circle"></i>
                                                <?php echo skill_get_project_status_label($project_meta['project_status']); ?>
                                            </span>
                                        <?php endif; ?>

                                        <?php if ($project_meta['start_number'] && $project_meta['end_number']): ?>
                                            <span class="meta-item">
                                                <i class="fas fa-calendar"></i>
                                                <?php echo esc_html($project_meta['start_number']); ?> - <?php echo esc_html($project_meta['end_number']); ?>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>

                                <!-- Technologies Preview -->
                                <?php if ($project_meta['technologies']): ?>
                                    <div class="project-technologies">
                                        <?php
                                        $tech_array = array_map('trim', explode(',', $project_meta['technologies']));
                                        $tech_count = 0;
                                        foreach ($tech_array as $tech):
                                            if ($tech_count < 3): // Show only first 3 technologies
                                        ?>
                                            <span class="tech-tag"><?php echo esc_html($tech); ?></span>
                                        <?php
                                            endif;
                                            $tech_count++;
                                        endforeach;
                                        if (count($tech_array) > 3):
                                        ?>
                                            <span class="tech-tag more">+<?php echo count($tech_array) - 3; ?> <?php _e('بیشتر', 'skill'); ?></span>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>

                                <!-- Project Links Preview -->
                                <?php if ($project_meta['live_url'] || $project_meta['github_url']): ?>
                                    <div class="project-links-preview">
                                        <?php if ($project_meta['live_url']): ?>
                                            <a href="<?php echo esc_url($project_meta['live_url']); ?>" class="project-link-preview live" target="_blank">
                                                <i class="fas fa-external-link-alt"></i>
                                                <?php _e('مشاهده', 'skill'); ?>
                                            </a>
                                        <?php endif; ?>
                                        
                                        <?php if ($project_meta['github_url']): ?>
                                            <a href="<?php echo esc_url($project_meta['github_url']); ?>" class="project-link-preview github" target="_blank">
                                                <i class="fab fa-github"></i>
                                                <?php _e('کد', 'skill'); ?>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>

                                <!-- Read More Link -->
                                <div class="project-readmore">
                                    <a href="<?php the_permalink(); ?>" class="readmore-link">
                                        <?php _e('مشاهده جزئیات', 'skill'); ?>
                                        <i class="fas fa-arrow-left"></i>
                                    </a>
                                </div>
                            </div>
                        </article>
                    <?php endwhile; ?>
                </div>

                <!-- Pagination -->
                <?php
                the_posts_pagination(array(
                    'mid_size' => 2,
                    'prev_text' => '<i class="fas fa-chevron-right"></i> ' . __('قبلی', 'skill'),
                    'next_text' => __('بعدی', 'skill') . ' <i class="fas fa-chevron-left"></i>',
                ));
                ?>

            <?php else: ?>
                <div class="no-projects">
                    <h2><?php _e('پروژه‌ای یافت نشد', 'skill'); ?></h2>
                    <p><?php _e('در حال حاضر هیچ پروژه‌ای در این دسته‌بندی وجود ندارد.', 'skill'); ?></p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php get_footer(); ?> 