<?php

class skill_box_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'skill_box_Widget';
    }

    public function get_title() {
        return esc_html__('کارهایی که من انجام میدم', 'skill');
    }

    public function get_icon() {
        return 'eicon-icon-box';
    }

    public function get_categories() {
        return ['skill-category'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('محتوا', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'columns',
            [
                'label' => esc_html__('تعداد ستون‌ها', 'skill'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '2',
                'options' => [
                    '2' => esc_html__('2 ستون', 'skill'),
                    '3' => esc_html__('3 ستون', 'skill'),
                ],
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'icon_type',
            [
                'label' => esc_html__('نوع آیکون', 'skill'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'library',
                'options' => [
                    'library' => esc_html__('کتابخانه آیکون', 'skill'),
                    'image' => esc_html__('تصویر (PNG/SVG)', 'skill'),
                ],
            ]
        );

        $repeater->add_control(
            'skill_icon',
            [
                'label' => esc_html__('آیکون', 'skill'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
                'condition' => [ 'icon_type' => 'library' ],
            ]
        );

        $repeater->add_control(
            'skill_icon_image',
            [
                'label' => esc_html__('تصویر آیکون', 'skill'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [ 'url' => '' ],
                'condition' => [ 'icon_type' => 'image' ],
            ]
        );

        $repeater->add_control(
            'skill_title',
            [
                'label' => esc_html__('عنوان مهارت', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('عنوان مهارت', 'skill'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'skill_description',
            [
                'label' => esc_html__('توضیحات', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.', 'skill'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'skills_list',
            [
                'label' => esc_html__('لیست مهارت‌ها', 'skill'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'skill_title' => esc_html__('طراحی قالب', 'skill'),
                        'skill_icon' => [
                            'value' => 'fab fa-html5',
                            'library' => 'fa-brands',
                        ],
                        'skill_description' => esc_html__('لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.', 'skill'),
                    ],
                    [
                        'skill_title' => esc_html__('برنامه نویسی', 'skill'),
                        'skill_icon' => [
                            'value' => 'fab fa-php',
                            'library' => 'fa-brands',
                        ],
                        'skill_description' => esc_html__('لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.', 'skill'),
                    ],
                ],
                'title_field' => '{{{ skill_title }}}',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('استایل', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'box_bg_color',
            [
                'label' => esc_html__('رنگ پس‌زمینه', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .skill_box' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('رنگ آیکون', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .skill_box .elementor-icon i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .skill_box .elementor-icon svg' => 'fill: {{VALUE}}',
                    '{{WRAPPER}} .skill_box i' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .skill_box h5' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label' => esc_html__('رنگ متن', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .skill_box p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'description_text_align',
            [
                'label' => esc_html__('تراز متن توضیحات', 'skill'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('چپ', 'skill'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('وسط', 'skill'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('راست', 'skill'),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__('چند سطری (Justify)', 'skill'),
                        'icon' => 'eicon-text-align-justify',
                    ],
                ],
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .skill_box p' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => esc_html__('تایپوگرافی عنوان', 'skill'),
                'selector' => '{{WRAPPER}} .skill_box h5',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'text_typography',
                'label' => esc_html__('تایپوگرافی متن', 'skill'),
                'selector' => '{{WRAPPER}} .skill_box p',
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => esc_html__('اندازه آیکون', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 200,
                        'step' => 1,
                    ],
                    'em' => [
                        'min' => 0.5,
                        'max' => 10,
                        'step' => 0.1,
                    ],
                    'rem' => [
                        'min' => 0.5,
                        'max' => 10,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 40,
                ],
                'selectors' => [
                    '{{WRAPPER}} .skill_box .elementor-icon' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .skill_box i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_padding',
            [
                'label' => esc_html__('حاشیه داخلی', 'skill'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .skill_box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_margin',
            [
                'label' => esc_html__('فاصله بین بلوک‌ها', 'skill'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .skill_boxs' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'box_border',
                'selector' => '{{WRAPPER}} .skill_box',
            ]
        );

        $this->add_control(
            'box_border_radius',
            [
                'label' => esc_html__('گردی گوشه‌ها', 'skill'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .skill_box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .skill_box',
            ]
        );

        // Hover gradient controls
        $this->add_control(
            'hover_gradient_enable',
            [
                'label' => esc_html__('گرادیانت روی هاور', 'skill'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'skill'),
                'label_off' => esc_html__('خیر', 'skill'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'hover_gradient_color_1',
            [
                'label' => esc_html__('رنگ گرادیانت 1', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#7c3aed',
                'condition' => [ 'hover_gradient_enable' => 'yes' ],
            ]
        );

        $this->add_control(
            'hover_gradient_color_2',
            [
                'label' => esc_html__('رنگ گرادیانت 2', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#6a11cb',
                'condition' => [ 'hover_gradient_enable' => 'yes' ],
            ]
        );

        $this->add_control(
            'hover_gradient_color_3',
            [
                'label' => esc_html__('رنگ گرادیانت 3', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#3b82f6',
                'condition' => [ 'hover_gradient_enable' => 'yes' ],
            ]
        );

        $this->add_control(
            'hover_gradient_angle',
            [
                'label' => esc_html__('زاویه گرادیانت', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['deg'],
                'range' => [ 'deg' => [ 'min' => 0, 'max' => 360 ] ],
                'default' => [ 'size' => 135, 'unit' => 'deg' ],
                'condition' => [ 'hover_gradient_enable' => 'yes' ],
            ]
        );

        // Icon badge options
        $this->add_control(
            'icon_badge_bg',
            [
                'label' => esc_html__('پس‌زمینه بیج آیکون', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .skill_box .skill_icon-wrap' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_badge_size',
            [
                'label' => esc_html__('اندازه بیج آیکون', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [ 'px' => [ 'min' => 40, 'max' => 120, 'step' => 1 ] ],
                'default' => [ 'size' => 64, 'unit' => 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .skill_box .skill_icon-wrap' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $columns = isset($settings['columns']) ? $settings['columns'] : '2';

        $column_classes = [
            '1' => 'col-12',
            '2' => 'col-md-6 col-12',
            '3' => 'col-md-4 col-12',
            '4' => 'col-md-3 col-12',
        ];

        $widget_id = $this->get_id();
        $g1 = !empty($settings['hover_gradient_color_1']) ? $settings['hover_gradient_color_1'] : '#7c3aed';
        $g2 = !empty($settings['hover_gradient_color_2']) ? $settings['hover_gradient_color_2'] : '#6a11cb';
        $g3 = !empty($settings['hover_gradient_color_3']) ? $settings['hover_gradient_color_3'] : '#3b82f6';
        $angle = isset($settings['hover_gradient_angle']['size']) ? $settings['hover_gradient_angle']['size'] : 135;
        $enable_grad = isset($settings['hover_gradient_enable']) ? $settings['hover_gradient_enable'] === 'yes' : true;

        // Scoped styles to match the provided design with dynamic controls
        echo '<style>
        #elementor-element-' . esc_attr($widget_id) . ' .skill_box {background:#ffffff;border-radius:22px;padding:28px;box-shadow:0 10px 30px rgba(16,24,40,.06);transition:transform .35s ease, box-shadow .35s ease, background .35s ease;position:relative;overflow:hidden;}
        #elementor-element-' . esc_attr($widget_id) . ' .skill_box:hover {transform:translateY(-6px);box-shadow:0 16px 50px rgba(16,24,40,.14);' . ( $enable_grad ? 'background-image:linear-gradient(' . esc_attr($angle) . 'deg,' . esc_attr($g1) . ' 0%,' . esc_attr($g2) . ' 38%,' . esc_attr($g3) . ' 100%);' : '' ) . '}
        #elementor-element-' . esc_attr($widget_id) . ' .skill_box .skill_icon-wrap {display:inline-flex;align-items:center;justify-content:center;width:' . ( isset($settings['icon_badge_size']['size']) ? esc_attr($settings['icon_badge_size']['size']) : 64 ) . 'px;height:' . ( isset($settings['icon_badge_size']['size']) ? esc_attr($settings['icon_badge_size']['size']) : 64 ) . 'px;border-radius:50%;background:' . ( !empty($settings['icon_badge_bg']) ? esc_attr($settings['icon_badge_bg']) : '#ffffff' ) . ';box-shadow:0 6px 20px rgba(16,24,40,.12);}        
        #elementor-element-' . esc_attr($widget_id) . ' .skill_box .elementor-icon {font-size:36px;line-height:1;color:#6a11cb;}
        #elementor-element-' . esc_attr($widget_id) . ' .skill_box .skill_head{display:flex;align-items:center;gap:12px;}
        #elementor-element-' . esc_attr($widget_id) . ' .skill_box .skill_head h5{margin:0;}
        #elementor-element-' . esc_attr($widget_id) . ' .skill_box h5 {margin:16px 0 6px;color:#0f172a;transition:color .35s ease}
        #elementor-element-' . esc_attr($widget_id) . ' .skill_box p {margin:0;color:#475569;transition:color .35s ease}
        #elementor-element-' . esc_attr($widget_id) . ' .skill_box:hover h5,
        #elementor-element-' . esc_attr($widget_id) . ' .skill_box:hover p {color:#ffffff}
        </style>';

        echo '<div class="row">';

        if ($settings['skills_list']) {
            foreach ($settings['skills_list'] as $item) {
                echo '<div class="' . esc_attr($column_classes[$columns]) . ' skill_boxs">';
                echo '<div class="skill_box">';
                echo '<div class="skill_head">';
                echo '<span class="skill_icon-wrap">';
                if ( isset($item['icon_type']) && $item['icon_type'] === 'image' && !empty($item['skill_icon_image']['url']) ) {
                    $icon_alt = !empty($item['skill_icon_image']['id']) ? get_post_meta($item['skill_icon_image']['id'], '_wp_attachment_image_alt', true) : '';
                    $icon_alt = $icon_alt ? $icon_alt : $item['skill_title'];
                    echo '<img src="' . esc_url($item['skill_icon_image']['url']) . '" alt="' . esc_attr($icon_alt) . '" style="max-width:36px;max-height:36px;" />';
                } else {
                    echo '<span class="elementor-icon">';
                    \Elementor\Icons_Manager::render_icon($item['skill_icon'], ['aria-hidden' => 'true']);
                    echo '</span>';
                }
                echo '</span>';
                echo '<h5>' . esc_html($item['skill_title']) . '</h5>';
                echo '</div>';
                echo '<p class="mt-4">' . esc_html($item['skill_description']) . '</p>';
                echo '</div>';
                echo '</div>';
            }
        }

        echo '</div>';
    }

    protected function _content_template() {
        ?>
        <#
        var column_classes = {
        '1': 'col-12',
        '2': 'col-md-6 col-12',
        '3': 'col-md-4 col-12',
        '4': 'col-md-3 col-12'
        };
        #>
        <div class="row">
            <# _.each(settings.skills_list, function(item) { #>
            <div class="{{ column_classes[settings.columns] }} skill_boxs">
                <div class="skill_box">
                    <div class="skill_head">
                    <span class="skill_icon-wrap">
                    <# if (item.icon_type === 'image' && item.skill_icon_image && item.skill_icon_image.url) { #>
                        <img src="{{ item.skill_icon_image.url }}" alt="{{ item.skill_title }}" style="max-width:36px;max-height:36px;" />
                    <# } else { 
                        var iconHTML = elementor.helpers.renderIcon(view, item.skill_icon, { 'aria-hidden': true }, 'i', 'object' );
                        if (iconHTML.rendered) { #>
                            {{{ iconHTML.value }}}
                        <# } 
                    } #>
                    </span>
                    <h5>{{{ item.skill_title }}}</h5>
                    </div>
                    <p class="mt-4">{{{ item.skill_description }}}</p>
                </div>
            </div>
            <# }); #>
        </div>
        <?php
    }
}