<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class skill_breadcrumb_Widget extends Widget_Base {
    public function get_name() {
        return 'skill_breadcrumb';
    }

    public function get_title() {
        return __( 'بردکرامب', 'skill' );
    }

    public function get_icon() {
        return 'eicon-chevron-right';
    }

    public function get_categories() {
        return [ 'skill-category' ];
    }

    public function get_keywords() {
        return [ 'بردکرامب', 'breadcrumb', 'مسیر', 'ناوبری' ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_style',
            [
                'label' => __( 'استایل', 'skill' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'color',
            [
                'label' => __( 'رنگ متن', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .skill-breadcrumb' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'link_color',
            [
                'label' => __( 'رنگ لینک', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .skill-breadcrumb a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'separator_color',
            [
                'label' => __( 'رنگ جداکننده', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .skill-breadcrumb .separator' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'font_size',
            [
                'label' => __( 'اندازه فونت', 'skill' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'em', 'rem' ],
                'range' => [
                    'px' => [ 'min' => 10, 'max' => 40 ],
                    'em' => [ 'min' => 0.5, 'max' => 3 ],
                    'rem' => [ 'min' => 0.5, 'max' => 3 ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .skill-breadcrumb' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        echo '<nav class="skill-breadcrumb" aria-label="breadcrumb">';
        $this->render_breadcrumbs();
        echo '</nav>';
    }

    private function render_breadcrumbs() {
        $home_url = home_url('/');
        $home_text = __( 'خانه', 'skill' );
        $sep = '<span class="separator"> / </span>';
        $breadcrumbs = array();
        $breadcrumbs[] = '<a href="' . $home_url . '">' . $home_text . '</a>';

        if ( is_category() || is_single() ) {
            $category = get_the_category();
            if ( $category && isset($category[0]) ) {
                $breadcrumbs[] = '<a href="' . get_category_link( $category[0]->term_id ) . '">' . $category[0]->cat_name . '</a>';
            }
            if ( is_single() ) {
                $breadcrumbs[] = get_the_title();
            }
        } elseif ( is_page() && !is_front_page() ) {
            $parent_id  = wp_get_post_parent_id( get_the_ID() );
            $parents = array();
            while ( $parent_id ) {
                $page = get_post( $parent_id );
                $parents[] = '<a href="' . get_permalink( $page->ID ) . '">' . get_the_title( $page->ID ) . '</a>';
                $parent_id = $page->post_parent;
            }
            $parents = array_reverse( $parents );
            $breadcrumbs = array_merge( $breadcrumbs, $parents );
            $breadcrumbs[] = get_the_title();
        } elseif ( is_search() ) {
            $breadcrumbs[] = __( 'جستجو برای', 'skill' ) . ' "' . get_search_query() . '"';
        } elseif ( is_404() ) {
            $breadcrumbs[] = __( 'خطای ۴۰۴', 'skill' );
        }

        echo implode( $sep, $breadcrumbs );
    }
}