<?php
if ( ! defined( 'ABSPATH' ) ) exit;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;

class skill_button_share_Widget extends Widget_Base {

    public function get_name() {
        return 'skill_button_share';
    }

    public function get_title() {
        return __( 'دکمه اشتراک گذاری', 'skill' );
    }

    public function get_icon() {
        return 'eicon-share';
    }

    public function get_categories() {
        return [ 'skill-category' ];
    }

    public function get_keywords() {
        return [ 'اشتراک', 'share', 'social', 'شبکه اجتماعی' ];
    }

    protected function register_controls() {
        // Button settings
        $this->start_controls_section(
            'section_title',
            [
                'label' => __( 'تنظیمات دکمه', 'skill' ),
            ]
        );

        $this->add_control(
            'show_button_text',
            [
                'label' => __( 'نمایش متن دکمه', 'skill' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'button_label',
            [
                'label' => __( 'متن دکمه', 'skill' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'اشتراک گذاری', 'skill' ),
                'condition' => [
                    'show_button_text' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'button_icon',
            [
                'label' => __( 'آیکون دکمه', 'skill' ),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'library' => 'fa-solid',
                    'value' => 'fas fa-share-alt',
                ],
                'include' => [ 'fa-solid', 'fa-regular', 'fa-brands' ],
            ]
        );

        $this->add_control(
            'share_url',
            [
                'label' => __( 'لینک اشتراک‌گذاری', 'skill' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'skill' ),
                'default' => [
                    'url' => '',
                ],
            ]
        );

        $this->end_controls_section();

        // Social networks
        $this->start_controls_section(
            'section_socials',
            [
                'label' => __( 'شبکه‌های اجتماعی', 'skill' ),
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'social_type',
            [
                'label' => __( 'نوع شبکه', 'skill' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'facebook' => 'فیسبوک',
                    'linkedin' => 'لینکدین',
                    'instagram' => 'اینستاگرام',
                    'twitter' => 'توییتر',
                    'telegram' => 'تلگرام',
                ],
                'default' => 'facebook',
            ]
        );

        $this->add_control(
            'socials',
            [
                'label' => __( 'شبکه‌های اجتماعی', 'skill' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [ 'social_type' => 'facebook' ],
                    [ 'social_type' => 'linkedin' ],
                    [ 'social_type' => 'instagram' ],
                    [ 'social_type' => 'twitter' ],
                    [ 'social_type' => 'telegram' ],
                ],
                'title_field' => '{{{ social_type }}}',
            ]
        );

        $this->end_controls_section();

        // --- style ---
        $this->start_controls_section(
            'section_style',
            [
                'label' => __( 'استایل', 'skill' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'button_bg_color',
            [
                'label' => __( 'رنگ پس‌زمینه دکمه', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#080708',
                'selectors' => [
                    '{{WRAPPER}} .skill-share-toggle' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'button_text_color',
            [
                'label' => __( 'رنگ متن دکمه', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#8d8d8d',
                'selectors' => [
                    '{{WRAPPER}} .skill-share-toggle, {{WRAPPER}} .skill-share-toggle .elementor-icon, {{WRAPPER}} .skill-share-toggle .elementor-icon i, {{WRAPPER}} .skill-share-toggle .elementor-icon svg, {{WRAPPER}} .skill-share-toggle i, {{WRAPPER}} .skill-share-toggle svg, {{WRAPPER}} .skill-share-btn-icon' => 'color: {{VALUE}}; fill: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'button_border_color',
            [
                'label' => __( 'رنگ حاشیه دکمه', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#8d8d8d',
                'selectors' => [
                    '{{WRAPPER}} .skill-share-toggle' => 'border-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'social_icon_color',
            [
                'label' => __( 'رنگ آیکون شبکه‌های اجتماعی', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#8b8b8b',
                'selectors' => [
                    '{{WRAPPER}} .skill-share-socials a' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'social_icon_color_hover',
            [
                'label' => __( 'رنگ آیکون شبکه‌های اجتماعی (هاور)', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .skill-share-socials a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'share_box_bg',
            [
                'label' => __( 'پس‌زمینه باکس اشتراک‌گذاری', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => 'rgba(8,7,8,0.55)',
                'selectors' => [
                    '{{WRAPPER}} .skill-share-socials' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'copy_input_color',
            [
                'label' => __( 'رنگ متن لینک کپی', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#8b8b8b',
                'selectors' => [
                    '{{WRAPPER}} .skill-share-link input' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'copy_icon_color',
            [
                'label' => __( 'رنگ آیکون کپی', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#8b8b8b',
                'selectors' => [
                    '{{WRAPPER}} .skill-share-copy' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'copy_icon_color_hover',
            [
                'label' => __( 'رنگ آیکون کپی (هاور)', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .skill-share-copy:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        // Social media icon size
        $this->add_control(
            'social_icon_size',
            [
                'label' => __( 'سایز آیکون شبکه‌های اجتماعی', 'skill' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [ 'min' => 12, 'max' => 48 ],
                ],
                'default' => [ 'size' => 22, 'unit' => 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .skill-share-socials a' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        // Button icon size
        $this->add_control(
            'button_icon_size',
            [
                'label' => __( 'سایز آیکون دکمه', 'skill' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [ 'min' => 12, 'max' => 48 ],
                ],
                'default' => [ 'size' => 18, 'unit' => 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .skill-share-toggle .elementor-icon, {{WRAPPER}} .skill-share-toggle .elementor-icon i, {{WRAPPER}} .skill-share-toggle .elementor-icon svg, {{WRAPPER}} .skill-share-toggle i, {{WRAPPER}} .skill-share-toggle svg, {{WRAPPER}} .skill-share-btn-icon' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .skill-share-toggle svg, {{WRAPPER}} .skill-share-toggle .skill-share-btn-icon.e-font-icon-svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        // Rounded corner of the sharing box
        $this->add_control(
            'share_box_radius',
            [
                'label' => __( 'گردی گوشه باکس اشتراک‌گذاری', 'skill' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [ 'min' => 0, 'max' => 40 ],
                ],
                'default' => [ 'size' => 12, 'unit' => 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .skill-share-socials' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        // Shadowbox Sharing
        $this->add_control(
            'share_box_shadow',
            [
                'label' => __( 'سایه باکس اشتراک‌گذاری', 'skill' ),
                'type' => Controls_Manager::BOX_SHADOW,
                'selectors' => [
                    '{{WRAPPER}} .skill-share-socials' => '{{VALUE}}',
                ],
            ]
        );
        // Button text typography
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'label' => __( 'تایپوگرافی متن دکمه', 'skill' ),
                'selector' => '{{WRAPPER}} .skill-share-toggle span',
            ]
        );
        // Copy link typography
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'copy_typography',
                'label' => __( 'تایپوگرافی لینک کپی', 'skill' ),
                'selector' => '{{WRAPPER}} .skill-share-link input',
            ]
        );
        // Sharing box spacing
        $this->add_control(
            'share_box_padding',
            [
                'label' => __( 'فاصله داخلی باکس اشتراک‌گذاری', 'skill' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'default' => [
                    'top' => 18,
                    'right' => 18,
                    'bottom' => 10,
                    'left' => 18,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .skill-share-socials' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $share_url = !empty($settings['share_url']['url']) ? esc_url($settings['share_url']['url']) : get_permalink();

        // Unique ID for each widget
        $widget_id = 'skill-share-widget-' . $this->get_id();

        // Icons and links for each network
        $icons = [
            'facebook' => 'fab fa-facebook-f',
            'linkedin' => 'fab fa-linkedin-in',
            'instagram' => 'fab fa-instagram',
            'twitter' => 'fab fa-twitter',
            'telegram' => 'fab fa-telegram-plane',
        ];
        $urls = [
            'facebook' => 'https://www.facebook.com/sharer/sharer.php?u=',
            'linkedin' => 'https://www.linkedin.com/shareArticle?mini=true&url=',
            'instagram' => 'https://www.instagram.com/?url=',
            'twitter' => 'https://twitter.com/intent/tweet?url=',
            'telegram' => 'https://t.me/share/url?url=',
        ];
        ?>
        <div class="skill-share-widget" id="<?php echo esc_attr($widget_id); ?>">
            <button class="skill-share-toggle">
                <?php if ($settings['show_button_text'] === 'yes'): ?>
                    <span><?php echo esc_html($settings['button_label']); ?></span>
                <?php endif; ?>
                <?php
                if (!empty($settings['button_icon']['value'])) {
                    \Elementor\Icons_Manager::render_icon($settings['button_icon'], [
                        'aria-hidden' => 'true',
                        'class' => 'skill-share-btn-icon'
                    ]);
                }
                ?>
            </button>
            <div class="skill-share-socials">
                <div class="skill-share-socials-icons" style="display: flex; flex-direction: row; gap: 20px; width: 100%; justify-content: flex-start;">
                <?php
                if (!empty($settings['socials'])):
                    foreach ($settings['socials'] as $item):
                        $type = $item['social_type'];
                        if (!isset($icons[$type])) continue;
                        ?>
                        <a href="<?php echo esc_url($urls[$type] . urlencode($share_url)); ?>" target="_blank" rel="noopener" title="<?php echo esc_attr($type); ?>">
                            <i class="<?php echo esc_attr($icons[$type]); ?>"></i>
                        </a>
                    <?php
                    endforeach;
                endif;
                ?>
                </div>
                <div class="skill-share-link" style="width: 100%; margin-top: 0;">
                    <input type="text" value="<?php echo esc_attr($share_url); ?>" readonly style="width: 100%; background: transparent; border: none; color: #8b8b8b; font-size: 15px; direction: ltr; outline: none; padding: 8px 8px;">
                    <button class="skill-share-copy" title="کپی لینک" style="font-size: 18px;">
                        <i class="far fa-copy"></i>
                    </button>
                </div>
            </div>
        </div>
        <style>
.skill-share-widget {
    position: relative;
    display: inline-block;
    direction: rtl;
}
.skill-share-toggle {
    background: #080708;
    color: #8d8d8d;
    border: 1px solid #8d8d8d;
    border-radius: 10px;
    padding: 10px 18px;
    cursor: pointer;
    font-size: 18px;
    display: flex;
    align-items: center;
    gap: 8px;
    transition: background 0.2s;
}
.skill-share-toggle:hover {
    background: #22263a;
}
.skill-share-socials {
    position: absolute;
    top: 110%;
    left: 0;
    background: rgba(8,7,8,0.55);
    border: 1px solid #8d8d8d;
    border-radius: 12px;
    padding: 18px 18px 10px 18px;
    min-width: 260px;
    box-shadow: 0 8px 32px rgba(0,0,0,0.18);
    z-index: 99;
    opacity: 0;
    pointer-events: none;
    transform: translateY(0);
    transition: opacity 0.8s cubic-bezier(.4,2,.6,1), max-height 0.8s cubic-bezier(.4,2,.6,1);
    display: flex;
    flex-direction: column;
    gap: 12px;
    max-height: 0;
    overflow: hidden;
    backdrop-filter: blur(12px) saturate(160%);
    -webkit-backdrop-filter: blur(12px) saturate(160%);
}
.skill-share-widget.active .skill-share-socials {
    opacity: 1;
    pointer-events: auto;
    max-height: 200px;
}
.skill-share-socials a {
    color: #8b8b8b;
    font-size: 22px;
    margin-left: 10px;
    transition: color 0.2s, transform 0.2s;
    display: inline-block;
}
.skill-share-socials a:hover {
    color: #fff;
    transform: scale(1.2) rotate(-8deg);
}
.skill-share-link {
    margin-top: 10px;
    background: #23263a;
    border-radius: 8px;
    padding: 0 8px;
    display: flex;
    align-items: center;
    gap: 6px;
    width: 100%;
}
.skill-share-link input {
    background: transparent;
    border: none;
    color: #8b8b8b;
    width: 100%;
    font-size: 15px;
    direction: ltr;
    outline: none;
    padding: 8px 8px;
    margin-bottom: 6px;
}
.skill-share-copy {
    background: none;
    border: none;
    color: #8b8b8b;
    font-size: 18px;
    cursor: pointer;
    transition: color 0.2s;
}
.skill-share-copy:hover {
    color: #fff;
}
</style>
        <script>
        (function($){
            var $widget = $('#<?php echo $widget_id; ?>');
            var $toggle = $widget.find('.skill-share-toggle');
            var $socials = $widget.find('.skill-share-socials');
            var $copyBtn = $widget.find('.skill-share-copy');
            var $input = $widget.find('.skill-share-link input');

            $toggle.on('click', function(e){
                e.stopPropagation();
                $('.skill-share-widget').not($widget).removeClass('active');
                $widget.toggleClass('active');
            });

            $(document).on('click', function(e){
                if (!$widget.is(e.target) && $widget.has(e.target).length === 0) {
                    $widget.removeClass('active');
                }
            });

            $copyBtn.on('click', function(e){
                e.stopPropagation();
                $input[0].focus();
                $input[0].setSelectionRange(0, $input[0].value.length);
                try {
                    var successful = document.execCommand('copy');
                    $copyBtn.html('<i class=\"fas fa-check\"></i>');
                    setTimeout(function(){
                        $copyBtn.html('<i class=\"far fa-copy\"></i>');
                    }, 1200);
                } catch (err) {
                    alert('کپی نشد!');
                }
            });
        })(jQuery);
        </script>
        <?php
    }
}