<?php


class skill_contact_info_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'skill_contact_info_Widget';
    }

    public function get_title() {
        return esc_html__('اطلاعات تماس و فرم', 'skill');
    }

    public function get_icon() {
        return 'eicon-person';
    }

    public function get_categories() {
        return ['skill-category'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'contact_info_section',
            [
                'label' => esc_html__('اطلاعات تماس', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'phone_number',
            [
                'label' => esc_html__('شماره تماس', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '09387075415',
            ]
        );

        $this->add_control(
            'email_address',
            [
                'label' => esc_html__('آدرس ایمیل', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'mohamad5415.m8@gmail.com',
            ]
        );

        $this->add_control(
            'form_shortcode',
            [
                'label' => esc_html__('شورت کد فرم', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => '',
                'description' => esc_html__('شورت کد فرم تماس یا هر فرم دیگری را اینجا وارد کنید', 'skill'),
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'contact_card_style_section',
            [
                'label' => esc_html__('استایل کارت اطلاعات تماس', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        // رنگ پس‌زمینه کارت
        $this->add_control(
            'contact_card_bg_color',
            [
                'label' => esc_html__('رنگ پس‌زمینه کارت', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'rgba(255,255,255,0.85)',
                'selectors' => [
                    '{{WRAPPER}} .contact-card' => 'background: {{VALUE}};',
                ],
            ]
        );

        // رنگ عنوان کارت
        $this->add_control(
            'contact_card_title_color',
            [
                'label' => esc_html__('رنگ عنوان کارت', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#0e59f2',
                'selectors' => [
                    '{{WRAPPER}} .contact-card h4' => 'color: {{VALUE}};',
                ],
            ]
        );
        // سایز فونت عنوان کارت
        $this->add_control(
            'contact_card_title_size',
            [
                'label' => esc_html__('سایز فونت عنوان کارت', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'range' => [
                    'px' => ['min' => 12, 'max' => 40],
                    'em' => ['min' => 0.7, 'max' => 2.5],
                    'rem' => ['min' => 0.7, 'max' => 2.5],
                ],
                'default' => ['unit' => 'rem', 'size' => 1.35],
                'selectors' => [
                    '{{WRAPPER}} .contact-card h4' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        // رنگ لیبل‌ها
        $this->add_control(
            'contact_label_color',
            [
                'label' => esc_html__('رنگ لیبل‌ها', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#7a859e',
                'selectors' => [
                    '{{WRAPPER}} .contact-info-label' => 'color: {{VALUE}};',
                ],
            ]
        );
        // سایز فونت لیبل‌ها
        $this->add_control(
            'contact_label_size',
            [
                'label' => esc_html__('سایز فونت لیبل‌ها', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'range' => [
                    'px' => ['min' => 10, 'max' => 24],
                    'em' => ['min' => 0.7, 'max' => 2],
                    'rem' => ['min' => 0.7, 'max' => 2],
                ],
                'default' => ['unit' => 'rem', 'size' => 0.95],
                'selectors' => [
                    '{{WRAPPER}} .contact-info-label' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        // رنگ مقدارها (ایمیل/شماره)
        $this->add_control(
            'contact_value_color',
            [
                'label' => esc_html__('رنگ مقدارها (ایمیل/شماره)', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#222',
                'selectors' => [
                    '{{WRAPPER}} .contact-info-value' => 'color: {{VALUE}};',
                ],
            ]
        );
        // سایز فونت مقدارها
        $this->add_control(
            'contact_value_size',
            [
                'label' => esc_html__('سایز فونت مقدارها', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'range' => [
                    'px' => ['min' => 10, 'max' => 24],
                    'em' => ['min' => 0.7, 'max' => 2],
                    'rem' => ['min' => 0.7, 'max' => 2],
                ],
                'default' => ['unit' => 'rem', 'size' => 0.98],
                'selectors' => [
                    '{{WRAPPER}} .contact-info-value' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        // رنگ آیکون‌ها
        $this->add_control(
            'contact_icon_color',
            [
                'label' => esc_html__('رنگ آیکون‌ها', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .contact-icon' => 'color: {{VALUE}};',
                ],
            ]
        );
        // رنگ پس‌زمینه آیکون‌ها
        $this->add_control(
            'contact_icon_bg',
            [
                'label' => esc_html__('پس‌زمینه آیکون‌ها', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .contact-icon' => 'background: {{VALUE}};',
                ],
            ]
        );

        // رنگ پیام کپی
        $this->add_control(
            'copy_toast_bg',
            [
                'label' => esc_html__('رنگ پس‌زمینه پیام کپی', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#0e59f2',
                'selectors' => [
                    '{{WRAPPER}} .copy-toast' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'copy_toast_color',
            [
                'label' => esc_html__('رنگ متن پیام کپی', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .copy-toast' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('استایل‌ها', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عناوین', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#333333',
                'selectors' => [
                    '{{WRAPPER}} .information h6' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'title_font_size',
            [
                'label' => esc_html__('سایز فونت عناوین', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                    ],
                    'em' => [
                        'min' => 0.5,
                        'max' => 2,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 16,
                ],
                'selectors' => [
                    '{{WRAPPER}} .information h6' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'contact_text_color',
            [
                'label' => esc_html__('رنگ متن تماس', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#555555',
                'selectors' => [
                    '{{WRAPPER}} .information span' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'contact_text_size',
            [
                'label' => esc_html__('سایز فونت متن تماس', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                    ],
                    'em' => [
                        'min' => 0.5,
                        'max' => 2,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 14,
                ],
                'selectors' => [
                    '{{WRAPPER}} .information span' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'form_label_color',
            [
                'label' => esc_html__('رنگ عناوین فرم', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#333333',
                'selectors' => [
                    '{{WRAPPER}} form label' => 'color: {{VALUE}}',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'form_label_size',
            [
                'label' => esc_html__('سایز فونت عناوین فرم', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                    ],
                    'em' => [
                        'min' => 0.5,
                        'max' => 2,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 14,
                ],
                'selectors' => [
                    '{{WRAPPER}} form label' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'submit_button_color',
            [
                'label' => esc_html__('رنگ دکمه ارسال', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#0e59f2',
                'selectors' => [
                    '{{WRAPPER}} input[type="submit"]' => 'background-color: {{VALUE}}',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'border_color',
            [
                'label' => esc_html__('رنگ حاشیه فیلدها', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ddd',
                'selectors' => [
                    '{{WRAPPER}} input[type=text], {{WRAPPER}} select, {{WRAPPER}} textarea' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <style>
        .skill-contact-widget {
          margin-top: 2rem;
          margin-bottom: 2rem;
        }
        .skill-contact-widget .contact-info-section {
          margin-bottom: 2rem;
        }
        .skill-contact-widget .contact-card {
          background: rgba(255,255,255,0.85);
          border-radius: 1.5rem;
          box-shadow: 0 8px 32px 0 rgba(31,38,135,0.10);
          backdrop-filter: blur(6px);
          border: 1px solid rgba(255,255,255,0.18);
          padding: 2.5rem 2rem 1.2rem 2rem;
          position: relative;
          overflow: hidden;
          min-height: 320px;
          width: 100%;
        }
        .skill-contact-widget .contact-card::before {
          content: '';
          position: absolute;
          top: -40px; left: -40px;
          width: 120px; height: 120px;
          background: linear-gradient(135deg, #0e59f2 0%, #6ec6ff 100%);
          opacity: 0.12;
          border-radius: 50%;
          z-index: 0;
        }
        .skill-contact-widget .contact-card h4 {
          font-size: 1.35rem;
          color: #0e59f2;
          font-weight: 800;
          margin-bottom: 2.2rem;
          letter-spacing: -0.5px;
          position: relative;
          z-index: 1;
        }
        .skill-contact-widget .contact-info-list {
          list-style: none;
          padding: 0;
          margin: 0 0 1.2rem 0;
          position: relative;
          z-index: 1;
        }
        /* Two-column layout for phone and email side-by-side */
        .skill-contact-widget .contact-info-grid {
          display: grid;
          grid-template-columns: 1fr 1fr;
          gap: 1.2rem;
          align-items: stretch;
        }
        .skill-contact-widget .contact-info-list li {
          display: flex;
          align-items: flex-start;
          margin-bottom: 1.2rem;
          padding-bottom: 1.2rem;
          border-bottom: 1px solid #f0f4fa;
          transition: background 0.15s;
        }
        .skill-contact-widget .contact-info-grid li {
          margin-bottom: 0;
          padding-bottom: 0;
          border-bottom: none;
        }
        .skill-contact-widget .contact-info-list li:last-child {
          margin-bottom: 0;
          padding-bottom: 0;
          border-bottom: none;
        }
        .skill-contact-widget .contact-icon {
          width: 48px;
          height: 48px;
          background: linear-gradient(135deg, #0e59f2 0%, #6ec6ff 100%);
          color: #fff;
          display: flex;
          align-items: center;
          justify-content: center;
          font-size: 1.5rem;
          border-radius: 50%;
          box-shadow: 0 2px 12px 0 rgba(14,89,242,0.10);
          margin-left: 1.1rem;
          transition: transform 0.18s, box-shadow 0.18s;
          flex-shrink: 0;
        }
        .skill-contact-widget .contact-info-list li:hover .contact-icon {
          transform: scale(1.08) rotate(-8deg);
          box-shadow: 0 4px 18px 0 rgba(14,89,242,0.18);
        }
        .skill-contact-widget .contact-info-label {
          font-size: 0.95rem;
          color: #7a859e;
          font-weight: 600;
          margin-bottom: 0.15rem;
        }
        .skill-contact-widget .contact-info-value {
          font-size: 0.98rem;
          color: #222;
          font-weight: 700;
          direction: ltr;
          letter-spacing: 0.5px;
          transition: color 0.18s;
          cursor: pointer;
          word-break: break-all;
          max-width: 180px;
          display: block;
          position: relative;
        }
        .skill-contact-widget .contact-info-value:hover {
          color: #0e59f2;
        }
        .skill-contact-widget .copy-toast {
          display: none;
          position: absolute;
          left: 50%;
          top: -32px;
          transform: translateX(-50%);
          background: #0e59f2;
          color: #fff;
          font-size: 0.85rem;
          padding: 0.25rem 0.9rem;
          border-radius: 1rem;
          box-shadow: 0 2px 8px 0 rgba(14,89,242,0.10);
          z-index: 10;
          white-space: nowrap;
          opacity: 0;
          transition: opacity 0.2s;
          pointer-events: none;
        }
        .skill-contact-widget .contact-info-value.copied .copy-toast {
          display: block;
          opacity: 1;
        }
        .skill-contact-widget .contact-social {
          margin-top: 1.2rem;
          position: relative;
          z-index: 1;
        }
        .skill-contact-widget .contact-social-title {
          font-weight: 700;
          color: #7a859e;
          font-size: 0.98rem;
          margin-bottom: 0.7rem;
        }
        .skill-contact-widget .social-icon {
          width: 38px;
          height: 38px;
          background: #f5f5f5;
          color: #0e59f2;
          font-size: 1.15rem;
          transition: background 0.2s, color 0.2s;
          border: 1px solid #e3e3e3;
          display: flex;
          align-items: center;
          justify-content: center;
          border-radius: 50%;
        }
        .skill-contact-widget .social-icon:hover {
          background: #0e59f2;
          color: #fff;
          border-color: #0e59f2;
        }
        .skill-contact-widget .contact-form-section {
          width: 100%;
        }
        .skill-contact-widget .contact-form-box {
          width: 100%;
          min-height: 400px;
        }
        
        /* Modern Contact Form 7 Styles */
        .skill-contact-widget .wpcf7-form {
          max-width: 100%;
        }
        
        .skill-contact-widget .wpcf7-form p {
          margin-bottom: 1.5rem;
          position: relative;
        }
        
        .skill-contact-widget .wpcf7-form label {
          display: block;
          font-weight: 600;
          color: #333;
          margin-bottom: 0.5rem;
          font-size: 0.95rem;
          transition: color 0.2s;
        }
        
        .skill-contact-widget .wpcf7-form input[type="text"],
        .skill-contact-widget .wpcf7-form input[type="email"],
        .skill-contact-widget .wpcf7-form input[type="tel"],
        .skill-contact-widget .wpcf7-form input[type="url"],
        .skill-contact-widget .wpcf7-form textarea,
        .skill-contact-widget .wpcf7-form select {
          width: 100%;
          padding: 1rem 1.2rem;
          border: 2px solid #e8eef7;
          border-radius: 12px;
          font-size: 0.95rem;
          background: #fff;
          transition: all 0.3s ease;
          box-shadow: 0 2px 8px rgba(0,0,0,0.04);
          color: #333;
        }
        
        .skill-contact-widget .wpcf7-form input[type="text"]:focus,
        .skill-contact-widget .wpcf7-form input[type="email"]:focus,
        .skill-contact-widget .wpcf7-form input[type="tel"]:focus,
        .skill-contact-widget .wpcf7-form input[type="url"]:focus,
        .skill-contact-widget .wpcf7-form textarea:focus,
        .skill-contact-widget .wpcf7-form select:focus {
          outline: none;
          border-color: #0e59f2;
          box-shadow: 0 4px 16px rgba(14,89,242,0.15);
          transform: translateY(-1px);
        }
        
        .skill-contact-widget .wpcf7-form textarea {
          min-height: 120px;
          resize: vertical;
          line-height: 1.6;
        }
        
        .skill-contact-widget .wpcf7-form input[type="submit"] {
          background: linear-gradient(135deg, #0e59f2 0%, #6ec6ff 100%);
          color: #fff;
          border: none;
          padding: 1rem 2.5rem;
          border-radius: 12px;
          font-size: 1rem;
          font-weight: 700;
          cursor: pointer;
          transition: all 0.3s ease;
          box-shadow: 0 4px 16px rgba(14,89,242,0.25);
          position: relative;
          overflow: hidden;
          min-width: 160px;
        }
        
        .skill-contact-widget .wpcf7-form input[type="submit"]:hover {
          transform: translateY(-2px);
          box-shadow: 0 6px 20px rgba(14,89,242,0.35);
          background: linear-gradient(135deg, #0a4bd1 0%, #5bb8ff 100%);
        }
        
        .skill-contact-widget .wpcf7-form input[type="submit"]:active {
          transform: translateY(0);
        }
        
        .skill-contact-widget .wpcf7-form input[type="submit"]::before {
          content: '';
          position: absolute;
          top: 0;
          left: -100%;
          width: 100%;
          height: 100%;
          background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
          transition: left 0.5s;
        }
        
        .skill-contact-widget .wpcf7-form input[type="submit"]:hover::before {
          left: 100%;
        }
        
        /* Form validation styles */
        .skill-contact-widget .wpcf7-form .wpcf7-not-valid {
          border-color: #ff4757 !important;
          box-shadow: 0 4px 16px rgba(255,71,87,0.15) !important;
        }
        
        .skill-contact-widget .wpcf7-form .wpcf7-not-valid-tip {
          color: #ff4757;
          font-size: 0.85rem;
          margin-top: 0.5rem;
          font-weight: 500;
        }
        
        .skill-contact-widget .wpcf7-form .wpcf7-response-output {
          margin: 1.5rem 0 0 0;
          padding: 1rem 1.5rem;
          border-radius: 12px;
          font-weight: 600;
          border: none;
        }
        
        .skill-contact-widget .wpcf7-form .wpcf7-mail-sent-ok {
          background: linear-gradient(135deg, #2ed573 0%, #7bed9f 100%);
          color: #fff;
          box-shadow: 0 4px 16px rgba(46,213,115,0.25);
        }
        
        .skill-contact-widget .wpcf7-form .wpcf7-validation-errors {
          background: linear-gradient(135deg, #ff4757 0%, #ff6b7a 100%);
          color: #fff;
          box-shadow: 0 4px 16px rgba(255,71,87,0.25);
        }
        
        .skill-contact-widget .wpcf7-form .wpcf7-spinner {
          margin: 0 0 0 1rem;
          position: relative;
          top: 2px;
        }
        
        /* Loading animation */
        .skill-contact-widget .wpcf7-form .wpcf7-spinner::before {
          content: '';
          width: 20px;
          height: 20px;
          border: 2px solid #f3f3f3;
          border-top: 2px solid #0e59f2;
          border-radius: 50%;
          animation: spin 1s linear infinite;
        }
        
        @keyframes spin {
          0% { transform: rotate(0deg); }
          100% { transform: rotate(360deg); }
        }
        
        /* Form field icons */
        .skill-contact-widget .wpcf7-form .field-with-icon {
          position: relative;
        }
        
        .skill-contact-widget .wpcf7-form .field-with-icon::before {
          content: '';
          position: absolute;
          left: 1rem;
          top: 50%;
          transform: translateY(-50%);
          width: 16px;
          height: 16px;
          background-size: contain;
          opacity: 0.6;
          z-index: 2;
        }
        
        .skill-contact-widget .wpcf7-form .field-with-icon input {
          padding-left: 3rem;
        }
        
        /* Email field specific styling */
        .skill-contact-widget .wpcf7-form input[type="email"] {
          background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='%230e59f2'%3E%3Cpath d='M20 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z'/%3E%3C/svg%3E");
          background-repeat: no-repeat;
          background-position: 1rem center;
          background-size: 18px;
          padding-left: 3rem;
        }
        
        .skill-contact-widget .wpcf7-form input[type="email"]:focus {
          background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='%230e59f2'%3E%3Cpath d='M20 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z'/%3E%3C/svg%3E");
        }
        
        /* Responsive adjustments */
        @media (max-width: 768px) {
          .skill-contact-widget .wpcf7-form input[type="text"],
          .skill-contact-widget .wpcf7-form input[type="email"],
          .skill-contact-widget .wpcf7-form input[type="tel"],
          .skill-contact-widget .wpcf7-form input[type="url"],
          .skill-contact-widget .wpcf7-form textarea {
            padding: 0.9rem 1rem;
            font-size: 0.9rem;
          }
          .skill-contact-widget .contact-info-grid { grid-template-columns: 1fr; }
          
          .skill-contact-widget .wpcf7-form input[type="submit"] {
            padding: 0.9rem 2rem;
            font-size: 0.95rem;
            width: 100%;
          }
        }
        @media (max-width: 767px) {
          .skill-contact-widget .contact-card,
          .skill-contact-widget .contact-form-box {
            margin-bottom: 1.5rem;
          }
          .skill-contact-widget .contact-info-value {
            max-width: 100%;
          }
          .skill-contact-widget .contact-card {
            padding: 2rem 1.5rem 1rem 1.5rem;
          }
          .skill-contact-widget .contact-form-box {
            padding: 2rem 1.5rem;
          }
        }
        </style>
        <script>
        function skillCopyToClipboard(el, value) {
          if (!navigator.clipboard) return;
          navigator.clipboard.writeText(value).then(function() {
            el.classList.add('copied');
            setTimeout(function() {
              el.classList.remove('copied');
            }, 2000);
          });
        }
        </script>
        <div class="skill-contact-widget">
            <!-- Contact Information Section -->
            <div class="contact-info-section mb-4">
                <div class="contact-card">
                    <h4><i class="eicon-person me-2"></i><?php echo esc_html__('اطلاعات تماس', 'skill'); ?></h4>
                    <ul class="contact-info-list contact-info-grid">
                        <li>
                            <span class="contact-icon"><i class="fas fa-phone"></i></span>
                            <div>
                                <div class="contact-info-label"><?php echo esc_html__('شماره تماس', 'skill'); ?></div>
                                <div class="contact-info-value" onclick="skillCopyToClipboard(this, '<?php echo esc_attr($settings['phone_number']); ?>')" title="کپی شماره">
                                    <?php echo esc_html($settings['phone_number']); ?>
                                    <span class="copy-toast">کپی شد!</span>
                                </div>
                            </div>
                        </li>
                        <li>
                            <span class="contact-icon"><i class="fas fa-envelope"></i></span>
                            <div>
                                <div class="contact-info-label"><?php echo esc_html__('ایمیل', 'skill'); ?></div>
                                <div class="contact-info-value" onclick="skillCopyToClipboard(this, '<?php echo esc_attr($settings['email_address']); ?>')" title="کپی ایمیل">
                                    <?php echo esc_html($settings['email_address']); ?>
                                    <span class="copy-toast">کپی شد!</span>
                                </div>
                            </div>
                        </li>
                    </ul>
                    <div class="contact-social">
                        <div class="contact-social-title"><?php echo esc_html__('شبکه‌های اجتماعی', 'skill'); ?></div>
                        <ul class="d-flex gap-2 p-0 m-0 list-unstyled">
                            <?php
                            $networks = get_option('social_sharing_networks', array());
                            foreach ($networks as $network) {
                                if (!empty($network['url']) && !empty($network['icon'])) {
                                    echo '<li><a class="social-icon" href="' . esc_url($network['url']) . '" target="_blank"><i class="' . esc_attr($network['icon']) . '"></i></a></li>';
                                }
                            }
                            ?>
                        </ul>
                    </div>
                </div>
            </div>
            
            <!-- Contact Form Section -->
            <div class="contact-form-section">
                <div class="contact-form-box p-4 shadow rounded-4 bg-white">
                    <h4 class="mb-4 fw-bold text-primary"><i class="fas fa-envelope-open me-2"></i><?php echo esc_html__('فرم تماس با ما', 'skill'); ?></h4>
                    <?php
                    if (!empty($settings['form_shortcode'])) {
                        echo do_shortcode($settings['form_shortcode']);
                    } else {
                        echo '<p class="text-danger">' . esc_html__('لطفاً شورت کد فرم را وارد کنید', 'skill') . '</p>';
                    }
                    ?>
                </div>
            </div>
        </div>
        <?php
    }
}