<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class skill_career_history_Widget extends Widget_Base {
    // Widget name
    public function get_name() {
        return 'skill-career-history';
    }

    // Widget title
    public function get_title() {
        return __( 'سوابق شغلی', 'skill' );
    }

    // Widget icon
    public function get_icon() {
        return 'eicon-time-line';
    }

    // Widget category
    public function get_categories() {
        return [ 'skill-category' ]; // You can change category if needed
    }

    // Register widget controls
    protected function _register_controls() {
        // Title control
        $this->start_controls_section(
            'section_title',
            [
                'label' => __( 'عنوان ویجت', 'skill' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'widget_title',
            [
                'label' => __( 'عنوان ویجت', 'skill' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'سوابق شغلی من', 'skill' ),
                'label_block' => true,
            ]
        );
        $this->end_controls_section();

        // Career history repeater section (as before)
        $this->start_controls_section(
            'section_career_history',
            [
                'label' => __( 'سوابق شغلی', 'skill' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'job_title',
            [
                'label' => __( 'عنوان شغل', 'skill' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'عنوان شغل', 'skill' ),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'company_name',
            [
                'label' => __( 'نام شرکت', 'skill' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'نام شرکت', 'skill' ),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'date_range',
            [
                'label' => __( 'بازه زمانی', 'skill' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'مثال: 1400-1402', 'skill' ),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'job_description',
            [
                'label' => __( 'توضیحات شغل', 'skill' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => __( 'توضیح مختصر درباره شغل', 'skill' ),
                'show_label' => true,
            ]
        );
        $this->add_control(
            'career_history_items',
            [
                'label' => __( 'سوابق شغلی', 'skill' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'job_title' => __( 'برنامه‌نویس', 'skill' ),
                        'company_name' => __( 'شرکت نمونه', 'skill' ),
                        'date_range' => __( '1400-1402', 'skill' ),
                        'job_description' => __( 'توضیح مختصر درباره شغل', 'skill' ),
                    ],
                ],
                'title_field' => '{{{ job_title }}}',
            ]
        );
        $this->end_controls_section();

        // Style tab
        $this->start_controls_section(
            'section_style',
            [
                'label' => __( 'استایل', 'skill' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        // Box background color
        $this->add_control(
            'box_bg_color',
            [
                'label' => __( 'رنگ پس‌زمینه باکس', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#181C2A24',
                'selectors' => [
                    '{{WRAPPER}} .skill-career-history-widget' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        // Box text color
        $this->add_control(
            'box_text_color',
            [
                'label' => __( 'رنگ متن', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .skill-career-history-widget' => 'color: {{VALUE}};',
                ],
            ]
        );
        // Dot color
        $this->add_control(
            'dot_color',
            [
                'label' => __( 'رنگ دایره', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#0E59F2',
                'selectors' => [
                    '{{WRAPPER}} .career-history-dot' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        // Vertical line color
        $this->add_control(
            'line_color',
            [
                'label' => __( 'رنگ خط عمودی', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#2a2e42',
                'selectors' => [
                    '{{WRAPPER}} .career-history-col--left' => 'border-right-color: {{VALUE}};',
                ],
            ]
        );
        // Job title color
        $this->add_control(
            'job_title_color',
            [
                'label' => __( 'رنگ عنوان شغلی', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .career-history-title' => 'color: {{VALUE}};',
                ],
            ]
        );
        // Date color
        $this->add_control(
            'date_color',
            [
                'label' => __( 'رنگ بازه زمانی', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#0E59F2',
                'selectors' => [
                    '{{WRAPPER}} .career-history-date' => 'color: {{VALUE}};',
                ],
            ]
        );
        // Company color
        $this->add_control(
            'company_color',
            [
                'label' => __( 'رنگ شرکت', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .career-history-company' => 'color: {{VALUE}};',
                ],
            ]
        );
        // Description color
        $this->add_control(
            'desc_color',
            [
                'label' => __( 'رنگ توضیحات', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#d1d1d1',
                'selectors' => [
                    '{{WRAPPER}} .career-history-desc' => 'color: {{VALUE}};',
                ],
            ]
        );
        // Button color
        $this->add_control(
            'btn_color',
            [
                'label' => __( 'رنگ دکمه اسکرول', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#0E59F2',
                'selectors' => [
                    '{{WRAPPER}} .career-history-btn' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .career-history-btn' => 'color: #181C2A24;',
                ],
            ]
        );
        // Title dot color
        $this->add_control(
            'title_dot_color',
            [
                'label' => __( 'رنگ مربع عنوان', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#1e73be',
                'selectors' => [
                    '{{WRAPPER}} .career-history-title-dot' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        // Box height
        $this->add_control(
            'box_height',
            [
                'label' => __( 'ارتفاع باکس (px)', 'skill' ),
                'type' => Controls_Manager::NUMBER,
                'default' => 350,
                'min' => 200,
                'max' => 800,
                'selectors' => [
                    '{{WRAPPER}} .career-history-scroll-wrapper' => 'max-height: {{VALUE}}px;',
                ],
            ]
        );
        $this->end_controls_section();
    }

    // Render widget output
    protected function render() {
        $settings = $this->get_settings_for_display();
        $items = $settings['career_history_items'];
        $widget_id = 'career-history-' . $this->get_id();
        $total_items = count($items);
        ?>
        <div class="skill-career-history-widget" id="<?php echo esc_attr($widget_id); ?>">
            <?php if ( !empty($settings['widget_title']) ) : ?>
                <div class="career-history-title-row" style="display:inline-flex;align-items:center;gap:8px;margin-bottom:24px;flex-direction:row-reverse;">
                    <h2 class="career-history-widget-title" style="font-size:24px;font-weight:bold;"><?php echo esc_html($settings['widget_title']); ?></h2>
                    <span class="career-history-title-dot" aria-hidden="true"></span>
                </div>
            <?php endif; ?>
            <div class="career-history-scroll-wrapper" style="overflow-y: auto; overflow-x: hidden;">
                <div class="career-history-list" style="position:relative;">
                    <!-- Vertical line for all items -->
                    <div class="career-history-vertical-line"></div>
                    <?php foreach ( $items as $index => $item ) : ?>
                        <div class="career-history-row" data-index="<?php echo $index; ?>" style="position:relative; transition: opacity 0.4s, transform 0.4s;">
                            <!-- Dot on the vertical line -->
                            <div class="career-history-dot-on-line" style="position:absolute;"></div>
                            <div class="career-history-col career-history-col--right">
                                <div class="career-history-date-company">
                                    <span class="career-history-date">
                                        <?php echo esc_html( $item['date_range'] ); ?>
                                    </span>
                                    <span class="career-history-company">
                                        <?php echo esc_html( $item['company_name'] ); ?>
                                    </span>
                                </div>
                            </div>
                            <div class="career-history-col career-history-col--left">
                                <div class="career-history-title">
                                    <?php echo esc_html( $item['job_title'] ); ?>
                                </div>
                                <div class="career-history-desc">
                                    <?php echo esc_html( $item['job_description'] ); ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <style>
        /* Career History Widget Styles */
        #<?php echo esc_attr($widget_id); ?> {
            direction: rtl;
            border-radius: 12px;
            padding: 32px 24px;
            position: relative;
            max-width: 600px;
            margin: 0 auto;
        }
        #<?php echo esc_attr($widget_id); ?> .career-history-title-dot {width:10px;height:10px;background:#1e73be;border-radius:2px;display:inline-block}
        #<?php echo esc_attr($widget_id); ?> .career-history-scroll-wrapper {
            overflow-y: auto;
            overflow-x: hidden;
            position: relative;
        }
        #<?php echo esc_attr($widget_id); ?> .career-history-list {
            transition: transform 0.3s;
            position: relative;
        }
        /* Vertical line spanning all items */
        #<?php echo esc_attr($widget_id); ?> .career-history-vertical-line {
            position: absolute;
            right: 170px;
            top: 0;
            width: 2px;
            height: 100%;
            background: var(--career-line-color, #2a2e42);
            z-index: 1;
        }
        /* Each row */
        #<?php echo esc_attr($widget_id); ?> .career-history-row {
            display: flex;
            flex-direction: row;
            align-items: flex-start;
            margin-bottom: 32px;
            position: relative;
            min-height: 48px;
        }
        /* Dot on the vertical line */
        #<?php echo esc_attr($widget_id); ?> .career-history-dot-on-line {
            right: 166px;
            top: 50%;
            transform: translateY(-50%);
            width: 10px;
            height: 10px;
            background: var(--career-dot-color, #0E59F2);
            border-radius: 50%;
            position: absolute;
            z-index: 2;
        }
        #<?php echo esc_attr($widget_id); ?> .career-history-col--right {
            width: 180px;
            min-width: 180px;
            display: flex;
            flex-direction: column;
            align-items: flex-start;
            position: relative;
            z-index: 3;
        }
        #<?php echo esc_attr($widget_id); ?> .career-history-date-company {
            display: flex;
            flex-direction: column;
            align-items: flex-end;
        }
        #<?php echo esc_attr($widget_id); ?> .career-history-date {
            font-weight: bold;
            font-size: 16px;
            margin-bottom: 2px;
        }
        #<?php echo esc_attr($widget_id); ?> .career-history-company {
            font-size: 14px;
        }
        #<?php echo esc_attr($widget_id); ?> .career-history-col--left {
            flex: 1;
            padding-right: 32px;
            border-right: none;
            z-index: 3;
        }
        #<?php echo esc_attr($widget_id); ?> .career-history-title {
            font-weight: bold;
            font-size: 18px;
            margin-bottom: 6px;
        }
        #<?php echo esc_attr($widget_id); ?> .career-history-desc {
            font-size: 15px;
        }
        #<?php echo esc_attr($widget_id); ?> .career-history-scroll-btns {
            display: flex;
            flex-direction: column;
            align-items: center;
            position: absolute;
            left: 16px;
            bottom: 16px;
            z-index: 2;
        }
        #<?php echo esc_attr($widget_id); ?> .career-history-btn {
            border: none;
            border-radius: 6px;
            width: 36px;
            height: 36px;
            margin: 2px 0;
            font-size: 20px;
            cursor: pointer;
            transition: background 0.2s;
        }
        #<?php echo esc_attr($widget_id); ?> .career-history-btn:active {
            filter: brightness(0.9);
        }
        @media (max-width: 600px) {
            #<?php echo esc_attr($widget_id); ?> {
                padding: 16px 4px;
            }
            #<?php echo esc_attr($widget_id); ?> .career-history-col--right {
                width: 110px;
                min-width: 110px;
            }
            #<?php echo esc_attr($widget_id); ?> .career-history-col--left {
                padding-right: 12px;
            }
            #<?php echo esc_attr($widget_id); ?> .career-history-vertical-line {
                right: 100px;
            }
            #<?php echo esc_attr($widget_id); ?> .career-history-dot-on-line {
                right: 96px;
            }
        }
        </style>
        <script>
        // Set CSS variables for dynamic colors
        (function(){
            var widget = document.getElementById('<?php echo esc_js($widget_id); ?>');
            if (!widget) return;
            var dotColor = getComputedStyle(widget.querySelector('.career-history-dot-on-line')).backgroundColor;
            var lineColor = getComputedStyle(widget.querySelector('.career-history-vertical-line')).backgroundColor;
            widget.style.setProperty('--career-dot-color', dotColor);
            widget.style.setProperty('--career-line-color', lineColor);
        })();
        </script>
        <?php
    }
}