<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Skill_certificate_slider_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'skill_certificate_slider';
	}

	public function get_title() {
		return __( 'اسلایدر سرتیفیکت', 'skill' );
	}

	public function get_icon() {
		return 'eicon-slider-3d';
	}

	public function get_categories() {
		return [ 'skill-category' ];
	}

	public function get_keywords() {
		return [ 'اسلایدر', 'سرتیفیکت', 'گواهی', 'مدرک', 'certificate', 'slider' ];
	}

	// Register widget controls
	protected function register_controls() {
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'سرتیفیکت‌ها', 'skill' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'certificates',
			[
				'label' => __( 'انتخاب تصاویر سرتیفیکت', 'skill' ),
				'type' => \Elementor\Controls_Manager::GALLERY,
				'default' => [],
			]
		);

		$this->add_control(
			'show_caption',
			[
				'label' => __( 'نمایش کپشن (عنوان تصویر)', 'skill' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'بله', 'skill' ),
				'label_off' => __( 'خیر', 'skill' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'settings_section',
			[
				'label' => __( 'تنظیمات اسلایدر', 'skill' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		// Slider Settings
		$this->add_control(
			'autoplay',
			[
				'label' => __( 'پخش خودکار', 'skill' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'بله', 'skill' ),
				'label_off' => __( 'خیر', 'skill' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'autoplay_delay',
			[
				'label' => __( 'تاخیر پخش خودکار (ثانیه)', 'skill' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'condition' => [ 'autoplay' => 'yes' ],
				'size_units' => [ 's' ],
				'range' => [ 's' => [ 'min' => 1, 'max' => 10, 'step' => 0.5 ] ],
				'default' => [ 'unit' => 's', 'size' => 5 ],
			]
		);

		$this->add_control(
			'speed',
			[
				'label' => __( 'سرعت انیمیشن (میلی‌ثانیه)', 'skill' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'ms' ],
				'range' => [ 'ms' => [ 'min' => 200, 'max' => 2000, 'step' => 100 ] ],
				'default' => [ 'unit' => 'ms', 'size' => 500 ],
			]
		);

		$this->add_control(
			'show_pagination',
			[
				'label' => __( 'نمایش نقاط صفحه‌بندی', 'skill' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'بله', 'skill' ),
				'label_off' => __( 'خیر', 'skill' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_thumbs',
			[
				'label' => __( 'نمایش تصاویر کوچک', 'skill' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'بله', 'skill' ),
				'label_off' => __( 'خیر', 'skill' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

		// Style section for captions
		$this->start_controls_section(
			'caption_style_section',
			[
				'label' => __( 'استایل کپشن', 'skill' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'caption_color',
			[
				'label' => __( 'رنگ متن کپشن', 'skill' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .skill-cert-slide .skill-cert-caption' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'caption_bg',
			[
				'label' => __( 'پس‌زمینه کپشن', 'skill' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => 'rgba(0,0,0,0.45)',
				'selectors' => [
					'{{WRAPPER}} .skill-cert-slide .skill-cert-caption' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'nav_bg',
			[
				'label' => __( 'رنگ پسزمینه دکمههای ناوبری', 'skill' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#0E59F2',
				'selectors' => [
					'{{WRAPPER}} .skill-cert-swiper .swiper-button-next, {{WRAPPER}} .skill-cert-swiper .swiper-button-prev' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'nav_icon',
			[
				'label' => __( 'رنگ آیکن ناوبری', 'skill' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .skill-cert-swiper .swiper-button-next:after, {{WRAPPER}} .skill-cert-swiper .swiper-button-prev:after' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'thumb_active_border',
			[
				'label' => __( 'رنگ حالت انتخابِ تصویر کوچک', 'skill' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#0E59F2',
				'selectors' => [
					'{{WRAPPER}} .skill-cert-thumbs .swiper-slide-thumb-active .skill-cert-thumb' => 'box-shadow: 0 0 0 2px {{VALUE}} inset;',
				],
			]
		);

		$this->end_controls_section();

		// Style section for main slider
		$this->start_controls_section(
			'main_slider_style',
			[
				'label' => __( 'استایل اسلایدر اصلی', 'skill' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'slider_width',
			[
				'label' => __( 'عرض اسلایدر (px)', 'skill' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [ 'px' => [ 'min' => 300, 'max' => 800, 'step' => 10 ] ],
				'default' => [ 'unit' => 'px', 'size' => 639 ],
				'selectors' => [
					'{{WRAPPER}} .skill-cert-swiper' => 'width: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

		$this->add_responsive_control(
			'slider_height',
			[
				'label' => __( 'ارتفاع اسلایدر (px)', 'skill' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [ 'px' => [ 'min' => 200, 'max' => 600, 'step' => 10 ] ],
				'default' => [ 'unit' => 'px', 'size' => 346 ],
				'selectors' => [
					'{{WRAPPER}} .skill-cert-swiper' => 'height: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

		$this->add_control(
			'frame_border_color',
			[
				'label' => __( 'رنگ حاشیه قاب', 'skill' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#333333',
				'selectors' => [
					'{{WRAPPER}} .certificate-frame' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'frame_border_width',
			[
				'label' => __( 'ضخامت حاشیه (px)', 'skill' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [ 'px' => [ 'min' => 1, 'max' => 10, 'step' => 1 ] ],
				'default' => [ 'unit' => 'px', 'size' => 3 ],
				'selectors' => [
					'{{WRAPPER}} .certificate-frame' => 'border-width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'frame_border_radius',
			[
				'label' => __( 'گردی گوشه‌ها (px)', 'skill' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [ 'px' => [ 'min' => 0, 'max' => 30, 'step' => 1 ] ],
				'default' => [ 'unit' => 'px', 'size' => 15 ],
				'selectors' => [
					'{{WRAPPER}} .skill-cert-swiper' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		// Style section for thumbnails
		$this->start_controls_section(
			'thumbnails_style',
			[
				'label' => __( 'استایل تصاویر کوچک', 'skill' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [ 'show_thumbs' => 'yes' ],
			]
		);

		$this->add_responsive_control(
			'thumbnails_width',
			[
				'label' => __( 'عرض کانتینر تصاویر کوچک (px)', 'skill' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [ 'px' => [ 'min' => 150, 'max' => 300, 'step' => 5 ] ],
				'default' => [ 'unit' => 'px', 'size' => 215 ],
				'selectors' => [
					'{{WRAPPER}} .thumbnails-container' => 'flex: 0 0 {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'thumb_height',
			[
				'label' => __( 'ارتفاع تصاویر کوچک (px)', 'skill' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [ 'px' => [ 'min' => 60, 'max' => 150, 'step' => 5 ] ],
				'default' => [ 'unit' => 'px', 'size' => 120 ],
				'selectors' => [
					'{{WRAPPER}} .skill-cert-thumb' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'thumb_border_radius',
			[
				'label' => __( 'گردی گوشه‌های تصاویر کوچک (px)', 'skill' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [ 'px' => [ 'min' => 0, 'max' => 30, 'step' => 1 ] ],
				'default' => [ 'unit' => 'px', 'size' => 15 ],
				'selectors' => [
					'{{WRAPPER}} .skill-cert-thumb' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'thumb_active_color',
			[
				'label' => __( 'رنگ تصویر فعال', 'skill' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#333333',
				'selectors' => [
					'{{WRAPPER}} .skill-cert-thumbs .swiper-slide-thumb-active .skill-cert-thumb' => 'box-shadow: 0 0 0 3px {{VALUE}};',
					'{{WRAPPER}} .skill-cert-thumb::after' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'thumb_spacing',
			[
				'label' => __( 'فاصله بین تصاویر کوچک (px)', 'skill' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [ 'px' => [ 'min' => 5, 'max' => 30, 'step' => 1 ] ],
				'default' => [ 'unit' => 'px', 'size' => 15 ],
				'selectors' => [
					'{{WRAPPER}} .skill-cert-thumbs .swiper-slide' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		// Style section for pagination
		$this->start_controls_section(
			'pagination_style',
			[
				'label' => __( 'استایل صفحه‌بندی', 'skill' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [ 'show_pagination' => 'yes' ],
			]
		);

		$this->add_control(
			'pagination_color',
			[
				'label' => __( 'رنگ نقاط صفحه‌بندی', 'skill' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#333333',
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination-bullet' => 'background: {{VALUE}}; border-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'pagination_active_color',
			[
				'label' => __( 'رنگ نقطه فعال', 'skill' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#666666',
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination-bullet-active' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'pagination_size',
			[
				'label' => __( 'سایز نقاط (px)', 'skill' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [ 'px' => [ 'min' => 6, 'max' => 20, 'step' => 1 ] ],
				'default' => [ 'unit' => 'px', 'size' => 12 ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination-bullet' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
	}

	// Render widget output on the frontend
	protected function render() {
		$settings = $this->get_settings_for_display();
		$images = isset($settings['certificates']) ? $settings['certificates'] : [];

		if ( empty( $images ) ) {
			echo '<div>' . esc_html__( 'هیچ تصویری انتخاب نشده است.', 'skill' ) . '</div>';
			return;
		}

		// Register and enqueue Swiper assets from the theme
		$theme_uri = get_template_directory_uri();
		if ( ! wp_style_is( 'skill-swiper', 'registered' ) ) {
			wp_register_style( 'skill-swiper', $theme_uri . '/assets/css/swiper-bundle.min.css', [], null );
		}
		if ( ! wp_script_is( 'skill-swiper', 'registered' ) ) {
			wp_register_script( 'skill-swiper', $theme_uri . '/assets/js/swiper-bundle.min.js', [], null, true );
		}
		wp_enqueue_style( 'skill-swiper' );
		wp_enqueue_script( 'skill-swiper' );

		$uid = uniqid('skill_cert_slider_');

		// Resolve responsive slidesPerView values
		$slides_desktop = isset($settings['slides_per_view']) ? (int)$settings['slides_per_view'] : 3;
		$slides_tablet = isset($settings['slides_per_view_tablet']) && $settings['slides_per_view_tablet'] !== '' ? (int)$settings['slides_per_view_tablet'] : 2;
		$slides_mobile = isset($settings['slides_per_view_mobile']) && $settings['slides_per_view_mobile'] !== '' ? (int)$settings['slides_per_view_mobile'] : 1;

		$effect = ! empty( $settings['effect'] ) ? $settings['effect'] : 'coverflow';
		$autoplay = ( isset($settings['autoplay']) && $settings['autoplay'] === 'yes' ) ? 'true' : 'false';
		$autoplay_delay = ! empty( $settings['autoplay_delay']['size'] ) ? (int)$settings['autoplay_delay']['size'] * 1000 : 5000;
		$loop = ( isset($settings['loop']) && $settings['loop'] === 'yes' ) ? 'true' : 'false';
		$speed = ! empty( $settings['speed']['size'] ) ? (int)$settings['speed']['size'] : 500;
		$show_pagination = ( isset($settings['show_pagination']) && $settings['show_pagination'] === 'yes' );
		$pagination_type = ! empty( $settings['pagination_type'] ) ? $settings['pagination_type'] : 'bullets';
		$show_navigation = ( isset($settings['show_navigation']) && $settings['show_navigation'] === 'yes' );
		$centered = ( isset($settings['center_slides']) && $settings['center_slides'] === 'yes' ) ? 'true' : 'false';
		$space_between = isset($settings['space_between']['size']) ? (int)$settings['space_between']['size'] : 24;
		$show_caption = ( isset($settings['show_caption']) && $settings['show_caption'] === 'yes' );

		// Output markup
		?>
		<div class="skill-certificate-slider" id="<?php echo esc_attr($uid); ?>" dir="rtl"
			data-effect="<?php echo esc_attr($effect); ?>"
			data-autoplay="<?php echo esc_attr($autoplay); ?>"
			data-delay="<?php echo esc_attr($autoplay_delay); ?>"
			data-loop="<?php echo esc_attr($loop); ?>"
			data-speed="<?php echo esc_attr($speed); ?>"
			data-pagination-type="<?php echo esc_attr($pagination_type); ?>"
			data-navigation="<?php echo $show_navigation ? 'true' : 'false'; ?>"
			data-centered="<?php echo esc_attr($centered); ?>"
			data-space-between="<?php echo esc_attr($space_between); ?>"
			data-slides-desktop="<?php echo esc_attr($slides_desktop); ?>"
			data-slides-tablet="<?php echo esc_attr($slides_tablet); ?>"
			data-slides-mobile="<?php echo esc_attr($slides_mobile); ?>"
			data-show-thumbs="<?php echo ( isset($settings['show_thumbs']) && $settings['show_thumbs'] === 'yes') ? 'true' : 'false'; ?>"
			data-thumbs-height="<?php echo isset($settings['thumbs_height']['size']) ? (int)$settings['thumbs_height']['size'] : 64; ?>"
			data-thumbs-space="<?php echo isset($settings['thumbs_space']['size']) ? (int)$settings['thumbs_space']['size'] : 8; ?>"
		>
			<!-- Main Slider Container (Left Side) -->
			<div class="main-slider-container">
			<style>
				/* Certificate Slider - Figma Design Layout */
				#<?php echo esc_html($uid); ?> { 
					direction: rtl; 
					width: 100%;
					max-width: 100%;
					overflow: hidden;
					padding: 40px 20px;
					display: flex;
					gap: 30px;
					align-items: flex-start;
					flex-direction: row-reverse;
					justify-content: center;
				}
				
				/* Main Slider Container (Left Side) */
				#<?php echo esc_html($uid); ?> .main-slider-container {
					flex: 1;
					max-width: 60%;
				}
				
				#<?php echo esc_html($uid); ?> .skill-cert-swiper { 
					position: relative; 
					width: 639px !important; 
					height: 346px !important;
					padding: 0 !important; 
					margin: 0 !important; 
					background: transparent !important;
					border-radius: 15px;
				}
				
				#<?php echo esc_html($uid); ?> .skill-cert-swiper .swiper-wrapper { 
					align-items: center !important; 
					height: 100%;
				}
				
				#<?php echo esc_html($uid); ?> .skill-cert-swiper .swiper-slide {
					width: 100% !important;
					height: 100%;
					background: transparent;
					border-radius: 0;
					overflow: visible;
					transition: all 0.3s ease;
				}
				
				#<?php echo esc_html($uid); ?> .skill-cert-swiper .swiper-slide-active { 
					z-index: 2; 
				}
				
				#<?php echo esc_html($uid); ?> .skill-cert-slide {
					position: relative;
					width: 100%;
					height: 100%;
					display: flex;
					align-items: center;
					justify-content: center;
					padding: 0;
					border-radius: 8px;
					box-shadow: 0 8px 32px rgba(0,0,0,0.15);
				}
				
				/* Certificate Frame */
				#<?php echo esc_html($uid); ?> .certificate-frame {
					position: relative;
					width: 100%;
					height: 100%;
					border: 3px solid #333;
					border-radius: 0;
					overflow: hidden;
					box-shadow: 0 0 30px rgba(0, 0, 0, 0.3);
				}
				
				/* Decorative Bottom Border */
				#<?php echo esc_html($uid); ?> .certificate-frame::after {
					content: '';
					position: absolute;
					bottom: 0;
					left: 0;
					right: 0;
					height: 60px;
					background: linear-gradient(45deg, #333 0%, #666 50%, #333 100%);
					z-index: 1;
				}
				
				/* Certificate Content Area */
				#<?php echo esc_html($uid); ?> .certificate-content {
					position: relative;
					width: 100%;
					height: 100%;
					background: #fff;
					display: flex;
					align-items: center;
					justify-content: center;
					z-index: 2;
				}
				
				#<?php echo esc_html($uid); ?> .skill-cert-image { 
					position: relative; 
					display: block; 
					max-width: 100%; 
					max-height: 100%; 
					width: auto;
					height: auto;
					object-fit: contain; 
					background: transparent;
					border-radius: 0;
					box-shadow: none;
				}
				
				#<?php echo esc_html($uid); ?> .skill-cert-overlay {
					display: none;
				}
				
				#<?php echo esc_html($uid); ?> .skill-cert-caption {
					position: absolute; 
					left: 20px; 
					right: 20px; 
					bottom: 20px;
					padding: 12px 16px; 
					border-radius: 0;
					background: rgba(0,0,0,0.8);
					backdrop-filter: blur(8px);
					font-size: 14px; 
					font-weight: 600; 
					line-height: 1.5;
					color: #fff;
					text-align: center;
					border: 1px solid #333;
				}
				
				/* Hide Navigation buttons */
				#<?php echo esc_html($uid); ?> .skill-cert-swiper .swiper-button-next,
				#<?php echo esc_html($uid); ?> .skill-cert-swiper .swiper-button-prev {
					display: none !important;
				}
				
				/* Pagination */
				#<?php echo esc_html($uid); ?> .skill-cert-swiper .swiper-pagination { 
					bottom: 20px; 
					z-index: 10;
				}
				
				#<?php echo esc_html($uid); ?> .skill-cert-swiper .swiper-pagination-bullet {
					background: #333; 
					opacity: 0.4; 
					width: 12px; 
					height: 12px;
					margin: 0 6px;
					transition: all 0.3s ease;
					border: 1px solid #333;
				}
				
				#<?php echo esc_html($uid); ?> .skill-cert-swiper .swiper-pagination-bullet-active { 
					opacity: 1; 
					transform: scale(1.2);
					background: #666;
				}

				/* Thumbnails Container (Right Side) */
				#<?php echo esc_html($uid); ?> .thumbnails-container {
					flex: 0 0 215px;
					height: 346px;
					overflow-y: auto;
					padding-right: 10px;
					position: relative;
				}
				
				/* Hide scrollbar */
				#<?php echo esc_html($uid); ?> .thumbnails-container::-webkit-scrollbar {
					display: none;
				}
				
				#<?php echo esc_html($uid); ?> .thumbnails-container {
					scrollbar-width: none;
					-ms-overflow-style: none;
				}
				
				#<?php echo esc_html($uid); ?> .skill-cert-thumbs { 
					margin: 0; 
					padding: 0;
					height: 100%;
				}
				
				#<?php echo esc_html($uid); ?> .skill-cert-thumbs .swiper-wrapper {
					flex-direction: column !important;
					height: auto !important;
				}
				
				#<?php echo esc_html($uid); ?> .skill-cert-thumbs .swiper-slide { 
					width: 100% !important; 
					height: auto !important;
					margin-bottom: 15px;
				}
				
				#<?php echo esc_html($uid); ?> .skill-cert-thumb {
					width: 100%; 
					height: 120px; 
					aspect-ratio: 3/4; 
					border-radius: 15px; 
					overflow: hidden;
					background: #fff; 
					box-shadow: 0 4px 12px rgba(0,0,0,0.1);
					transition: all 0.3s ease;
					cursor: pointer;
					border: 2px solid transparent;
					position: relative;
				}
				
				#<?php echo esc_html($uid); ?> .skill-cert-thumb img { 
					width: 100%; 
					height: 100%; 
					object-fit: cover; 
					display: block; 
					background: #fff; 
					filter: grayscale(20%); 
					opacity: 0.8; 
					transition: all 0.3s ease; 
				}
				
				#<?php echo esc_html($uid); ?> .skill-cert-thumbs .swiper-slide-thumb-active .skill-cert-thumb { 
					box-shadow: 0 0 0 3px #333, 0 8px 24px rgba(0, 0, 0, 0.3); 
					transform: scale(1.02);
					border-color: #333;
				}
				
				#<?php echo esc_html($uid); ?> .skill-cert-thumbs .swiper-slide-thumb-active .skill-cert-thumb img { 
					filter: none; 
					opacity: 1; 
				}
				
				/* Active indicator */
				#<?php echo esc_html($uid); ?> .skill-cert-thumb::after {
					content: '';
					position: absolute;
					top: 8px;
					right: 8px;
					width: 12px;
					height: 12px;
					background: #333;
					border-radius: 50%;
					opacity: 0;
					transition: opacity 0.3s ease;
				}
				
				#<?php echo esc_html($uid); ?> .skill-cert-thumbs .swiper-slide-thumb-active .skill-cert-thumb::after {
					opacity: 1;
				}
				
				/* Responsive design */
				@media (max-width: 1024px) {
					#<?php echo esc_html($uid); ?> {
						flex-direction: column;
						gap: 20px;
					}
					
					#<?php echo esc_html($uid); ?> .main-slider-container {
						max-width: 100%;
					}
					
					#<?php echo esc_html($uid); ?> .thumbnails-container {
						flex: none;
						height: auto;
						width: 100%;
					}
					
					#<?php echo esc_html($uid); ?> .skill-cert-thumbs .swiper-wrapper {
						flex-direction: row !important;
						height: auto !important;
					}
					
					#<?php echo esc_html($uid); ?> .skill-cert-thumbs .swiper-slide {
						width: auto !important;
						height: auto !important;
						margin-right: 15px;
						margin-bottom: 0;
					}
					
					#<?php echo esc_html($uid); ?> .skill-cert-thumb {
						width: 80px;
						height: 100px;
					}
				}
				
				@media (max-width: 768px) {
					#<?php echo esc_html($uid); ?> .skill-cert-swiper { 
						width: 100% !important;
						height: 300px !important;
					}
					
					#<?php echo esc_html($uid); ?> .thumbnails-container {
						height: 300px;
					}
				}
			</style>
				<div class="swiper skill-cert-swiper">
					<div class="swiper-wrapper">
						<?php foreach ( $images as $index => $image ) :
							$url = isset($image['url']) ? $image['url'] : '';
							$id  = isset($image['id']) ? (int)$image['id'] : 0;
							if ( ! $url ) { continue; }
							$alt = '';
							if ( $id ) {
								$alt = get_post_meta( $id, '_wp_attachment_image_alt', true );
							}
							if ( ! $alt ) {
								$alt = sprintf( esc_html__( 'گواهینامه %d', 'skill' ), $index + 1 );
							}
							$title = '';
							if ( $id ) {
								$attachment = get_post( $id );
								if ( $attachment && ! is_wp_error( $attachment ) ) {
									$title = $attachment->post_title;
								}
							}
						?>
						<div class="swiper-slide">
							<figure class="skill-cert-slide">
								<div class="certificate-frame">
									<div class="certificate-content">
										<img class="skill-cert-image" src="<?php echo esc_url( $url ); ?>" alt="<?php echo esc_attr( $alt ); ?>"/>
										<?php if ( $show_caption && $title ) : ?>
											<figcaption class="skill-cert-caption"><?php echo esc_html( $title ); ?></figcaption>
										<?php endif; ?>
									</div>
								</div>
							</figure>
						</div>
						<?php endforeach; ?>
					</div>

					<?php if ( $show_navigation ) : ?>
						<div class="swiper-button-next"></div>
						<div class="swiper-button-prev"></div>
					<?php endif; ?>

					<?php if ( $show_pagination ) : ?>
						<div class="swiper-pagination"></div>
					<?php endif; ?>
				</div>
			</div>

			<!-- Thumbnails Container (Right Side) -->
			<?php if ( isset($settings['show_thumbs']) && $settings['show_thumbs'] === 'yes' ) : ?>
			<div class="thumbnails-container">
				<div class="swiper skill-cert-thumbs">
					<div class="swiper-wrapper">
						<?php foreach ( $images as $index => $image ) : 
							$url = isset($image['url']) ? $image['url'] : ''; 
							if ( ! $url ) { continue; } 
						?>
							<div class="swiper-slide">
								<div class="skill-cert-thumb">
									<img src="<?php echo esc_url( $url ); ?>" alt="thumb">
								</div>
							</div>
						<?php endforeach; ?>
					</div>
				</div>
			</div>
			<?php endif; ?>

			<script>
				// Initialize Swiper safely (works in Elementor editor and frontend)
				(function(){
					var rootId = '<?php echo esc_js( $uid ); ?>';
					function initSlider(){
						var root = document.getElementById(rootId);
						if(!root) return;
						var el = root.querySelector('.skill-cert-swiper');
						if(!el) return;

						var effect = root.getAttribute('data-effect') || 'coverflow';
						var autoplay = root.getAttribute('data-autoplay') === 'true';
						var delay = parseInt(root.getAttribute('data-delay') || '5000', 10);
						var loop = root.getAttribute('data-loop') === 'true';
						var speed = parseInt(root.getAttribute('data-speed') || '500', 10);
						
						// Debug: Log values to console
						console.log('Slider Settings:', {
							autoplay: autoplay,
							delay: delay,
							speed: speed,
							loop: loop
						});
						var nav = root.getAttribute('data-navigation') === 'true';
						var centered = root.getAttribute('data-centered') === 'true';
						var spaceBetween = parseInt(root.getAttribute('data-space-between') || '24', 10);
						var slidesDesktop = parseInt(root.getAttribute('data-slides-desktop') || '3', 10);
						var slidesTablet = parseInt(root.getAttribute('data-slides-tablet') || '2', 10);
						var slidesMobile = parseInt(root.getAttribute('data-slides-mobile') || '1', 10);
						var paginationType = root.getAttribute('data-pagination-type') || 'bullets';

						var config = {
							loop: loop,
							speed: speed,
							spaceBetween: spaceBetween,
							centeredSlides: false,
							effect: 'slide',
							grabCursor: true,
							direction: 'horizontal',
							observer: true,
							observeParents: true,
							resizeObserver: true,
							slidesPerView: 1,
							// RTL is handled via container dir="rtl" and CSS
						};

						if (autoplay) {
							config.autoplay = { delay: delay, disableOnInteraction: false };
						}

						// Simple slide effect - no additional effects needed

						if (<?php echo $show_pagination ? 'true' : 'false'; ?>) {
							config.pagination = { el: root.querySelector('.swiper-pagination'), clickable: true, type: paginationType };
						}

						if (nav) {
							config.navigation = { nextEl: root.querySelector('.swiper-button-next'), prevEl: root.querySelector('.swiper-button-prev') };
						}

						// Destroy existing instance in Elementor editor before re-init
						if (el && el.swiper && typeof el.swiper.destroy === 'function') {
							try { el.swiper.destroy(true, true); } catch(e) {}
						}
						var mainSwiper = new Swiper(el, config);

						// Thumbnails
						var showThumbs = root.getAttribute('data-show-thumbs') === 'true';
						if (showThumbs) {
							var thumbsEl = root.querySelector('.skill-cert-thumbs');
							if (thumbsEl) {
								var thumbs = new Swiper(thumbsEl, {
									direction: 'vertical',
									spaceBetween: 15,
									slidesPerView: 'auto',
									freeMode: true,
									watchSlidesProgress: true,
									centeredSlides: true,
								});
								
								function updateThumbActive(index){
									if(!thumbs || !thumbs.slides){ return; }
									for(var t=0; t<thumbs.slides.length; t++){
										thumbs.slides[t].classList.remove('swiper-slide-thumb-active');
									}
									if(thumbs.slides[index]){
										thumbs.slides[index].classList.add('swiper-slide-thumb-active');
									}
								}
								
								updateThumbActive(mainSwiper.realIndex || 0);
								
								mainSwiper.on('slideChange', function(){
									var i = mainSwiper.realIndex;
									updateThumbActive(i);
									// Auto scroll to active thumbnail
									if (thumbs && thumbs.slides && thumbs.slides[i]) {
										thumbs.slideTo(i, 300);
									}
								});
								
								// Click on thumbnail to change main slide
								if (thumbs && typeof thumbs.on === 'function') {
									thumbs.on('click', function(swiper){
										if (typeof swiper.clickedIndex === 'number') {
											mainSwiper.slideTo(swiper.clickedIndex);
											updateThumbActive(swiper.clickedIndex);
										}
									});
								}
								
								// Click on thumbnails directly
								var thumbElements = thumbsEl.querySelectorAll('.skill-cert-thumb');
								thumbElements.forEach(function(thumb, index) {
									thumb.addEventListener('click', function() {
										mainSwiper.slideTo(index);
										updateThumbActive(index);
									});
								});
							}
						}
					}

					function whenSwiperReady(attempt){
						attempt = attempt || 0;
						if (typeof window.Swiper === 'function') { initSlider(); return; }
						if (attempt > 60) { return; }
						setTimeout(function(){ whenSwiperReady(attempt + 1); }, 100);
					}

					if (document.readyState === 'loading') {
						document.addEventListener('DOMContentLoaded', function(){ whenSwiperReady(0); });
					} else {
						whenSwiperReady(0);
					}
				})();
			</script>
		</div>
		<?php
	}
}


