<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;

class Skill_Certificate_Widget extends Widget_Base {

    public function get_name() {
        return 'skill_certificate';
    }

    public function get_title() {
        return __( 'گواهینامه ها', 'skill' );
    }

    public function get_icon() {
        return 'eicon-star';
    }

    public function get_categories() {
        return [ 'skill-category' ];
    }

    // Register widget controls
    protected function register_controls() {

        // General section
        $this->start_controls_section(
            'section_general',
            [
                'label' => __( 'تنظیمات کلی', 'skill' ),
            ]
        );

        $this->add_control(
            'main_title',
            [
                'label' => __( 'عنوان کلی ویجت', 'skill' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'گواهینامه‌های من', 'skill' ),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        // Certificates section
        $this->start_controls_section(
            'section_certificates',
            [
                'label' => __( 'گواهینامه‌ها', 'skill' ),
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'title',
            [
                'label' => __( 'عنوان گواهینامه', 'skill' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'سئو تکنیکال', 'skill' ),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'subtitle',
            [
                'label' => __( 'زیرعنوان', 'skill' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'اصول دیجیتال مارکتینگ (۱۳۹۹)', 'skill' ),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'image',
            [
                'label' => __( 'تصویر لوگو', 'skill' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'certificates',
            [
                'label' => __( 'گواهینامه‌ها', 'skill' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'title' => 'سئوتکنیکال',
                        'subtitle' => 'اصول یادگیری سئو سال 1399',
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->end_controls_section();

        // Style tab
        $this->start_controls_section(
            'section_style',
            [
                'label' => __( 'استایل', 'skill' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        // Widget background
        $this->add_control(
            'widget_bg_color',
            [
                'label' => __( 'رنگ پس‌زمینه ویجت', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#181C2A24',
                'selectors' => [
                    '{{WRAPPER}} .skill-certificate-list' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        // Main title color
        $this->add_control(
            'main_title_color',
            [
                'label' => __( 'رنگ عنوان کلی', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#8D8D8D',
                'selectors' => [
                    '{{WRAPPER}} .skill-certificate-main-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        // Certificate item background
        $this->add_control(
            'item_bg_color',
            [
                'label' => __( 'رنگ پس‌زمینه هر گواهینامه', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#080708',
                'selectors' => [
                    '{{WRAPPER}} .skill-certificate-item' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        // Certificate title color
        $this->add_control(
            'title_color',
            [
                'label' => __( 'رنگ عنوان گواهینامه', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#0E59F2',
                'selectors' => [
                    '{{WRAPPER}} .skill-certificate-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        // Certificate subtitle color
        $this->add_control(
            'subtitle_color',
            [
                'label' => __( 'رنگ زیرعنوان', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .skill-certificate-subtitle' => 'color: {{VALUE}};',
                ],
            ]
        );

        // Logo background color
        $this->add_control(
            'logo_bg_color',
            [
                'label' => __( 'رنگ پس‌زمینه لوگو', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#181a28',
                'selectors' => [
                    '{{WRAPPER}} .skill-certificate-logo' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        // Logo size
        $this->add_responsive_control(
            'logo_size',
            [
                'label' => __( 'اندازه لوگو', 'skill' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 32,
                        'max' => 120,
                    ],
                ],
                'default' => [
                    'size' => 56,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .skill-certificate-logo' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .skill-certificate-logo img' => 'width: 100%; height: 100%;',
                ],
            ]
        );

        // Max Height for List
$this->add_responsive_control(
    'list_max_height',
    [
        'label' => __( 'حداکثر ارتفاع لیست', 'skill' ),
        'type' => Controls_Manager::SLIDER,
        'size_units' => [ 'px' ],
        'range' => [
            'px' => [
                'min' => 100,
                'max' => 1000,
            ],
        ],
        'default' => [
            'size' => 350,
            'unit' => 'px',
        ],
        'selectors' => [
            '{{WRAPPER}} .skill-certificate-list' => 'max-height: {{SIZE}}{{UNIT}}; overflow-y: auto;',
        ],
    ]
);

        // Title dot color
        $this->add_control(
            'title_dot_color',
            [
                'label' => __( 'رنگ مربع عنوان', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#1e73be',
                'selectors' => [
                    '{{WRAPPER}} .skill-certificate-title-dot' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    // Render widget output
    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="skill-certificate-list">
        <?php if ( ! empty( $settings['main_title'] ) ) : ?>
    <div class="skill-certificate-title-row" style="display:inline-flex;align-items:center;gap:8px;margin-bottom:24px;flex-direction:row-reverse;justify-content: flex-end;">
        <h2 class="skill-certificate-main-title" style="font-size:24px;font-weight:bold;"><?php echo esc_html( $settings['main_title'] ); ?></h2>
        <span class="skill-certificate-title-dot" aria-hidden="true"></span>
    </div>
<?php endif; ?>
<div class="skill-certificate-list">
    <?php if ( ! empty( $settings['certificates'] ) ) : ?>
        <?php foreach ( $settings['certificates'] as $item ) : ?>
            <div class="skill-certificate-item">
                <!-- Logo on the right -->
                <?php if ( ! empty( $item['image']['url'] ) ) : ?>
                    <div class="skill-certificate-logo">
                        <img src="<?php echo esc_url( $item['image']['url'] ); ?>" alt="<?php echo esc_attr( $item['title'] ); ?>">
                    </div>
                <?php endif; ?>
                <!-- Text on the left -->
                <div class="skill-certificate-content">
                    <div class="skill-certificate-title">
                        <?php echo esc_html( $item['title'] ); ?>
                    </div>
                    <div class="skill-certificate-subtitle">
                        <?php echo esc_html( $item['subtitle'] ); ?>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>
</div>
        <style>
        /* Certificate Widget Styles */
        .skill-certificate-list {
            display: flex;
            flex-direction: column;
            gap: 16px;
            border-radius: 12px;
            padding: 12px;
            max-height: 350px;
            overflow-y: auto;
            direction: rtl;
            text-align: right;
        }
        .skill-certificate-title-dot {width:10px;height:10px;background:#1e73be;border-radius:2px;display:inline-block}
.skill-certificate-item {
    display: flex;
    flex-direction: row-reverse;
    align-items: center;
    border-radius: 12px;
    padding: 18px 24px;
    transition: box-shadow 0.3s;
    margin-bottom: 0;
}
.skill-certificate-logo {
    border-radius: 16px;
    display: flex;
    align-items: center;
    justify-content: center;
    min-width: 56px;
    min-height: 56px;
    background: #181a28;
    transition: background 0.3s;
    margin-right: 20px;
}
.skill-certificate-logo img {
    border-radius: 12px;
    filter: grayscale(100%);
    transition: filter 0.3s;
    background: transparent;
    padding: 0;
}
.skill-certificate-item:hover {
    cursor: pointer;
}
.skill-certificate-item:hover .skill-certificate-logo img {
    filter: grayscale(0%);
}
.skill-certificate-content {
    display: flex;
    flex-direction: column;
    gap: 8px;
    flex: 1;
    text-align: right;
}

.skill-certificate-title {
	font-size: 18px;
    font-weight: bold;
}

.skill-certificate-subtitle {
	font-size: 15px;
    font-weight: 300;
}
        </style>
        <?php
    }
}