<?php


class skill_comments_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'skill_comments_Widget';
    }

    public function get_title() {
        return esc_html__('نظرات مشتریان من', 'skill');
    }

    public function get_icon() {
        return 'eicon-testimonial-carousel';
    }

    public function get_categories() {
        return ['skill-category'];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('محتوا', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'user_image',
            [
                'label' => esc_html__('تصویر کاربر', 'skill'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'user_name',
            [
                'label' => esc_html__('نام کاربر', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('کاربر نمونه', 'skill'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'user_comment',
            [
                'label' => esc_html__('نظر کاربر', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است', 'skill'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'user_rating',
            [
                'label' => esc_html__('امتیاز (ستاره)', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [''],
                'range' => [
                    '' => [
                        'min' => 1,
                        'max' => 5,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => '',
                    'size' => 5,
                ],
            ]
        );

        $repeater->add_control(
            'user_position',
            [
                'label' => esc_html__('سمت/شغل', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('مشتری راضی', 'skill'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'testimonials_list',
            [
                'label' => esc_html__('لیست نظرات', 'skill'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'user_name' => esc_html__('سپیده', 'skill'),
                        'user_comment' => esc_html__('لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است', 'skill'),
                        'user_rating' => ['size' => 5],
                        'user_position' => esc_html__('مدیر پروژه', 'skill'),
                    ],
                    [
                        'user_name' => esc_html__('سارا', 'skill'),
                        'user_comment' => esc_html__('لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است', 'skill'),
                        'user_rating' => ['size' => 5],
                        'user_position' => esc_html__('توسعه‌دهنده', 'skill'),
                    ],
                ],
                'title_field' => '{{{ user_name }}}',
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('پخش خودکار', 'skill'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('فعال', 'skill'),
                'label_off' => esc_html__('غیرفعال', 'skill'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'autoplay_speed',
            [
                'label' => esc_html__('سرعت پخش خودکار (میلی‌ثانیه)', 'skill'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 3000,
                'condition' => [
                    'autoplay' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'show_rating',
            [
                'label' => esc_html__('نمایش ستاره‌های امتیاز', 'skill'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'skill'),
                'label_off' => esc_html__('مخفی', 'skill'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_position',
            [
                'label' => esc_html__('نمایش سمت/شغل', 'skill'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'skill'),
                'label_off' => esc_html__('مخفی', 'skill'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('استایل', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'container_style',
            [
                'label' => esc_html__('کانتینر', 'skill'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'container_width',
            [
                'label' => esc_html__('عرض کانتینر', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['%', 'px'],
                'range' => [
                    '%' => [
                        'min' => 50,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 300,
                        'max' => 1200,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 80,
                ],
                'selectors' => [
                    '{{WRAPPER}} .skill-testimonial-container' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'container_bg',
            [
                'label' => esc_html__('پس‌زمینه', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .skill-testimonial-swiper' => 'background-color: {{VALUE}}',
                ],
                'default' => '#ffffff',
            ]
        );

        $this->add_control(
            'container_shadow',
            [
                'label' => __('سایه باکس', 'skill'),
                'type' => \Elementor\Controls_Manager::BOX_SHADOW,
                'selectors' => [
                    '{{WRAPPER}} .skill-testimonial-swiper' => 'box-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{SPREAD}}px {{COLOR}};',
                ],
                'default' => [
                    'horizontal' => 0,
                    'vertical' => 10,
                    'blur' => 30,
                    'spread' => 0,
                    'color' => 'rgba(0, 0, 0, 0.1)',
                ]
            ]
        );

        $this->add_control(
            'container_shadow_hover',
            [
                'label' => __('سایه باکس هنگام هاور', 'skill'),
                'type' => \Elementor\Controls_Manager::BOX_SHADOW,
                'selectors' => [
                    '{{WRAPPER}} .skill-testimonial-swiper:hover' => 'box-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{SPREAD}}px {{COLOR}};',
                ],
                'default' => [
                    'horizontal' => 0,
                    'vertical' => 15,
                    'blur' => 40,
                    'spread' => 0,
                    'color' => 'rgba(0, 0, 0, 0.15)',
                ]
            ]
        );

        $this->add_control(
            'avatar_border_width',
            [
                'label' => esc_html__('ضخامت حاشیه آواتار', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 20,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 3,
                ],
                'selectors' => [
                    '{{WRAPPER}} .skill-testimonial-avatar' => 'border-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'avatar_border_radius',
            [
                'label' => esc_html__('گردی گوشه‌های آواتار', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['%', 'px'],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 100,
                ],
                'selectors' => [
                    '{{WRAPPER}} .skill-testimonial-avatar' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'avatar_border_color',
            [
                'label' => esc_html__('رنگ حاشیه آواتار', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .skill-testimonial-avatar' => 'border-color: {{VALUE}}; border-style: solid;',
                ],
            ]
        );

        $this->add_control(
            'avatar_style',
            [
                'label' => esc_html__('آواتار', 'skill'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'avatar_size',
            [
                'label' => esc_html__('اندازه آواتار', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 50,
                        'max' => 200,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 80,
                ],
                'selectors' => [
                    '{{WRAPPER}} .skill-testimonial-avatar' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'text_style',
            [
                'label' => esc_html__('متن', 'skill'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'name_color',
            [
                'label' => esc_html__('رنگ نام', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#333333',
                'selectors' => [
                    '{{WRAPPER}} .skill-testimonial-name' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'name_typography',
                'selector' => '{{WRAPPER}} .skill-testimonial-name',
                'label' => esc_html__('تایپوگرافی نام', 'skill'),
            ]
        );

        $this->add_control(
            'comment_color',
            [
                'label' => esc_html__('رنگ نظر', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#666666',
                'selectors' => [
                    '{{WRAPPER}} .skill-testimonial-comment' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'comment_typography',
                'selector' => '{{WRAPPER}} .skill-testimonial-comment',
                'label' => esc_html__('تایپوگرافی نظر', 'skill'),
            ]
        );

        $this->add_control(
            'position_style',
            [
                'label' => esc_html__('سمت/شغل', 'skill'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'position_color',
            [
                'label' => esc_html__('رنگ سمت', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#667eea',
                'selectors' => [
                    '{{WRAPPER}} .skill-testimonial-position' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'position_typography',
                'selector' => '{{WRAPPER}} .skill-testimonial-position',
                'label' => esc_html__('تایپوگرافی سمت', 'skill'),
            ]
        );

        $this->add_control(
            'rating_style',
            [
                'label' => esc_html__('ستاره‌های امتیاز', 'skill'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'star_color',
            [
                'label' => esc_html__('رنگ ستاره', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffd700',
                'selectors' => [
                    '{{WRAPPER}} .skill-testimonial-star' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'star_size',
            [
                'label' => esc_html__('اندازه ستاره', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 12,
                        'max' => 30,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 18,
                ],
                'selectors' => [
                    '{{WRAPPER}} .skill-testimonial-star' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'pagination_style',
            [
                'label' => esc_html__('صفحه‌بندی', 'skill'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'pagination_color',
            [
                'label' => esc_html__('رنگ', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#007bff',
                'selectors' => [
                    '{{WRAPPER}} .skill-testimonial-pagination .swiper-pagination-bullet' => 'background: {{VALUE}}',
                    '{{WRAPPER}} .skill-testimonial-pagination .swiper-pagination-bullet-active' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $id = 'testimonial-slider-' . $this->get_id();

        if (empty($settings['testimonials_list'])) {
            return;
        }

        $autoplay = $settings['autoplay'] === 'yes' ? [
            'delay' => $settings['autoplay_speed'],
            'disableOnInteraction' => false,
        ] : false;
        ?>

        <div class="skill-testimonial-wrapper" dir="rtl">
            <div class="skill-testimonial-container">
                <div class="skill-testimonial-swiper swiper" id="<?php echo esc_attr($id); ?>">
                    <div class="swiper-wrapper">
                        <?php foreach ($settings['testimonials_list'] as $item): ?>
                            <div class="skill-testimonial-slide swiper-slide">
                                <?php if (!empty($item['user_image']['url'])): ?>
                                    <img src="<?php echo esc_url($item['user_image']['url']); ?>" class="skill-testimonial-avatar" alt="<?php echo esc_attr($item['user_name']); ?>">
                                <?php endif; ?>
                                <div class="skill-testimonial-name"><?php echo esc_html($item['user_name']); ?></div>
                                <?php if ($settings['show_position'] === 'yes' && !empty($item['user_position'])): ?>
                                    <div class="skill-testimonial-position"><?php echo esc_html($item['user_position']); ?></div>
                                <?php endif; ?>
                                <?php if ($settings['show_rating'] === 'yes' && !empty($item['user_rating']['size'])): ?>
                                    <div class="skill-testimonial-rating">
                                        <?php for ($i = 1; $i <= 5; $i++): ?>
                                            <span class="skill-testimonial-star"><?php echo $i <= $item['user_rating']['size'] ? '★' : '☆'; ?></span>
                                        <?php endfor; ?>
                                    </div>
                                <?php endif; ?>
                                <div class="skill-testimonial-comment"><?php echo esc_html($item['user_comment']); ?></div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <div class="skill-testimonial-pagination swiper-pagination"></div>
                </div>
            </div>
        </div>

        <script>
            jQuery(document).ready(function($) {
                new Swiper('#<?php echo esc_js($id); ?>', {
                    loop: true,
                    autoplay: <?php echo $autoplay ? wp_json_encode($autoplay) : 'false'; ?>,
                    pagination: {
                        el: '.swiper-pagination',
                        clickable: true,
                    },
                    rtl: true,
                    effect: 'slide',
                    speed: 800,
                    spaceBetween: 30,
                    on: {
                        init: function() {
                            $('.skill-testimonial-wrapper').addClass('loaded');
                        },
                        slideChange: function() {
                            $('.skill-testimonial-slide').removeClass('skill-testimonial-slide-active');
                            $('.swiper-slide-active').addClass('skill-testimonial-slide-active');
                        }
                    }
                });
            });
        </script>
        <?php
    }

    protected function content_template() {
        ?>
        <#
        var autoplay = settings.autoplay === 'yes' ? {
        delay: settings.autoplay_speed,
        disableOnInteraction: false
        } : false;
        #>

        <div class="skill-testimonial-wrapper" dir="rtl">
            <div class="skill-testimonial-container">
                <div class="skill-testimonial-swiper swiper" id="testimonial-slider-{{ view.getID() }}">
                    <div class="swiper-wrapper">
                        <# _.each(settings.testimonials_list, function(item) { #>
                        <div class="skill-testimonial-slide swiper-slide">
                            <# if (item.user_image.url) { #>
                            <img src="{{ item.user_image.url }}" class="skill-testimonial-avatar" alt="{{ item.user_name }}">
                            <# } #>
                            <div class="skill-testimonial-name">{{{ item.user_name }}}</div>
                            <# if (settings.show_position === 'yes' && item.user_position) { #>
                            <div class="skill-testimonial-position">{{{ item.user_position }}}</div>
                            <# } #>
                            <# if (settings.show_rating === 'yes' && item.user_rating && item.user_rating.size) { #>
                            <div class="skill-testimonial-rating">
                                <# for (var i = 1; i <= 5; i++) { #>
                                <span class="skill-testimonial-star">{{{ i <= item.user_rating.size ? '★' : '☆' }}}</span>
                                <# } #>
                            </div>
                            <# } #>
                            <div class="skill-testimonial-comment">{{{ item.user_comment }}}</div>
                        </div>
                        <# }); #>
                    </div>
                    <div class="skill-testimonial-pagination swiper-pagination"></div>
                </div>
            </div>
        </div>

        <script>
            jQuery(document).ready(function($) {
                new Swiper('#testimonial-slider-{{ view.getID() }}', {
                    loop: true,
                    autoplay: <# print(JSON.stringify(autoplay)) #>,
                pagination: {
                    el: '.swiper-pagination',
                        clickable: true,
                },
                rtl: true,
            });
            });
        </script>
        <?php
    }
}