<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class skill_contact_us_widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'skill_contact_us_widget';
    }

    public function get_title() {
        return __('فرم تماس مدرن', 'skill');
    }

    public function get_icon() {
        return 'eicon-mail';
    }

    public function get_categories() {
        return ['skill-category'];
    }

    public function get_keywords() {
        return ['contact', 'form', 'modern', 'dark', 'skill', 'glassmorphism'];
    }

    protected function _register_controls() {
        
		// Content Section
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

		// Replace basic title/subtitle with the Skill Title+Desc capability
		$this->add_control('show_title', [
			'label' => __('نمایش عنوان', 'skill'),
			'type' => \Elementor\Controls_Manager::SWITCHER,
			'label_on' => __('بله', 'skill'),
			'label_off' => __('خیر', 'skill'),
			'return_value' => 'yes',
			'default' => 'yes',
		]);
		$this->add_control('title_text', [
			'label' => __('عنوان', 'skill'),
			'type' => \Elementor\Controls_Manager::TEXT,
			'default' => __('تماس با ما', 'skill'),
			'condition' => ['show_title' => 'yes'],
			'label_block' => true,
		]);
		$this->add_control('show_dot', [
			'label' => __('نمایش مربع آبی', 'skill'),
			'type' => \Elementor\Controls_Manager::SWITCHER,
			'label_on' => __('بله', 'skill'),
			'label_off' => __('خیر', 'skill'),
			'return_value' => 'yes',
			'default' => 'yes',
		]);
		$this->add_control('dot_position', [
			'label' => __('جایگاه مربع', 'skill'),
			'type' => \Elementor\Controls_Manager::SELECT,
			'options' => [ 'right' => __('راست عنوان', 'skill'), 'left' => __('چپ عنوان', 'skill') ],
			'default' => 'right',
			'condition' => ['show_dot' => 'yes']
		]);
		$this->add_control('show_desc', [
			'label' => __('نمایش توضیح کوتاه', 'skill'),
			'type' => \Elementor\Controls_Manager::SWITCHER,
			'label_on' => __('بله', 'skill'),
			'label_off' => __('خیر', 'skill'),
			'return_value' => 'yes',
			'default' => 'yes',
		]);
		$this->add_control('desc_text', [
			'label' => __('توضیح کوتاه', 'skill'),
			'type' => \Elementor\Controls_Manager::TEXTAREA,
			'default' => __('از طریق فرم زیر با ما در تماس باشید', 'skill'),
			'rows' => 2,
			'condition' => ['show_desc' => 'yes']
		]);

        $this->add_control(
            'contact_form_shortcode',
            [
                'label' => __('کد کوتاه فرم تماس', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '[contact-form-7 id="2312" title="Contact form 1"]',
                'placeholder' => __('کد کوتاه Contact Form 7 را وارد کنید', 'skill'),
                'description' => __('کد کوتاه فرم تماس خود را اینجا قرار دهید', 'skill'),
            ]
        );

        $this->add_control(
            'show_contact_info',
            [
                'label' => __('نمایش اطلاعات تماس', 'skill'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('نمایش', 'skill'),
                'label_off' => __('مخفی', 'skill'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'enable_animations',
            [
                'label' => __('فعال‌سازی انیمیشن‌ها', 'skill'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('فعال', 'skill'),
                'label_off' => __('غیرفعال', 'skill'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );



        $this->end_controls_section();

        // Contact Info Section
        $this->start_controls_section(
            'contact_info_section',
            [
                'label' => __('اطلاعات تماس', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'show_contact_info' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'phone',
            [
                'label' => __('شماره تماس', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('09380000000', 'skill'),
                'placeholder' => __('شماره تماس را وارد کنید', 'skill'),
            ]
        );

        $this->add_control(
            'email',
            [
                'label' => __('ایمیل', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('info@example.com', 'skill'),
                'placeholder' => __('آدرس ایمیل را وارد کنید', 'skill'),
            ]
        );

        $this->add_control(
            'address',
            [
                'label' => __('آدرس', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('شهرکرد ، ایران', 'skill'),
                'placeholder' => __('آدرس را وارد کنید', 'skill'),
            ]
        );

        $this->add_control(
            'working_hours',
            [
                'label' => __('ساعات کاری', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('شنبه تا چهارشنبه: 9 صبح تا 6 عصر', 'skill'),
                'placeholder' => __('ساعات کاری را وارد کنید', 'skill'),
            ]
        );

        $this->end_controls_section();



        // Social Links Section
        $this->start_controls_section(
            'social_links_section',
            [
                'label' => __('شبکه‌های اجتماعی', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'social_icon',
            [
                'label' => __('آیکون', 'skill'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'telegram',
                'options' => [
                    'telegram' => __('تلگرام', 'skill'),
                    'linkedin' => __('لینکدین', 'skill'),
                    'github' => __('گیت‌هاب', 'skill'),
                    'instagram' => __('اینستاگرام', 'skill'),
                    'twitter' => __('توییتر', 'skill'),
                    'facebook' => __('فیسبوک', 'skill'),
                    'youtube' => __('یوتیوب', 'skill'),
                    'whatsapp' => __('واتساپ', 'skill'),
                    'email' => __('ایمیل', 'skill'),
                ],
            ]
        );

        $repeater->add_control(
            'social_url',
            [
                'label' => __('لینک', 'skill'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://example.com', 'skill'),
                'show_external' => false,
                'default' => [ 'url' => '' ],
                'condition' => [
                    'social_icon!' => 'email',
                ],
            ]
        );

        $repeater->add_control(
            'social_label',
            [
                'label' => __('عنوان', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '',
                'placeholder' => __('عنوان شبکه اجتماعی', 'skill'),
            ]
        );

        $this->add_control(
            'social_links',
            [
                'label' => __('شبکه‌های اجتماعی', 'skill'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'social_icon' => 'telegram',
                        'social_url' => [ 'url' => '' ],
                        'social_label' => __('تلگرام', 'skill'),
                    ],
                    [
                        'social_icon' => 'linkedin',
                        'social_url' => [ 'url' => '' ],
                        'social_label' => __('لینکدین', 'skill'),
                    ],
                    [
                        'social_icon' => 'github',
                        'social_url' => [ 'url' => '' ],
                        'social_label' => __('گیت‌هاب', 'skill'),
                    ],
                ],
                'title_field' => '{{{ social_label }}}',
                'prevent_empty' => false,
            ]
        );

        $this->end_controls_section();


		// Style Section - Title
        $this->start_controls_section(
            'title_style_section',
            [
                'label' => __('استایل عنوان', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .tdw-title',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('رنگ عنوان', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
					'{{WRAPPER}} .tdw-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_margin',
            [
                'label' => __('فاصله عنوان', 'skill'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
					'{{WRAPPER}} .tdw-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

		// Style - Dot
		$this->start_controls_section(
			'header_dot_style_section',
			[
				'label' => __('استایل مربع عنوان', 'skill'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'header_dot_color',
			[
				'label' => __('رنگ مربع', 'skill'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#1e73be',
				'selectors' => [
					'{{WRAPPER}} .tdw-dot' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();

        // Style Section - Subtitle
		$this->start_controls_section(
            'subtitle_style_section',
            [
                'label' => __('استایل زیرعنوان', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle_typography',
				'selector' => '{{WRAPPER}} .tdw-desc',
            ]
        );

		$this->add_control(
            'subtitle_color',
            [
                'label' => __('رنگ زیرعنوان', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#cccccc',
                'selectors' => [
					'{{WRAPPER}} .tdw-desc' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Style Section - Contact Info
        $this->start_controls_section(
            'contact_info_style_section',
            [
                'label' => __('استایل اطلاعات تماس', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_contact_info' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'contact_info_color',
            [
                'label' => __('رنگ متن', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .contact-info-item' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'contact_info_icon_color',
            [
                'label' => __('رنگ آیکون', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#6366f1',
                'selectors' => [
                    '{{WRAPPER}} .contact-info-icon' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'contact_info_icon_bg_color',
            [
                'label' => __('رنگ پس‌زمینه آیکون', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#6366f1',
                'selectors' => [
                    '{{WRAPPER}} .contact-info-icon' => 'background: linear-gradient(135deg, {{VALUE}}, {{VALUE}}dd);',
                ],
            ]
        );

        $this->add_control(
            'contact_info_hover_color',
            [
                'label' => __('رنگ hover اطلاعات تماس', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#6366f1',
                'selectors' => [
                    '{{WRAPPER}} .contact-info-item:hover' => 'border-color: {{VALUE}};',
                    '{{WRAPPER}} .contact-info-item:hover .contact-info-icon' => 'background: linear-gradient(135deg, {{VALUE}}, {{VALUE}}dd);',
                ],
            ]
        );



        $this->add_control(
            'background_color',
            [
                'label' => __('رنگ پس‌زمینه', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#0a0a0a',
                'selectors' => [
                    '{{WRAPPER}} .skill-contact-widget' => 'background: radial-gradient(ellipse at center, {{VALUE}} 0%, {{VALUE}}dd 50%, {{VALUE}}aa 100%);',
                ],
            ]
        );

        $this->add_control(
            'accent_color',
            [
                'label' => __('رنگ اصلی', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#6366f1',
                'selectors' => [
                    '{{WRAPPER}} .contact-title' => 'background: linear-gradient(135deg, {{VALUE}}, {{VALUE}}dd, {{VALUE}}aa);',
                    '{{WRAPPER}} .contact-title::after' => 'background: linear-gradient(90deg, {{VALUE}}, {{VALUE}}dd);',
                    '{{WRAPPER}} .contact-info-content h4' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        
        // Validate and sanitize settings
        $animation_class = (!empty($settings['enable_animations']) && $settings['enable_animations'] === 'yes') ? 'with-animations' : '';
        
        // Get social links from repeater
        $social_links = $settings['social_links'] ?? [];
        
        // Helper function to get SVG icon
        function get_social_svg($icon_type) {
            $icons = [
                'telegram' => '<svg width="22" height="22" viewBox="0 0 24 24" fill="currentColor"><path d="M9.04 15.47l-.37 5.28c.53 0 .76-.23 1.03-.51l2.47-2.37 5.12 3.75c.94.52 1.61.25 1.86-.86l3.37-15.8h0c.3-1.4-.5-1.95-1.4-1.6L1.77 10.06c-1.36.53-1.34 1.3-.23 1.64l5.24 1.64 12.17-7.68c.57-.38 1.08-.17.66.21"/></svg>',
                'linkedin' => '<svg width="22" height="22" viewBox="0 0 24 24" fill="currentColor"><path d="M4.98 3.5C4.98 4.88 3.86 6 2.5 6S0 4.88 0 3.5 1.12 1 2.5 1 4.98 2.12 4.98 3.5zM0 8h5v16H0V8zm7.5 0h4.8v2.2h.1c.67-1.27 2.3-2.6 4.73-2.6 5.06 0 6 3.33 6 7.66V24h-5v-7.2c0-1.72-.03-3.93-2.4-3.93-2.4 0-2.77 1.87-2.77 3.8V24h-5V8z"/></svg>',
                'github' => '<svg width="22" height="22" viewBox="0 0 24 24" fill="currentColor"><path d="M12 .5a12 12 0 00-3.79 23.4c.6.11.82-.26.82-.58 0-.29-.01-1.05-.02-2.07-3.34.73-4.04-1.61-4.04-1.61-.55-1.39-1.35-1.76-1.35-1.76-1.1-.75.08-.73.08-.73 1.22.09 1.86 1.25 1.86 1.25 1.08 1.85 2.82 1.31 3.5 1 .11-.79.42-1.31.76-1.61-2.66-.31-5.47-1.33-5.47-5.93 0-1.31.47-2.38 1.24-3.22-.12-.31-.54-1.56.12-3.25 0 0 1.01-.32 3.3 1.23a11.5 11.5 0 016 0c2.29-1.55 3.3-1.23 3.3-1.23.66 1.69.24 2.94.12 3.25.77.84 1.24 1.91 1.24 3.22 0 4.61-2.81 5.61-5.49 5.92.43.37.81 1.1.81 2.22 0 1.6-.02 2.89-.02 3.28 0 .32.22.7.83.58A12 12 0 0012 .5z"/></svg>',
                'instagram' => '<svg width="22" height="22" viewBox="0 0 24 24" fill="currentColor"><path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849 3.148-3.221 1.664-4.771 4.919-4.919 1.266-.058 1.644-.07 4.85-.07zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/></svg>',
                'twitter' => '<svg width="22" height="22" viewBox="0 0 24 24" fill="currentColor"><path d="M23.953 4.57a10 10 0 01-2.825.775 4.958 4.958 0 002.163-2.723c-.951.555-2.005.959-3.127 1.184a4.92 4.92 0 00-8.384 4.482C7.69 8.095 4.067 6.13 1.64 3.162a4.822 4.822 0 00-.666 2.475c0 1.71.87 3.213 2.188 4.096a4.904 4.904 0 01-2.228-.616v.06a4.923 4.923 0 003.946 4.827 4.996 4.996 0 01-2.212.085 4.936 4.936 0 004.604 3.417 9.867 9.867 0 01-6.102 2.105c-.39 0-.779-.023-1.17-.067a13.995 13.995 0 007.557 2.209c9.053 0 13.998-7.496 13.998-13.985 0-.21 0-.42-.015-.63A9.935 9.935 0 0024 4.59z"/></svg>',
                'facebook' => '<svg width="22" height="22" viewBox="0 0 24 24" fill="currentColor"><path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/></svg>',
                'youtube' => '<svg width="22" height="22" viewBox="0 0 24 24" fill="currentColor"><path d="M23.498 6.186a3.016 3.016 0 0 0-2.122-2.136C19.505 3.545 12 3.545 12 3.545s-7.505 0-9.377.505A3.017 3.017 0 0 0 .502 6.186C0 8.07 0 12 0 12s0 3.93.502 5.814a3.016 3.016 0 0 0 2.122 2.136c1.871.505 9.376.505 9.376.505s7.505 0 9.377-.505a3.015 3.015 0 0 0 2.122-2.136C24 15.93 24 12 24 12s0-3.93-.502-5.814zM9.545 15.568V8.432L15.818 12l-6.273 3.568z"/></svg>',
                'whatsapp' => '<svg width="22" height="22" viewBox="0 0 24 24" fill="currentColor"><path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893A11.821 11.821 0 0020.885 3.488"/></svg>',
                'email' => '<svg width="22" height="22" viewBox="0 0 24 24" fill="currentColor"><path d="M20 4H4c-1.1 0-2 .9-2 2v12a2 2 0 002 2h16a2 2 0 002-2V6a2 2 0 00-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z"/></svg>',
            ];
            
            return $icons[$icon_type] ?? $icons['telegram'];
        }
        
        ?>
        
        <div class="skill-contact-widget <?php echo esc_attr($animation_class); ?>">
        <div class="contact-header">
                        <div class="tdw-wrap" dir="rtl">
                            <div class="tdw-title-row" style="display:inline-flex; align-items:center; gap:8px; <?php echo (($settings['dot_position'] ?? 'right') === 'right') ? 'flex-direction: row-reverse;' : ''; ?>">
                                <?php if (!empty($settings['show_title']) && $settings['show_title'] === 'yes'): ?>
                                    <h2 class="tdw-title"><?php echo esc_html($settings['title_text'] ?? ''); ?></h2>
                                <?php endif; ?>
                                <?php if (!empty($settings['show_dot']) && $settings['show_dot'] === 'yes'): ?>
                                    <span class="tdw-dot" aria-hidden="true" style="display:inline-block; border-radius:3px;"></span>
                                <?php endif; ?>
                            </div>
                            <?php if (!empty($settings['show_desc']) && $settings['show_desc'] === 'yes' && !empty($settings['desc_text'])): ?>
                                <div class="tdw-desc" style="margin-top:10px;">
                                    <?php echo esc_html($settings['desc_text']); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
            <!-- Animated Background -->
            <div class="animated-background">
                <div class="floating-shapes">
                    <div class="shape shape-1"></div>
                    <div class="shape shape-2"></div>
                    <div class="shape shape-3"></div>
                    <div class="shape shape-4"></div>
                    <div class="shape shape-5"></div>
                    <div class="shape shape-6"></div>
                </div>
            </div>

            <div class="contact-content-wrapper">
                <!-- Left Section - Contact Form -->
                <div class="contact-form-section">

                    <?php if (!empty($settings['contact_form_shortcode'])) : ?>
                        <div class="contact-form-wrapper">
                            <?php echo do_shortcode($settings['contact_form_shortcode']); ?>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Right Section - Contact Info -->
                <?php if (!empty($settings['show_contact_info']) && $settings['show_contact_info'] === 'yes') : ?>
                    <div class="contact-info-section">
                        <div class="contact-info-container">
                            <?php if (!empty($settings['phone'])) : ?>
                                <div class="contact-info-item clickable-contact" data-copy="<?php echo esc_attr($settings['phone']); ?>" data-type="phone">
                                    <div class="contact-info-icon">
                                        <i class="fas fa-phone"></i>
                                    </div>
                                    <div class="contact-info-content">
                                        <h4><?php echo __('تلفن', 'skill'); ?></h4>
                                        <p class="contact-text"><?php echo esc_html($settings['phone']); ?></p>
                                        <div class="copy-indicator">
                                            <i class="fas fa-copy"></i>
                                            <span class="copy-text">کپی کردن</span>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <?php if (!empty($settings['email'])) : ?>
                                <div class="contact-info-item clickable-contact" data-copy="<?php echo esc_attr($settings['email']); ?>" data-type="email">
                                    <div class="contact-info-icon">
                                        <i class="fas fa-envelope"></i>
                                    </div>
                                    <div class="contact-info-content">
                                        <h4><?php echo __('ایمیل', 'skill'); ?></h4>
                                        <p class="contact-text"><?php echo esc_html($settings['email']); ?></p>
                                        <div class="copy-indicator">
                                            <i class="fas fa-copy"></i>
                                            <span class="copy-text">کپی کردن</span>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <?php if (!empty($settings['address'])) : ?>
                                <div class="contact-info-item">
                                    <div class="contact-info-icon">
                                        <i class="fas fa-map-marker-alt"></i>
                                    </div>
                                    <div class="contact-info-content">
                                        <h4><?php echo __('آدرس', 'skill'); ?></h4>
                                        <p><?php echo esc_html($settings['address']); ?></p>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <?php if (!empty($settings['working_hours'])) : ?>
                                <div class="contact-info-item">
                                    <div class="contact-info-icon">
                                        <i class="fas fa-clock"></i>
                                    </div>
                                    <div class="contact-info-content">
                                        <h4><?php echo __('ساعات کاری', 'skill'); ?></h4>
                                        <p><?php echo esc_html($settings['working_hours']); ?></p>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                        <?php if (!empty($social_links)) : ?>
                        <div class="mh-footer__social" aria-label="شبکه‌های اجتماعی">
                            <?php foreach ($social_links as $index => $item) : ?>
                                <?php
                                $social_icon = $item['social_icon'];
                                $social_url = $item['social_url']['url'];
                                $social_label = $item['social_label'];
                                ?>
                                <?php if (!empty($social_url)) : ?>
                                <a href="<?php echo esc_url($social_url); ?>" aria-label="<?php echo esc_attr($social_label); ?>">
                                  <?php echo get_social_svg($social_icon); ?>
                                </a>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <style>
        /* Skill Contact Widget - Beautiful Modern User-Friendly Design */
        
        /* ===== MAIN CONTAINER ===== */
        .wpcf7 form.wpcf7-form input, .wpcf7 form.wpcf7-form textarea {
            height: 64px;
        }

        .skill-contact-widget {
            margin: 0 auto;
            padding: 70px 20px;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            background: 
                radial-gradient(circle at 25% 75%, rgba(99, 102, 241, 0.1) 0%, transparent 60%),
                radial-gradient(circle at 75% 25%, rgba(139, 92, 246, 0.06) 0%, transparent 60%),
                radial-gradient(circle at 50% 50%, rgba(168, 85, 247, 0.04) 0%, transparent 70%),
                linear-gradient(135deg, #0a0a0a 0%, #1a1a1a 30%, #0d0d0d 50%, #1a1a1a 70%, #0a0a0a 100%);
            position: relative;
            overflow: hidden;
            flex-direction: column;
        }

        /* ===== ANIMATED BACKGROUND ===== */
        .animated-background {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: -1;
        }

        .floating-shapes {
            position: absolute;
            width: 100%;
            height: 100%;
            overflow: hidden;
        }

        .shape {
            position: absolute;
            border-radius: 50%;
            background: radial-gradient(circle, rgba(99, 102, 241, 0.35) 0%, rgba(139, 92, 246, 0.2) 50%, rgba(168, 85, 247, 0.12) 100%);
            animation: particleFloat 16s ease-in-out infinite;
            filter: blur(1px);
            box-shadow: 
                0 0 20px rgba(99, 102, 241, 0.25),
                inset 0 0 12px rgba(255, 255, 255, 0.06);
        }

        .shape-1 { width: 10px; height: 10px; top: 20%; left: 10%; animation-delay: 0s; animation-duration: 20s; }
        .shape-2 { width: 16px; height: 16px; top: 70%; right: 15%; animation-delay: 3s; animation-duration: 23s; }
        .shape-3 { width: 7px; height: 7px; bottom: 30%; left: 20%; animation-delay: 6s; animation-duration: 18s; }
        .shape-4 { width: 12px; height: 12px; top: 40%; right: 10%; animation-delay: 9s; animation-duration: 25s; }
        .shape-5 { width: 18px; height: 18px; bottom: 20%; right: 25%; animation-delay: 12s; animation-duration: 22s; }
        .shape-6 { width: 5px; height: 5px; top: 80%; left: 60%; animation-delay: 15s; animation-duration: 19s; }

        @keyframes particleFloat {
            0%, 100% { transform: translateY(0px) translateX(0px) scale(1) rotate(0deg); opacity: 0.35; }
            25% { transform: translateY(-25px) translateX(12px) scale(1.25) rotate(90deg); opacity: 0.7; }
            50% { transform: translateY(-35px) translateX(-6px) scale(0.75) rotate(180deg); opacity: 0.5; }
            75% { transform: translateY(-15px) translateX(20px) scale(1.15) rotate(270deg); opacity: 0.8; }
        }

        /* ===== CONTENT LAYOUT ===== */
        .contact-content-wrapper {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 60px;
            align-items: stretch;
            position: relative;
            z-index: 2;
            max-width: 1000px;
            width: 100%;
        }

        /* ===== HEADER SECTION ===== */
        .contact-header { text-align: center; margin-bottom: 40px; }
        .tdw-title { font-size: 3.2rem; font-weight: 700; margin-bottom: 18px; position: relative; letter-spacing: -0.5px; }
        .tdw-desc { font-size: 1.1rem; line-height: 1.6; color: #d1d5db; margin: 0; font-weight: 300; opacity: 0.85; max-width: 450px; margin: 0 auto; }
        .tdw-dot { width: 10px; height: 10px; display:inline-block; border-radius:3px; background-color:#1e73be; }

        /* ===== FORM AND INFO SECTIONS ===== */
        .contact-form-section {
            display: flex;
            flex-direction: column;
            justify-content: flex-start;
            align-items: stretch;
            height: 100%;
        }

        .contact-info-section {
            display: flex;
            flex-direction: column;
        }

        .contact-form-section {
            align-items: center;
        }

        .contact-title {
            font-size: 3.2rem;
            font-weight: 700;
            margin-bottom: 18px;
            background: linear-gradient(135deg, #6366f1 0%, #8b5cf6 30%, #a855f7 60%, #c084fc 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            position: relative;
            text-shadow: 0 0 25px rgba(99, 102, 241, 0.25);
            letter-spacing: -0.5px;
        }

        .contact-title::after {
            content: '';
            position: absolute;
            bottom: -10px;
            left: 50%;
            transform: translateX(-50%);
            width: 70px;
            height: 3px;
            background: linear-gradient(90deg, #6366f1, #8b5cf6, #a855f7);
            border-radius: 2px;
            box-shadow: 0 0 20px rgba(99, 102, 241, 0.5);
        }

        .contact-subtitle {
            font-size: 1.1rem;
            line-height: 1.6;
            color: #d1d5db;
            margin: 0;
            font-weight: 300;
            opacity: 0.85;
            max-width: 450px;
            margin: 0 auto;
        }

        /* ===== CONTACT FORM 7 STYLES ===== */
        .wpcf7 form.wpcf7-form {
            background: rgba(255, 255, 255, 0.07);
            padding: 32px;
            border-radius: 22px;
            width: 100%;
            max-width: 420px;
            margin: 0 auto;
            backdrop-filter: blur(22px);
            border: 1px solid rgba(255, 255, 255, 0.12);
            box-shadow: 
                0 20px 40px rgba(0, 0, 0, 0.3),
                0 0 0 1px rgba(255, 255, 255, 0.08),
                inset 0 1px 0 rgba(255, 255, 255, 0.12);
            position: relative;
            overflow: hidden;
            transition: all 0.35s cubic-bezier(0.4, 0, 0.2, 1);
            height: fit-content;
        }

        .wpcf7 form.wpcf7-form::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: 
                radial-gradient(circle at 25% 75%, rgba(99, 102, 241, 0.1) 0%, transparent 60%),
                radial-gradient(circle at 75% 25%, rgba(139, 92, 246, 0.06) 0%, transparent 60%);
            pointer-events: none;
            opacity: 0;
            transition: opacity 0.35s ease;
        }

        .wpcf7 form.wpcf7-form:hover::before {
            opacity: 1;
        }

        .wpcf7 form.wpcf7-form:hover {
            border-color: rgba(99, 102, 241, 0.35);
            box-shadow: 
                0 25px 50px rgba(0, 0, 0, 0.4),
                0 0 0 1px rgba(99, 102, 241, 0.25),
                inset 0 1px 0 rgba(255, 255, 255, 0.15),
                0 0 30px rgba(99, 102, 241, 0.15);
            transform: translateY(-4px);
        }

        /* Form Inputs */
        .wpcf7 form.wpcf7-form input,
        .wpcf7 form.wpcf7-form textarea,
        input.wpcf7-form-control.wpcf7-email.wpcf7-validates-as-required.wpcf7-text.wpcf7-validates-as-email {
            background: rgba(255, 255, 255, 0.08);
            border: 2px solid rgba(99, 102, 241, 0.25);
            color: #fff;
            border-radius: 16px;
            margin-bottom: 18px;
            width: 100%;
            padding: 16px 18px;
            font-size: 15px;
            outline: none;
            transition: all 0.35s cubic-bezier(0.4, 0, 0.2, 1);
            backdrop-filter: blur(12px);
            position: relative;
            box-shadow: 
                0 6px 16px rgba(0, 0, 0, 0.12),
                inset 0 1px 0 rgba(255, 255, 255, 0.06);
        }

        .wpcf7 form.wpcf7-form input:focus,
        .wpcf7 form.wpcf7-form textarea:focus {
            border-color: #6366f1;
            box-shadow: 
                0 0 25px rgba(99, 102, 241, 0.35),
                0 0 0 2px rgba(99, 102, 241, 0.08),
                0 8px 20px rgba(0, 0, 0, 0.15);
            transform: translateY(-2px);
            background: rgba(255, 255, 255, 0.12);
        }

        .wpcf7 form.wpcf7-form input::placeholder,
        .wpcf7 form.wpcf7-form textarea::placeholder {
            color: rgba(255, 255, 255, 0.65);
            font-weight: 300;
        }

        .wpcf7 form.wpcf7-form textarea {
            min-height: 110px;
            resize: vertical;
        }

        /* Email Input Specific Styling */
        .wpcf7 form.wpcf7-form input[type="email"] {
            background: rgba(255, 255, 255, 0.08);
            border: 2px solid rgba(99, 102, 241, 0.25);
            color: #fff;
            border-radius: 16px;
            margin-bottom: 18px;
            width: 100%;
            padding: 16px 18px;
            font-size: 15px;
            outline: none;
            transition: all 0.35s cubic-bezier(0.4, 0, 0.2, 1);
            backdrop-filter: blur(12px);
            position: relative;
            box-shadow: 
                0 6px 16px rgba(0, 0, 0, 0.12),
                inset 0 1px 0 rgba(255, 255, 255, 0.06);
        }

        .wpcf7 form.wpcf7-form input[type="email"]:focus {
            border-color: #6366f1;
            box-shadow: 
                0 0 25px rgba(99, 102, 241, 0.35),
                0 0 0 2px rgba(99, 102, 241, 0.08),
                0 8px 20px rgba(0, 0, 0, 0.15);
            transform: translateY(-2px);
            background: rgba(255, 255, 255, 0.12);
        }

        .wpcf7 form.wpcf7-form input[type="email"]::placeholder {
            color: rgba(255, 255, 255, 0.65);
            font-weight: 300;
        }

        /* Submit Button */
        .wpcf7 form.wpcf7-form .wpcf7-submit {
            background: linear-gradient(135deg, #6366f1 0%, #8b5cf6 30%, #a855f7 70%, #6366f1 100%);
            color: #ffffff;
            border: none;
            border-radius: 20px;
            font-size: 15px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.35s cubic-bezier(0.4, 0, 0.2, 1);
            margin-top: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-direction: row;
            box-shadow: 
                0 12px 25px rgba(99, 102, 241, 0.35),
                0 0 0 1px rgba(255, 255, 255, 0.08),
                inset 0 1px 0 rgba(255, 255, 255, 0.12);
            position: relative;
            overflow: hidden;
            text-transform: uppercase;
            letter-spacing: 0.8px;
            padding: 15px 50px 15px 50px;
        }

        .wpcf7 form.wpcf7-form .wpcf7-submit::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.25), transparent);
            transition: left 0.5s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .wpcf7 form.wpcf7-form .wpcf7-submit::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: 
                radial-gradient(circle at 25% 75%, rgba(99, 102, 241, 0.2) 0%, transparent 60%),
                radial-gradient(circle at 75% 25%, rgba(139, 92, 246, 0.12) 0%, transparent 60%);
            opacity: 0;
            transition: opacity 0.35s ease;
            pointer-events: none;
        }

        .wpcf7 form.wpcf7-form .wpcf7-submit:hover {
            background: linear-gradient(135deg, #8b5cf6 0%, #a855f7 30%, #c084fc 70%, #6366f1 100%);
            transform: translateY(-4px) scale(1.02);
            box-shadow: 
                0 16px 35px rgba(99, 102, 241, 0.4),
                0 0 0 1px rgba(255, 255, 255, 0.15),
                0 0 25px rgba(99, 102, 241, 0.25);
        }

        .wpcf7 form.wpcf7-form .wpcf7-submit:hover::before {
            left: 100%;
        }

        .wpcf7 form.wpcf7-form .wpcf7-submit:hover::after {
            opacity: 1;
        }

        /* Hide BR tags inside submit button */
        .wpcf7 form.wpcf7-form .wpcf7-submit br {
            display: none;
        }

        /* General rule to hide BR tags in all submit buttons */
        .wpcf7-form .wpcf7-submit br {
            display: none !important;
        }

        /* Ensure proper text alignment in submit button */
        .wpcf7-form .wpcf7-submit {
            white-space: nowrap;
            text-align: center;
        }

        /* Remove any unwanted spacing from button content */
        .wpcf7-form .wpcf7-submit > * {
            margin: 0;
            padding: 0;
        }

        /* Form States */
        .wpcf7 form.wpcf7-form.sent .wpcf7-submit {
            background: linear-gradient(135deg, #10b981, #059669, #047857);
            animation: successPulse 0.7s ease-in-out;
        }

        .wpcf7 form.wpcf7-form.invalid .wpcf7-submit {
            background: linear-gradient(135deg, #ef4444, #dc2626, #b91c1c);
            animation: errorShake 0.7s ease-in-out;
        }

        /* ===== CONTACT INFO SECTION ===== */
        .contact-info-section {
            display: flex;
            flex-direction: column;
        }

        .contact-info-container {
            display: flex;
            flex-direction: column;
            gap: 20px;
        }

        .contact-info-item {
            display: flex;
            align-items: center;
            gap: 20px;
            padding: 25px;
            background: rgba(255, 255, 255, 0.06);
            border-radius: 20px;
            border: 1px solid rgba(255, 255, 255, 0.1);
            transition: all 0.35s cubic-bezier(0.4, 0, 0.2, 1);
            backdrop-filter: blur(20px);
            position: relative;
            overflow: hidden;
            box-shadow: 
                0 12px 25px rgba(0, 0, 0, 0.2),
                0 0 0 1px rgba(255, 255, 255, 0.06);
        }

        .contact-info-item::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: 
                radial-gradient(circle at 25% 75%, rgba(99, 102, 241, 0.12) 0%, transparent 60%),
                radial-gradient(circle at 75% 25%, rgba(139, 92, 246, 0.08) 0%, transparent 60%);
            opacity: 0;
            transition: opacity 0.35s ease;
        }

        .contact-info-item:hover {
            transform: translateY(-6px) scale(1.01);
            border-color: rgba(99, 102, 241, 0.3);
            box-shadow: 
                0 20px 40px rgba(0, 0, 0, 0.3),
                0 0 0 1px rgba(99, 102, 241, 0.25),
                0 0 25px rgba(99, 102, 241, 0.2);
        }

        .contact-info-item:hover::before {
            opacity: 1;
        }

        /* Contact Icons */
        .contact-info-icon {
            width: 52px;
            height: 52px;
            background: linear-gradient(135deg, #6366f1 0%, #8b5cf6 30%, #a855f7 70%, #6366f1 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
            color: #ffffff;
            flex-shrink: 0;
            box-shadow: 
                0 12px 25px rgba(99, 102, 241, 0.35),
                0 0 0 1px rgba(255, 255, 255, 0.08),
                inset 0 1px 0 rgba(255, 255, 255, 0.12);
            transition: all 0.35s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
        }

        .contact-info-icon::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(135deg, rgba(255, 255, 255, 0.2), transparent);
            opacity: 0;
            transition: opacity 0.35s ease;
        }

        .contact-info-icon::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: 
                radial-gradient(circle at 25% 75%, rgba(99, 102, 241, 0.25) 0%, transparent 60%),
                radial-gradient(circle at 75% 25%, rgba(139, 92, 246, 0.15) 0%, transparent 60%);
            opacity: 0;
            transition: opacity 0.35s ease;
            pointer-events: none;
        }

        .contact-info-item:hover .contact-info-icon {
            transform: scale(1.08) rotate(6deg);
            box-shadow: 
                0 16px 35px rgba(99, 102, 241, 0.4),
                0 0 0 1px rgba(255, 255, 255, 0.15),
                0 0 25px rgba(99, 102, 241, 0.25);
        }

        .contact-info-item:hover .contact-info-icon::before,
        .contact-info-item:hover .contact-info-icon::after {
            opacity: 1;
        }

        /* Contact Content */
        .contact-info-content h4 {
            font-size: 16px;
            font-weight: 600;
            margin-bottom: 6px;
            color: #6366f1;
            text-transform: uppercase;
            letter-spacing: 0.8px;
        }

        .contact-info-content p {
            font-size: 14px;
            line-height: 1.5;
            margin: 0;
            color: #d1d5db;
            font-weight: 300;
        }

        .contact-info-content a {
            color: #6366f1;
            text-decoration: none;
            transition: color 0.3s ease;
            font-weight: 500;
        }

        .contact-info-content a:hover {
            color: #8b5cf6;
            text-shadow: 0 0 8px rgba(99, 102, 241, 0.4);
        }

        /* ===== SOCIAL MEDIA SECTION ===== */
        .social-media-section {
            display: flex;
            gap: 15px;
            margin-top: 25px;
            justify-content: center;
            flex-wrap: wrap;
        }

        /* Footer Social Icons Styling */
        .mh-footer__social {
            display: flex;
            gap: 12px;
            margin-top: 20px;
            justify-content: center;
            flex-wrap: wrap;
        }

        .mh-footer__social a {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
            color: #ffffff;
            text-decoration: none;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            position: relative;
            overflow: hidden;
        }

        .mh-footer__social a::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(135deg, rgba(99, 102, 241, 0.2), rgba(139, 92, 246, 0.1));
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .mh-footer__social a:hover {
            background: rgba(99, 102, 241, 0.2);
            transform: translateY(-3px) scale(1.05);
            box-shadow: 
                0 10px 25px rgba(99, 102, 241, 0.3),
                0 0 0 1px rgba(99, 102, 241, 0.3);
        }

        .mh-footer__social a:hover::before {
            opacity: 1;
        }

        .mh-footer__social svg {
            width: 20px;
            height: 20px;
            transition: all 0.3s ease;
            filter: drop-shadow(0 2px 4px rgba(0, 0, 0, 0.2));
        }

        .mh-footer__social a:hover svg {
            transform: scale(1.1);
            filter: drop-shadow(0 4px 8px rgba(99, 102, 241, 0.4));
        }

        /* ===== ANIMATIONS ===== */
        .with-animations .contact-form-section {
            animation: slideInUp 1s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .with-animations .contact-info-item {
            animation: slideInRight 1s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .with-animations .contact-info-item:nth-child(2) { animation-delay: 0.2s; }
        .with-animations .contact-info-item:nth-child(3) { animation-delay: 0.4s; }
        .with-animations .contact-info-item:nth-child(4) { animation-delay: 0.6s; }
        .with-animations .contact-info-item:nth-child(5) { animation-delay: 0.8s; }

        @keyframes slideInUp {
            from { opacity: 0; transform: translateY(50px); }
            to { opacity: 1; transform: translateY(0); }
        }

        @keyframes slideInRight {
            from { opacity: 0; transform: translateX(50px); }
            to { opacity: 1; transform: translateX(0); }
        }

        @keyframes successPulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.03); }
            100% { transform: scale(1); }
        }

        @keyframes errorShake {
            0%, 100% { transform: translateX(0); }
            25% { transform: translateX(-5px); }
            75% { transform: translateX(5px); }
        }

        /* ===== CLICKABLE CONTACT ITEMS ===== */
        .clickable-contact {
            cursor: pointer;
            position: relative;
            overflow: hidden;
        }

        .clickable-contact::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(135deg, rgba(99, 102, 241, 0.15), rgba(139, 92, 246, 0.1));
            opacity: 0;
            transition: opacity 0.3s ease;
            pointer-events: none;
        }

        .clickable-contact:hover::after {
            opacity: 1;
        }

        .copy-indicator {
            position: absolute;
            top: 50%;
            right: 20px;
            transform: translateY(-50%);
            display: flex;
            align-items: center;
            gap: 8px;
            background: rgba(99, 102, 241, 0.9);
            color: #ffffff;
            padding: 8px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 500;
            opacity: 0;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            backdrop-filter: blur(10px);
            box-shadow: 0 4px 15px rgba(99, 102, 241, 0.3);
            pointer-events: none;
        }

        .clickable-contact:hover .copy-indicator {
            opacity: 1;
            transform: translateY(-50%) translateX(-5px);
        }

        .copy-indicator i {
            font-size: 11px;
        }

        .copy-indicator.copied {
            background: rgba(16, 185, 129, 0.9);
            box-shadow: 0 4px 15px rgba(16, 185, 129, 0.3);
        }

        .copy-indicator.copied .copy-text {
            content: 'کپی شد!';
        }

        .contact-info-content {
            position: relative;
            flex: 1;
        }

        .contact-text {
            transition: color 0.3s ease;
        }

        .clickable-contact:hover .contact-text {
            color: #6366f1;
        }

        /* Copy Animation */
        @keyframes copySuccess {
            0% { transform: scale(1); }
            50% { transform: scale(1.1); }
            100% { transform: scale(1); }
        }

        .copy-success {
            animation: copySuccess 0.6s ease-in-out;
        }

        /* ===== RESPONSIVE DESIGN ===== */
        @media (max-width: 1024px) {
            .contact-content-wrapper {
                grid-template-columns: 1fr;
                gap: 60px;
                align-items: center;
            }
            
            .contact-form-section,
            .contact-info-section {
                align-items: center;
            }
        }

        @media (max-width: 768px) {
            .skill-contact-widget {
                padding: 50px 15px;
            }

            .contact-content-wrapper {
                gap: 50px;
            }

            .contact-title {
                font-size: 2.6rem;
            }

            .contact-info-item {
                padding: 20px;
            }

            .contact-info-icon {
                width: 45px;
                height: 45px;
                font-size: 18px;
            }

            .copy-indicator {
                right: 15px;
                padding: 6px 10px;
                font-size: 11px;
            }
        }

        @media (max-width: 480px) {
            .contact-title {
                font-size: 2.2rem;
            }

            .contact-info-item {
                padding: 18px;
                flex-direction: column;
                text-align: center;
                gap: 15px;
            }

            .contact-info-icon {
                width: 40px;
                height: 40px;
                font-size: 16px;
            }

            .copy-indicator {
                position: static;
                transform: none;
                margin-top: 10px;
                justify-content: center;
                opacity: 1;
            }

            .clickable-contact:hover .copy-indicator {
                transform: none;
            }

            /* Social Icons Responsive */
            .mh-footer__social {
                gap: 12px;
                margin-top: 20px;
            }

            .mh-footer__social a {
                width: 40px;
                height: 40px;
            }

            .mh-footer__social svg {
                width: 20px;
                height: 20px;
            }
        }
        </style>

        <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Copy functionality for contact items
            const clickableContacts = document.querySelectorAll('.clickable-contact');
            
            clickableContacts.forEach(function(contact) {
                contact.addEventListener('click', function() {
                    const textToCopy = this.getAttribute('data-copy');
                    const copyIndicator = this.querySelector('.copy-indicator');
                    const copyText = copyIndicator.querySelector('.copy-text');
                    const copyIcon = copyIndicator.querySelector('i');
                    
                    // Copy to clipboard
                    if (navigator.clipboard && window.isSecureContext) {
                        // Use modern clipboard API
                        navigator.clipboard.writeText(textToCopy).then(function() {
                            showCopySuccess(copyIndicator, copyText, copyIcon);
                        }).catch(function(err) {
                            console.error('Failed to copy: ', err);
                            fallbackCopyTextToClipboard(textToCopy, copyIndicator, copyText, copyIcon);
                        });
                    } else {
                        // Fallback for older browsers
                        fallbackCopyTextToClipboard(textToCopy, copyIndicator, copyText, copyIcon);
                    }
                });
            });
            
            function showCopySuccess(copyIndicator, copyText, copyIcon) {
                // Change to success state
                copyIndicator.classList.add('copied');
                copyIcon.className = 'fas fa-check';
                copyText.textContent = 'کپی شد!';
                
                // Add success animation
                copyIndicator.parentElement.classList.add('copy-success');
                
                // Reset after 2 seconds
                setTimeout(function() {
                    copyIndicator.classList.remove('copied');
                    copyIcon.className = 'fas fa-copy';
                    copyText.textContent = 'کپی کردن';
                    copyIndicator.parentElement.classList.remove('copy-success');
                }, 2000);
            }
            
            function fallbackCopyTextToClipboard(text, copyIndicator, copyText, copyIcon) {
                const textArea = document.createElement('textarea');
                textArea.value = text;
                textArea.style.position = 'fixed';
                textArea.style.left = '-999999px';
                textArea.style.top = '-999999px';
                document.body.appendChild(textArea);
                textArea.focus();
                textArea.select();
                
                try {
                    const successful = document.execCommand('copy');
                    if (successful) {
                        showCopySuccess(copyIndicator, copyText, copyIcon);
                    } else {
                        console.error('Failed to copy text');
                    }
                } catch (err) {
                    console.error('Fallback: Oops, unable to copy', err);
                }
                
                document.body.removeChild(textArea);
            }
        });
        </script>

        <?php
    }

    protected function _content_template() {
        ?>
        <div class="skill-contact-widget">
            <!-- Animated Background -->
            <div class="animated-background">
                <div class="floating-shapes">
                    <div class="shape shape-1"></div>
                    <div class="shape shape-2"></div>
                    <div class="shape shape-3"></div>
                    <div class="shape shape-4"></div>
                    <div class="shape shape-5"></div>
                    <div class="shape shape-6"></div>
                </div>
            </div>

            <div class="contact-content-wrapper">
                <!-- Left Section - Contact Form -->
                <div class="contact-form-section">
                    <div class="contact-header">
                        <# if (settings.title) { #>
                            <h2 class="contact-title">{{{ settings.title }}}</h2>
                        <# } #>
                        
                        <# if (settings.subtitle) { #>
                            <p class="contact-subtitle">{{{ settings.subtitle }}}</p>
                        <# } #>
                    </div>

                    <# if (settings.contact_form_shortcode) { #>
                        <div class="contact-form-wrapper">
                            {{{ settings.contact_form_shortcode }}}
                        </div>
                    <# } #>
                </div>

                <!-- Right Section - Contact Info -->
                <# if (settings.show_contact_info === 'yes') { #>
                    <div class="contact-info-section">
                        <div class="contact-info-container">
                            <# if (settings.phone) { #>
                                <div class="contact-info-item clickable-contact" data-copy="{{{ settings.phone }}}" data-type="phone">
                                    <div class="contact-info-icon">
                                        <i class="fas fa-phone"></i>
                                    </div>
                                    <div class="contact-info-content">
                                        <h4><?php echo __('تلفن', 'skill'); ?></h4>
                                        <p class="contact-text">{{{ settings.phone }}}</p>
                                        <div class="copy-indicator">
                                            <i class="fas fa-copy"></i>
                                            <span class="copy-text">کپی کردن</span>
                                        </div>
                                    </div>
                                </div>
                            <# } #>

                            <# if (settings.email) { #>
                                <div class="contact-info-item clickable-contact" data-copy="{{{ settings.email }}}" data-type="email">
                                    <div class="contact-info-icon">
                                        <i class="fas fa-envelope"></i>
                                    </div>
                                    <div class="contact-info-content">
                                        <h4><?php echo __('ایمیل', 'skill'); ?></h4>
                                        <p class="contact-text">{{{ settings.email }}}</p>
                                        <div class="copy-indicator">
                                            <i class="fas fa-copy"></i>
                                            <span class="copy-text">کپی کردن</span>
                                        </div>
                                    </div>
                                </div>
                            <# } #>

                            <# if (settings.address) { #>
                                <div class="contact-info-item">
                                    <div class="contact-info-icon">
                                        <i class="fas fa-map-marker-alt"></i>
                                    </div>
                                    <div class="contact-info-content">
                                        <h4><?php echo __('آدرس', 'skill'); ?></h4>
                                        <p>{{{ settings.address }}}</p>
                                    </div>
                                </div>
                            <# } #> 

                            <# if (settings.working_hours) { #>
                                <div class="contact-info-item">
                                    <div class="contact-info-icon">
                                        <i class="fas fa-clock"></i>
                                    </div>
                                    <div class="contact-info-content">
                                        <h4><?php echo __('ساعات کاری', 'skill'); ?></h4>
                                        <p>{{{ settings.working_hours }}}</p>
                                    </div>
                                </div>
                            <# } #>
                        </div>
                        <# if (settings.social_links && settings.social_links.length > 0) { #>
                        <div class="mh-footer__social" aria-label="شبکه‌های اجتماعی">
                            <# _.each(settings.social_links, function(item) { #>
                                <# var social_icon = item.social_icon; #>
                                <# var social_url = item.social_url.url; #>
                                <# var social_label = item.social_label; #>
                                <# if (social_url) { #>
                                <a href="{{ social_url }}" aria-label="{{ social_label }}">
                                    <# if (social_icon === 'telegram') { #>
                                        <svg width="22" height="22" viewBox="0 0 24 24" fill="currentColor"><path d="M9.04 15.47l-.37 5.28c.53 0 .76-.23 1.03-.51l2.47-2.37 5.12 3.75c.94.52 1.61.25 1.86-.86l3.37-15.8h0c.3-1.4-.5-1.95-1.4-1.6L1.77 10.06c-1.36.53-1.34 1.3-.23 1.64l5.24 1.64 12.17-7.68c.57-.38 1.08-.17.66.21"/></svg>
                                    <# } else if (social_icon === 'linkedin') { #>
                                        <svg width="22" height="22" viewBox="0 0 24 24" fill="currentColor"><path d="M4.98 3.5C4.98 4.88 3.86 6 2.5 6S0 4.88 0 3.5 1.12 1 2.5 1 4.98 2.12 4.98 3.5zM0 8h5v16H0V8zm7.5 0h4.8v2.2h.1c.67-1.27 2.3-2.6 4.73-2.6 5.06 0 6 3.33 6 7.66V24h-5v-7.2c0-1.72-.03-3.93-2.4-3.93-2.4 0-2.77 1.87-2.77 3.8V24h-5V8z"/></svg>
                                    <# } else if (social_icon === 'github') { #>
                                        <svg width="22" height="22" viewBox="0 0 24 24" fill="currentColor"><path d="M12 .5a12 12 0 00-3.79 23.4c.6.11.82-.26.82-.58 0-.29-.01-1.05-.02-2.07-3.34.73-4.04-1.61-4.04-1.61-.55-1.39-1.35-1.76-1.35-1.76-1.1-.75.08-.73.08-.73 1.22.09 1.86 1.25 1.86 1.25 1.08 1.85 2.82 1.31 3.5 1 .11-.79.42-1.31.76-1.61-2.66-.31-5.47-1.33-5.47-5.93 0-1.31.47-2.38 1.24-3.22-.12-.31-.54-1.56.12-3.25 0 0 1.01-.32 3.3 1.23a11.5 11.5 0 016 0c2.29-1.55 3.3-1.23 3.3-1.23.66 1.69.24 2.94.12 3.25.77.84 1.24 1.91 1.24 3.22 0 4.61-2.81 5.61-5.49 5.92.43.37.81 1.1.81 2.22 0 1.6-.02 2.89-.02 3.28 0 .32.22.7.83.58A12 12 0 0012 .5z"/></svg>
                                    <# } else if (social_icon === 'instagram') { #>
                                        <svg width="22" height="22" viewBox="0 0 24 24" fill="currentColor"><path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849 3.148-3.221 1.664-4.771 4.919-4.919 1.266-.058 1.644-.07 4.85-.07zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/></svg>
                                    <# } else if (social_icon === 'twitter') { #>
                                        <svg width="22" height="22" viewBox="0 0 24 24" fill="currentColor"><path d="M23.953 4.57a10 10 0 01-2.825.775 4.958 4.958 0 002.163-2.723c-.951.555-2.005.959-3.127 1.184a4.92 4.92 0 00-8.384 4.482C7.69 8.095 4.067 6.13 1.64 3.162a4.822 4.822 0 00-.666 2.475c0 1.71.87 3.213 2.188 4.096a4.904 4.904 0 01-2.228-.616v.06a4.923 4.923 0 003.946 4.827 4.996 4.996 0 01-2.212.085 4.936 4.936 0 004.604 3.417 9.867 9.867 0 01-6.102 2.105c-.39 0-.779-.023-1.17-.067a13.995 13.995 0 007.557 2.209c9.053 0 13.998-7.496 13.998-13.985 0-.21 0-.42-.015-.63A9.935 9.935 0 0024 4.59z"/></svg>
                                    <# } else if (social_icon === 'facebook') { #>
                                        <svg width="22" height="22" viewBox="0 0 24 24" fill="currentColor"><path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/></svg>
                                    <# } else if (social_icon === 'youtube') { #>
                                        <svg width="22" height="22" viewBox="0 0 24 24" fill="currentColor"><path d="M23.498 6.186a3.016 3.016 0 0 0-2.122-2.136C19.505 3.545 12 3.545 12 3.545s-7.505 0-9.377.505A3.017 3.017 0 0 0 .502 6.186C0 8.07 0 12 0 12s0 3.93.502 5.814a3.016 3.016 0 0 0 2.122 2.136c1.871.505 9.376.505 9.376.505s7.505 0 9.377-.505a3.015 3.015 0 0 0 2.122-2.136C24 15.93 24 12 24 12s0-3.93-.502-5.814zM9.545 15.568V8.432L15.818 12l-6.273 3.568z"/></svg>
                                    <# } else if (social_icon === 'whatsapp') { #>
                                        <svg width="22" height="22" viewBox="0 0 24 24" fill="currentColor"><path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893A11.821 11.821 0 0020.885 3.488"/></svg>
                                    <# } else if (social_icon === 'email') { #>
                                        <svg width="22" height="22" viewBox="0 0 24 24" fill="currentColor"><path d="M20 4H4c-1.1 0-2 .9-2 2v12a2 2 0 002 2h16a2 2 0 002-2V6a2 2 0 00-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z"/></svg>
                                    <# } #>
                                </a>
                                <# } #>
                            <# }); #>
                        </div>
                        <# } #>
                    </div>
                <# } #>
            </div>
        </div>
        <?php
    }
}
