<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class skill_foreign_language_Widget extends Widget_Base {
    public function get_name() {
        return 'skill_foreign_language';
    }

    public function get_title() {
        return __( 'لیست زبان‌ها با پرچم', 'skill' );
    }

    public function get_icon() {
        return 'eicon-globe';
    }

    public function get_categories() {
        return [ 'skill-category' ];
    }

    protected function _register_controls() {
        // Widget title control
        $this->start_controls_section(
            'section_title',
            [
                'label' => __( 'عنوان', 'skill' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'widget_title',
            [
                'label' => __( 'عنوان ویجت', 'skill' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'زبان‌های من', 'skill' ),
                'placeholder' => __( 'عنوان را وارد کنید', 'skill' ),
            ]
        );
        // Title color control
        $this->add_control(
            'widget_title_color',
            [
                'label' => __( 'رنگ عنوان ویجت', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#222222',
                'selectors' => [
                    '{{WRAPPER}} .skill-language-widget-title' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'widget_title_alignment',
            [
                'label' => __( 'چینش عنوان', 'skill' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'چپ', 'skill' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __( 'وسط', 'skill' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __( 'راست', 'skill' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .skill-language-widget-title' => 'text-align: {{VALUE}};',
                ],
                'toggle' => false,
            ]
        );
        $this->end_controls_section();

        // Language control
        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'زبان‌ها', 'skill' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();
        $repeater->add_control(
            'language_name',
            [
                'label' => __( 'نام زبان', 'skill' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'انگلیسی', 'skill' ),
            ]
        );
        $repeater->add_control(
            'flag',
            [
                'label' => __( 'پرچم', 'skill' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => '',
                ],
            ]
        );

        $this->add_control(
            'languages',
            [
                'label' => __( 'زبان‌ها', 'skill' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'language_name' => __( 'انگلیسی', 'skill' ),
                        'flag' => [ 'url' => '' ],
                    ],
                ],
                'title_field' => '{{{ language_name }}}',
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $widget_id = $this->get_id();
        // Show widget title
        if ( ! empty( $settings['widget_title'] ) ) {
            echo '<h3 class="skill-language-widget-title">' . esc_html( $settings['widget_title'] ) . '</h3>';
        }
        // Show list of languages as an arc slider (center larger & colored)
        if ( ! empty( $settings['languages'] ) ) {
            $items = $settings['languages'];
            $id = 'skill-lang-arc-' . $widget_id;
            echo '<div class="skill-language-arc" id="' . esc_attr($id) . '">'
               . '<svg class="skill-language-arc-path" viewBox="0 0 800 300" preserveAspectRatio="none" aria-hidden="true">'
               . '<path d="M20 260 C 220 140, 580 140, 780 260" fill="none" stroke="rgba(255,255,255,0.08)" stroke-width="2"/></svg>';
            foreach ( $items as $index => $item ) {
                $flag_url = isset($item['flag']['url']) ? $item['flag']['url'] : '';
                $lang_name = esc_html($item['language_name']);
                echo '<div class="skill-language-flag-item" data-index="' . intval($index) . '">';
                if ( $flag_url ) {
                    echo '<img class="skill-language-flag-img" src="' . esc_url($flag_url) . '" alt="' . $lang_name . '">';
                }
                echo '<span class="skill-language-tooltip">' . $lang_name . '</span>';
                echo '</div>';
            }
            echo '<button class="skill-language-arc-nav next" type="button" aria-label="قبلی"><i class="fa fa-chevron-right"></i></button>';
            echo '<button class="skill-language-arc-nav prev" type="button" aria-label="بعدی"><i class="fa fa-chevron-left"></i></button>';
            echo '</div>';

            // Styles & slider behavior
            echo '<style>
            .skill-language-arc { position: relative; height: 320px; max-width: 980px; margin: 0 auto; }
            .skill-language-arc-path { position: absolute; inset: 0; width: 100%; height: 100%; pointer-events: none; }
            .skill-language-flag-item { position: absolute; top: 50%; left: 50%; width: 78px; height: 78px; border-radius: 50%; display: flex; align-items: center; justify-content: center; background: rgba(255,255,255,0.03); box-shadow: 0 10px 30px rgba(0,0,0,0.35); backdrop-filter: blur(2px); -webkit-backdrop-filter: blur(2px); transition: transform .35s ease, opacity .35s ease, left .35s ease, top .35s ease; }
            .skill-language-flag-img { width: 100%; height: 100%; border-radius: 50%; object-fit: cover; filter: grayscale(100%) brightness(0.7); transition: transform .35s ease, filter .35s ease; }
            .skill-language-flag-item:hover .skill-language-flag-img { transform: scale(1.04); }
            .skill-language-tooltip { position: absolute; bottom: calc(100% + 8px); left: 50%; transform: translateX(-50%) translateY(8px); padding: 6px 10px; font-size: 12px; color: #fff; background: rgba(35,36,50,0.85); border-radius: 8px; white-space: nowrap; border: 1px solid rgba(255,255,255,0.08); opacity: 0; visibility: hidden; transition: opacity .25s ease, transform .25s ease; }
            .skill-language-tooltip::after { content: ""; position: absolute; top: 100%; left: 50%; transform: translateX(-50%); border-width: 6px; border-style: solid; border-color: rgba(35,36,50,0.85) transparent transparent transparent; }
            .skill-language-flag-item:hover .skill-language-tooltip { opacity: 1; visibility: visible; transform: translateX(-50%) translateY(0); }
            .skill-language-flag-item.pos1 { left: 8%;  top: 72%; opacity: .35; transform: translate(-50%, -50%) scale(.9); }
            .skill-language-flag-item.pos2 { left: 30%; top: 56%; opacity: .65; transform: translate(-50%, -50%) scale(.95); }
            .skill-language-flag-item.pos3 { left: 50%; top: 36%; width: 130px; height: 130px; opacity: 1; z-index: 2; transform: translate(-50%, -50%) scale(1); }
            .skill-language-flag-item.pos3 .skill-language-flag-img { filter: none; }
            .skill-language-flag-item.pos4 { left: 70%; top: 56%; opacity: .65; transform: translate(-50%, -50%) scale(.95); }
            .skill-language-flag-item.pos5 { left: 92%; top: 72%; opacity: .35; transform: translate(-50%, -50%) scale(.9); }
            .skill-language-flag-item.is-hidden { opacity: 0; pointer-events: none; transform: translate(-50%,-50%) scale(.8); }
            .skill-language-arc-nav { position: absolute; bottom: 8px; width: 40px; height: 40px; border-radius: 50%; border: 1px solid rgba(255,255,255,.15); background: rgba(255,255,255,.06); color: #fff; display: flex; align-items: center; justify-content: center; cursor: pointer; transition: background .25s ease, transform .25s ease; z-index: 3; }
            .skill-language-arc-nav:hover { background: rgba(255,255,255,.12); transform: translateY(-2px); }
            .skill-language-arc-nav.prev { left: 12px; }
            .skill-language-arc-nav.next { right: 12px; }
            @media (max-width: 768px) {
                .skill-language-arc { height: 260px; }
                .skill-language-flag-item { width: 64px; height: 64px; }
                .skill-language-flag-item.pos3 { width: 108px; height: 108px; top: 40%; }
                .skill-language-flag-item.pos1 { left: 12%; top: 76%; }
                .skill-language-flag-item.pos2 { left: 32%; top: 60%; }
                .skill-language-flag-item.pos4 { left: 68%; top: 60%; }
                .skill-language-flag-item.pos5 { left: 88%; top: 76%; }
            }
			.skill-language-widget-title{
				font-weight: 700;
				font-size: 24px;
			}
            </style>';

            // Slider script
            $id_js = esc_js( $id );
            echo '<script>(function(){var root=document.getElementById("'.$id_js.'");if(!root)return;var items=[].slice.call(root.querySelectorAll(".skill-language-flag-item"));if(!items.length)return;var current=0;function render(){items.forEach(function(el){el.className=el.className.replace(/\\bpos[1-5]\\b|\\bis-hidden\\b|\\bis-center\\b/g,"").trim();});for(var o=-2;o<=2;o++){var idx=(current+o+items.length)%items.length;var el=items[idx];var posClass="pos"+(o+3);el.classList.add(posClass);if(o===0)el.classList.add("is-center");}for(var i=0;i<items.length;i++){if(!items[i].className.match(/pos[1-5]/))items[i].classList.add("is-hidden");}}function next(){current=(current+1)%items.length;render();}function prev(){current=(current-1+items.length)%items.length;render();}render();var navNext=root.querySelector(".skill-language-arc-nav.next");var navPrev=root.querySelector(".skill-language-arc-nav.prev");if(navNext)navNext.addEventListener("click",next);if(navPrev)navPrev.addEventListener("click",prev);var autoplay=setInterval(next,3000);root.addEventListener("mouseenter",function(){clearInterval(autoplay);autoplay=null;});root.addEventListener("mouseleave",function(){if(!autoplay)autoplay=setInterval(next,3000);});})();</script>';
        }
    }

    public function get_style_depends() {
        return [];
    }

    public function get_script_depends() {
        return [];
    }
}

// Tooltip and slider handled per-widget in render output; no global script needed