<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class skill_list_weblog_Widget extends \Elementor\Widget_Base {

    // Widget slug
    public function get_name() {
        return 'skill_list_weblog_widget';
    }

    // Widget title
    public function get_title() {
        return esc_html__('مقالات من', 'skill');
    }

    // Widget icon
    public function get_icon() {
        return 'eicon-post-list';
    }

    // Widget category
    public function get_categories() {
        return ['skill-category'];
    }

    // Register widget controls
    protected function _register_controls() {
        // Content section
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات محتوا', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        // Header: title/desc similar to skill-title-desc-widget
        $this->add_control('show_title', [
            'label' => esc_html__('نمایش عنوان', 'skill'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => esc_html__('بله', 'skill'),
            'label_off' => esc_html__('خیر', 'skill'),
            'return_value' => 'yes',
            'default' => 'yes',
        ]);
        $this->add_control('title_text', [
            'label' => esc_html__('عنوان', 'skill'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__('مقالات من', 'skill'),
            'condition' => ['show_title' => 'yes']
        ]);
        $this->add_control('show_dot', [
            'label' => esc_html__('نمایش مربع آبی', 'skill'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => esc_html__('بله', 'skill'),
            'label_off' => esc_html__('خیر', 'skill'),
            'return_value' => 'yes',
            'default' => 'yes',
        ]);
        $this->add_control('dot_position', [
            'label' => esc_html__('جایگاه مربع', 'skill'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [ 'right' => esc_html__('راست عنوان', 'skill'), 'left' => esc_html__('چپ عنوان', 'skill') ],
            'default' => 'right',
            'condition' => ['show_dot' => 'yes']
        ]);
        $this->add_control('show_desc', [
            'label' => esc_html__('نمایش توضیح کوتاه', 'skill'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => esc_html__('بله', 'skill'),
            'label_off' => esc_html__('خیر', 'skill'),
            'return_value' => 'yes',
            'default' => 'yes',
        ]);
        $this->add_control('desc_text', [
            'label' => esc_html__('توضیح کوتاه', 'skill'),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'default' => esc_html__('توسعه‌دهنده‌ای هستم که وردپرس را مانند کف دست می‌شناسم. مشکل را به من بگویید...', 'skill'),
            'rows' => 2,
            'condition' => ['show_desc' => 'yes']
        ]);

        // Post count control
        $this->add_control(
            'posts_per_page',
            [
                'label' => esc_html__('تعداد مقالات', 'skill'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 4,
                'min' => 1,
                'max' => 20,
            ]
        );

        // Category filter
        $this->add_control(
            'category',
            [
                'label' => esc_html__('دسته‌بندی', 'skill'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => $this->get_categories_options(),
                'multiple' => true,
                'label_block' => true,
            ]
        );

        // Order by
        $this->add_control(
            'orderby',
            [
                'label' => esc_html__('مرتب‌سازی بر اساس', 'skill'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'date' => esc_html__('تاریخ', 'skill'),
                    'title' => esc_html__('عنوان', 'skill'),
                    'rand' => esc_html__('تصادفی', 'skill'),
                ],
            ]
        );

        // Order
        $this->add_control(
            'order',
            [
                'label' => esc_html__('ترتیب', 'skill'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'DESC',
                'options' => [
                    'DESC' => esc_html__('نزولی', 'skill'),
                    'ASC' => esc_html__('صعودی', 'skill'),
                ],
            ]
        );

        // Show author
        $this->add_control(
            'show_author',
            [
                'label' => esc_html__('نمایش نویسنده', 'skill'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => esc_html__('بله', 'skill'),
                'label_off' => esc_html__('خیر', 'skill'),
            ]
        );

        // Show date
        $this->add_control(
            'show_date',
            [
                'label' => esc_html__('نمایش تاریخ', 'skill'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => esc_html__('بله', 'skill'),
                'label_off' => esc_html__('خیر', 'skill'),
            ]
        );

        // Show excerpt
        $this->add_control(
            'show_excerpt',
            [
                'label' => esc_html__('نمایش خلاصه', 'skill'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => esc_html__('بله', 'skill'),
                'label_off' => esc_html__('خیر', 'skill'),
            ]
        );

        // Show more button
        $this->add_control(
            'show_more',
            [
                'label' => esc_html__('نمایش دکمه بیشتر', 'skill'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => esc_html__('بله', 'skill'),
                'label_off' => esc_html__('خیر', 'skill'),
            ]
        );

        // More button text
        $this->add_control(
            'more_text',
            [
                'label' => esc_html__('متن دکمه بیشتر', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('نمونه های بیشتر...', 'skill'),
                'condition' => [
                    'show_more' => 'yes',
                ],
            ]
        );

        // More button custom link
        $this->add_control(
            'more_link',
            [
                'label' => esc_html__('لینک دکمه بیشتر', 'skill'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => 'https://your-link.com',
                'default' => [
                    'url' => '',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'condition' => [
                    'show_more' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        // Style section
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('استایل', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        // Card background color
        $this->add_control(
            'card_bg_color',
            [
                'label' => esc_html__('رنگ پس‌زمینه کارت', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#232432',
            ]
        );
        // Card border radius
        $this->add_control(
            'card_radius',
            [
                'label' => esc_html__('گردی گوشه کارت', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => ['min' => 0, 'max' => 40],
                    '%' => ['min' => 0, 'max' => 50],
                ],
                'default' => ['unit' => 'px', 'size' => 18],
            ]
        );
        // Card box shadow
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'card_box_shadow',
                'selector' => '{{WRAPPER}} .skill-blog-card',
            ]
        );
        // Title color
        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [ '{{WRAPPER}} .skill-blog-header-title' => 'color: {{VALUE}};' ],
            ]
        );
        // Title typography (size, weight, etc.)
        $this->add_group_control(\Elementor\Group_Control_Typography::get_type(), [
            'name' => 'header_title_typo',
            'label' => esc_html__('تایپوگرافی عنوان', 'skill'),
            'selector' => '{{WRAPPER}} .skill-blog-header-title'
        ]);
        // Desc color
        $this->add_control(
            'header_desc_color',
            [
                'label' => esc_html__('رنگ توضیح', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'rgba(255,255,255,0.8)',
                'selectors' => [ '{{WRAPPER}} .skill-blog-header-desc' => 'color: {{VALUE}};' ],
            ]
        );
        // Desc typography (size, weight, etc.)
        $this->add_group_control(\Elementor\Group_Control_Typography::get_type(), [
            'name' => 'header_desc_typo',
            'label' => esc_html__('تایپوگرافی توضیح', 'skill'),
            'selector' => '{{WRAPPER}} .skill-blog-header-desc'
        ]);
        // Dot color
        $this->add_control(
            'header_dot_color',
            [
                'label' => esc_html__('رنگ مربع', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#1e73be',
                'selectors' => [ '{{WRAPPER}} .skill-blog-header-dot' => 'background-color: {{VALUE}};' ],
            ]
        );
        // Meta color
        $this->add_control(
            'meta_color',
            [
                'label' => esc_html__('رنگ متا (دسته/نویسنده)', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
            ]
        );
        // Excerpt color
        $this->add_control(
            'excerpt_color',
            [
                'label' => esc_html__('رنگ خلاصه', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
            ]
        );
        // Date color
        $this->add_control(
            'date_color',
            [
                'label' => esc_html__('رنگ تاریخ', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
            ]
        );
        // Button background color
        $this->add_control(
            'btn_bg_color',
            [
                'label' => esc_html__('رنگ پس‌زمینه دکمه', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffb43a',
            ]
        );
        // Button text color
        $this->add_control(
            'btn_text_color',
            [
                'label' => esc_html__('رنگ متن دکمه', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#232432',
            ]
        );
        // Button background color hover
        $this->add_control(
            'btn_bg_color_hover',
            [
                'label' => esc_html__('رنگ پس‌زمینه دکمه (هاور)', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ff9800',
            ]
        );
        // Button text color hover
        $this->add_control(
            'btn_text_color_hover',
            [
                'label' => esc_html__('رنگ متن دکمه (هاور)', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
            ]
        );
        $this->end_controls_section();
    }

    // Helper: Get categories for select2
    private function get_categories_options() {
        $cats = get_categories(['hide_empty' => false]);
        $options = [];
        foreach ($cats as $cat) {
            $options[$cat->term_id] = $cat->name;
        }
        return $options;
    }

    // Render widget output
    protected function render() {
        $settings = $this->get_settings_for_display();

        // Prepare query args
        $args = [
            'post_type' => 'post',
            'posts_per_page' => !empty($settings['posts_per_page']) ? intval($settings['posts_per_page']) : 4,
            'orderby' => $settings['orderby'],
            'order' => $settings['order'],
        ];
        if (!empty($settings['category'])) {
            $args['category__in'] = array_map('intval', (array)$settings['category']);
        }
        $query = new WP_Query($args);

        // Style variables from controls
        $card_bg = !empty($settings['card_bg_color']) ? $settings['card_bg_color'] : '#232432';
        $card_radius = !empty($settings['card_radius']['size']) ? $settings['card_radius']['size'].$settings['card_radius']['unit'] : '18px';
        $title_color = !empty($settings['title_color']) ? $settings['title_color'] : '#ffb43a';
        $meta_color = !empty($settings['meta_color']) ? $settings['meta_color'] : '#fff';
        $excerpt_color = !empty($settings['excerpt_color']) ? $settings['excerpt_color'] : '#fff';
        $date_color = !empty($settings['date_color']) ? $settings['date_color'] : '#fff';
        $btn_bg = !empty($settings['btn_bg_color']) ? $settings['btn_bg_color'] : '#ffb43a';
        $btn_text = !empty($settings['btn_text_color']) ? $settings['btn_text_color'] : '#232432';
        $btn_bg_hover = !empty($settings['btn_bg_color_hover']) ? $settings['btn_bg_color_hover'] : '#ff9800';
        $btn_text_hover = !empty($settings['btn_text_color_hover']) ? $settings['btn_text_color_hover'] : '#fff';
        // Box shadow is handled by Elementor selector, so not in inline style

        ?>
        <style>
        .skill-blog-list-widget {
            direction: rtl;
        }
        /* Shared grid wrapper to align header and cards */
        .skill-blog-list-inner { display:grid; grid-template-columns: repeat(auto-fit, minmax(301px, 301px)); gap: 2rem; justify-content: center; }
        .skill-blog-list-title { display: flex; align-items: center; justify-content: space-between; gap: 1rem; margin-bottom: 1.5rem; grid-column: 1 / -1; }
        .skill-blog-header-right { display:flex; flex-direction: column; gap:8px; }
        .skill-blog-header-row { display:inline-flex; align-items:center; gap:8px; }
        .skill-blog-header-title { font-size: 2rem; margin:0; color:#fff; }
        .skill-blog-header-dot { width:10px; height:10px; background:#1e73be; border-radius:3px; }
        .skill-blog-header-desc { color: rgba(255,255,255,0.8); font-size:1.1rem; }
        /* Let cards be direct items of the grid wrapper */
        .skill-blog-list-cards { display: contents; }
        .skill-blog-card {
            background: <?php echo esc_attr($card_bg); ?>;
            border-radius: <?php echo esc_attr($card_radius); ?>;
            box-shadow: none;
            overflow: hidden;
            width: 301px;
            height: 411px;
            position: relative;
            transition: box-shadow 0.2s;
        }
        .skill-blog-card:hover {
            box-shadow: 0 8px 32px 0 rgba(0,0,0,0.18);
        }
        .skill-blog-card-img-wrap {
            position: relative;
            width: 100%;
            height: 100%;
            overflow: hidden;
        }
        .skill-blog-card-img {
            width: 100% !important;
            height: 100% !important;
            object-fit: cover;
            filter: grayscale(0.2) saturate(95%);
            transform: scale(1);
            transition: transform 0.35s ease, filter 0.35s ease;
        }
        .skill-blog-card:hover .skill-blog-card-img { transform: scale(1.06); filter: grayscale(0) saturate(110%); }
        .skill-blog-card-info {
            position: absolute;
            left: 12px;
            right: 12px;
            bottom: 12px;
            background: rgba(0,20,62,0.80);
            -webkit-backdrop-filter: blur(10px);
            backdrop-filter: blur(10px);
            border: 0;
            border-radius: 14px;
            box-shadow: 0 4px 13.6px rgba(0,0,0,0.55);
            padding: 0.85rem 0.95rem;
            color: #fff;
        }
        .skill-blog-card-meta {
            display: flex;
            flex-wrap: wrap;
            align-items: center;
            gap: 0.7rem;
            color: <?php echo esc_attr($meta_color); ?>;
            font-size: 0.95rem;
            margin: 1.2rem 1rem 0.5rem 1rem;
            opacity: 0.85;
        }
        .skill-blog-card-meta span {
            display: flex;
            align-items: center;
            gap: 0.3rem;
        }
        .skill-blog-card-excerpt {
            color: <?php echo esc_attr($excerpt_color); ?>;
            opacity: 0.9;
            font-size: 0.95rem;
            margin: 0;
        }
        .skill-blog-card-footer { display:flex; align-items:center; justify-content: space-between; }
        .skill-blog-card-date {
            font-size: 0.92rem;
            color: <?php echo esc_attr($date_color); ?>;
            opacity: 0.85;
            display: flex;
            align-items: center;
            transition: opacity 0.3s;
        }
        .skill-blog-card-footer-spacer { flex: 1 1 auto; }
        .skill-blog-card-link { display:block; width:100%; height:100%; text-decoration:none; }
        .skill-blog-card-readmore-btn, .skill-blog-card-more-btn {
            background: <?php echo esc_attr($btn_bg); ?>;
            color: <?php echo esc_attr($btn_text); ?>;
            border: none;
            border-radius: 8px;
            padding: 0.5rem 1.3rem;
            font-weight: 600;
            font-size: 1rem;
            transition: background 0.2s, color 0.2s, opacity 0.3s, transform 0.35s cubic-bezier(.4,1.7,.7,1.01);
            text-decoration: none;
            display: inline-block;
            box-shadow: 0 2px 8px rgba(0,0,0,0.10);
        }
        .skill-blog-card-readmore-btn { display:none; }
        .skill-blog-card-readmore-btn:hover, .skill-blog-card-more-btn:hover {
            background: <?php echo esc_attr($btn_bg_hover); ?>;
            color: <?php echo esc_attr($btn_text_hover); ?>;
        }
        /* Clamp title and excerpt to two lines */
        .skill-blog-card-title {
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
            text-overflow: ellipsis;
        }
        .skill-blog-card-excerpt {
            display: -webkit-box;
            -webkit-line-clamp: 3;
            -webkit-box-orient: vertical;
            overflow: hidden;
            text-overflow: ellipsis;
        }
        </style>
        <div class="skill-blog-list-widget">
            <div class="skill-blog-list-inner">
            <div class="skill-blog-list-title">
                <div class="skill-blog-header-right" dir="rtl">
                    <div class="skill-blog-header-row" style="<?php echo (($settings['dot_position'] ?? 'right') === 'right') ? 'flex-direction: row-reverse;' : ''; ?>">
                        <?php if (!empty($settings['show_title']) && $settings['show_title'] === 'yes'): ?>
                            <h2 class="skill-blog-header-title"><?php echo esc_html($settings['title_text'] ?? ''); ?></h2>
                        <?php endif; ?>
                        <?php if (!empty($settings['show_dot']) && $settings['show_dot'] === 'yes'): ?>
                            <span class="skill-blog-header-dot" aria-hidden="true"></span>
                        <?php endif; ?>
                    </div>
                    <?php if (!empty($settings['show_desc']) && $settings['show_desc'] === 'yes' && !empty($settings['desc_text'])): ?>
                        <div class="skill-blog-header-desc"><?php echo esc_html($settings['desc_text']); ?></div>
                    <?php endif; ?>
                </div>
                <?php if ($settings['show_more'] === 'yes') : ?>
                    <?php
                    $more_url = '';
                    if (!empty($settings['more_link']['url'])) {
                        $more_url = $settings['more_link']['url'];
                    } else {
                        $more_url = get_permalink(get_option('page_for_posts'));
                    }
                    $more_target = !empty($settings['more_link']['is_external']) ? ' target="_blank"' : '';
                    $more_rel = !empty($settings['more_link']['nofollow']) ? ' rel="nofollow"' : '';
                    ?>
                    <a href="<?php echo esc_url($more_url); ?>" class="skill-blog-card-more-btn"<?php echo $more_target . $more_rel; ?>> <?php echo esc_html($settings['more_text']); ?> </a>
                <?php endif; ?>
            </div>
            <div class="skill-blog-list-cards">
                <?php if ($query->have_posts()) : while ($query->have_posts()) : $query->the_post(); ?>
                    <div class="skill-blog-card">
                        <a class="skill-blog-card-link" href="<?php the_permalink(); ?>">
                            <div class="skill-blog-card-img-wrap">
                                <?php if (has_post_thumbnail()) : ?>
                                    <img class="skill-blog-card-img" src="<?php echo esc_url(get_the_post_thumbnail_url(get_the_ID(), 'large')); ?>" alt="<?php the_title_attribute(); ?>" />
                                <?php else: ?>
                                    <div style="width:100%;height:100%;background:#444;"></div>
                                <?php endif; ?>
                                <div class="skill-blog-card-info">
                                    <div class="skill-blog-card-footer">
                                        <div class="skill-blog-card-meta">
                                            <?php if ($settings['show_author'] === 'yes') { echo '<span><i class=\"fa fa-user\"></i> ' . get_the_author() . '</span>'; } ?>
                                            <?php if ($settings['show_date'] === 'yes') { echo '<span class=\"skill-blog-card-date\"><i class=\"fa fa-calendar-alt me-1\"></i> ' . skill_get_persian_post_date_conditional('j F Y') . '</span>'; } ?>
                                        </div>
                                    </div>
                                    <?php if ($settings['show_excerpt'] === 'yes') : ?>
                                        <div class="skill-blog-card-excerpt"><?php echo wp_trim_words(get_the_excerpt(), 28); ?></div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </a>
                        <div class="skill-blog-card-meta">
                            <?php
                            // Category
                            $cat = get_the_category();
                            if ($cat && isset($cat[0])) {
                                echo '<span><i class="fa fa-folder-open"></i> ' . esc_html($cat[0]->name) . '</span>';
                            }
                            // Author
                            if ($settings['show_author'] === 'yes') {
                                echo '<span><i class="fa fa-user"></i> ' . get_the_author() . '</span>';
                            }
                            ?>
                        </div>
                         <?php /* below meta/excerpt/footer are now shown inside .skill-blog-card-info overlay */ ?>
                    </div>
                <?php endwhile; else: ?>
                    <div style="color:#fff; padding:2rem; text-align:center; width:100%;"> <?php echo esc_html__('متاسفانه چیزی برای نمایش وجود نداره.', 'skill'); ?> </div>
                <?php endif; wp_reset_postdata(); ?>
            </div>
            <?php /* more button moved to header */ ?>
            </div>
        </div>
        <?php
    }

    // JS template for live preview (optional, can be expanded)
    protected function _content_template() {}
}