<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Skill_Feamenu_oner_page_demo_developer_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'skill_menu_demo_developer';
    }

    public function get_title() {
        return __( 'منوی صفحات داخلی مهارت', 'skill' );
    }

    public function get_icon() {
        return 'eicon-menu-bar';
    }

    public function get_categories() {
        return [ 'skill-category' ];
    }

    public function get_keywords() {
        return [ 'menu', 'navigation', 'internal', 'pages', 'skill' ];
    }

    protected function register_controls() {

        // logo
        $this->start_controls_section(
            'section_logo',
            [
                'label' => __( 'لوگو', 'skill' ),
            ]
        );
        $this->add_control(
            'logo_type',
            [
                'label' => __( 'نوع لوگو', 'skill' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'svg' => __( 'SVG', 'skill' ),
                    'image' => __( 'تصویر (JPG/PNG)', 'skill' ),
                    'text' => __( 'متن', 'skill' ),
                ],
                'default' => 'svg',
            ]
        );
        $this->add_control(
            'logo_svg',
            [
                'label' => __( 'کد SVG', 'skill' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'condition' => [
                    'logo_type' => 'svg',
                ],
            ]
        );
        $this->add_control(
            'logo_image',
            [
                'label' => __( 'آپلود تصویر', 'skill' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'condition' => [
                    'logo_type' => 'image',
                ],
            ]
        );
        $this->add_control(
            'logo_text',
            [
                'label' => __( 'متن لوگو', 'skill' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'condition' => [
                    'logo_type' => 'text',
                ],
            ]
        );
        $this->add_control(
            'logo_link',
            [
                'label' => __( 'لینک لوگو', 'skill' ),
                'type' => \Elementor\Controls_Manager::URL,
                'default' => [
                    'url' => home_url(),
                    'is_external' => false,
                ],
            ]
        );
        $this->add_responsive_control(
            'logo_width',
            [
                'label' => __( 'عرض لوگو (px)', 'skill' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [ 'min' => 40, 'max' => 300 ],
                ],
                'default' => [ 'size' => 145 ],
                'selectors' => [
                    '{{WRAPPER}} .skill-menu-logo img, {{WRAPPER}} .skill-menu-logo svg' => 'width: {{SIZE}}px;',
                ],
            ]
        );
        $this->add_responsive_control(
            'logo_height',
            [
                'label' => __( 'ارتفاع لوگو (px)', 'skill' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [ 'min' => 20, 'max' => 150 ],
                ],
                'default' => [ 'size' => 55 ],
                'selectors' => [
                    '{{WRAPPER}} .skill-menu-logo img, {{WRAPPER}} .skill-menu-logo svg' => 'height: {{SIZE}}px;',
                ],
            ]
        );
        $this->end_controls_section();

        // Menu items
        $this->start_controls_section(
            'section_menu',
            [
                'label' => __( 'آیتم‌های منو', 'skill' ),
            ]
        );
        $this->add_control(
            'menu_items',
            [
                'label' => __( 'آیتم‌ها', 'skill' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'label',
                        'label' => __( 'عنوان', 'skill' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => __( 'آیتم منو', 'skill' ),
                    ],
                    [
                        'name' => 'anchor',
                        'label' => __( 'شناسه بخش (Anchor)', 'skill' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => 'section-id',
                    ],
                ],
                'default' => [
                    [ 'label' => 'صفحه اصلی', 'anchor' => 'home' ],
                    [ 'label' => 'درباره من', 'anchor' => 'about' ],
                    [ 'label' => 'خدمات من', 'anchor' => 'services' ],
                ],
                'title_field' => '{{{ label }}}',
            ]
        );
        $this->end_controls_section();

		// فهرست وردپرس
		$this->start_controls_section(
			'section_menu_wp',
			[
				'label' => __( 'فهرست وردپرس', 'skill' ),
			]
		);
		$menus = function_exists('wp_get_nav_menus') ? wp_get_nav_menus() : [];
		$menu_options = [];
		if ( ! empty( $menus ) && is_array( $menus ) ) {
			foreach ( $menus as $menu ) {
				$menu_options[ $menu->term_id ] = $menu->name;
			}
		}
		$default_menu_id = '';
		if ( ! empty( $menu_options ) ) {
			$keys = array_keys( $menu_options );
			$default_menu_id = $keys[0];
		}
		$this->add_control(
			'nav_menu_id',
			[
				'label' => __( 'انتخاب فهرست', 'skill' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => $menu_options,
				'default' => $default_menu_id,
				'description' => __( 'از مسیر نمایش > فهرست‌ها یک فهرست بسازید و اینجا انتخاب کنید.', 'skill' ),
			]
		);
		$this->end_controls_section();

        // button
        $this->start_controls_section(
            'section_button',
            [
                'label' => __( 'دکمه', 'skill' ),
            ]
        );
        $this->add_control(
            'button_text',
            [
                'label' => __( 'متن دکمه', 'skill' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'تماس با من', 'skill' ),
            ]
        );
        $this->add_control(
            'button_link',
            [
                'label' => __( 'لینک دکمه', 'skill' ),
                'type' => \Elementor\Controls_Manager::URL,
                'default' => [
                    'url' => '#contact',
                    'is_external' => false,
                ],
            ]
        );
        $this->end_controls_section();

        // Responsive Settings
        $this->start_controls_section(
            'section_responsive',
            [
                'label' => __( 'تنظیمات ریسپانسیو', 'skill' ),
            ]
        );
        $this->add_control(
            'mobile_breakpoint',
            [
                'label' => __( 'نقطه شکست موبایل (px)', 'skill' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 1024,
                'min' => 768,
                'max' => 1200,
                'step' => 1,
            ]
        );
        $this->add_control(
            'hamburger_color',
            [
                'label' => __( 'رنگ منوی همبرگری', 'skill' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#333',
                'selectors' => [
                    '{{WRAPPER}} .skill-hamburger span' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'mobile_menu_bg',
            [
                'label' => __( 'رنگ پس‌زمینه منوی موبایل', 'skill' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .skill-mobile-menu' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'overlay_color',
            [
                'label' => __( 'رنگ پس‌زمینه overlay', 'skill' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'rgba(0, 0, 0, 0.5)',
                'selectors' => [
                    '{{WRAPPER}} .skill-overlay' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'overlay_blur',
            [
                'label' => __( 'میزان بلور overlay (px)', 'skill' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [ 'min' => 0, 'max' => 20, 'step' => 1 ],
                ],
                'default' => [ 'size' => 5 ],
                'selectors' => [
                    '{{WRAPPER}} .skill-overlay' => 'backdrop-filter: blur({{SIZE}}px); -webkit-backdrop-filter: blur({{SIZE}}px);',
                ],
            ]
        );
        $this->end_controls_section();

        // Menu style
        $this->start_controls_section(
            'section_menu_style',
            [
                'label' => __( 'استایل منو', 'skill' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'menu_color',
            [
                'label' => __( 'رنگ آیتم منو', 'skill' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#333',
                'selectors' => [
                    '{{WRAPPER}} .skill-menu-link, {{WRAPPER}} .skill-menu-list a' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'menu_hover_color',
            [
                'label' => __( 'رنگ هاور آیتم منو', 'skill' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#1769ff',
                'selectors' => [
                    '{{WRAPPER}} .skill-menu-link:hover, {{WRAPPER}} .skill-menu-list a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'menu_font_size',
            [
                'label' => __( 'سایز فونت آیتم منو', 'skill' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'em', 'rem' ],
                'range' => [
                    'px' => [ 'min' => 10, 'max' => 50 ],
                    'em' => [ 'min' => 0.5, 'max' => 3 ],
                    'rem' => [ 'min' => 0.5, 'max' => 3 ],
                ],
                'default' => [ 'size' => 16, 'unit' => 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .skill-menu-link, {{WRAPPER}} .skill-menu-list a' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'menu_transition',
            [
                'label' => __( 'ترنزیشن هاور (ثانیه)', 'skill' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 's' ],
                'range' => [ 's' => [ 'min' => 0, 'max' => 2, 'step' => 0.05 ] ],
                'default' => [ 'size' => 0.3 ],
                'selectors' => [
                    '{{WRAPPER}} .skill-menu-link, {{WRAPPER}} .skill-menu-list a' => 'transition: color {{SIZE}}s;',
                ],
            ]
        );

        $this->add_control(
            'menu_item_bg_color',
            [
                'label' => __( 'رنگ پس‌زمینه آیتم‌ها (li)', 'skill' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .skill-menu-list > li' => 'background: {{VALUE}} !important; background-color: {{VALUE}} !important;',
                    '{{WRAPPER}} .skill-menu-list > li > a' => 'background: {{VALUE}} !important; background-color: {{VALUE}} !important;',
                    '{{WRAPPER}} .skill-menu-list > li > a > .skill-menu-link' => 'background: {{VALUE}} !important; background-color: {{VALUE}} !important;',
                    '{{WRAPPER}} .skill-mobile-menu .skill-menu-list > li' => 'background: {{VALUE}} !important; background-color: {{VALUE}} !important;',
                    '{{WRAPPER}} .skill-mobile-menu .skill-menu-list > li > a' => 'background: {{VALUE}} !important; background-color: {{VALUE}} !important;',
                    '{{WRAPPER}} .skill-mobile-menu .skill-menu-list > li > a > .skill-menu-link' => 'background: {{VALUE}} !important; background-color: {{VALUE}} !important;',
                ],
            ]
        );
        $this->end_controls_section();

        // Button style
        $this->start_controls_section(
            'section_button_style',
            [
                'label' => __( 'استایل دکمه', 'skill' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'button_color',
            [
                'label' => __( 'رنگ پس‌زمینه دکمه', 'skill' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#0e59f2',
                'selectors' => [
                    '{{WRAPPER}} .skill-menu-action-btn' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'button_text_color',
            [
                'label' => __( 'رنگ متن دکمه', 'skill' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .skill-menu-action-btn' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'button_padding',
            [
                'label' => __( 'فاصله داخلی دکمه', 'skill' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => '15',
                    'right' => '50',
                    'bottom' => '15',
                    'left' => '50',
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .skill-menu-action-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'button_border_radius',
            [
                'label' => __( 'گردی گوشه دکمه', 'skill' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [ 'min' => 0, 'max' => 100 ],
                ],
                'default' => [ 'size' => 50 ],
                'selectors' => [
                    '{{WRAPPER}} .skill-menu-action-btn' => 'border-radius: {{SIZE}}px;',
                ],
            ]
        );
        $this->add_control(
            'button_hover_color',
            [
                'label' => __( 'رنگ پس‌زمینه هاور دکمه', 'skill' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#0d47a1',
                'selectors' => [
                    '{{WRAPPER}} .skill-menu-action-btn:hover' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'button_hover_text_color',
            [
                'label' => __( 'رنگ متن هاور دکمه', 'skill' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .skill-menu-action-btn:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'button_transition',
            [
                'label' => __( 'ترنزیشن هاور دکمه (ثانیه)', 'skill' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 's' ],
                'range' => [ 's' => [ 'min' => 0, 'max' => 2, 'step' => 0.05 ] ],
                'default' => [ 'size' => 0.3 ],
                'selectors' => [
                    '{{WRAPPER}} .skill-menu-action-btn' => 'transition: background {{SIZE}}s, color {{SIZE}}s;',
                ],
            ]
        );
        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $mobile_breakpoint = $settings['mobile_breakpoint'] ?? 1024;
        ?>
        
        <style>
        /* Main styles */
        .skill-navbar {
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 30px;
            direction: rtl;
            padding: 15px 0;
            position: relative;
            z-index: 1000;
        }

        .skill-desktop-menu {
            display: flex;
            align-items: center;
            gap: 30px;
        }

        .skill-menu-list {
            display: flex;
            align-items: center;
            gap: 30px;
            list-style: none;
            margin: 0;
            padding: 0;
        }

        .skill-menu-list a,
        .skill-menu-link {
            text-decoration: none;
            transition: color 0.3s ease;
            font-weight: 500;
            color: #333;
        }

        .skill-menu-link:hover {
            color: #1769ff;
        }

        .skill-menu-action-btn {
            display: inline-block;
            padding: 15px 50px;
            background: #0e59f2;
            color: #fff;
            text-decoration: none;
            border-radius: 50px;
            transition: all 0.3s ease;
            font-weight: 500;
        }

        .skill-menu-action-btn:hover {
            background: #0d47a1;
            color: #fff;
        }

        /* Hamburger menu */
        .skill-hamburger {
            display: none;
            flex-direction: column;
            justify-content: space-between;
            width: 30px;
            height: 25px;
            cursor: pointer;
            z-index: 10000;
            position: relative;
        }

        .skill-hamburger span {
            display: block;
            width: 100%;
            height: 3px;
            background-color: #333;
            transition: all 0.3s ease;
            border-radius: 2px;
        }

        .skill-hamburger.active span:nth-child(1) {
            transform: rotate(45deg) translate(5px, 5px);
        }

        .skill-hamburger.active span:nth-child(2) {
            opacity: 0;
        }

        .skill-hamburger.active span:nth-child(3) {
            transform: rotate(-45deg) translate(7px, -6px);
        }

        /* Dark and crystallized background */
        .skill-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            backdrop-filter: blur(5px);
            -webkit-backdrop-filter: blur(5px);
            z-index: 9998;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
        }

        .skill-overlay.active {
            opacity: 1;
            visibility: visible;
        }

        /* Menu Mobile */
        .skill-mobile-menu {
            position: fixed;
            top: 0;
            right: 0;
            width: 300px;
            height: 100vh;
            background: #fff;
            box-shadow: -2px 0 10px rgba(0,0,0,0.1);
            z-index: 9999;
            padding: 80px 30px 30px;
            overflow-y: auto;
            direction: rtl;
            transform: translateX(100%);
            transition: transform 0.3s ease;
        }

        .skill-mobile-menu.active {
            transform: translateX(0);
        }

        .skill-mobile-menu .skill-menu-list {
            flex-direction: column !important;
            gap: 20px !important;
            align-items: flex-start !important;
        }

        .skill-mobile-menu .skill-menu-list li {
            width: 100%;
        }

        .skill-mobile-menu .skill-menu-list a,
        .skill-mobile-menu .skill-menu-link {
            display: block;
            padding: 15px 0;
            border-bottom: 1px solid #eee;
            font-size: 18px;
            color: #333;
        }

        .skill-mobile-menu .skill-menu-link:hover {
            color: #1769ff;
        }

        .skill-mobile-menu .skill-menu-btn {
            margin-top: 30px;
        }

        .skill-mobile-menu .skill-menu-action-btn {
            width: 100%;
            text-align: center;
            display: block;
        }

        /* Close button */
        .skill-close-menu {
            position: absolute;
            top: 20px;
            left: 20px;
            background: none;
            border: none;
            font-size: 24px;
            cursor: pointer;
            color: #333;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: background 0.3s ease;
        }

        .skill-close-menu:hover {
            background: #f5f5f5;
        }

        /* Responsive */
        @media (max-width: <?php echo $mobile_breakpoint; ?>px) {
            .skill-desktop-menu {
                display: none !important;
            }
            .skill-hamburger {
                display: flex !important;
            }
        }

        @media (min-width: <?php echo $mobile_breakpoint + 1; ?>px) {
            .skill-hamburger {
                display: none !important;
            }
            .skill-desktop-menu {
                display: flex !important;
            }
        }

        /* Additional settings for mobile */
        @media (max-width: 768px) {
            .skill-menu-btn {
                display: none;
            }

            .skill-mobile-menu {
                width: 50%;
            }
            
            .skill-navbar {
                padding: 15px 0;
            }
            
            .skill-menu-logo img,
            .skill-menu-logo svg {
                max-width: 120px;
                height: auto;
            }
        }

        @media (max-width: 425px) {
            .skill-mobile-menu {
                width: 90%;
            }
        }

        /* Animation for menu items */
        .skill-mobile-menu .skill-menu-list li {
            opacity: 0;
            transform: translateX(20px);
            animation: fadeInSlide 0.3s ease forwards;
        }

        .skill-mobile-menu .skill-menu-list li:nth-child(1) { animation-delay: 0.1s; }
        .skill-mobile-menu .skill-menu-list li:nth-child(2) { animation-delay: 0.2s; }
        .skill-mobile-menu .skill-menu-list li:nth-child(3) { animation-delay: 0.3s; }
        .skill-mobile-menu .skill-menu-list li:nth-child(4) { animation-delay: 0.4s; }
        .skill-mobile-menu .skill-menu-list li:nth-child(5) { animation-delay: 0.5s; }

        @keyframes fadeInSlide {
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }

        /* Style for scroll mode */
        body.menu-open {
            overflow: hidden;
        }

        /* Style for the logo */
        .skill-menu-logo a {
            text-decoration: none;
            color: inherit;
        }

        .skill-menu-logo img,
        .skill-menu-logo svg {
            max-width: 145px;
            height: auto;
            display: block;
        }
        </style>

        <nav class="skill-navbar">
            <!-- لوگو -->
            <div class="skill-menu-logo">
                <?php
                $logo_content = '';
                if ($settings['logo_type'] == 'svg' && !empty($settings['logo_svg'])) {
                    $logo_content = $settings['logo_svg'];
                } elseif ($settings['logo_type'] == 'image' && !empty($settings['logo_image']['url'])) {
                    $logo_content = '<img src="' . esc_url($settings['logo_image']['url']) . '" alt="logo">';
                } elseif ($settings['logo_type'] == 'text' && !empty($settings['logo_text'])) {
                    $logo_content = '<span style="font-weight:bold;font-size:24px;">' . esc_html($settings['logo_text']) . '</span>';
                }
                
                if (!empty($logo_content)) {
                    if (!empty($settings['logo_link']['url'])) {
                        echo '<a href="' . esc_url($settings['logo_link']['url']) . '"' . 
                             ($settings['logo_link']['is_external'] ? ' target="_blank"' : '') . 
                             ($settings['logo_link']['nofollow'] ? ' rel="nofollow"' : '') . '>';
                        echo $logo_content;
                        echo '</a>';
                    } else {
                        echo $logo_content;
                    }
                }
                ?>
            </div>

            <!-- منوی دسکتاپ -->
            <div class="skill-desktop-menu">
                <?php
                $selected_menu_id = isset($settings['nav_menu_id']) ? (int) $settings['nav_menu_id'] : 0;
                if ( $selected_menu_id ) {
                    echo '<ul class="skill-menu-list">';
                    wp_nav_menu([
                        'menu' => $selected_menu_id,
                        'container' => false,
                        'items_wrap' => '%3$s',
                        'echo' => true,
                        'fallback_cb' => '__return_empty_string',
                        'depth' => 1,
                        'link_before' => '<span class="skill-menu-link">',
                        'link_after' => '</span>',
                    ]);
                    echo '</ul>';
                } else {
                    echo '<ul class="skill-menu-list">';
                    if (!empty($settings['menu_items'])) {
                        foreach ($settings['menu_items'] as $item) {
                            echo '<li><a href="#' . esc_attr($item['anchor']) . '" class="skill-menu-link">' . esc_html($item['label']) . '</a></li>';
                        }
                    }
                    echo '</ul>';
                }
                ?>
            </div>

            <div class="skill-menu-btn">
                    <a href="<?php echo esc_url($settings['button_link']['url']); ?>" class="skill-menu-action-btn">
                        <?php echo esc_html($settings['button_text']); ?>
                    </a>
                </div>

            <!-- دکمه همبرگری -->
            <div class="skill-hamburger">
                <span></span>
                <span></span>
                <span></span>
            </div>
        </nav>

        <!-- پس‌زمینه تیره و بلور شده -->
        <div class="skill-overlay"></div>
        
        <!-- منوی موبایل -->
        <div class="skill-mobile-menu">
            <button class="skill-close-menu">&times;</button>
            <ul class="skill-menu-list">
                <?php
                $selected_menu_id = isset($settings['nav_menu_id']) ? (int) $settings['nav_menu_id'] : 0;
                if ( $selected_menu_id ) {
                    wp_nav_menu([
                        'menu' => $selected_menu_id,
                        'container' => false,
                        'items_wrap' => '%3$s',
                        'echo' => true,
                        'fallback_cb' => '__return_empty_string',
                        'depth' => 1,
                        'link_before' => '<span class="skill-menu-link">',
                        'link_after' => '</span>',
                    ]);
                } else {
                    if (!empty($settings['menu_items'])) {
                        foreach ($settings['menu_items'] as $item) {
                            echo '<li><a href="#' . esc_attr($item['anchor']) . '" class="skill-menu-link">' . esc_html($item['label']) . '</a></li>';
                        }
                    }
                }
                ?>
            </ul>
            <div class="skill-menu-btn">
                <a href="<?php echo esc_url($settings['button_link']['url']); ?>" class="skill-menu-action-btn">
                    <?php echo esc_html($settings['button_text']); ?>
                </a>
            </div>
        </div>
        
        <script>
        document.addEventListener('DOMContentLoaded', function() {
            const hamburger = document.querySelector('.skill-hamburger');
            const mobileMenu = document.querySelector('.skill-mobile-menu');
            const closeMenu = document.querySelector('.skill-close-menu');
            const overlay = document.querySelector('.skill-overlay');
            
            if (!hamburger || !mobileMenu || !closeMenu || !overlay) return;
            
            // Open the hamburger menu
            hamburger.addEventListener('click', function(e) {
                e.stopPropagation();
                hamburger.classList.add('active');
                mobileMenu.classList.add('active');
                overlay.classList.add('active');
                document.body.classList.add('menu-open');
            });
            
            // Close the hamburger menu
            function closeMobileMenu() {
                hamburger.classList.remove('active');
                mobileMenu.classList.remove('active');
                overlay.classList.remove('active');
                document.body.classList.remove('menu-open');
            }
            
            closeMenu.addEventListener('click', closeMobileMenu);
            
            // Close the menu by clicking on items
            document.querySelectorAll('.skill-mobile-menu .skill-menu-link, .skill-mobile-menu .skill-menu-list a').forEach(function(link) {
                link.addEventListener('click', function() {
                    closeMobileMenu();
                });
            });
            
            // Close the menu by clicking on the overlay
            overlay.addEventListener('click', function() {
                closeMobileMenu();
            });
            
            // Close the menu by clicking outside it
            document.addEventListener('click', function(e) {
                if (mobileMenu.classList.contains('active') && 
                    !hamburger.contains(e.target) && 
                    !mobileMenu.contains(e.target) &&
                    !overlay.contains(e.target)) {
                    closeMobileMenu();
                }
            });
            
            // Close the menu with the Escape key
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape' && mobileMenu.classList.contains('active')) {
                    closeMobileMenu();
                }
            });
            
            // Smooth scrolling to sections
            document.querySelectorAll('.skill-menu-link, .skill-menu-list a').forEach(function(link) {
                link.addEventListener('click', function(e) {
                    const href = this.getAttribute('href');
                    if (href && href.startsWith('#')) {
                        const target = document.getElementById(href.substring(1));
                    if(target) {
                        e.preventDefault();
                            const headerOffset = 80; // Adjust the distance from the top of the page
                            const elementPosition = target.getBoundingClientRect().top;
                            const offsetPosition = elementPosition + window.pageYOffset - headerOffset;
                            
                        window.scrollTo({
                                top: offsetPosition,
                            behavior: 'smooth'
                        });
                        }
                    }
                });
            });
            
            // Reset menu on screen resize
            let resizeTimer;
            window.addEventListener('resize', function() {
                clearTimeout(resizeTimer);
                resizeTimer = setTimeout(function() {
                    if (window.innerWidth > <?php echo $mobile_breakpoint; ?>) {
                        closeMobileMenu();
                    }
                }, 250);
            });
            
            // Improved overlay performance on mobile
            if ('ontouchstart' in window) {
                overlay.addEventListener('touchstart', function(e) {
                    e.stopPropagation();
                });
            }
            
            // Animation for menu items
            function animateMenuItems() {
                const menuItems = mobileMenu.querySelectorAll('.skill-menu-list li');
                menuItems.forEach((item, index) => {
                    item.style.animationDelay = (index * 0.1) + 's';
                });
            }
            
            // Run animation when menu opens
            hamburger.addEventListener('click', function() {
                setTimeout(animateMenuItems, 100);
            });
            
            // Adjusting the height of the mobile menu
            function setMobileMenuHeight() {
                if (window.innerWidth <= <?php echo $mobile_breakpoint; ?>) {
                    mobileMenu.style.height = window.innerHeight + 'px';
                }
            }
            
            setMobileMenuHeight();
            window.addEventListener('resize', setMobileMenuHeight);
            
            //Improve user experience - add loading state
            hamburger.addEventListener('click', function() {
                hamburger.style.pointerEvents = 'none';
                setTimeout(() => {
                    hamburger.style.pointerEvents = 'auto';
                }, 300);
            });
            
            // Improved scrolling on mobile
            if ('ontouchstart' in window) {
                mobileMenu.addEventListener('touchstart', function(e) {
                    e.stopPropagation();
                });
            }
        });
        </script>
        <?php
    }
}