<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class skill_my_image_personal_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'my_avatar_widget';
    }

    public function get_title() {
        return __('آواتار من', 'skill');
    }

    public function get_icon() {
        return 'eicon-person';
    }

    public function get_categories() {
        return ['skill-category'];
    }

    protected function _register_controls() {
        // Content section
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'avatar_image',
            [
                'label' => __('تصویر آواتار', 'skill'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        // Online Status Control
        $this->add_control(
            'show_online_status',
            [
                'label' => __('نمایش وضعیت آنلاین', 'skill'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('فعال', 'skill'),
                'label_off' => __('غیرفعال', 'skill'),
                'return_value' => 'yes',
                'default' => 'yes',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'status_type',
            [
                'label' => __('نوع وضعیت', 'skill'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'online',
                'options' => [
                    'online' => __('آنلاین', 'skill'),
                    'busy' => __('مشغول', 'skill'),
                    'away' => __('غایب', 'skill'),
                    'offline' => __('آفلاین', 'skill'),
                    'auto' => __('تشخیص خودکار', 'skill'),
                ],
                'condition' => [
                    'show_online_status' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'online_status_text',
            [
                'label' => __('متن وضعیت آنلاین', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('آنلاین', 'skill'),
                'condition' => [
                    'show_online_status' => 'yes',
                    'status_type!' => 'auto',
                ],
            ]
        );

        $this->add_control(
            'busy_status_text',
            [
                'label' => __('متن وضعیت مشغول', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('مشغول', 'skill'),
                'condition' => [
                    'show_online_status' => 'yes',
                    'status_type!' => 'auto',
                ],
            ]
        );

        $this->add_control(
            'away_status_text',
            [
                'label' => __('متن وضعیت غایب', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('غایب', 'skill'),
                'condition' => [
                    'show_online_status' => 'yes',
                    'status_type!' => 'auto',
                ],
            ]
        );

        $this->add_control(
            'offline_status_text',
            [
                'label' => __('متن وضعیت آفلاین', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('آفلاین', 'skill'),
                'condition' => [
                    'show_online_status' => 'yes',
                    'status_type!' => 'auto',
                ],
            ]
        );

        $this->end_controls_section();

        // Bubbles section
        $this->start_controls_section(
            'bubbles_section',
            [
                'label' => __('حباب‌های متحرک', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_bubbles',
            [
                'label' => __('نمایش حباب‌ها', 'skill'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('فعال', 'skill'),
                'label_off' => __('غیرفعال', 'skill'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'bubbles_count',
            [
                'label' => __('تعداد حباب‌ها', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [''],
                'range' => [
                    '' => [
                        'min' => 3,
                        'max' => 15,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => '',
                    'size' => 8,
                ],
                'condition' => [
                    'show_bubbles' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'bubbles_size',
            [
                'label' => __('اندازه حباب‌ها', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 30,
                ],
                'condition' => [
                    'show_bubbles' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'bubbles_speed',
            [
                'label' => __('سرعت حرکت', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['s'],
                'range' => [
                    's' => [
                        'min' => 5,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 's',
                    'size' => 15,
                ],
                'condition' => [
                    'show_bubbles' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'bubbles_opacity',
            [
                'label' => __('شفافیت حباب‌ها', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [''],
                'range' => [
                    '' => [
                        'min' => 0.1,
                        'max' => 1,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'unit' => '',
                    'size' => 0.3,
                ],
                'condition' => [
                    'show_bubbles' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        // Style section
        $this->start_controls_section(
            'style_section',
            [
                'label' => __('استایل', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        // Original image style
        $this->add_control(
            'image_style',
            [
                'label' => __('استایل تصویر', 'skill'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'border_radius',
            [
                'label' => __('شعاع حاشیه', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 304,
                ],
                'selectors' => [
                    '{{WRAPPER}} .skill_my_avatar img' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'border_width',
            [
                'label' => __('ضخامت حاشیه', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors' => [
                    '{{WRAPPER}} .skill_my_avatar img' => 'border-style: solid; border-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'border_color',
            [
                'label' => __('رنگ حاشیه', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#272627',
                'selectors' => [
                    '{{WRAPPER}} .skill_my_avatar img' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'image_size',
            [
                'label' => __('اندازه تصویر', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 50,
                        'max' => 500,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 200,
                ],
                'selectors' => [
                    '{{WRAPPER}} .skill_my_avatar img' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'object_fit',
            [
                'label' => __('نحوه نمایش تصویر', 'skill'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'cover',
                'options' => [
                    'cover' => __('پوشش (Cover)', 'skill'),
                    'contain' => __('حفظ نسبت (Contain)', 'skill'),
                    'fill' => __('پر کردن (Fill)', 'skill'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .skill_my_avatar img' => 'object-fit: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Online Status Style Section
        $this->start_controls_section(
            'online_status_style',
            [
                'label' => __('استایل وضعیت آنلاین', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_online_status' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'status_indicator_size',
            [
                'label' => __('اندازه نشانگر', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 8,
                        'max' => 30,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 12,
                ],
                'selectors' => [
                    '{{WRAPPER}} .online-status-indicator' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'status_indicator_color',
            [
                'label' => __('رنگ نشانگر', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#4CAF50',
                'selectors' => [
                    '{{WRAPPER}} .online-status-indicator' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'status_type' => 'online',
                ],
            ]
        );

        $this->add_control(
            'busy_indicator_color',
            [
                'label' => __('رنگ نشانگر مشغول', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FF9800',
                'selectors' => [
                    '{{WRAPPER}} .busy-status-indicator' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'status_type' => 'busy',
                ],
            ]
        );

        $this->add_control(
            'away_indicator_color',
            [
                'label' => __('رنگ نشانگر غایب', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFC107',
                'selectors' => [
                    '{{WRAPPER}} .away-status-indicator' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'status_type' => 'away',
                ],
            ]
        );

        $this->add_control(
            'offline_indicator_color',
            [
                'label' => __('رنگ نشانگر آفلاین', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#9E9E9E',
                'selectors' => [
                    '{{WRAPPER}} .offline-status-indicator' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'status_type' => 'offline',
                ],
            ]
        );

        $this->add_control(
            'status_indicator_border_color',
            [
                'label' => __('رنگ حاشیه نشانگر', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .online-status-indicator' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'status_text_color',
            [
                'label' => __('رنگ متن وضعیت', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#4CAF50',
                'selectors' => [
                    '{{WRAPPER}} .online-status-text' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'status_text_typography',
                'label' => __('تایپوگرافی متن وضعیت', 'skill'),
                'selector' => '{{WRAPPER}} .online-status-text',
            ]
        );

        $this->end_controls_section();

        // Bubbles Style Section
        $this->start_controls_section(
            'bubbles_style_section',
            [
                'label' => __('استایل حباب‌ها', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_bubbles' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'bubbles_color',
            [
                'label' => __('رنگ حباب‌ها', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#4CAF50',
                'selectors' => [
                    '{{WRAPPER}} .bubble' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'bubbles_border_color',
            [
                'label' => __('رنگ حاشیه حباب‌ها', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .bubble' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'bubbles_border_width',
            [
                'label' => __('ضخامت حاشیه حباب‌ها', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 10,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .bubble' => 'border-width: {{SIZE}}{{UNIT}}; border-style: solid;',
                ],
            ]
        );

        $this->add_control(
            'bubbles_blur',
            [
                'label' => __('تاری حباب‌ها', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 20,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 2,
                ],
                'selectors' => [
                    '{{WRAPPER}} .bubble' => 'filter: blur({{SIZE}}{{UNIT}});',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $show_online_status = $settings['show_online_status'] === 'yes';
        $status_type = $settings['status_type'] ?? 'online';
        
        // Get status text based on type
        $status_text = '';
        $status_class = '';
        
        switch ($status_type) {
            case 'online':
                $status_text = $settings['online_status_text'] ?? __('آنلاین', 'skill');
                $status_class = 'online-status-indicator';
                break;
            case 'busy':
                $status_text = $settings['busy_status_text'] ?? __('مشغول', 'skill');
                $status_class = 'busy-status-indicator';
                break;
            case 'away':
                $status_text = $settings['away_status_text'] ?? __('غایب', 'skill');
                $status_class = 'away-status-indicator';
                break;
            case 'offline':
                $status_text = $settings['offline_status_text'] ?? __('آفلاین', 'skill');
                $status_class = 'offline-status-indicator';
                break;
            case 'auto':
                $status_text = __('آنلاین', 'skill');
                $status_class = 'auto-status-indicator';
                break;
        }
        ?>
        
        <style>
        .skill_my_avatar {
            display: flex;
            justify-content: center;
            align-items: center;
            position: relative;
            cursor: pointer;
        }

        .skill_my_avatar img {
            border-radius: 50%;
            border: 10px solid #272627;
            width: 200px;
            height: 200px;
            object-fit: cover;
            transition: all 0.3s ease;
            position: relative;
            z-index: 5;
        }

        .skill_my_avatar img:hover {
            transform: scale(1.05);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
        }

        /* Ensure status text shows on image hover */
        .skill_my_avatar img:hover ~ .online-status-text {
            opacity: 1 !important;
            visibility: visible !important;
        }

        /* Better hover effect for status text */
        .skill_my_avatar:hover .online-status-text {
            opacity: 1 !important;
            transform: translateX(-50%) translateY(-2px);
        }

        /* Alternative hover trigger */
        .skill_my_avatar img:hover + .online-status-text,
        .skill_my_avatar img:hover ~ .online-status-text {
            opacity: 1 !important;
            transform: translateX(-50%) translateY(-2px);
        }

        /* Force show on hover for debugging */
        .skill_my_avatar:hover .online-status-text {
            opacity: 1 !important;
            visibility: visible !important;
        }

        /* Bubbles Container */
        .bubbles-container {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 1;
            overflow: hidden;
        }

        /* Individual Bubbles */
        .bubble {
            position: absolute;
            background-color: #4CAF50;
            border: 1px solid #ffffff;
            border-radius: 50%;
            opacity: 0.3;
            filter: blur(2px);
            animation: float 15s infinite ease-in-out;
        }

        /* Different sizes and positions for variety */
        .bubble-0 { width: 20px; height: 20px; left: 10%; animation-delay: 0s; }
        .bubble-1 { width: 35px; height: 35px; left: 20%; animation-delay: 2s; }
        .bubble-2 { width: 25px; height: 25px; left: 30%; animation-delay: 4s; }
        .bubble-3 { width: 40px; height: 40px; left: 40%; animation-delay: 6s; }
        .bubble-4 { width: 15px; height: 15px; left: 50%; animation-delay: 8s; }
        .bubble-5 { width: 30px; height: 30px; left: 60%; animation-delay: 10s; }
        .bubble-6 { width: 45px; height: 45px; left: 70%; animation-delay: 12s; }
        .bubble-7 { width: 20px; height: 20px; left: 80%; animation-delay: 14s; }
        .bubble-8 { width: 35px; height: 35px; left: 90%; animation-delay: 1s; }
        .bubble-9 { width: 25px; height: 25px; left: 15%; animation-delay: 3s; }
        .bubble-10 { width: 40px; height: 40px; left: 25%; animation-delay: 5s; }
        .bubble-11 { width: 30px; height: 30px; left: 35%; animation-delay: 7s; }
        .bubble-12 { width: 20px; height: 20px; left: 45%; animation-delay: 9s; }
        .bubble-13 { width: 35px; height: 35px; left: 55%; animation-delay: 11s; }
        .bubble-14 { width: 25px; height: 25px; left: 65%; animation-delay: 13s; }

        /* Floating Animation */
        @keyframes float {
            0% {
                transform: translateY(100vh) scale(0);
                opacity: 0;
            }
            10% {
                opacity: 0.3;
            }
            90% {
                opacity: 0.3;
            }
            100% {
                transform: translateY(-100px) scale(1);
                opacity: 0;
            }
        }

        /* Online Status Indicator */
        .online-status-indicator,
        .busy-status-indicator,
        .away-status-indicator,
        .offline-status-indicator,
        .auto-status-indicator {
            position: absolute;
            bottom: 15px;
            right: 15px;
            width: 12px;
            height: 12px;
            border: 2px solid #ffffff;
            border-radius: 50%;
            z-index: 10;
        }

        .online-status-indicator {
            background-color: #4CAF50;
            animation: pulse 2s infinite;
        }

        .busy-status-indicator {
            background-color: #FF9800;
            animation: pulse 2s infinite;
        }

        .away-status-indicator {
            background-color: #FFC107;
            animation: pulse 2s infinite;
        }

        .offline-status-indicator {
            background-color: #9E9E9E;
        }

        .auto-status-indicator {
            background-color: #4CAF50;
            animation: pulse 2s infinite;
        }

        .online-status-text {
            position: absolute;
            bottom: 5px;
            left: 50%;
            transform: translateX(-50%);
            background: rgba(0, 0, 0, 0.8);
            color: #4CAF50;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 11px;
            font-weight: 500;
            white-space: nowrap;
            opacity: 0;
            transition: all 0.3s ease;
            z-index: 15;
            pointer-events: none;
            min-width: 60px;
            text-align: center;
        }

        @keyframes pulse {
            0% {
                box-shadow: 0 0 0 0 rgba(76, 175, 80, 0.7);
            }
            70% {
                box-shadow: 0 0 0 8px rgba(76, 175, 80, 0);
            }
            100% {
                box-shadow: 0 0 0 0 rgba(76, 175, 80, 0);
            }
        }

        /* Responsive styles */
        @media (max-width: 768px) {
            .skill_my_avatar img {
                width: 150px;
                height: 150px;
                border-width: 8px;
            }
            .online-status-indicator,
            .busy-status-indicator,
            .away-status-indicator,
            .offline-status-indicator,
            .auto-status-indicator {
                bottom: 10px;
                right: 10px;
                width: 10px;
                height: 10px;
            }
        }

        @media (max-width: 480px) {
            .skill_my_avatar img {
                width: 120px;
                height: 120px;
                border-width: 6px;
            }
            .online-status-indicator,
            .busy-status-indicator,
            .away-status-indicator,
            .offline-status-indicator,
            .auto-status-indicator {
                bottom: 8px;
                right: 8px;
                width: 8px;
                height: 8px;
            }
        }
        </style>
        
        <div class="skill_my_avatar">
            <?php if ($settings['show_bubbles'] === 'yes'): ?>
                <div class="bubbles-container">
                    <?php 
                    $bubbles_count = $settings['bubbles_count']['size'] ?? 8;
                    for ($i = 0; $i < $bubbles_count; $i++): 
                    ?>
                        <div class="bubble bubble-<?php echo $i; ?>"></div>
                    <?php endfor; ?>
                </div>
            <?php endif; ?>
            
            <img src="<?php echo esc_url($settings['avatar_image']['url']); ?>" alt="<?php echo esc_attr(get_the_title()); ?>">
            
            <?php if ($show_online_status): ?>
                <div class="<?php echo esc_attr($status_class); ?>"></div>
                <div class="online-status-text"><?php echo esc_html($status_text); ?></div>
            <?php endif; ?>
        </div>

        <?php if ($show_online_status && $status_type === 'auto'): ?>
        <script>
        (function() {
            let lastActivity = Date.now();
            let isOnline = true;
            const indicator = document.querySelector('.<?php echo esc_js($status_class); ?>');
            const statusText = document.querySelector('.online-status-text');
            
            // Update activity on user interaction
            function updateActivity() {
                lastActivity = Date.now();
                if (!isOnline) {
                    setOnline();
                }
            }
            
            // Check if user is active
            function checkActivity() {
                const now = Date.now();
                const inactiveTime = now - lastActivity;
                
                // Consider offline after 5 minutes of inactivity
                if (inactiveTime > 5 * 60 * 1000 && isOnline) {
                    setOffline();
                } else if (inactiveTime <= 5 * 60 * 1000 && !isOnline) {
                    setOnline();
                }
            }
            
            function setOnline() {
                isOnline = true;
                if (indicator) {
                    indicator.style.backgroundColor = '#4CAF50';
                    indicator.style.animation = 'pulse 2s infinite';
                }
                if (statusText) {
                    statusText.textContent = '<?php echo esc_js(__('آنلاین', 'skill')); ?>';
                    statusText.style.color = '#4CAF50';
                }
            }
            
            function setOffline() {
                isOnline = false;
                if (indicator) {
                    indicator.style.backgroundColor = '#9E9E9E';
                    indicator.style.animation = 'none';
                }
                if (statusText) {
                    statusText.textContent = '<?php echo esc_js(__('آفلاین', 'skill')); ?>';
                    statusText.style.color = '#9E9E9E';
                }
            }
            
            // Listen for user activity
            ['mousedown', 'mousemove', 'keypress', 'scroll', 'touchstart', 'click'].forEach(function(event) {
                document.addEventListener(event, updateActivity, true);
            });
            
            // Check activity every 30 seconds
            setInterval(checkActivity, 30000);
            
            // Initial check
            checkActivity();
        })();
        </script>
        <?php endif; ?>

        <?php if ($settings['show_bubbles'] === 'yes'): ?>
        <script>
        (function() {
            const bubblesContainer = document.querySelector('.bubbles-container');
            if (!bubblesContainer) return;

            // Get settings from PHP
            const bubblesCount = <?php echo $settings['bubbles_count']['size'] ?? 8; ?>;
            const bubblesSize = <?php echo $settings['bubbles_size']['size'] ?? 30; ?>;
            const bubblesSpeed = <?php echo $settings['bubbles_speed']['size'] ?? 15; ?>;
            const bubblesOpacity = <?php echo $settings['bubbles_opacity']['size'] ?? 0.3; ?>;

            // Update bubble styles based on settings
            const bubbles = bubblesContainer.querySelectorAll('.bubble');
            bubbles.forEach((bubble, index) => {
                // Set custom size if different from default
                if (bubblesSize !== 30) {
                    const customSize = Math.random() * (bubblesSize * 0.8) + (bubblesSize * 0.2);
                    bubble.style.width = customSize + 'px';
                    bubble.style.height = customSize + 'px';
                }

                // Set custom animation duration
                bubble.style.animationDuration = bubblesSpeed + 's';

                // Set custom opacity
                bubble.style.opacity = bubblesOpacity;

                // Randomize positions for more natural movement
                const randomLeft = Math.random() * 100;
                const randomDelay = Math.random() * bubblesSpeed;
                bubble.style.left = randomLeft + '%';
                bubble.style.animationDelay = randomDelay + 's';
            });

            // Add hover effect to make bubbles more interactive
            bubblesContainer.addEventListener('mouseenter', function() {
                bubbles.forEach(bubble => {
                    bubble.style.animationPlayState = 'paused';
                });
            });

            bubblesContainer.addEventListener('mouseleave', function() {
                bubbles.forEach(bubble => {
                    bubble.style.animationPlayState = 'running';
                });
            });
        })();
        </script>
        <?php endif; ?>
        <?php
    }

    protected function _content_template() {
        ?>
        <div class="skill_my_avatar">
            <# if (settings.show_bubbles === 'yes') { #>
                <div class="bubbles-container">
                    <# for (var i = 0; i < (settings.bubbles_count.size || 8); i++) { #>
                        <div class="bubble bubble-{{ i }}"></div>
                    <# } #>
                </div>
            <# } #>
            
            <img src="{{ settings.avatar_image.url }}">
            <# if (settings.show_online_status === 'yes') { #>
                <div class="online-status-indicator"></div>
                <div class="online-status-text">{{ settings.online_status_text }}</div>
            <# } #>
        </div>
        <?php
    }
}