<?php
if (!defined('ABSPATH')) exit;

class skill_my_personal_new_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'my_personal_modern_widget';
    }

    public function get_title() {
        return __('اطلاعات شخصی جدید', 'skill');
    }

    public function get_icon() {
        return 'eicon-person';
    }

    public function get_categories() {
        return ['skill-category'];
    }

    protected function _register_controls() {
        // content
        $this->start_controls_section('content_section', [
                'label' => __('محتوا', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]);
        $this->add_control('greeting_text', [
                'label' => __('متن سلام', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('سلام، من .', 'skill'),
        ]);
        $this->add_control('first_name', [
                'label' => __('نام', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('محمد', 'skill'),
        ]);
        $this->add_control('last_name', [
                'label' => __('نام خانوادگی', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('حیدری', 'skill'),
        ]);
        $this->add_control('working_since_title', [
                'label' => __('عنوان زمان شروع کار', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('زمان شروع به کار از', 'skill'),
        ]);
        $this->add_control('working_since_year', [
                'label' => __('سال شروع کار', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('1399', 'skill'),
        ]);
        $this->add_control('intro_title', [
                'label' => __('عنوان مقدمه', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('مقدمه', 'skill'),
        ]);
        $this->add_control('intro_text', [
                'label' => __('متن مقدمه', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
            'default' => __('من خلاقیت و قادریتم را با هر کسی که می‌خواهد طرح جای هر شکنده‌ای بکند، به اشتراک می‌گذارم. در مسیرم بر شناری کنش‌گذاری غذای گیاهی به‌ویژه برای مشتریان علاقه‌مند و جویای یک سبک زندگی، من اینجا هستم تا رویای شما را به واقعیت تبدیل کنم.', 'skill'),
        ]);
        $this->add_control('avatar_image', [
                'label' => __('تصویر آواتار', 'skill'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
        ]);
        $this->end_controls_section();

        // Main container style
        $this->start_controls_section('container_style', [
            'label' => __('استایل کانتینر', 'skill'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]);
        $this->add_responsive_control('container_padding', [
            'label' => __('فاصله داخلی', 'skill'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em', '%'],
            'selectors' => [
                '{{WRAPPER}} .skill_my-info-personal' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            'default' => [
                'top' => '40',
                'right' => '30',
                'bottom' => '40',
                'left' => '30',
                'unit' => 'px',
            ],
        ]);
        $this->add_responsive_control('container_gap', [
            'label' => __('فاصله بین المان‌ها', 'skill'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px', 'em'],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 100,
                    'step' => 1,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .skill_my-info-personal' => 'gap: {{SIZE}}{{UNIT}};',
            ],
            'default' => [
                'unit' => 'px',
                'size' => 40,
            ],
        ]);
        $this->add_control('container_border_radius', [
            'label' => __('گردی گوشه‌ها', 'skill'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors' => [
                '{{WRAPPER}} .skill_my-info-personal' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            'default' => [
                'top' => '20',
                'right' => '20',
                'bottom' => '20',
                'left' => '20',
                'unit' => 'px',
            ],
        ]);
        $this->add_group_control(\Elementor\Group_Control_Background::get_type(), [
            'name' => 'container_background',
            'label' => __('پس‌زمینه', 'skill'),
            'types' => ['classic', 'gradient'],
            'selector' => '{{WRAPPER}} .skill_my-info-personal',
        ]);
        $this->end_controls_section();

        // Avatar image style
        $this->start_controls_section('avatar_style', [
            'label' => __('استایل تصویر آواتار', 'skill'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]);
        $this->add_responsive_control('avatar_width', [
            'label' => __('عرض تصویر', 'skill'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px', '%'],
            'range' => [
                'px' => [
                    'min' => 100,
                    'max' => 500,
                    'step' => 1,
                ],
                '%' => [
                    'min' => 10,
                    'max' => 100,
                    'step' => 1,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .skill_my-image-avatar img' => 'width: {{SIZE}}{{UNIT}};',
            ],
            'default' => [
                'unit' => 'px',
                'size' => 320,
            ],
        ]);
        $this->add_control('avatar_border_radius', [
            'label' => __('گردی گوشه‌ها', 'skill'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors' => [
                '{{WRAPPER}} .skill_my-image-avatar img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            'default' => [
                'top' => '20',
                'right' => '20',
                'bottom' => '20',
                'left' => '20',
                'unit' => 'px',
            ],
        ]);
        $this->add_group_control(\Elementor\Group_Control_Background::get_type(), [
            'name' => 'avatar_background',
            'label' => __('پس‌زمینه تصویر', 'skill'),
            'types' => ['classic', 'gradient'],
            'selector' => '{{WRAPPER}} .skill_my-image-avatar img',
        ]);
        $this->end_controls_section();

        // Name style
        $this->start_controls_section('name_style', [
            'label' => __('استایل نام', 'skill'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]);
        $this->add_control('greeting_color', [
            'label' => __('رنگ متن سلام', 'skill'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .skill_my-name h2:first-child' => 'color: {{VALUE}};',
            ],
            'default' => '#bdbdbd',
        ]);
        $this->add_group_control(\Elementor\Group_Control_Typography::get_type(), [
            'name' => 'greeting_typography',
            'label' => __('تایپوگرافی متن سلام', 'skill'),
            'selector' => '{{WRAPPER}} .skill_my-name h2:first-child',
        ]);
        $this->add_responsive_control('greeting_margin', [
            'label' => __('فاصله متن سلام', 'skill'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em'],
            'selectors' => [
                '{{WRAPPER}} .skill_my-name h2:first-child' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            'default' => [
                'bottom' => '30',
                'unit' => 'px',
            ],
        ]);
        $this->add_control('name_color', [
            'label' => __('رنگ نام', 'skill'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .skill_my-name h2:not(:first-child)' => 'color: {{VALUE}};',
            ],
            'default' => '#fff',
        ]);
        $this->add_group_control(\Elementor\Group_Control_Typography::get_type(), [
            'name' => 'name_typography',
            'label' => __('تایپوگرافی نام', 'skill'),
            'selector' => '{{WRAPPER}} .skill_my-name h2:not(:first-child)',
        ]);
        $this->add_responsive_control('name_margin', [
            'label' => __('فاصله نام', 'skill'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em'],
            'selectors' => [
                '{{WRAPPER}} .skill_my-name h2:not(:first-child)' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            'default' => [
                'bottom' => '10',
                'unit' => 'px',
            ],
        ]);
        $this->end_controls_section();

        // Workspace style
        $this->start_controls_section('working_style', [
            'label' => __('استایل بخش کار', 'skill'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]);
        $this->add_responsive_control('working_margin', [
            'label' => __('فاصله بخش کار', 'skill'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em'],
            'selectors' => [
                '{{WRAPPER}} .skill_working-since' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            'default' => [
                'top' => '30',
                'bottom' => '10',
                'unit' => 'px',
            ],
        ]);
        $this->add_responsive_control('working_padding', [
            'label' => __('فاصله داخلی بخش کار', 'skill'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em'],
            'selectors' => [
                '{{WRAPPER}} .skill_working-since' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            'default' => [
                'top' => '10',
                'bottom' => '10',
                'unit' => 'px',
            ],
        ]);
        $this->add_control('working_border_color', [
            'label' => __('رنگ خطوط', 'skill'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .skill_working-since' => 'border-top-color: {{VALUE}}; border-bottom-color: {{VALUE}};',
            ],
            'default' => '#444',
        ]);
        $this->add_control('working_title_color', [
            'label' => __('رنگ عنوان کار', 'skill'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .skill_working-since h2' => 'color: {{VALUE}};',
            ],
            'default' => '#bdbdbd',
        ]);
        $this->add_group_control(\Elementor\Group_Control_Typography::get_type(), [
            'name' => 'working_title_typography',
            'label' => __('تایپوگرافی عنوان کار', 'skill'),
            'selector' => '{{WRAPPER}} .skill_working-since h2',
        ]);
        $this->add_control('working_year_color', [
            'label' => __('رنگ سال کار', 'skill'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .skill_working-since h3' => 'color: {{VALUE}};',
            ],
            'default' => '#fff',
        ]);
        $this->add_group_control(\Elementor\Group_Control_Typography::get_type(), [
            'name' => 'working_year_typography',
            'label' => __('تایپوگرافی سال کار', 'skill'),
            'selector' => '{{WRAPPER}} .skill_working-since h3',
        ]);
        $this->add_responsive_control('working_year_width', [
            'label' => __('عرض سال کار', 'skill'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['%'],
            'range' => [
                '%' => [
                    'min' => 10,
                    'max' => 100,
                    'step' => 1,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .skill_working-since h3' => 'width: {{SIZE}}{{UNIT}};',
            ],
            'default' => [
                'unit' => '%',
                'size' => 60,
            ],
        ]);
        $this->end_controls_section();

        // Introduction style
        $this->start_controls_section('intro_style', [
            'label' => __('استایل مقدمه', 'skill'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]);
        $this->add_control('intro_title_color', [
            'label' => __('رنگ عنوان مقدمه', 'skill'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .skill_intro h2' => 'color: {{VALUE}};',
            ],
            'default' => '#bdbdbd',
        ]);
        $this->add_group_control(\Elementor\Group_Control_Typography::get_type(), [
            'name' => 'intro_title_typography',
            'label' => __('تایپوگرافی عنوان مقدمه', 'skill'),
            'selector' => '{{WRAPPER}} .skill_intro h2',
        ]);
        $this->add_responsive_control('intro_title_margin', [
            'label' => __('فاصله عنوان مقدمه', 'skill'),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em'],
            'selectors' => [
                '{{WRAPPER}} .skill_intro h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            'default' => [
                'bottom' => '8',
                'unit' => 'px',
            ],
        ]);
        $this->add_control('intro_text_color', [
            'label' => __('رنگ متن مقدمه', 'skill'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .skill_intro p' => 'color: {{VALUE}};',
            ],
            'default' => '#fff',
        ]);
        $this->add_group_control(\Elementor\Group_Control_Typography::get_type(), [
            'name' => 'intro_text_typography',
            'label' => __('تایپوگرافی متن مقدمه', 'skill'),
            'selector' => '{{WRAPPER}} .skill_intro p',
        ]);
        $this->add_responsive_control('intro_text_width', [
            'label' => __('عرض متن مقدمه', 'skill'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['%'],
            'range' => [
                '%' => [
                    'min' => 10,
                    'max' => 100,
                    'step' => 1,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}} .skill_intro p' => 'width: {{SIZE}}{{UNIT}};',
            ],
            'default' => [
                'unit' => '%',
                'size' => 60,
            ],
        ]);
        $this->end_controls_section();

        // Responsive style
        $this->start_controls_section('responsive_style', [
            'label' => __('استایل ریسپانسیو', 'skill'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]);
        $this->add_control('mobile_breakpoint', [
            'label' => __('نقطه شکست موبایل', 'skill'),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'default' => 900,
            'min' => 320,
            'max' => 1200,
            'step' => 1,
        ]);
        $this->add_control('mobile_small_breakpoint', [
            'label' => __('نقطه شکست موبایل کوچک', 'skill'),
            'type' => \Elementor\Controls_Manager::NUMBER,
            'default' => 425,
            'min' => 320,
            'max' => 768,
            'step' => 1,
        ]);
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $mobile_breakpoint = $settings['mobile_breakpoint'] ?? 900;
        $mobile_small_breakpoint = $settings['mobile_small_breakpoint'] ?? 425;
        ?>
        <div class="skill_my-info-personal">
            <div class="skill_my-image-avatar">
                <img src="<?php echo esc_url($settings['avatar_image']['url']); ?>"
                     alt="<?php echo esc_attr($settings['first_name'] . ' ' . $settings['last_name']); ?>">
            </div>
            <div class="skill_my-resume">
                <div class="skill_my-name">
                    <?php if (!empty($settings['greeting_text'])): ?>
                        <h2><?php echo esc_html($settings['greeting_text']); ?></h2>
                    <?php endif; ?>
                    <?php if (!empty($settings['first_name']) || !empty($settings['last_name'])): ?>
                        <h2 class="full-name">
                            <?php if (!empty($settings['first_name'])): ?>
                                <span class="first-name"><?php echo esc_html($settings['first_name']); ?></span>
                            <?php endif; ?>
                            <?php if (!empty($settings['last_name'])): ?>
                                <span class="last-name"><?php echo esc_html($settings['last_name']); ?></span>
                            <?php endif; ?>
                        </h2>
                    <?php endif; ?>
                </div>
                    <div class="skill_working-since">
                            <h2><?php echo esc_html($settings['working_since_title']); ?></h2>
                            <h3><?php echo esc_html($settings['working_since_year']); ?></h3>
                    </div>
                    <div class="skill_intro">
                            <h2><?php echo esc_html($settings['intro_title']); ?></h2>
                            <p><?php echo esc_html($settings['intro_text']); ?></p>
                    </div>
            </div>
        </div>
        <style>
        .skill_my-info-personal {
            display: flex;
            align-items: flex-start;
            flex-direction: row-reverse;
            color: #fff;
        }
        .skill_my-image-avatar img {
            height: auto;
            object-fit: cover;
        }
        .skill_my-resume {
            flex: 1;
            display: flex;
            flex-direction: column;
            justify-content: flex-start;
        }
        .skill_my-name h2 {
            margin: 0;
        }
        .skill_my-name .full-name {
            display: flex;
            align-items: center;
            gap: 10px;
        }
        .skill_my-name .full-name .first-name,
        .skill_my-name .full-name .last-name {
            display: inline-block;
        }
        .skill_working-since {
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-top: 1px solid;
            border-bottom: 1px solid;
        }
        .skill_working-since h2, .skill_working-since h3 {
            margin: 0;
        }
        .skill_intro {
            display: flex;
            justify-content: space-between;
        }
        .skill_intro h2 {
            margin: 0;
        }
        .skill_intro p {
            margin: 0;
            line-height: 2;
        }
        @media (max-width: <?php echo $mobile_breakpoint; ?>px) {
            .skill_my-info-personal {
                flex-direction: column-reverse;
                align-items: center;
            }
            .skill_my-image-avatar img {
                width: 100%;
                height: 100%;
            }
            .skill_my-resume {
                width: 100%;
            }
        }

        @media (max-width: <?php echo $mobile_small_breakpoint; ?>px) {
            .skill_working-since {
                flex-direction: column;
                align-items: flex-start;
            }
            .skill_working-since h2 {
                margin-bottom: 20px;
            }
            .skill_working-since h3 {
                width: 100%;
            }
            .skill_intro {
                flex-direction: column;
            }
            .skill_intro p {
                width: 100% !important;
            }
            .skill_intro h2 {
                margin-bottom: 20px;
            }
        }
        </style>
        <?php
    }
}