<?php


class skill_info_personal_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'personal_info_widget';
    }

    public function get_title() {
        return __('اطلاعات شخصی من', 'skill');
    }

    public function get_icon() {
        return 'eicon-person';
    }

    public function get_categories() {
        return ['skill-category'];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'personal_info_section',
            [
                'label' => __('اطلاعات شخصی', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'birth_date',
            [
                'label' => __('تاریخ تولد', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '1380/10/06',
            ]
        );

        $this->add_control(
            'location',
            [
                'label' => __('محل سکونت', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'شهرکرد',
            ]
        );

        $this->add_control(
            'cooperation',
            [
                'label' => __('نحوه همکاری', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'تمام وقت / دورکاری',
            ]
        );

        $this->add_control(
            'expertise',
            [
                'label' => __('تخصص', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'توسعه دهنده',
            ]
        );

        $this->add_control(
            'phone',
            [
                'label' => __('شماره تماس', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '09387075415',
            ]
        );

        $this->add_control(
            'email',
            [
                'label' => __('ایمیل', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 'mohamad5415.m8@gmail.com',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style_section',
            [
                'label' => __('استایل', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('رنگ عنوان', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .skill-personal-info-box' => '--skill-title-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'value_color',
            [
                'label' => __('رنگ مقدار', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .skill-personal-info-box' => '--skill-value-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        // Inline CSS for styling and animation (with CSS variables for dynamic colors)
        echo '<style>
        .skill-personal-info-box {
            background: #fff;
            border-radius: 18px;
            box-shadow: 0 4px 24px 0 rgba(60,72,88,.08);
            padding: 2.5rem 2rem;
            max-width: 100%;
            margin: 0 auto;
            border: 1px solid #f0f0f0;
            animation: fadeInUp 0.8s cubic-bezier(.39,.575,.565,1) both;
            --skill-title-color: #222;
            --skill-value-color: #555;
        }
        @keyframes fadeInUp {
            0% { opacity: 0; transform: translateY(40px); }
            100% { opacity: 1; transform: none; }
        }
        .skill-personal-info-list {
            display: flex;
            flex-direction: column;
            gap: 9px;
        }
        .skill-personal-info-row {
            display: flex;
            flex-direction: row;
            gap: 1.2rem;
        }
        .skill-personal-info-item {
            flex: 1 1 0;
            display: flex;
            align-items: center;
            gap: 0.7rem;
            background: #f7f9fa;
            border-radius: 10px;
            padding: 0.7rem 1rem;
            transition: box-shadow 0.2s;
            box-shadow: 0 1px 4px 0 rgba(60,72,88,.04);
            position: relative;
            min-width: 0;
            flex-wrap: nowrap; /* مهم: wrap را بردار */
        }
        .skill-personal-info-item:hover {
            box-shadow: 0 4px 16px 0 rgba(60,72,88,.10);
        }
        .skill-personal-info-icon {
            width: 22px;
            height: 22px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #3b82f6;
        }
        .skill-personal-info-label {
            font-weight: 700;
            color: var(--skill-title-color, #222);
            font-size: 1rem;
            margin-left: 0.3rem;
            white-space: nowrap;
            flex-shrink: 0;
        }
        .skill-personal-info-value-wrap {
            display: flex;
            align-items: center;
            min-width: 0;
            flex: 1 1 0;
            gap: 0.5rem;
        }
        .skill-personal-info-value {
            color: var(--skill-value-color, #555);
            font-size: 1rem;
            font-weight: 400;
            word-break: break-all;
            overflow-wrap: anywhere;
            min-width: 0;
            flex: 1 1 0;
            display: block;
        }
        .skill-personal-info-copy {
            background: #e0e7ef;
            border: none;
            border-radius: 6px;
            padding: 0.2rem 0.5rem;
            cursor: pointer;
            font-size: 0.95rem;
            color: #3b82f6;
            transition: background 0.2s;
            white-space: nowrap;
            flex-shrink: 0;
            margin-left: 0.5rem;
        }
        .skill-personal-info-copy:hover {
            background: #c7d7ef;
        }
        .skill-personal-info-copied {
            position: absolute;
            left: 10px;
            top: 50%;
            transform: translateY(-50%);
            background: #d1fae5;
            color: #059669;
            font-size: 0.85rem;
            padding: 0.1rem 0.6rem;
            border-radius: 5px;
            opacity: 0;
            pointer-events: none;
            transition: opacity 0.3s;
        }
        .skill-personal-info-item.copied .skill-personal-info-copied {
            opacity: 1;
        }
        @media (max-width: 768px) {
            .skill-personal-info-row {
                flex-direction: column;
                gap: 1.2rem;
            }
            .skill-personal-info-item {
                flex-direction: column;
                align-items: flex-start;
                gap: 0.4rem;
                padding: 1rem 0.7rem;
            }
            .skill-personal-info-label,
            .skill-personal-info-value,
            .skill-personal-info-copy {
                margin: 0;
            }
            .skill-personal-info-value {
                word-break: break-all;
                overflow-wrap: anywhere;
                font-size: 0.98rem;
            }
            .skill-personal-info-copy {
                align-self: flex-end;
                margin-top: 0.3rem;
            }
        }
        </style>';

        // Inline JS for copy buttons
        echo '<script>
        document.addEventListener("DOMContentLoaded", function() {
            document.querySelectorAll(".skill-personal-info-copy").forEach(function(btn) {
                btn.addEventListener("click", function(e) {
                    var value = btn.getAttribute("data-copy");
                    navigator.clipboard.writeText(value).then(function() {
                        var parent = btn.closest(".skill-personal-info-item");
                        parent.classList.add("copied");
                        setTimeout(function() { parent.classList.remove("copied"); }, 1200);
                    });
                });
            });
        });
        </script>';

        // SVG icons for each info type
        $icons = [
            'birth_date' => '<svg class="skill-personal-info-icon" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24"><rect x="3" y="7" width="18" height="14" rx="2"/><path d="M16 3v4M8 3v4M3 11h18"/></svg>',
            'location' => '<svg class="skill-personal-info-icon" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24"><path d="M12 21s-6-5.686-6-10A6 6 0 1 1 18 11c0 4.314-6 10-6 10z"/><circle cx="12" cy="11" r="2.5"/></svg>',
            'cooperation' => '<svg class="skill-personal-info-icon" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24"><rect x="2" y="7" width="20" height="13" rx="2"/><path d="M16 3v4M8 3v4"/></svg>',
            'expertise' => '<svg class="skill-personal-info-icon" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24"><path d="M12 17v-6m0 0V7m0 4h4m-4 0H8"/><circle cx="12" cy="12" r="10"/></svg>',
            'phone' => '<svg class="skill-personal-info-icon" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24"><path d="M2 5.5A2.5 2.5 0 0 1 4.5 3h2A2.5 2.5 0 0 1 9 5.5v2A2.5 2.5 0 0 1 6.5 10h-2A2.5 2.5 0 0 1 2 7.5v-2zM15 19.5A2.5 2.5 0 0 1 17.5 17h2a2.5 2.5 0 0 1 2.5 2.5v2A2.5 2.5 0 0 1 19.5 24h-2A2.5 2.5 0 0 1 15 21.5v-2z"/><path d="M6.5 10a9 9 0 0 0 9 9"/></svg>',
            'email' => '<svg class="skill-personal-info-icon" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24"><rect x="3" y="5" width="18" height="14" rx="2"/><path d="M3 7l9 6 9-6"/></svg>',
        ];

        echo '<div class="skill-personal-info-box">';
        echo '<div class="skill-personal-info-list">';

        // Arrange info items in pairs (2 per row)
        echo '<div class="skill-personal-info-row">';
        $this->render_info_item_adv(__('تاریخ تولد:', 'skill'), $settings['birth_date'], $icons['birth_date']);
        $this->render_info_item_adv(__('محل سکونت:', 'skill'), $settings['location'], $icons['location']);
        echo '</div>';
        echo '<div class="skill-personal-info-row">';
        $this->render_info_item_adv(__('نحوه همکاری:', 'skill'), $settings['cooperation'], $icons['cooperation']);
        $this->render_info_item_adv(__('تخصص:', 'skill'), $settings['expertise'], $icons['expertise']);
        echo '</div>';
        echo '<div class="skill-personal-info-row">';
        $this->render_info_item_adv(__('شماره تماس:', 'skill'), $settings['phone'], $icons['phone'], true);
        $this->render_info_item_adv(__('ایمیل:', 'skill'), $settings['email'], $icons['email'], true);
        echo '</div>';

        echo '</div>';
        echo '</div>';
    }

    // Advanced info item with icon and copy button
    protected function render_info_item_adv($title, $value, $icon_svg, $copyable = false) {
        $copy_btn = $copyable ? '<button class="skill-personal-info-copy" data-copy="' . esc_attr($value) . '">' . __('کپی', 'skill') . '</button>' : '';
        $copied_msg = $copyable ? '<span class="skill-personal-info-copied">' . __('کپی شد!', 'skill') . '</span>' : '';
        echo '<div class="skill-personal-info-item">';
        echo $icon_svg;
        echo '<span class="skill-personal-info-label">' . $title . '</span>';
        echo '<div class="skill-personal-info-value-wrap">';
        echo '<span class="skill-personal-info-value">' . $value . '</span>';
        echo $copy_btn;
        echo '</div>';
        echo $copied_msg;
        echo '</div>';
    }
}