<?php

class skill_progress_widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'skill_progress_widget';
    }

    public function get_title() {
        return __('مهارت‌ های من', 'skill');
    }

    public function get_icon() {
        return 'eicon-skill-bar';
    }

    public function get_categories() {
        return ['skill-category'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'skills_section',
            [
                'label' => __('مهارت‌ها', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'skills_title',
            [
                'label' => __('عنوان بخش مهارت‌ها', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('مهارت های من', 'skill'),
            ]
        );

        $this->add_control(
            'show_percentage',
            [
                'label' => __('نمایش درصد', 'skill'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('بله', 'skill'),
                'label_off' => __('خیر', 'skill'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'skill_name',
            [
                'label' => __('نام مهارت', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('توسعه وردپرس', 'skill'),
            ]
        );

        $repeater->add_control(
            'skill_value',
            [
                'label' => __('درصد مهارت', 'skill'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 1,
                'default' => 100,
            ]
        );

        $this->add_control(
            'skills_list',
            [
                'label' => __('لیست مهارت‌ها', 'skill'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'skill_name' => __('توسعه وردپرس', 'skill'),
                        'skill_value' => 100,
                    ],
                    [
                        'skill_name' => __('Java', 'skill'),
                        'skill_value' => 70,
                    ],
                ],
                'title_field' => '{{{ skill_name }}}',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'languages_section',
            [
                'label' => __('زبان‌ها', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'languages_title',
            [
                'label' => __('عنوان بخش زبان‌ها', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('زبان های خارجی', 'skill'),
            ]
        );

        $language_repeater = new \Elementor\Repeater();

        $language_repeater->add_control(
            'language_name',
            [
                'label' => __('نام زبان', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('انگلیسی', 'skill'),
            ]
        );

        $language_repeater->add_control(
            'language_value',
            [
                'label' => __('درصد تسلط', 'skill'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 100,
                'step' => 1,
                'default' => 70,
            ]
        );

        $this->add_control(
            'languages_list',
            [
                'label' => __('لیست زبان‌ها', 'skill'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $language_repeater->get_controls(),
                'default' => [
                    [
                        'language_name' => __('انگلیسی', 'skill'),
                        'language_value' => 70,
                    ],
                    [
                        'language_name' => __('آلمانی', 'skill'),
                        'language_value' => 40,
                    ],
                ],
                'title_field' => '{{{ language_name }}}',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'style_section',
            [
                'label' => __('استایل‌ها', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('رنگ عنوان', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .services span' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .services span',
            ]
        );

        $this->add_control(
            'skill_label_color',
            [
                'label' => __('رنگ برچسب مهارت', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .skill_items label' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'label_typography',
                'selector' => '{{WRAPPER}} .skill_items label',
            ]
        );

        $this->add_control(
            'percentage_color',
            [
                'label' => __('رنگ درصد', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .percentage' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'show_percentage' => 'yes',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'percentage_typography',
                'selector' => '{{WRAPPER}} .percentage',
                'condition' => [
                    'show_percentage' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $show_percentage = $settings['show_percentage'];
        ?>
        <div class="skilles mt-5 d-flex">
            <div class="skill mt-3">
                <div class="services mb-5">
                    <span><i class="fa-solid fa-palette"></i> <?php echo esc_html($settings['skills_title']); ?></span>
                </div>
                <div class="skill_progress_bar d-flex flex-wrap">
                    <?php foreach ($settings['skills_list'] as $skill): ?>
                        <div class="skill_items d-flex align-items-center mb-3">
                            <label class="me-2 file"><?php echo esc_html($skill['skill_name']); ?></label>
                            <progress class="file" value="<?php echo esc_attr($skill['skill_value']); ?>" max="100">
                                <?php echo esc_html($skill['skill_value']); ?>%
                            </progress>
                            <?php if ('yes' === $show_percentage): ?>
                                <span class="percentage ms-2"><?php echo esc_html($skill['skill_value']); ?>%</span>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="skill_language mt-3">
                <div class="services mb-5">
                    <span><i class="fa-solid fa-language"></i> <?php echo esc_html($settings['languages_title']); ?></span>
                </div>
                <div class="language d-flex flex-wrap">
                    <?php foreach ($settings['languages_list'] as $language): ?>
                        <div class="skill_items d-flex align-items-center mb-3">
                            <label class="me-2 file"><?php echo esc_html($language['language_name']); ?></label>
                            <progress class="file" value="<?php echo esc_attr($language['language_value']); ?>" max="100">
                                <?php echo esc_html($language['language_value']); ?>%
                            </progress>
                            <?php if ('yes' === $show_percentage): ?>
                                <span class="percentage ms-2"><?php echo esc_html($language['language_value']); ?>%</span>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <?php
    }
}

function register_skill_progress_widget($widgets_manager) {
    $widgets_manager->register(new \skill_progress_widget());
}
add_action('elementor/widgets/register', 'register_skill_progress_widget');

function enqueue_font_awesome() {
    wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css', [], '6.0.0');
}
add_action('wp_enqueue_scripts', 'enqueue_font_awesome');