<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class skill_project_team_Widget extends \Elementor\Widget_Base {
    public function get_name() {
        return 'skill_project_team_Widget';
    }
    public function get_title() {
        return esc_html__('اعضای تیم پروژه', 'skill');
    }
    public function get_icon() {
        return 'eicon-person';
    }
    public function get_categories() {
        return ['skill-category'];
    }
    
    protected function register_controls() {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات تیم', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'section_title',
            [
                'label' => esc_html__('عنوان بخش', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('اعضای تیم پروژه', 'skill'),
                'placeholder' => esc_html__('عنوان بخش را وارد کنید', 'skill'),
            ]
        );

        $this->add_control(
            'columns',
            [
                'label' => esc_html__('تعداد ستون‌ها', 'skill'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '5',
                'options' => [
                    '3' => esc_html__('3 ستون', 'skill'),
                    '4' => esc_html__('4 ستون', 'skill'),
                    '5' => esc_html__('5 ستون', 'skill'),
                ],
            ]
        );

        $this->add_control(
            'show_social_media',
            [
                'label' => esc_html__('نمایش شبکه‌های اجتماعی', 'skill'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('نمایش', 'skill'),
                'label_off' => esc_html__('مخفی', 'skill'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('استایل', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .team-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .team-title',
            ]
        );

        $this->add_control(
            'member_name_color',
            [
                'label' => esc_html__('رنگ نام عضو', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#000000',
                'selectors' => [
                    '{{WRAPPER}} .member-name' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'member_role_color',
            [
                'label' => esc_html__('رنگ تخصص', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#666666',
                'selectors' => [
                    '{{WRAPPER}} .member-role' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'card_background_color',
            [
                'label' => esc_html__('رنگ پس‌زمینه کارت', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .team-member-card' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'social_hover_color',
            [
                'label' => esc_html__('رنگ هاور شبکه‌های اجتماعی', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#007cba',
                'selectors' => [
                    '{{WRAPPER}} .social-links a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        
        $post_id = get_the_ID();
        $team_members = get_post_meta($post_id, '_project_team', true);
        
        if (!is_array($team_members) || empty($team_members)) {
            return;
        }

        $columns = $settings['columns'];
        $show_social_media = $settings['show_social_media'] === 'yes';
        ?>
        <div class="skill-project-team-widget">
            <div class="team-container">
                <?php if ($settings['section_title']): ?>
                    <h3 class="team-title"><?php echo esc_html($settings['section_title']); ?></h3>
                <?php endif; ?>
                
                <div class="team-members team-columns-<?php echo esc_attr($columns); ?>">
                    <?php foreach ($team_members as $member): ?>
                        <div class="team-member-card">
                            <div class="member-avatar">
                                <div class="avatar-placeholder">
                                    <i class="fas fa-user"></i>
                                </div>
                            </div>
                            <div class="member-info">
                                <h4 class="member-name"><?php echo esc_html($member['name']); ?></h4>
                                <p class="member-role"><?php echo esc_html($member['role']); ?></p>
                                
                                <?php if ($show_social_media): ?>
                                    <div class="social-links">
                                        <?php if (!empty($member['linkedin'])): ?>
                                            <a href="<?php echo esc_url($member['linkedin']); ?>" target="_blank" class="social-link linkedin" title="لینکدین">
                                                <i class="fab fa-linkedin"></i>
                                            </a>
                                        <?php endif; ?>
                                 <?php if (!empty($member['instagram'])): ?>
                                     <?php 
                                     $instagram_value = trim($member['instagram']);
                                     $instagram_url = preg_match('/^https?:\/\//i', $instagram_value) ? $instagram_value : ('https://instagram.com/' . ltrim($instagram_value, '@'));
                                     ?>
                                     <a href="<?php echo esc_url($instagram_url); ?>" target="_blank" class="social-link instagram" title="اینستاگرام">
                                         <i class="fab fa-instagram"></i>
                                     </a>
                                 <?php endif; ?>
                                 <?php if (!empty($member['telegram'])): ?>
                                     <?php 
                                     $telegram_value = trim($member['telegram']);
                                     $telegram_url = preg_match('/^https?:\/\//i', $telegram_value) ? $telegram_value : ('https://t.me/' . ltrim($telegram_value, '@'));
                                     ?>
                                     <a href="<?php echo esc_url($telegram_url); ?>" target="_blank" class="social-link telegram" title="تلگرام">
                                         <i class="fab fa-telegram-plane"></i>
                                     </a>
                                 <?php endif; ?>
                                        <?php if (!empty($member['email'])): ?>
                                            <a href="mailto:<?php echo esc_attr($member['email']); ?>" class="social-link email" title="ایمیل">
                                                <i class="fas fa-envelope"></i>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>

        <style>
        .skill-project-team-widget {
            margin: 2rem 0;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 3rem 2rem;
            border-radius: 20px;
            position: relative;
            overflow: hidden;
        }
        
        .skill-project-team-widget::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grid" width="10" height="10" patternUnits="userSpaceOnUse"><path d="M 10 0 L 0 0 0 10" fill="none" stroke="rgba(255,255,255,0.1)" stroke-width="0.5"/></pattern></defs><rect width="100" height="100" fill="url(%23grid)"/></svg>');
            opacity: 0.3;
        }
        
        .team-container {
            position: relative;
            z-index: 2;
        }
        
        .team-title {
            margin-bottom: 3rem;
            font-size: 2.5rem;
            font-weight: 700;
            color: #ffffff;
            text-align: center;
            text-shadow: 0 2px 4px rgba(0,0,0,0.3);
        }
        
        .team-members {
            display: grid;
            gap: 2rem;
            justify-items: center;
        }
        
        .team-columns-3 { grid-template-columns: repeat(3, 1fr); }
        .team-columns-4 { grid-template-columns: repeat(4, 1fr); }
        .team-columns-5 { grid-template-columns: repeat(5, 1fr); }
        
        .team-member-card {
            background: #ffffff;
            border-radius: 20px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
            overflow: hidden;
            width: 100%;
            max-width: 280px;
            position: relative;
        }
        
        .team-member-card:hover {
            transform: translateY(-10px) scale(1.05);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.3);
        }
        
        .member-avatar {
            position: relative;
            height: 200px;
            background: linear-gradient(45deg, #f0f0f0, #e0e0e0);
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
        }
        
        .avatar-placeholder {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, #667eea, #764ba2);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
        }
        
        .avatar-placeholder i {
            font-size: 2.5rem;
            color: #ffffff;
        }
        
        .member-info {
            padding: 1.5rem;
            text-align: center;
        }
        
        .member-name {
            font-size: 1.3rem;
            font-weight: 700;
            color: #333333;
            margin-bottom: 0.5rem;
            line-height: 1.2;
        }
        
        .member-role {
            font-size: 1rem;
            color: #666666;
            margin-bottom: 1.5rem;
            font-weight: 500;
            line-height: 1.4;
        }
        
        .social-links {
            display: flex;
            justify-content: center;
            gap: 0.8rem;
            flex-wrap: wrap;
        }
        
        .social-link {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: #f8f9fa;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #666666;
            text-decoration: none;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        
        .social-link::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
            transition: left 0.5s ease;
        }
        
        .social-link:hover::before {
            left: 100%;
        }
        
        .social-link:hover {
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
        }
        
        .social-link.linkedin:hover {
            background: #0077b5;
            color: #ffffff;
        }
        
        .social-link.instagram:hover {
            background: linear-gradient(45deg, #f09433, #e6683c, #dc2743, #cc2366, #bc1888);
            color: #ffffff;
        }
        
        .social-link.telegram:hover {
            background: #0088cc;
            color: #ffffff;
        }
        
        .social-link.whatsapp:hover {
            background: #25d366;
            color: #ffffff;
        }
        
        .social-link.email:hover {
            background: #ea4335;
            color: #ffffff;
        }
        
        .social-link i {
            font-size: 1.2rem;
            z-index: 1;
            position: relative;
        }
        
        @media (max-width: 1200px) {
            .team-columns-5 { grid-template-columns: repeat(4, 1fr); }
        }
        
        @media (max-width: 992px) {
            .team-columns-4,
            .team-columns-5 { grid-template-columns: repeat(3, 1fr); }
        }
        
        @media (max-width: 768px) {
            .team-columns-3,
            .team-columns-4,
            .team-columns-5 { grid-template-columns: repeat(2, 1fr); }
            
            .team-title {
                font-size: 2rem;
            }
            
            .skill-project-team-widget {
                padding: 2rem 1rem;
            }
        }
        
        @media (max-width: 480px) {
            .team-columns-2,
            .team-columns-3,
            .team-columns-4,
            .team-columns-5 { grid-template-columns: 1fr; }
            
            .team-title {
                font-size: 1.8rem;
            }
        }
        </style>
        <?php
    }
}
