<?php
class skill_tabs_project_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'skill_tabs_project_Widget';
    }

    public function get_title() {
        return esc_html__('نمونه کارهای من', 'skill');
    }

    public function get_icon() {
        return 'eicon-gallery-grid';
    }

    public function get_categories() {
        return ['skill-category'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('محتوا', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
            'filter_items',
            [
                'label' => esc_html__('آیتم‌های فیلتر', 'skill'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'filter_name',
                        'label' => esc_html__('نام فیلتر', 'skill'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__('همه', 'skill'),
                    ],
                    [
                        'name' => 'filter_default',
                        'label' => esc_html__('فیلتر پیش‌فرض', 'skill'),
                        'type' => \Elementor\Controls_Manager::SWITCHER,
                        'label_on' => esc_html__('بله', 'skill'),
                        'label_off' => esc_html__('خیر', 'skill'),
                        'return_value' => 'yes',
                        'default' => 'no',
                    ]
                ],
                'default' => [
                    [
                        'filter_name' => esc_html__('همه', 'skill'),
                        'filter_default' => 'yes'
                    ],
                    [
                        'filter_name' => esc_html__('فرانت', 'skill')
                    ],
                    [
                        'filter_name' => esc_html__('محصولات وردپرسی', 'skill')
                    ]
                ],
                'title_field' => '{{{ filter_name }}}',
            ]
        );


        $this->add_control(
            'gallery_items',
            [
                'label' => esc_html__('آیتم‌های گالری', 'skill'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'image',
                        'label' => esc_html__('تصویر', 'skill'),
                        'type' => \Elementor\Controls_Manager::MEDIA,
                        'default' => [
                            'url' => \Elementor\Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'name' => 'title',
                        'label' => esc_html__('عنوان', 'skill'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__('عنوان پروژه', 'skill'),
                    ],
                    [
                        'name' => 'link',
                        'label' => esc_html__('لینک', 'skill'),
                        'type' => \Elementor\Controls_Manager::URL,
                        'placeholder' => 'https://example.com',
                    ],
                    [
                        'name' => 'tags',
                        'label' => esc_html__('تگ‌ها (با کاما جدا کنید)', 'skill'),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__('فرانت', 'skill'),
                        'description' => esc_html__('تگ‌های مربوط به این آیتم را با کاما جدا کنید', 'skill'),
                    ]
                ],
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('استایل', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );


        $this->add_control(
            'filter_buttons_style',
            [
                'label' => esc_html__('دکمه‌های فیلتر', 'skill'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'filter_typography',
                'label' => esc_html__('تایپوگرافی', 'skill'),
                'selector' => '{{WRAPPER}} .buttons a',
            ]
        );

        $this->start_controls_tabs('filter_button_tabs');

        $this->start_controls_tab(
            'filter_button_normal',
            [
                'label' => esc_html__('عادی', 'skill'),
            ]
        );

        $this->add_control(
            'filter_button_color',
            [
                'label' => esc_html__('رنگ متن', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#464644',
                'selectors' => [
                    '{{WRAPPER}} .buttons a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'filter_button_border_color',
            [
                'label' => esc_html__('رنگ حاشیه', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ddd',
                'selectors' => [
                    '{{WRAPPER}} .buttons a' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'filter_button_hover',
            [
                'label' => esc_html__('هاور', 'skill'),
            ]
        );

        $this->add_control(
            'filter_button_hover_color',
            [
                'label' => esc_html__('رنگ متن', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .buttons a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'filter_button_hover_border_color',
            [
                'label' => esc_html__('رنگ حاشیه', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#0e59f2',
                'selectors' => [
                    '{{WRAPPER}} .buttons a:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'filter_button_active',
            [
                'label' => esc_html__('فعال', 'skill'),
            ]
        );

        $this->add_control(
            'filter_button_active_color',
            [
                'label' => esc_html__('رنگ متن', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .buttons a.active' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'filter_button_active_border_color',
            [
                'label' => esc_html__('رنگ حاشیه', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#0e59f2',
                'selectors' => [
                    '{{WRAPPER}} .buttons a.active' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_control(
            'filter_button_padding',
            [
                'label' => esc_html__('پدینگ', 'skill'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .buttons a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => '0.5',
                    'right' => '1',
                    'bottom' => '0.5',
                    'left' => '1',
                    'unit' => 'em',
                    'isLinked' => false,
                ],
            ]
        );

        $this->add_control(
            'filter_button_border_radius',
            [
                'label' => esc_html__('گردی گوشه‌ها', 'skill'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .buttons a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => '40',
                    'right' => '40',
                    'bottom' => '40',
                    'left' => '40',
                    'unit' => 'px',
                    'isLinked' => true,
                ],
            ]
        );


        $this->add_control(
            'gallery_style',
            [
                'label' => esc_html__('گالری', 'skill'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'gallery_gap',
            [
                'label' => esc_html__('فاصله بین آیتم‌ها', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 2,
                ],
                'selectors' => [
                    '{{WRAPPER}} .gallery' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'image_width',
            [
                'label' => esc_html__('عرض تصاویر', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['%'],
                'range' => [
                    '%' => [
                        'min' => 10,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 49,
                ],
                'selectors' => [
                    '{{WRAPPER}} .image' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        // Desktop image height
$this->add_control(
    'image_height_desktop',
    [
        'label' => esc_html__('ارتفاع تصاویر (دسکتاپ)', 'skill'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'vh'],
        'range' => [
            'px' => ['min' => 50, 'max' => 1000, 'step' => 1],
            '%'  => ['min' => 1, 'max' => 100],
            'vh' => ['min' => 1, 'max' => 100],
        ],
        'default' => ['unit' => 'px', 'size' => 179],
        'selectors' => [
            '{{WRAPPER}} .image, {{WRAPPER}} .gallery img' => 'height: {{SIZE}}{{UNIT}};',
        ],
    ]
);

// Tablet image height
$this->add_control(
    'image_height_tablet',
    [
        'label' => esc_html__('ارتفاع تصاویر (تبلت)', 'skill'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'vh'],
        'range' => [
            'px' => ['min' => 50, 'max' => 1000, 'step' => 1],
            '%'  => ['min' => 1, 'max' => 100],
            'vh' => ['min' => 1, 'max' => 100],
        ],
        'selectors' => [
            '(tablet){{WRAPPER}} .image, {{WRAPPER}} .gallery img' => 'height: {{SIZE}}{{UNIT}};',
        ],
    ]
);

// Mobile image height
$this->add_control(
    'image_height_mobile',
    [
        'label' => esc_html__('ارتفاع تصاویر (موبایل)', 'skill'),
        'type' => \Elementor\Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'vh'],
        'range' => [
            'px' => ['min' => 50, 'max' => 1000, 'step' => 1],
            '%'  => ['min' => 1, 'max' => 100],
            'vh' => ['min' => 1, 'max' => 100],
        ],
        'selectors' => [
            '(mobile){{WRAPPER}} .image, {{WRAPPER}} .gallery img' => 'height: {{SIZE}}{{UNIT}};',
        ],
    ]
);

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'image_border',
                'label' => esc_html__('حاشیه تصاویر', 'skill'),
                'selector' => '{{WRAPPER}} .image',
                'default' => [
                    'width' => 1,
                    'color' => '#ddd',
                ],
            ]
        );

        $this->add_control(
            'image_border_radius',
            [
                'label' => esc_html__('گردی گوشه‌های تصاویر', 'skill'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => '10',
                    'right' => '10',
                    'bottom' => '10',
                    'left' => '10',
                    'unit' => 'px',
                    'isLinked' => true,
                ],
            ]
        );


        $this->add_control(
            'hover_content_style',
            [
                'label' => esc_html__('محتوای هاور', 'skill'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'hover_content_bg',
            [
                'label' => esc_html__('پس‌زمینه', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'rgba(255, 255, 255, 0.82)',
                'selectors' => [
                    '{{WRAPPER}} .content_project' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'hover_content_title_color',
            [
                'label' => esc_html__('رنگ عنوان', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#464644',
                'selectors' => [
                    '{{WRAPPER}} .content_project span' => 'color: {{VALUE}}',
                ],
            ]
        );


        $this->add_control(
            'button_style',
            [
                'label' => esc_html__('دکمه', 'skill'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'button_bg_color',
            [
                'label' => esc_html__('رنگ پس‌زمینه', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#0e59f2',
                'selectors' => [
                    '{{WRAPPER}} .btn-select' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button_text_color',
            [
                'label' => esc_html__('رنگ متن', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .btn-select' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'label' => esc_html__('تایپوگرافی', 'skill'),
                'selector' => '{{WRAPPER}} .btn-select',
            ]
        );

        $this->add_control(
            'button_padding',
            [
                'label' => esc_html__('پدینگ', 'skill'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .btn-select' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => '15',
                    'right' => '15',
                    'bottom' => '15',
                    'left' => '15',
                    'unit' => 'px',
                    'isLinked' => true,
                ],
            ]
        );

        $this->add_control(
            'button_border_radius',
            [
                'label' => esc_html__('گردی گوشه‌ها', 'skill'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .btn-select' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => '7',
                    'right' => '7',
                    'bottom' => '7',
                    'left' => '7',
                    'unit' => 'px',
                    'isLinked' => true,
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="page text-center">
            <div class="buttons mb-5">
                <ul>
                    <?php foreach ($settings['filter_items'] as $filter): ?>
                        <li class="d-inline ms-2">
                            <a href="#" class="text-decoration-none <?php echo $filter['filter_default'] === 'yes' ? 'active' : ''; ?>">
                                <?php echo esc_html($filter['filter_name']); ?>
                            </a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
            <div class="gallery d-flex flex-wrap overflow-hidden">
                <?php foreach ($settings['gallery_items'] as $item): ?>
                    <div class="image position-relative overflow-hidden"
                         data-tags="<?php echo esc_attr($item['tags']); ?>">
                        <img src="<?php echo esc_url($item['image']['url']); ?>"
                             class="object-fit-cover w-100 overflow-hidden position-relative">
                        <div class="content_project position-absolute w-100 h-100 d-flex justify-content-center align-items-center flex-column">
                            <span><?php echo esc_html($item['title']); ?></span>
                            <div class="skill_btn_see_project d-flex align-items-center justify-content-center">
                                <a class="btn-select text-decoration-none text-light d-block"
                                   href="<?php echo esc_url($item['link']['url']); ?>"
                                    <?php echo $item['link']['is_external'] ? 'target="_blank"' : ''; ?>
                                    <?php echo $item['link']['nofollow'] ? 'rel="nofollow"' : ''; ?>>
                                    <?php echo esc_html__('مشاهده نمونه کار', 'skill'); ?>
                                </a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php
    }

    protected function _content_template() {
        ?>
        <div class="page text-center">
            <div class="buttons mb-3">
                <ul>
                    <# _.each(settings.filter_items, function(filter) { #>
                    <li class="d-inline ms-2">
                        <a href="#" class="text-decoration-none {{ filter.filter_default === 'yes' ? 'active' : '' }}">
                            {{{ filter.filter_name }}}
                        </a>
                    </li>
                    <# }); #>
                </ul>
            </div>
            <div class="gallery d-flex flex-wrap overflow-hidden">
                <# _.each(settings.gallery_items, function(item) { #>
                <div class="image position-relative overflow-hidden"
                     data-tags="{{ item.tags }}">
                    <img src="{{ item.image.url }}"
                         class="object-fit-cover w-100 overflow-hidden position-relative">
                    <div class="content_project position-absolute w-100 h-100 d-flex justify-content-center align-items-center flex-column">
                        <span>{{{ item.title }}}</span>
                        <div class="btn d-flex align-items-center justify-content-center">
                            <a class="btn-select text-decoration-none text-light d-block"
                               href="{{ item.link.url }}"
                            <# if (item.link.is_external) { #>target="_blank"<# } #>
                            <# if (item.link.nofollow) { #>rel="nofollow"<# } #>>
                            <?php echo esc_html__('مشاهده نمونه کار', 'skill'); ?>
                            </a>
                        </div>
                    </div>
                </div>
                <# }); #>
            </div>
        </div>
        <?php
    }
}