<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class skill_thumbnail_post_Widget extends \Elementor\Widget_Base {
    public function get_name() {
        return 'skill_thumbnail_post_Widget';
    }
    public function get_title() {
        return esc_html__('تصویر شاخص نوشته', 'skill');
    }
    public function get_icon() {
        return 'eicon-image';
    }
    public function get_categories() {
        return ['skill-category'];
    }
    protected function _register_controls() {}
    protected function render() {
        // Only show the current post's featured image
        if ( ! has_post_thumbnail() ) {
            return;
        }
        $image_url = get_the_post_thumbnail_url( null, 'large' );
        if ( ! $image_url ) {
            return;
        }
        ?>
        <div class="skill-thumbnail-post-widget">
            <img src="<?php echo esc_url($image_url); ?>" alt="<?php the_title_attribute(); ?>" />
        </div>
        <style>
        .skill-thumbnail-post-widget {
            position: relative;
            margin: 2rem 0;
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
        }
        
        .skill-thumbnail-post-widget:hover {
            transform: translateY(-5px);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
        }
        
        .skill-thumbnail-post-widget img {
            width: 100%;
            height: auto;
            display: block;
            border-radius: 20px;
            transition: all 0.3s ease;
        }
        
        .skill-thumbnail-post-widget:hover img {
            transform: scale(1.02);
        }
        
        /* Responsive styles */
        @media (max-width: 768px) {
            .skill-thumbnail-post-widget {
                margin: 1.5rem 0;
            }
        }
        </style>
        <?php
    }
}