<?php
if (!defined('ABSPATH')) exit;


class Skill_title_desc_Widget extends \Elementor\Widget_Base {
	public function get_name() { return 'skill_title_desc'; }
	public function get_title() { return __('عنوان + توضیح کوتاه', 'skill'); }
	public function get_icon() { return 'eicon-heading'; }
	public function get_categories() { return ['skill-category']; }

	protected function _register_controls() {
		// Content
		$this->start_controls_section('tdw_content', ['label' => __('محتوا', 'skill'), 'tab' => \Elementor\Controls_Manager::TAB_CONTENT]);
		$this->add_control('show_title', ['label' => __('نمایش عنوان', 'skill'), 'type' => \Elementor\Controls_Manager::SWITCHER, 'label_on' => __('بله', 'skill'), 'label_off' => __('خیر', 'skill'), 'return_value' => 'yes', 'default' => 'yes']);
		$this->add_control('title_text', ['label' => __('عنوان', 'skill'), 'type' => \Elementor\Controls_Manager::TEXT, 'default' => __('مقالات من', 'skill'), 'condition' => ['show_title' => 'yes']]);
		$this->add_control('show_dot', ['label' => __('نمایش مربع آبی', 'skill'), 'type' => \Elementor\Controls_Manager::SWITCHER, 'label_on' => __('بله', 'skill'), 'label_off' => __('خیر', 'skill'), 'return_value' => 'yes', 'default' => 'yes']);
		$this->add_control('dot_position', ['label' => __('جایگاه مربع', 'skill'), 'type' => \Elementor\Controls_Manager::SELECT, 'options' => ['right' => __('راست عنوان', 'skill'), 'left' => __('چپ عنوان', 'skill')], 'default' => 'right', 'condition' => ['show_dot' => 'yes']]);
		$this->add_control('show_desc', ['label' => __('نمایش توضیح کوتاه', 'skill'), 'type' => \Elementor\Controls_Manager::SWITCHER, 'label_on' => __('بله', 'skill'), 'label_off' => __('خیر', 'skill'), 'return_value' => 'yes', 'default' => 'yes']);
		$this->add_control('desc_text', ['label' => __('توضیح کوتاه', 'skill'), 'type' => \Elementor\Controls_Manager::TEXTAREA, 'default' => __('توسعه‌دهنده‌ای هستم که وردپرس را مانند کف دست می‌شناسم. مشکل را به من بگویید...', 'skill'), 'rows' => 2, 'condition' => ['show_desc' => 'yes']]);
		$this->end_controls_section();

		// Style
		$this->start_controls_section('tdw_style', ['label' => __('استایل', 'skill'), 'tab' => \Elementor\Controls_Manager::TAB_STYLE]);
		$this->add_responsive_control('align', ['label' => __('چینش', 'skill'), 'type' => \Elementor\Controls_Manager::CHOOSE, 'options' => [ 'right' => ['title' => __('راست', 'skill'), 'icon' => 'eicon-text-align-right'], 'center' => ['title' => __('وسط', 'skill'), 'icon' => 'eicon-text-align-center'], 'left' => ['title' => __('چپ', 'skill'), 'icon' => 'eicon-text-align-left'] ], 'default' => 'center', 'selectors' => [ '{{WRAPPER}} .tdw-wrap' => 'text-align: {{VALUE}};' ]]);
		$this->add_control('title_color', ['label' => __('رنگ عنوان', 'skill'), 'type' => \Elementor\Controls_Manager::COLOR, 'default' => '#ffffff', 'selectors' => [ '{{WRAPPER}} .tdw-title' => 'color: {{VALUE}};' ]]);
		$this->add_group_control(\Elementor\Group_Control_Typography::get_type(), ['name' => 'title_typo', 'label' => __('تایپوگرافی عنوان', 'skill'), 'selector' => '{{WRAPPER}} .tdw-title']);
		$this->add_control('desc_color', ['label' => __('رنگ توضیح', 'skill'), 'type' => \Elementor\Controls_Manager::COLOR, 'default' => 'rgba(255,255,255,0.8)', 'selectors' => [ '{{WRAPPER}} .tdw-desc' => 'color: {{VALUE}};' ]]);
		$this->add_group_control(\Elementor\Group_Control_Typography::get_type(), ['name' => 'desc_typo', 'label' => __('تایپوگرافی توضیح', 'skill'), 'selector' => '{{WRAPPER}} .tdw-desc']);
		$this->add_control('dot_color', ['label' => __('رنگ مربع', 'skill'), 'type' => \Elementor\Controls_Manager::COLOR, 'default' => '#1e73be', 'selectors' => [ '{{WRAPPER}} .tdw-dot' => 'background-color: {{VALUE}};' ]]);
		$this->add_control('dot_size', ['label' => __('سایز مربع (px)', 'skill'), 'type' => \Elementor\Controls_Manager::SLIDER, 'size_units' => ['px'], 'range' => [ 'px' => ['min' => 6, 'max' => 24] ], 'default' => ['unit' => 'px', 'size' => 10], 'selectors' => [ '{{WRAPPER}} .tdw-dot' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};' ]]);
		$this->end_controls_section();
	}

	protected function render() {
		$s = $this->get_settings_for_display();
		$dot_right = ($s['dot_position'] ?? 'right') === 'right';
		?>
		<div class="tdw-wrap" dir="rtl">
			<div class="tdw-title-row" style="display:inline-flex; align-items:center; gap:8px; <?php echo $dot_right ? 'flex-direction: row-reverse;' : ''; ?>">
				<?php if (!empty($s['show_title']) && $s['show_title'] === 'yes'): ?>
					<h2 class="tdw-title"><?php echo esc_html($s['title_text'] ?: ''); ?></h2>
				<?php endif; ?>
				<?php if (!empty($s['show_dot']) && $s['show_dot'] === 'yes'): ?>
					<span class="tdw-dot" aria-hidden="true" style="display:inline-block; border-radius:3px;"></span>
				<?php endif; ?>
			</div>
			<?php if (!empty($s['show_desc']) && $s['show_desc'] === 'yes' && !empty($s['desc_text'])): ?>
				<div class="tdw-desc" style="margin-top:10px;">
					<?php echo esc_html($s['desc_text']); ?>
				</div>
			<?php endif; ?>
		</div>
		<?php
	}
}


