<?php
class skill_Title_page_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'my_custom_icon_title';
    }

    public function get_title() {
        return __('عنوان صفحات', 'skill');
    }

    public function get_icon() {
        return 'eicon-heading';
    }

    public function get_categories() {
        return ['skill-category'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title_text',
            [
                'label' => __('عنوان', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('رزومه من', 'skill'),
                'placeholder' => __('متن عنوان را وارد کنید', 'skill'),
            ]
        );

        $this->add_control(
            'icon',
            [
                'label' => __('آیکون', 'skill'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-file',
                    'library' => 'fa-solid',
                ],
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'style_section',
            [
                'label' => __('استایل', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'wrapper_style',
            [
                'label' => __('استایل اصلی', 'skill'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'selector' => '{{WRAPPER}} .my-custom-icon-title',
                'fields_options' => [
                    'border' => [
                        'default' => 'solid',
                    ],
                    'width' => [
                        'default' => [
                            'top' => 1,
                            'right' => 1,
                            'bottom' => 1,
                            'left' => 1,
                            'unit' => 'px',
                            'isLinked' => true,
                        ],
                    ],
                    'color' => [
                        'default' => '#ddddddc4',
                    ],
                ],
            ]
        );

        $this->add_control(
            'border_radius',
            [
                'label' => __('گردی گوشه', 'skill'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'default' => [
                    'top' => 40,
                    'right' => 40,
                    'bottom' => 40,
                    'left' => 40,
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .my-custom-icon-title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'padding',
            [
                'label' => __('فاصله داخلی', 'skill'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'default' => [
                    'top' => 5,
                    'right' => 20,
                    'bottom' => 5,
                    'left' => 20,
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .my-custom-icon-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'icon_spacing',
            [
                'label' => __('فاصله آیکون از متن', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'default' => [
                    'size' => 8,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .my-custom-icon-title i' => 'margin-left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_style',
            [
                'label' => __('استایل عنوان', 'skill'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('رنگ عنوان', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .my-custom-icon-title' => 'color: {{VALUE}}',
                ],
                'default' => '#333333',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .my-custom-icon-title',
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => __('رنگ آیکون', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .my-custom-icon-title i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .my-custom-icon-title svg' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => __('سایز آیکون', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 100,
                    ],
                    'em' => [
                        'min' => 0.5,
                        'max' => 5,
                    ],
                    'rem' => [
                        'min' => 0.5,
                        'max' => 5,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 16,
                ],
                'selectors' => [
                    '{{WRAPPER}} .my-custom-icon-title i' => 'font-size: {{SIZE}}{{UNIT}}',
                    '{{WRAPPER}} .my-custom-icon-title svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="my-custom-icon-title-container">
            <span class="my-custom-icon-title">
                <?php \Elementor\Icons_Manager::render_icon($settings['icon'], ['aria-hidden' => 'true']); ?>
                <?php echo esc_html($settings['title_text']); ?>
            </span>
        </div>
        <?php
    }

    protected function _content_template() {
        ?>
        <#
        var iconHTML = elementor.helpers.renderIcon(view, settings.icon, { 'aria-hidden': true }, 'i', 'object' );
        #>
        <div class="my-custom-icon-title-container">
            <span class="my-custom-icon-title">
                {{{ iconHTML.value }}}
                {{{ settings.title_text }}}
            </span>
        </div>
        <?php
    }
}