<?php

class work_edoction_widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'skill_job_history_widget';
    }

    public function get_title() {
        return __('سوابق کاری من', 'skill');
    }

    public function get_icon() {
        return 'eicon-person';
    }

    public function get_categories() {
        return ['skill-category'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_title',
            [
                'label' => __('عنوان بخش', 'skill'),
            ]
        );

        // Title+Desc controls (match skill-title-desc-widget)
        $this->add_control('show_title', [
            'label' => __('نمایش عنوان', 'skill'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => __('بله', 'skill'),
            'label_off' => __('خیر', 'skill'),
            'return_value' => 'yes',
            'default' => 'yes',
        ]);
        $this->add_control('title_text', [
            'label' => __('عنوان', 'skill'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __('سوابق کاری', 'skill'),
            'condition' => ['show_title' => 'yes'],
            'label_block' => true,
        ]);
        $this->add_control('show_dot', [
            'label' => __('نمایش مربع آبی', 'skill'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => __('بله', 'skill'),
            'label_off' => __('خیر', 'skill'),
            'return_value' => 'yes',
            'default' => 'yes',
        ]);
        $this->add_control('dot_position', [
            'label' => __('جایگاه مربع', 'skill'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [ 'right' => __('راست عنوان', 'skill'), 'left' => __('چپ عنوان', 'skill') ],
            'default' => 'right',
            'condition' => ['show_dot' => 'yes']
        ]);
        $this->add_control('show_desc', [
            'label' => __('نمایش توضیح کوتاه', 'skill'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => __('بله', 'skill'),
            'label_off' => __('خیر', 'skill'),
            'return_value' => 'yes',
            'default' => '',
        ]);
        $this->add_control('desc_text', [
            'label' => __('توضیح کوتاه', 'skill'),
            'type' => \Elementor\Controls_Manager::TEXTAREA,
            'rows' => 2,
            'condition' => ['show_desc' => 'yes']
        ]);

        // Backward-compat legacy controls (kept)
        $this->add_control(
            'section_title_text',
            [
                'label' => __('عنوان', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('سوابق کاری', 'skill'),
            ]
        );

        $this->add_control(
            'section_title_icon',
            [
                'label' => __('آیکون', 'skill'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-briefcase',
                    'library' => 'solid',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_jobs',
            [
                'label' => __('آیتم‌های شغلی', 'skill'),
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'company_name',
            [
                'label' => __('نام شرکت', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('مهارت', 'skill'),
            ]
        );

        $repeater->add_control(
            'job_title',
            [
                'label' => __('عنوان شغل', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('توسعه دهنده', 'skill'),
            ]
        );

        $repeater->add_control(
            'job_description',
            [
                'label' => __('توضیحات', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ', 'skill'),
            ]
        );

        $repeater->add_control(
            'job_period',
            [
                'label' => __('دوره زمانی', 'skill'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('از 1400 تا 1402', 'skill'),
            ]
        );

        $repeater->add_control(
            'company_logo',
            [
                'label' => __('لوگو شرکت', 'skill'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'company_url',
            [
                'label' => __('لینک شرکت', 'skill'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => 'https://your-link.com',
            ]
        );

        $this->add_control(
            'jobs_list',
            [
                'label' => __('لیست مشاغل', 'skill'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'company_name' => __('مهارت', 'skill'),
                        'job_title' => __('توسعه دهنده', 'skill'),
                        'job_description' => __('لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ', 'skill'),
                        'job_period' => __('از 1400 تا 1402', 'skill'),
                    ],
                ],
                'title_field' => '{{{ job_title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style',
            [
                'label' => __('استایل', 'skill'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        // Title+Desc styles (match skill-title-desc-widget)
        $this->add_responsive_control('tdw_align', [
            'label' => __('چینش', 'skill'),
            'type' => \Elementor\Controls_Manager::CHOOSE,
            'options' => [
                'right' => ['title' => __('راست', 'skill'), 'icon' => 'eicon-text-align-right'],
                'center' => ['title' => __('وسط', 'skill'), 'icon' => 'eicon-text-align-center'],
                'left' => ['title' => __('چپ', 'skill'), 'icon' => 'eicon-text-align-left'],
            ],
            'default' => 'center',
            'selectors' => [ '{{WRAPPER}} .tdw-wrap' => 'text-align: {{VALUE}};' ],
        ]);
        $this->add_control('tdw_title_color', [
            'label' => __('رنگ عنوان', 'skill'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '#ffffff',
            'selectors' => [ '{{WRAPPER}} .tdw-title' => 'color: {{VALUE}};' ],
        ]);
        $this->add_group_control(\Elementor\Group_Control_Typography::get_type(), [
            'name' => 'tdw_title_typo',
            'label' => __('تایپوگرافی عنوان', 'skill'),
            'selector' => '{{WRAPPER}} .tdw-title'
        ]);
        $this->add_control('tdw_desc_color', [
            'label' => __('رنگ توضیح', 'skill'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => 'rgba(255,255,255,0.8)',
            'selectors' => [ '{{WRAPPER}} .tdw-desc' => 'color: {{VALUE}};' ],
        ]);
        $this->add_group_control(\Elementor\Group_Control_Typography::get_type(), [
            'name' => 'tdw_desc_typo',
            'label' => __('تایپوگرافی توضیح', 'skill'),
            'selector' => '{{WRAPPER}} .tdw-desc'
        ]);
        $this->add_control('tdw_dot_color', [
            'label' => __('رنگ مربع', 'skill'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'default' => '#1e73be',
            'selectors' => [ '{{WRAPPER}} .tdw-dot' => 'background-color: {{VALUE}};' ],
        ]);
        $this->add_control('tdw_dot_size', [
            'label' => __('سایز مربع (px)', 'skill'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px'],
            'range' => [ 'px' => ['min' => 6, 'max' => 24] ],
            'default' => ['unit' => 'px', 'size' => 10],
            'selectors' => [ '{{WRAPPER}} .tdw-dot' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};' ],
        ]);

        // Name company
        $this->add_control(
            'company_color',
            [
                'label' => __('رنگ نام شرکت', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#1976d2',
                'selectors' => [
                    '{{WRAPPER}} .job-std-company' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'company_font_size',
            [
                'label' => __('سایز فونت نام شرکت', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => ['min' => 10, 'max' => 40],
                ],
                'default' => [
                    'size' => 17,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .job-std-company' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'company_font_weight',
            [
                'label' => __('وزن فونت نام شرکت', 'skill'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '400' => 'Normal',
                    '500' => 'Medium',
                    '700' => 'Bold',
                    '800' => 'Extra Bold',
                    '900' => 'Black',
                ],
                'default' => '800',
                'selectors' => [
                    '{{WRAPPER}} .job-std-company' => 'font-weight: {{VALUE}};',
                ],
            ]
        );

        // عنوان شغل
        $this->add_control(
            'job_title_color',
            [
                'label' => __('رنگ عنوان شغل', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#333333',
                'selectors' => [
                    '{{WRAPPER}} .job-std-job-title' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'job_title_font_size',
            [
                'label' => __('سایز فونت عنوان شغل', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => ['min' => 10, 'max' => 40],
                ],
                'default' => [
                    'size' => 15,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .job-std-job-title' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'job_title_font_weight',
            [
                'label' => __('وزن فونت عنوان شغل', 'skill'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    '400' => 'Normal',
                    '500' => 'Medium',
                    '700' => 'Bold',
                    '800' => 'Extra Bold',
                    '900' => 'Black',
                ],
                'default' => '700',
                'selectors' => [
                    '{{WRAPPER}} .job-std-job-title' => 'font-weight: {{VALUE}};',
                ],
            ]
        );

        // توضیحات
        $this->add_control(
            'desc_color',
            [
                'label' => __('رنگ توضیحات', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#607d8b',
                'selectors' => [
                    '{{WRAPPER}} .job-std-desc' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'desc_font_size',
            [
                'label' => __('سایز فونت توضیحات', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => ['min' => 10, 'max' => 30],
                ],
                'default' => [
                    'size' => 14,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .job-std-desc' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        // بازه زمانی
        $this->add_control(
            'period_color',
            [
                'label' => __('رنگ متن بازه زمانی', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .job-std-period' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'period_bg_color',
            [
                'label' => __('رنگ پس‌زمینه بازه زمانی', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#1976d2',
                'selectors' => [
                    '{{WRAPPER}} .job-std-period' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'period_font_size',
            [
                'label' => __('سایز فونت بازه زمانی', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => ['min' => 10, 'max' => 30],
                ],
                'default' => [
                    'size' => 13,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .job-std-period' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        // کارت
        $this->add_control(
            'card_bg_color',
            [
                'label' => __('رنگ پس‌زمینه کارت', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .job-std-card' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'card_border_color',
            [
                'label' => __('رنگ حاشیه کارت', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#f0f4f8',
                'selectors' => [
                    '{{WRAPPER}} .job-std-card' => 'border-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'card_border_radius',
            [
                'label' => __('گردی گوشه کارت', 'skill'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => ['min' => 0, 'max' => 40],
                ],
                'default' => [
                    'size' => 16,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .job-std-card' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'card_box_shadow',
            [
                'label' => __('سایه کارت', 'skill'),
                'type' => \Elementor\Controls_Manager::BOX_SHADOW,
                'default' => [
                    'horizontal' => 0,
                    'vertical' => 2,
                    'blur' => 16,
                    'spread' => 0,
                    'color' => 'rgba(25, 118, 210, 0.08)',
                ],
                'selectors' => [
                    '{{WRAPPER}} .job-std-card' => '{{BOX_SHADOW}}',
                ],
            ]
        );

        // آیکون عنوان
        $this->add_control(
            'icon_color',
            [
                'label' => __('رنگ آیکون عنوان', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#1976d2',
                'selectors' => [
                    '{{WRAPPER}} .job-std-title-icon' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'icon_bg_color',
            [
                'label' => __('رنگ پس‌زمینه آیکون', 'skill'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#e3f2fd',
                'selectors' => [
                    '{{WRAPPER}} .job-std-title-icon' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <style>
        .job-std-list {
            display: flex;
            flex-direction: column;
            gap: 28px;
            max-width: 100%;
            margin: 0 auto;
        }
        .job-std-title-wrap {
            display: flex;
            align-items: center;
            gap: 12px;
            margin-bottom: 32px;
        }
        .job-std-title-wrap .job-std-title-icon {
            font-size: 2.1rem;
            color: #1976d2;
            background: #e3f2fd;
            border-radius: 8px;
            padding: 6px;
        }
        .job-std-title {
            font-size: 1.5rem;
            font-weight: 800;
            color: #222;
            letter-spacing: -0.5px;
        }
        .job-std-card {
            display: flex;
            flex-direction: row;
            align-items: flex-start;
            justify-content: space-between;
            background: #fff;
            border-radius: 16px;
            box-shadow: 0 2px 16px 0 rgba(25, 118, 210, 0.08);
            padding: 20px 24px;
            gap: 20px;
            border: 1px solid #f0f4f8;
            transition: box-shadow 0.2s, border 0.2s;
            position: relative;
        }
        .job-std-card-right {
            display: flex;
            align-items: flex-start;
            gap: 16px;
        }
        .job-std-card-left {
            display: flex;
            flex-direction: column;
            align-items: flex-start;
            justify-content: flex-start;
            min-width: 90px;
            margin-right: auto;
        }
        .job-std-logo {
            width: 60px;
            height: 60px;
            min-width: 60px;
            min-height: 60px;
            border-radius: 12px;
            background: #e3f2fd;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
            box-shadow: 0 2px 8px 0 rgba(25, 118, 210, 0.08);
            border: 2px solid #90caf9;
            align-self: flex-start;
        }
        .job-std-logo img {
            width: 44px;
            height: 44px;
            object-fit: contain;
            border-radius: 8px;
        }
        .job-std-info {
            display: flex;
            flex-direction: column;
            gap: 6px;
        }
        .job-std-job-title {
            font-size: 15px;
            font-weight: 700;
            color: #333;
        }
        .job-std-company {
            color: #1976d2;
            font-size: 17px;
            font-weight: 800;
        }
        .job-std-company a {
            color: #1976d2;
            text-decoration: none;
            transition: color 0.2s;
        }
        .job-std-company a:hover {
            color: #0d47a1;
        }
        .job-std-period {
            font-size: 13px;
            color: #fff;
            background: #1976d2;
            border-radius: 6px;
            padding: 5px 12px 2px 12px;
            font-weight: 500;
            margin: 0 0 8px 0;
            align-self: flex-start;
        }
        .job-std-desc {
            font-size: 14px;
            color: #607d8b;
            margin-top: 2px;
        }
        @media (max-width: 700px) {
            .job-std-list {
                max-width: 98vw;
            }
            .job-std-card {
                flex-direction: column;
                align-items: center;
                padding: 14px 6px;
            }
            .job-std-card-right {
                flex-direction: column;
                align-items: center;
                justify-content: center;
                gap: 8px;
                width: 100%;
            }
            .job-std-card-left {
                align-items: center;
                justify-content: center;
                width: 100%;
                margin-bottom: 8px;
                margin-right: 0;
            }
            .job-std-logo {
                margin-bottom: 8px;
                align-self: center;
            }
            .job-std-info, .job-std-job-title, .job-std-company, .job-std-desc {
                align-items: center !important;
                text-align: center !important;
                width: 100%;
            }
            .job-std-period {
                align-self: center !important;
            }
            .job-std-title {
                font-size: 1.1rem;
            }
        }
        </style>
        <div class="job-std-list">
            <div class="tdw-wrap" dir="rtl" style="margin-bottom:22px;">
                <div class="tdw-title-row" style="display:inline-flex; align-items:center; gap:8px; <?php echo (($settings['dot_position'] ?? 'right') === 'right') ? 'flex-direction: row-reverse;' : ''; ?>">
                    <?php if (!empty($settings['show_title']) && $settings['show_title'] === 'yes'): ?>
                        <h2 class="tdw-title"><?php echo esc_html($settings['title_text'] ?: $settings['section_title_text']); ?></h2>
                    <?php endif; ?>
                    <?php if (!empty($settings['show_dot']) && $settings['show_dot'] === 'yes'): ?>
                        <span class="tdw-dot" aria-hidden="true" style="display:inline-block; border-radius:3px;"></span>
                    <?php endif; ?>
                </div>
                <?php if (!empty($settings['show_desc']) && $settings['show_desc'] === 'yes' && !empty($settings['desc_text'])): ?>
                    <div class="tdw-desc" style="margin-top:10px;">
                        <?php echo esc_html($settings['desc_text']); ?>
                    </div>
                <?php endif; ?>
            </div>
            <?php foreach ($settings['jobs_list'] as $job): ?>
                <div class="job-std-card">
                    <div class="job-std-card-right" style="display:flex; align-items:center; gap:16px;">
                        <div class="job-std-logo">
                            <?php if (!empty($job['company_logo']['url'])): ?>
                                <img src="<?php echo esc_url($job['company_logo']['url']); ?>" alt="<?php echo esc_attr($job['company_name']); ?> logo">
                            <?php endif; ?>
                        </div>
                        <div class="job-std-info">
                            <div class="job-std-company">
                                <?php if (!empty($job['company_url']['url'])): ?>
                                    <a href="<?php echo esc_url($job['company_url']['url']); ?>" target="<?php echo esc_attr($job['company_url']['is_external'] ? '_blank' : '_self'); ?>">
                                        <strong ><?php echo esc_html($job['company_name']); ?></strong>
                                    </a>
                                <?php else: ?>
                                    <strong ><?php echo esc_html($job['company_name']); ?></strong>
                                <?php endif; ?>
                            </div>
                            <div class="job-std-job-title"><?php echo esc_html($job['job_title']); ?></div>
                            <div class="job-std-desc"><?php echo esc_html($job['job_description']); ?></div>
                        </div>
                    </div>
                    <div class="job-std-card-left" style="display:flex; flex-direction:column; align-items:flex-start; justify-content:flex-start; min-width:90px; margin-right:auto;">
                        <span class="job-std-period"><?php echo esc_html($job['job_period']); ?></span>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        <?php
    }
}