<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class skill_work_educational_exprience_Widget extends Widget_Base {
    public function get_name() {
        return 'skill_work_educational_experience_widget';
    }

    public function get_title() {
        return __( 'تجربه کاری/تحصیلی مهارت', 'skill' );
    }

    public function get_icon() {
        return 'eicon-user-circle-o';
    }

    public function get_categories() {
        return [ 'skill-category' ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'محتوا', 'skill' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'widget_title',
            [
                'label' => __( 'عنوان ویجت', 'skill' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'عنوان نمونه ویجت', 'skill' ),
                'label_block' => true,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'item_image',
            [
                'label' => __( 'تصویر', 'skill' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'item_title',
            [
                'label' => __( 'عنوان آیتم', 'skill' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'عنوان نمونه', 'skill' ),
            ]
        );

        $repeater->add_control(
            'item_date',
            [
                'label' => __( 'تاریخ', 'skill' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'آذر 1399 تا حالا', 'skill' ),
            ]
        );

        $repeater->add_control(
            'item_link',
            [
                'label' => __( 'لینک', 'skill' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'skill' ),
                'show_external' => true,
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => __( 'آیتم‌ها', 'skill' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'item_title' => __( 'فریلنسر تمام وقت در شرکت مهارت', 'skill' ),
                        'item_date' => __( 'آذر 1399 تا حالا', 'skill' ),
                    ],
                ],
                'title_field' => '{{{ item_title }}}',
            ]
        );

        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
            'section_style',
            [
                'label' => __( 'استایل', 'skill' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'widget_title_color',
            [
                'label' => __( 'رنگ عنوان ویجت', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .skill-widget-title' => 'color: {{VALUE}};',
                ],
                'default' => '#fff',
            ]
        );

        $this->add_control(
            'widget_title_size',
            [
                'label' => __( 'اندازه فونت عنوان ویجت', 'skill' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .skill-widget-title' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 22,
                ],
            ]
        );

        $this->add_control(
            'bg_color',
            [
                'label' => __( 'رنگ پس‌زمینه آیتم‌ها', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .skill-experience-widget' => 'background-color: {{VALUE}};',
                ],
                'default' => '#111',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __( 'رنگ عنوان آیتم‌ها', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .skill-experience-title' => 'color: {{VALUE}};',
                ],
                'default' => '#fff',
            ]
        );

        $this->add_control(
            'title_size',
            [
                'label' => __( 'اندازه فونت عنوان آیتم‌ها', 'skill' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .skill-experience-title' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 18,
                ],
            ]
        );

        $this->add_control(
            'date_color',
            [
                'label' => __( 'رنگ تاریخ', 'skill' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .skill-experience-date' => 'color: {{VALUE}};',
                ],
                'default' => '#aaa',
            ]
        );

        $this->add_control(
            'date_size',
            [
                'label' => __( 'اندازه فونت تاریخ', 'skill' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 20,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .skill-experience-date' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 14,
                ],
            ]
        );

        $this->add_control(
            'image_size',
            [
                'label' => __( 'اندازه تصویر', 'skill' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 30,
                        'max' => 150,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .skill-experience-image' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 85,
                ],
            ]
        );

        $this->add_control(
            'border_radius',
            [
                'label' => __( 'شعاع حاشیه', 'skill' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .skill-experience-widget' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
            ]
        );

        $this->add_control(
            'padding',
            [
                'label' => __( 'فاصله داخلی', 'skill' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .skill-experience-widget' => 'padding: {{SIZE}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        if ( !empty($settings['widget_title']) ) : ?>
            <div class="skill-widget-title" style="margin-bottom:18px;font-weight:bold;">
                <?php echo esc_html($settings['widget_title']); ?>
            </div>
        <?php endif; ?>

        <?php if ( !empty($settings['items']) ) : ?>
            <?php foreach ( $settings['items'] as $item ) :
                $item_link = $item['item_link']['url'] ?? '';
                $item_target = $item['item_link']['is_external'] ? ' target="_blank"' : '';
                $item_rel = $item['item_link']['nofollow'] ? ' rel="nofollow"' : '';
                $open_link = $item_link ? '<a href="' . esc_url($item_link) . '"' . $item_target . $item_rel . ' style="text-decoration:none;display:block;">' : '';
                $close_link = $item_link ? '</a>' : '';
                echo $open_link;
            ?>
            <div class="skill-experience-widget" style="display:flex;align-items:center;gap:15px;direction:rtl;margin-bottom:15px;">
                <div>
                    <?php if ( !empty($item['item_image']['url']) ) : ?>
                        <img src="<?php echo esc_url($item['item_image']['url']); ?>" alt="<?php echo esc_attr($item['item_title']); ?>" class="skill-experience-image" style="max-width: 100%;height: auto;width: 80px;padding: 10px;object-fit:cover;background:#222;border-radius:15px;">
                    <?php endif; ?>
                </div>
                <div>
                    <div class="skill-experience-title" style="margin-bottom:5px;">
                        <?php echo esc_html( $item['item_title'] ); ?>
                    </div>
                    <div class="skill-experience-date">
                        <?php echo esc_html( $item['item_date'] ); ?>
                    </div>
                </div>
            </div>
            <?php echo $close_link; endforeach; ?>
        <?php endif; ?>
        <?php
    }
}
