<?php


//**************** add account card woocommerce ****************//
if (class_exists('WooCommerce')) {
    
    function add_profile_image_upload_field() {
        $user = wp_get_current_user();
        $profile_image = get_user_meta($user->ID, 'profile_image', true);
        ?>
        <div class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
            <label for="profile_image"><?php _e('تصویر پروفایل', 'skill'); ?></label>
            <input type="file" name="profile_image" id="profile_image" accept="image/*">
            <?php if ($profile_image) : ?>
                <div class="current-profile-image">
                    <img src="<?php echo esc_url($profile_image); ?>" width="80" style="margin-top:10px;">
                    <p>
                        <input type="checkbox" name="remove_profile_image" id="remove_profile_image">
                        <label for="remove_profile_image"><?php _e('حذف تصویر فعلی', 'skill'); ?></label>
                    </p>
                </div>
            <?php endif; ?>
        </div>
        <?php
    }
    add_action('woocommerce_edit_account_form', 'add_profile_image_upload_field');

    function save_profile_image_upload($user_id) {
        if (!empty($_FILES['profile_image']['tmp_name'])) {
            require_once(ABSPATH . 'wp-admin/includes/image.php');
            require_once(ABSPATH . 'wp-admin/includes/file.php');
            require_once(ABSPATH . 'wp-admin/includes/media.php');

            $attachment_id = media_handle_upload('profile_image', 0);

            if (!is_wp_error($attachment_id)) {
                $image_url = wp_get_attachment_url($attachment_id);
                update_user_meta($user_id, 'profile_image', $image_url);
                update_user_meta($user_id, 'profile_image_id', $attachment_id);
            }
        }

        if (!empty($_POST['remove_profile_image'])) {
            $old_image_id = get_user_meta($user_id, 'profile_image_id', true);
            if ($old_image_id) {
                wp_delete_attachment($old_image_id, true);
            }
            delete_user_meta($user_id, 'profile_image');
            delete_user_meta($user_id, 'profile_image_id');
        }
    }
    add_action('woocommerce_save_account_details', 'save_profile_image_upload');

    function add_account_summary_card() {
        $user = wp_get_current_user();
        $profile_image = get_user_meta($user->ID, 'profile_image', true);
        ?>
        <div class="account-summary-card">
            <div class="account-avatar">
                <?php if ($profile_image) : ?>
                    <img src="<?php echo esc_url($profile_image); ?>" width="80" height="80" style="border-radius:50%;">
                <?php else : ?>
                    <?php echo get_avatar($user->ID, 80); ?>
                <?php endif; ?>
            </div>
            <h3><?php echo $user->display_name; ?></h3>
            <p>عضو از: <?php echo date_i18n('d F Y', strtotime($user->user_registered)); ?></p>
        </div>
        <?php
    }
    add_action('woocommerce_before_account_navigation', 'add_account_summary_card');

    function enable_profile_image_upload() {
        wp_enqueue_script('jquery');
        if (function_exists('is_account_page') && is_account_page()) {
            wp_enqueue_media();
        }
    }
    add_action('wp_enqueue_scripts', 'enable_profile_image_upload');

    function allow_profile_image_upload() {
        echo 'enctype="multipart/form-data"';
    }
    add_action('woocommerce_edit_account_form_tag', 'allow_profile_image_upload');
}
//**************** end add account card woocommerce ****************//