<?php

// Page selection metabox for categories and tags
function skill_add_page_selector_to_terms($term) {
    $selected = get_term_meta($term->term_id, '_skill_redirect_page_id', true);
    $pages = get_pages(['post_status' => 'publish']);
    ?>
    <tr class="form-field">
        <th scope="row"><label for="skill_redirect_page_id"><?php _e('انتخاب برگه برای ریدایرکت', 'skill'); ?></label></th>
        <td>
            <select name="skill_redirect_page_id" id="skill_redirect_page_id">
                <option value=""><?php _e('انتخاب نشده', 'skill'); ?></option>
                <?php foreach ($pages as $page): ?>
                    <option value="<?php echo esc_attr($page->ID); ?>" <?php selected($selected, $page->ID); ?>>
                        <?php echo esc_html($page->post_title); ?>
                    </option>
                <?php endforeach; ?>
            </select>
            <p class="description"><?php _e('در صورت انتخاب، کاربران این دسته/برچسب به این برگه منتقل می‌شوند.', 'skill'); ?></p>
        </td>
    </tr>
    <?php
}
add_action('category_edit_form_fields', 'skill_add_page_selector_to_terms');
add_action('post_tag_edit_form_fields', 'skill_add_page_selector_to_terms');

// Save metabox value
function skill_save_page_selector_to_terms($term_id) {
    if (isset($_POST['skill_redirect_page_id'])) {
        update_term_meta($term_id, '_skill_redirect_page_id', intval($_POST['skill_redirect_page_id']));
    }
}
add_action('edited_category', 'skill_save_page_selector_to_terms');
add_action('edited_post_tag', 'skill_save_page_selector_to_terms');

// Redirect category or tag archive to selected page
add_action('template_redirect', function() {
    if (is_category() || is_tag()) {
        $term = get_queried_object();
        $page_id = get_term_meta($term->term_id, '_skill_redirect_page_id', true);
        if ($page_id) {
            $url = get_permalink($page_id);
            if ($url) {
                wp_redirect($url, 301);
                exit;
            }
        }
    }
});