<?php

// Function to get font family CSS - Common function for all font operations
function skill_get_font_family_css($font_name) {
    switch($font_name) {
        case 'iranyekan':
            return '"iranyekan", tahoma, sans-serif';
        case 'dana':
            return '"dana", tahoma, sans-serif';
        case 'kalameh':
            return '"KalamehWebFaNum", tahoma, sans-serif';
        case 'yekanbakh':
            return '"Yekan Bakh FaNum", tahoma, sans-serif';
        default:
            return '"iranyekan", tahoma, sans-serif';
    }
}

function skill_theme_options($wp_customize) {
	
	// Theme Options Panel Control - Comment this line to disable theme options panel
	\cb205fa8b689aa51bae6731b7c7e0b::c35d4b1d9b784bada9cac1bd97320f();
	// Check if theme options panel is enabled
	if (!apply_filters('skill_enable_theme_options_panel', false)) {
		return; // Exit if theme options are disabled
	}
	
	$wp_customize->add_panel('skill_theme_option', array(
        'title' => __('تنظیمات قالب مهارت', 'skill'),
        'description' => __('اینجا تنظیمات قالب مهارت است', 'skill'),
        'priority' => 1
    ));
    /**
 * Add Persian date option to theme customizer
 */
    // Add section
    $wp_customize->add_section('skill_persian_date_section', array(
        'title' => __('تنظیمات تاریخ شمسی', 'skill'),
        'priority' => 1,
        'panel' => 'skill_theme_option'
    ));
    
    // Add setting
    $wp_customize->add_setting('skill_enable_persian_date', array(
        'default' => true,
        'sanitize_callback' => 'skill_sanitize_checkbox',
    ));
    
    // Add control
    $wp_customize->add_control('skill_enable_persian_date', array(
        'label' => __('فعال‌سازی تاریخ شمسی', 'skill'),
        'description' => __('اگر فعال باشد، تمام تاریخ‌های قالب به شمسی تبدیل می‌شوند', 'skill'),
        'section' => 'skill_persian_date_section',
        'type' => 'checkbox',
    ));
    add_action('customize_register', 'skill_persian_date_customizer');

    /**
     * Add Hamburger Menu Settings Section
     */
    // Add section
    $wp_customize->add_section('skill_hamburger_menu_section', array(
        'title' => __('تنظیمات منوی همبرگری', 'skill'),
        'priority' => 2,
        'panel' => 'skill_theme_option'
    ));
    
    // Add setting for phone number display
    $wp_customize->add_setting('skill_hamburger_phone_display', array(
        'default' => true,
        'sanitize_callback' => 'skill_sanitize_checkbox',
    ));
    
    // Add control for phone number display
    $wp_customize->add_control('skill_hamburger_phone_display', array(
        'label' => __('نمایش شماره تلفن در منوی همبرگری', 'skill'),
        'description' => __('اگر فعال باشد، شماره تلفن در منوی همبرگری نمایش داده می‌شود', 'skill'),
        'section' => 'skill_hamburger_menu_section',
        'type' => 'checkbox',
        'priority' => 1
    ));
    
    // Add setting for phone number
    $wp_customize->add_setting('skill_hamburger_phone_number', array(
        'default' => '09380000000',
        'sanitize_callback' => 'sanitize_text_field',
    ));
    
    // Add control for phone number
    $wp_customize->add_control('skill_hamburger_phone_number', array(
        'label' => __('شماره تلفن منوی همبرگری', 'skill'),
        'description' => __('شماره تلفن مورد نظر خود را وارد کنید', 'skill'),
        'section' => 'skill_hamburger_menu_section',
        'type' => 'text',
        'priority' => 2
    ));

    //    settings footer
    
    $wp_customize->add_section('skill_edit_text_footer', array(
        'title' => __('ویرایش متن فوتر سایت', 'skill'),
        'description' => __('این قسمت میتونید متن دلخواه خودتون رو قرار بدین', 'skill'),
        'priority' => 1,
        'panel' => 'skill_theme_option'
    ));

    $wp_customize->add_setting('skill_footer_display', array(
        'default' => true,
        'sanitize_callback' => 'skill_sanitize_checkbox'
    ));

    $wp_customize->add_control('skill_footer_display', array(
        'label' => __('نمایش فوتر', 'skill'),
        'description' => __('اگر می‌خواهید فوتر نمایش داده شود این گزینه را فعال کنید', 'skill'),
        'section' => 'skill_edit_text_footer',
        'type' => 'checkbox',
        'priority' => 1
    ));

    $wp_customize->add_setting('skill_edit_footer', array(
        'default' => __('© تمامی حقوق محفوظ است. کپی به هرشکل غیرمجاز و غیرقانونی است.', 'skill')
    ));

    $wp_customize->add_control('skill_edit_footer', array(
        'label' => __('ویرایش متن فوتر', 'skill'),
        'section' => 'skill_edit_text_footer',
        'priority' => 2
    ));

    // New footer settings
    $wp_customize->add_setting('skill_footer_name', array(
        'default' => __('محمد حیدری', 'skill'),
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('skill_footer_name', array(
        'label' => __('نام در فوتر', 'skill'),
        'description' => __('نامی که در فوتر نمایش داده می‌شود', 'skill'),
        'section' => 'skill_edit_text_footer',
        'type' => 'text',
        'priority' => 3
    ));

    $wp_customize->add_setting('skill_footer_job', array(
        'default' => __('برنامه‌نویس', 'skill'),
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('skill_footer_job', array(
        'label' => __('شغل در فوتر', 'skill'),
        'description' => __('عنوان شغلی که در فوتر نمایش داده می‌شود', 'skill'),
        'section' => 'skill_edit_text_footer',
        'type' => 'text',
        'priority' => 4
    ));

    $wp_customize->add_setting('skill_footer_resume_url', array(
        'default' => '',
        'sanitize_callback' => 'esc_url_raw'
    ));

    $wp_customize->add_control('skill_footer_resume_url', array(
        'label' => __('لینک دانلود رزومه', 'skill'),
        'description' => __('لینک فایل رزومه برای دانلود', 'skill'),
        'section' => 'skill_edit_text_footer',
        'type' => 'url',
        'priority' => 5
    ));

    // Social media settings
    $wp_customize->add_setting('skill_social_telegram', array(
        'default' => '',
        'sanitize_callback' => 'esc_url_raw'
    ));

    $wp_customize->add_control('skill_social_telegram', array(
        'label' => __('لینک تلگرام', 'skill'),
        'description' => __('لینک پروفایل تلگرام', 'skill'),
        'section' => 'skill_edit_text_footer',
        'type' => 'url',
        'priority' => 6
    ));

    $wp_customize->add_setting('skill_social_linkedin', array(
        'default' => '',
        'sanitize_callback' => 'esc_url_raw'
    ));

    $wp_customize->add_control('skill_social_linkedin', array(
        'label' => __('لینک لینکدین', 'skill'),
        'description' => __('لینک پروفایل لینکدین', 'skill'),
        'section' => 'skill_edit_text_footer',
        'type' => 'url',
        'priority' => 7
    ));

    $wp_customize->add_setting('skill_social_github', array(
        'default' => '',
        'sanitize_callback' => 'esc_url_raw'
    ));

    $wp_customize->add_control('skill_social_github', array(
        'label' => __('لینک گیت‌هاب', 'skill'),
        'description' => __('لینک پروفایل گیت‌هاب', 'skill'),
        'section' => 'skill_edit_text_footer',
        'type' => 'url',
        'priority' => 8
    ));

    $wp_customize->add_setting('skill_social_email', array(
        'default' => '',
        'sanitize_callback' => 'sanitize_email'
    ));

    $wp_customize->add_control('skill_social_email', array(
        'label' => __('ایمیل', 'skill'),
        'description' => __('آدرس ایمیل', 'skill'),
        'section' => 'skill_edit_text_footer',
        'type' => 'email',
        'priority' => 9
    ));

    // Quick links settings
    $wp_customize->add_setting('skill_footer_about_link', array(
        'default' => '#about',
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('skill_footer_about_link', array(
        'label' => __('لینک درباره‌من', 'skill'),
        'description' => __('لینک بخش درباره‌من', 'skill'),
        'section' => 'skill_edit_text_footer',
        'type' => 'text',
        'priority' => 10
    ));

    $wp_customize->add_setting('skill_footer_about_text', array(
        'default' => __('درباره‌من', 'skill'),
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('skill_footer_about_text', array(
        'label' => __('متن لینک درباره‌من', 'skill'),
        'description' => __('متن نمایشی لینک درباره‌من', 'skill'),
        'section' => 'skill_edit_text_footer',
        'type' => 'text',
        'priority' => 11
    ));

    $wp_customize->add_setting('skill_footer_projects_link', array(
        'default' => '#projects',
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('skill_footer_projects_link', array(
        'label' => __('لینک نمونه‌کارها', 'skill'),
        'description' => __('لینک بخش نمونه‌کارها', 'skill'),
        'section' => 'skill_edit_text_footer',
        'type' => 'text',
        'priority' => 12
    ));

    $wp_customize->add_setting('skill_footer_projects_text', array(
        'default' => __('نمونه‌کارها', 'skill'),
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('skill_footer_projects_text', array(
        'label' => __('متن لینک نمونه‌کارها', 'skill'),
        'description' => __('متن نمایشی لینک نمونه‌کارها', 'skill'),
        'section' => 'skill_edit_text_footer',
        'type' => 'text',
        'priority' => 13
    ));

    $wp_customize->add_setting('skill_footer_skills_link', array(
        'default' => '#skills',
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('skill_footer_skills_link', array(
        'label' => __('لینک مهارت‌ها', 'skill'),
        'description' => __('لینک بخش مهارت‌ها', 'skill'),
        'section' => 'skill_edit_text_footer',
        'type' => 'text',
        'priority' => 14
    ));

    $wp_customize->add_setting('skill_footer_skills_text', array(
        'default' => __('مهارت‌ها', 'skill'),
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('skill_footer_skills_text', array(
        'label' => __('متن لینک مهارت‌ها', 'skill'),
        'description' => __('متن نمایشی لینک مهارت‌ها', 'skill'),
        'section' => 'skill_edit_text_footer',
        'type' => 'text',
        'priority' => 15
    ));

    $wp_customize->add_setting('skill_footer_contact_link', array(
        'default' => '#contact',
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('skill_footer_contact_link', array(
        'label' => __('لینک ارتباط', 'skill'),
        'description' => __('لینک بخش ارتباط', 'skill'),
        'section' => 'skill_edit_text_footer',
        'type' => 'text',
        'priority' => 16
    ));

    $wp_customize->add_setting('skill_footer_contact_text', array(
        'default' => __('ارتباط', 'skill'),
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('skill_footer_contact_text', array(
        'label' => __('متن لینک ارتباط', 'skill'),
        'description' => __('متن نمایشی لینک ارتباط', 'skill'),
        'section' => 'skill_edit_text_footer',
        'type' => 'text',
        'priority' => 17
    ));

    $wp_customize->add_setting('skill_footer_resume_text', array(
        'default' => __('دانلود رزومه', 'skill'),
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('skill_footer_resume_text', array(
        'label' => __('متن لینک دانلود رزومه', 'skill'),
        'description' => __('متن نمایشی لینک دانلود رزومه', 'skill'),
        'section' => 'skill_edit_text_footer',
        'type' => 'text',
        'priority' => 18
    ));
    //    end settings footer

    //    settings shop
    $wp_customize->add_section('skill_cart_settings', array(
        'title' => __('تنظیمات فروشگاه', 'skill'),
        'description' => __('اینجا تنظیمات فروشگاه است', 'skill'),
        'priority' => 2,
        'panel' => 'skill_theme_option'
    ));

    $wp_customize->add_setting('skill_cart_display', array(
        'default' => true,
        'sanitize_callback' => 'skill_sanitize_checkbox'
    ));

    $wp_customize->add_control('skill_cart_display', array(
        'label' => __('نمایش سبد خرید', 'skill'),
        'description' => __('اگر می‌خواهید سبد خرید نمایش داده شود این گزینه را فعال کنید' , 'skill'),
        'section' => 'skill_cart_settings',
        'type' => 'checkbox',
        'priority' => 1
    ));

    $wp_customize->add_setting('skill_cart_text', array(
        'default' => __('سبدخرید من' , 'skill')
    ));

    $wp_customize->add_control('skill_cart_text', array(
        'label' => __('متن سبد خرید' , 'skill'),
        'description' => __('متن دلخواه خود را برای سبد خرید وارد کنید', 'skill'),
        'section' => 'skill_cart_settings',
        'type' => 'text',
        'priority' => 2
    ));

    $wp_customize->add_setting('skill_cart_icon', array(
        'default' => 'fa-opencart',
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('skill_cart_icon', array(
        'label' => __('آیکون سبد خرید', 'skill'),
        'description' => __('نام کلاس آیکون Font Awesome را وارد کنید (مثال: fa-shopping-cart)', 'skill'),
        'section' => 'skill_cart_settings',
        'type' => 'text',
        'priority' => 3
    ));

    $wp_customize->add_setting('skill_cart_icon_prefix', array(
        'default' => 'fas',
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('skill_cart_icon_prefix', array(
        'label' => __('نوع آیکون', 'skill'),
        'description' => __('پیشوند آیکون را انتخاب کنید (مثلاً fas برای solid، fab برای brands)' , 'skill'),
        'section' => 'skill_cart_settings',
        'type' => 'select',
        'choices' => array(
            'fas' => 'Solid (fas)',
            'far' => 'Regular (far)',
            'fab' => 'Brands (fab)'
        ),
        'priority' => 4
    ));
    //    end settings shop

    //    settings background
    $wp_customize->add_section('skill_background_settings', array(
        'title' => __('تنظیمات پس‌زمینه' , 'skill'),
        'description' => __('در این قسمت می‌توانید تصویر پس‌زمینه سایت را تغییر دهید', 'skill'),
        'priority' => 3,
        'panel' => 'skill_theme_option'
    ));

    // Background mode: static (color/image) or animated gradient
    $wp_customize->add_setting('skill_background_mode', array(
        'default' => 'static',
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('skill_background_mode', array(
        'label' => __('حالت پس‌زمینه', 'skill'),
        'description' => __('انتخاب بین پس‌زمینه ثابت (رنگ/تصویر) یا گرادینت متحرک مدرن', 'skill'),
        'section' => 'skill_background_settings',
        'type' => 'select',
        'choices' => array(
            'static' => __('ثابت (رنگ/تصویر)', 'skill'),
            'animated_gradient' => __('گرادینت متحرک', 'skill')
        ),
        'priority' => 0
    ));

    // Animated gradient preset (shown only when animated gradient is selected)
    $wp_customize->add_setting('skill_animated_gradient_preset', array(
        'default' => 'aurora',
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('skill_animated_gradient_preset', array(
        'label' => __('انتخاب گرادینت', 'skill'),
        'description' => __('یک گرادینت متحرک مدرن و جذاب انتخاب کنید', 'skill'),
        'section' => 'skill_background_settings',
        'type' => 'select',
        'choices' => array(
            'aurora'   => __('Aurora Flow', 'skill'),
            'neon'     => __('Neon Glow', 'skill'),
            'sunset'   => __('Sunset Horizon', 'skill'),
            'ocean'    => __('Ocean Breeze', 'skill'),
            'pastel'   => __('Soft Pastel', 'skill'),
            'cyber'    => __('Cyberpunk', 'skill'),
            'tropical' => __('Tropical Vibes', 'skill'),
            'midnight' => __('Midnight Blues', 'skill'),
            'sunrise'  => __('Sunrise Burst', 'skill'),
            'lava'     => __('Lava Lamp', 'skill'),
            'prism'    => __('Prismatic', 'skill'),
            'aurora_blur' => __('Aurora Blur (Ultra Soft)', 'skill'),
            'mesh'        => __('Modern Mesh', 'skill'),
            'conic'       => __('Conic Sweep', 'skill'),
            'wave'        => __('Wave Motion', 'skill'),
            'grid_neon'   => __('Neon Grid', 'skill'),
            'plasma'      => __('Plasma Field', 'skill')
        ),
        'priority' => 1,
        'active_callback' => 'skill_is_animated_gradient_selected'
    ));

    // Animated gradient speed in seconds
    $wp_customize->add_setting('skill_animated_gradient_speed', array(
        'default' => 20,
        'sanitize_callback' => 'absint'
    ));

    $wp_customize->add_control('skill_animated_gradient_speed', array(
        'label' => __('سرعت انیمیشن (ثانیه)', 'skill'),
        'section' => 'skill_background_settings',
        'type' => 'number',
        'input_attrs' => array(
            'min' => 5,
            'max' => 120,
            'step' => 1
        ),
        'priority' => 2,
        'active_callback' => 'skill_is_animated_gradient_selected'
    ));

    $wp_customize->add_setting('skill_background_image', array(
        'default' => '',
        'sanitize_callback' => 'esc_url_raw'
    ));

    // Background Color Setting
    $wp_customize->add_setting('skill_background_color', array(
        'default' => '#ffffff',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_background_color', array(
        'label' => __('رنگ پس‌زمینه', 'skill'),
        'description' => __('رنگ مورد نظر خود را برای پس‌زمینه انتخاب کنید', 'skill'),
        'section' => 'skill_background_settings',
        'priority' => 1
    )));
    // end Background Color Setting

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'skill_background_image', array(
        'label' => __('تصویر پس‌زمینه', 'skill'),
        'description' => __('تصویر مورد نظر خود را برای پس‌زمینه آپلود کنید', 'skill'),
        'section' => 'skill_background_settings',
        'priority' => 1,
        'active_callback' => 'skill_is_static_background_selected'
    )));

    $wp_customize->add_setting('skill_background_repeat', array(
        'default' => 'no-repeat',
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('skill_background_repeat', array(
        'label' => __('تکرار تصویر', 'skill'),
        'section' => 'skill_background_settings',
        'type' => 'select',
        'choices' => array(
            'no-repeat' => __('تکرار تصویر', 'skill'),
            'repeat' => __('تکرار افقی و عمودی', 'skill'),
            'repeat-x' => __('تکرار افقی', 'skill'),
            'repeat-y' => __('تکرار عمودی', 'skill')
        ),
        'priority' => 2,
        'active_callback' => 'skill_is_static_background_selected'
    ));

    $wp_customize->add_setting('skill_background_size', array(
        'default' => 'cover',
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('skill_background_size', array(
        'label' => __('اندازه تصویر', 'skill'),
        'section' => 'skill_background_settings',
        'type' => 'select',
        'choices' => array(
            'cover' => __('پوشش کامل (cover)', 'skill'),
            'contain' => __('حفظ نسبت (contain)', 'skill'),
            'auto' => __('سایز اصلی', 'skill')
        ),
        'priority' => 3,
        'active_callback' => 'skill_is_static_background_selected'
    ));

    $wp_customize->add_setting('skill_background_position', array(
        'default' => 'center center',
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('skill_background_position', array(
        'label' => __('موقعیت تصویر', 'skill'),
        'section' => 'skill_background_settings',
        'type' => 'select',
        'choices' => array(
            'left top' => __('چپ بالا', 'skill'),
            'left center' => __('چپ وسط','skill'),
            'left bottom' => __('چپ پایین','skill'),
            'right top' => __('راست بالا','skill'),
            'right center' => __('راست وسط','skill'),
            'right bottom' => __('راست پایین','skill'),
            'center top' => __('وسط بالا','skill'),
            'center center' => __('وسط','skill'),
            'center bottom' => __('وسط پایین','skill')
        ),
        'priority' => 4,
        'active_callback' => 'skill_is_static_background_selected'
    ));
    //    end settings background

    //    settings content background
    $wp_customize->add_section('skill_content_background', array(
        'title' => __('تنظیمات رنگ', 'skill'),
        'description' => __('تنظیمات رنگ سایت', 'skill'),
        'priority' => 4,
        'panel' => 'skill_theme_option'
    ));

    $wp_customize->add_setting('skill_content_bg_color', array(
        'default' => '#ffffff',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_content_bg_color', array(
        'label' => __('رنگ پس‌زمینه محتوا', 'skill'),
        'description' => __('رنگ پس‌زمینه بخش محتوای اصلی را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 1
    )));

    //    settings my_info background
    $wp_customize->add_setting('skill_myinfo_bg_color', array(
        'default' => '#ffffff',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_myinfo_bg_color', array(
        'label' => __('رنگ پس‌زمینه بخش اطلاعات من', 'skill'),
        'description' => __('رنگ پس‌زمینه بخش اطلاعات کاربر را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 2
    )));

    $wp_customize->add_setting('skill_my_info_color', array(
        'default' => '#0e59f2',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_my_info_color', array(
        'label' => __('رنگ عنوان شغلی اطلاعات شخصی من', 'skill'),
        'description' => __('رنگ عنوان اطلاعات شخصی من را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 2
    )));

    $wp_customize->add_setting('skill_my_info_name_color', array(
        'default' => '#383838',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_my_info_name_color', array(
        'label' => __('رنگ نام و نام خانوادگی', 'skill'),
        'description' => __('رنگ نام و نام خانوادگی اطلاعات شخصی من', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 2
    )));

    $wp_customize->add_setting('skill_my_info_links_color', array(
        'default' => '#464644',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_my_info_links_color', array(
        'label' => __('رنگ لینک ها', 'skill'),
        'description' => __('رنگ لینک های اطلاعات شخصی من', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 2
    )));
    //    end settings my_info background

    //    settings social
    $wp_customize->add_setting('skill_social_border_color', array(
        'default' => '#dddddd',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_social_border_color', array(
        'label' => __('رنگ بردر شبکه های اجتماعی', 'skill'),
        'description' => __('رنگ بردر شبکه های احتماعی را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 2
    )));

    $wp_customize->add_setting('skill_social_border_hover_color', array(
        'default' => '#0e59f2',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_social_border_hover_color', array(
        'label' => __('رنگ هاور بردر شبکه های اجتماعی', 'skill'),
        'description' => __('رنگ بردر شبکه های احتماعی هنگام هاور را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 2
    )));

    $wp_customize->add_setting('skill_social_color', array(
        'default' => '#464644',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_social_color', array(
        'label' => __('رنگ آیکون شبکه های اجتماعی', 'skill'),
        'description' => __('رنگ آیکون شبکه های احتماعی را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 2
    )));

    $wp_customize->add_setting('skill_social_hover_icon_color', array(
        'default' => '#0e59f2',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_social_hover_icon_color', array(
        'label' => __('رنگ هاور آیکون شبکه های اجتماعی', 'skill'),
        'description' => __('رنگ آیکون شبکه های احتماعی هنگام هاور را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 2
    )));
    //    endsettings social

    //    settings menu background
    $wp_customize->add_setting('skill_menu_bg_color', array(
        'default' => '#ffffff',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_menu_bg_color', array(
        'label' => __('رنگ پس زمینه منو', 'skill'),
        'description' => __('رنگ پس‌زمینه بخش منو را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 2
    )));
    //    end settings menu background

    //    settings menu-item background
    $wp_customize->add_setting('skill_menu_item_bg_color', array(
        'default' => '#fbfbfb',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_menu_item_bg_color', array(
        'label' => __('رنگ پس زمینه آیکون های منو', 'skill'),
        'description' => __('رنگ پس‌زمینه بخش آیکون های منو را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 3
    )));
    //    end settings menu-item background

    //    settings menu-item icons color
    $wp_customize->add_setting('skill_menu_item_icons_color', array(
        'default' => '#464644',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_menu_item_icons_color', array(
        'label' => __('رنگ آیکون های منو', 'skill'),
        'description' => __('رنگ آیکون های منو را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 3
    )));
    //    end settings menu-item icons color

    //    settings menu-item active & hover color
    $wp_customize->add_setting('skill_menu_item_active_color', array(
        'default' => '#0e59f2',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_menu_item_active_color', array(
        'label' => __('رنگ آیکون فعال و هنگام هاور', 'skill'),
        'description' => __('رنگ آیکون فعال و آیکون هنگام هاور را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 3
    )));
    //    end settings menu-item active & hover color

    //    settings menu-item tooltip
    $wp_customize->add_setting('skill_menu_item_tooltip_color', array(
        'default' => '#0e59f2',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_menu_item_tooltip_color', array(
        'label' => __('رنگ tooltip هنگام هاور روی آیتم های منو', 'skill'),
        'description' => __('رنگ tooltip هنگام هاور را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 3
    )));

    $wp_customize->add_setting('skill_menu_item_tooltip_hover_color', array(
        'default' => '#ffffff',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_menu_item_tooltip_hover_color', array(
        'label' => __('رنگ متن tooltip', 'skill'),
        'description' => __('رنگ متن tooltip را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 3
    )));
    //    end settings menu-item tooltip

    //    settings scrollbar
    $wp_customize->add_setting('skill_scrollbar_color', array(
        'default' => '#464644',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_scrollbar_color', array(
        'label' => __('رنگ پس زمینه اسکرول بار', 'skill'),
        'description' => __('رنگ پس زمینه اسکرول بار را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 3
    )));

    $wp_customize->add_setting('skill_scrollbar_background_color', array(
        'default' => '#0e59f2',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_scrollbar_background_color', array(
        'label' => __('رنگ اسکرول بار', 'skill'),
        'description' => __('رنگ اسکرول بار را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 4
    )));

    $wp_customize->add_setting('skill_scrollbar_hover_color', array(
        'default' => '#6b6b6b',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_scrollbar_hover_color', array(
        'label' => __('رنگ هاور اسکرول بار', 'skill'),
        'description' => __('رنگ هنگام هاور روی اسکرول بار را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 4
    )));

    $wp_customize->add_setting('skill_scrollbar_width', array(
        'default' => 8,
        'sanitize_callback' => 'absint'
    ));

    $wp_customize->add_control('skill_scrollbar_width', array(
        'label' => __('عرض اسکرول بار (پیکسل)', 'skill'),
        'description' => __('عرض اسکرول بار را بین 4 تا 20 پیکسل تنظیم کنید', 'skill'),
        'section' => 'skill_content_background',
        'type' => 'number',
        'input_attrs' => array(
            'min' => 4,
            'max' => 20,
            'step' => 1
        ),
        'priority' => 4
    ));
    //    end settings scrollba

    //    setting color shop
    $wp_customize->add_setting('skill_woo_cart_color', array(
        'default' => '#ddddddc4',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_woo_cart_color', array(
        'label' => __('رنگ بردر سبدخرید', 'skill'),
        'description' => __('رنگ بردر سبدخرید را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 5
    )));

    $wp_customize->add_setting('skill_woo_cart_text_color', array(
        'default' => '#464644',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_woo_cart_text_color', array(
        'label' => __('رنگ متن سبدخرید', 'skill'),
        'description' => __('رنگ متن سبدخرید را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 5
    )));

    $wp_customize->add_setting('skill_woo_cart_count_color', array(
        'default' => '#dddddd',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_woo_cart_count_color', array(
        'label' => __('رنگ بک گراند تعداد محصولات سبدخرید', 'skill'),
        'description' => __('رنگ بک گراند تعداد محصولات سبدخرید را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 5
    )));

    $wp_customize->add_setting('skill_cart_count_color', array(
        'default' => '#464644',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_cart_count_color', array(
        'label' => __('رنگ تعداد محصولات سبدخرید', 'skill'),
        'description' => __('رنگ تعداد محصولات سبدخرید را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 5
    )));

    $wp_customize->add_setting('skill_woo_cart_hover_color', array(
        'default' => '#0e59f2',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_woo_cart_hover_color', array(
        'label' => __('رنگ هاور سبدخرید', 'skill'),
        'description' => __('رنگ هاور سبدخرید را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 5
    )));

    $wp_customize->add_setting('skill_woo_cart_hover_count_color', array(
        'default' => '#ffffff',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_woo_cart_hover_count_color', array(
        'label' => __('رنگ هاور تعداد محصولات سبدخرید', 'skill'),
        'description' => __('رنگ هاور تعداد محصولات سبدخرید را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 5
    )));

    $wp_customize->add_setting('skill_woo_breadcrumb_color', array(
        'default' => '#464644',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_woo_breadcrumb_color', array(
        'label' => __('رنگ مسیر ناوبری فروشگاه', 'skill'),
        'description' => __('رنگ مسیر ناوبری فروشگاه را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 5
    )));

    $wp_customize->add_setting('skill_woo_breadcrumb_hover_color', array(
        'default' => '#0e59f2',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_woo_breadcrumb_hover_color', array(
        'label' => __('رنگ هاور مسیر ناوبری فروشگاه', 'skill'),
        'description' => __('رنگ هاور مسیر ناوبری فروشگاه را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 5
    )));

    $wp_customize->add_setting('skill_woo_title_page_shop_color', array(
        'default' => '#ddddddc4',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_woo_title_page_shop_color', array(
        'label' => __('رنگ بردر صفحه فروشگاه', 'skill'),
        'description' => __('رنگ بردر صفحه فروشگاه را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 5
    )));

    $wp_customize->add_setting('skill_woo_title_page_color', array(
        'default' => '#464644',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_woo_title_page_color', array(
        'label' => __('رنگ عنوان صفحه فروشگاه', 'skill'),
        'description' => __('رنگ عنوان صفحه فروشگاه را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 5
    )));

    $wp_customize->add_setting('skill_woo_result_count_color', array(
        'default' => '#464644',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_woo_result_count_color', array(
        'label' => __('رنگ تعداد نتایج محصولات در صفحه فروشگاه', 'skill'),
        'description' => __('رنگ تعداد نتایج محصولات در صفحه فروشگاه را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 5
    )));

    $wp_customize->add_setting('skill_woo_page_numbers_color', array(
        'default' => '#dddddd',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_woo_page_numbers_color', array(
        'label' => __('رنگ بردر تعداد موارد در صفحه فروشگاه', 'skill'),
        'description' => __('رنگ بردر تعداد موارد در صفحه فروشگاه را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 5
    )));

    $wp_customize->add_setting('skill_woo_page_numbers_bg_color', array(
        'default' => '#f3f3f3ab',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_woo_page_numbers_bg_color', array(
        'label' => __('رنگ بک گراند صفحه فعال در فروشگاه', 'skill'),
        'description' => __('رنگ بک گراند صفحه فعال در فروشگاه را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 5
    )));

    $wp_customize->add_setting('skill_woo_page_numbers_number_color', array(
        'default' => '#464644',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_woo_page_numbers_number_color', array(
        'label' => __('رنگ عدد صفحه فعال در فروشگاه', 'skill'),
        'description' => __('رنگ عدد صفحه فعال در فروشگاه را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 5
    )));

    $wp_customize->add_setting('skill_woo_title_product_color', array(
        'default' => '#464644',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_woo_title_product_color', array(
        'label' => __('رنگ عنوان محصول فروشگاه', 'skill'),
        'description' => __('رنگ عنوان محصول در فروشگاه را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 5
    )));

    $wp_customize->add_setting('skill_woo_product_variable_color', array(
        'default' => '#464644',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_woo_product_variable_color', array(
        'label' => __('رنگ عنوان محصول متغییر فروشگاه', 'skill'),
        'description' => __('رنگ عنوان محصول متغییر در فروشگاه را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 5
    )));

    $wp_customize->add_setting('skill_woo_product_meta_color', array(
        'default' => '#464644',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_woo_product_meta_color', array(
        'label' => __('رنگ اطلاعات محصول فروشگاه', 'skill'),
        'description' => __('رنگ اطلاعات محصول در فروشگاه را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 5
    )));

    $wp_customize->add_setting('skill_woo_product_description_color', array(
        'default' => '#464644',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_woo_product_description_color', array(
        'label' => __('رنگ توضیحات محصول فروشگاه', 'skill'),
        'description' => __('رنگ توضیحات محصول در فروشگاه را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 5
    )));
    //    end setting color shop

    //    setting color weblog
    $wp_customize->add_setting('skill_border_title_page_blog_color', array(
        'default' => '#ddddddc4',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_border_title_page_blog_color', array(
        'label' => __('رنگ بردر عنوان صفحه وبلاگ', 'skill'),
        'description' => __('رنگ بردر عنوان صفحه وبلاگ را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 6
    )));

    $wp_customize->add_setting('skill_title_page_blog_color', array(
        'default' => '#333333',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_title_page_blog_color', array(
        'label' => __('رنگ عنوان صفحه وبلاگ', 'skill'),
        'description' => __('رنگ عنوان صفحه وبلاگ را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 6
    )));

    $wp_customize->add_setting('skill_link_article_blog_color', array(
        'default' => '#464644',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_link_article_blog_color', array(
        'label' => __('رنگ لینک مقاله', 'skill'),
        'description' => __('رنگ لینک مقاله را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 6
    )));

    $wp_customize->add_setting('skill_title_article_blog_color', array(
        'default' => '#464644',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_title_article_blog_color', array(
        'label' => __('رنگ عنوان مقاله', 'skill'),
        'description' => __('رنگ عنوان مقاله را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 6
    )));

    $wp_customize->add_setting('skill_border_date_article_blog_color', array(
        'default' => '#dddddd',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_border_date_article_blog_color', array(
        'label' => __('رنگ بردر تاریخ اننتشار مقاله', 'skill'),
        'description' => __('رنگ بردر تاریخ اننتشار مقاله را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 6
    )));

    $wp_customize->add_setting('skill_date_article_blog_color', array(
        'default' => '#333333',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_date_article_blog_color', array(
        'label' => __('رنگ تاریخ اننتشار مقاله', 'skill'),
        'description' => __('رنگ تاریخ اننتشار مقاله را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 6
    )));

    $wp_customize->add_setting('skill_decs_article_blog_color', array(
        'default' => '#464644',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_decs_article_blog_color', array(
        'label' => __('رنگ توضیحات کوتاه مقاله', 'skill'),
        'description' => __('رنگ توضیحات کوتاه مقاله را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 6
    )));

    $wp_customize->add_setting('skill_read_more_hover_article_blog_color', array(
        'default' => '#0e59f2',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_read_more_hover_article_blog_color', array(
        'label' => __('رنگ هاور ادامه مطلب مقاله', 'skill'),
        'description' => __('رنگ هاور ادامه مطلب مقاله را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 6
    )));

    $wp_customize->add_setting('skill_icon_article_blog_color', array(
        'default' => '#464644',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_icon_article_blog_color', array(
        'label' => __('رنگ آیکون لینک ادامه مقاله', 'skill'),
        'description' => __('رنگ آیکون لینک ادامه مقاله را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 6
    )));
    //    end setting color weblog

    //    setting color project
    $wp_customize->add_setting('skill_title_project_color', array(
        'default' => '#1e293b',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_title_project_color', array(
        'label' => __('رنگ عنوان پروژه', 'skill'),
        'description' => __('رنگ عنوان پروژه را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 7
    )));

    $wp_customize->add_setting('skill_categori_project_color', array(
        'default' => '#1e293b',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_categori_project_color', array(
        'label' => __('رنگ دسته بندی پروژه', 'skill'),
        'description' => __('رنگ دسته بندی پروژه را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 7
    )));

    $wp_customize->add_setting('skill_title_categori_project_color', array(
        'default' => '#1e293b',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_title_categori_project_color', array(
        'label' => __('رنگ عنوان های دسته بندی پروژه', 'skill'),
        'description' => __('رنگ عنوان های دسته بندی پروژه را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 7
    )));

    $wp_customize->add_setting('skill_border_title_categori_project_color', array(
        'default' => '#e2e8f0',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_border_title_categori_project_color', array(
        'label' => __('رنگ بردر دسته بندی پروژه', 'skill'),
        'description' => __('رنگ بردر دسته بندی پروژه را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 7
    )));

    $wp_customize->add_setting('skill_border_hover_categori_project_color', array(
        'default' => '#7c3aed',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_border_hover_categori_project_color', array(
        'label' => __('رنگ هاور بردر دسته بندی پروژه', 'skill'),
        'description' => __('رنگ هاور بردر دسته بندی پروژه را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 7
    )));

    $wp_customize->add_setting('skill_list_project_color', array(
        'default' => '#1e293b',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_list_project_color', array(
        'label' => __('رنگ جزئیات پروژه', 'skill'),
        'description' => __('رنگ جزئیات پروژه را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 7
    )));
    //    end setting color project

    //    setting color single blog
    $wp_customize->add_setting('skill_post_title_color', array(
        'default' => '#464644',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_post_title_color', array(
        'label' => __('رنگ عنوان مقاله', 'skill'),
        'description' => __('رنگ عنوان مقاله را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 8
    )));

    $wp_customize->add_setting('skill_post_icon_color', array(
        'default' => '#464644',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_post_icon_color', array(
        'label' => __('رنگ آیکون مقاله', 'skill'),
        'description' => __('رنگ آیکون اطلاعات مقاله را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 8
    )));

    $wp_customize->add_setting('skill_post_meta_color', array(
        'default' => '#464644',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_post_meta_color', array(
        'label' => __('رنگ اطلاعات مقاله', 'skill'),
        'description' => __('رنگ اطلاعات مقاله را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 8
    )));

    $wp_customize->add_setting('skill_post_category_color', array(
        'default' => '#464644',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_post_category_color', array(
        'label' => __('رنگ دسته بندی های مقاله', 'skill'),
        'description' => __('رنگ دسته بندی های مقاله را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 8
    )));

    $wp_customize->add_setting('skill_post_category_hover_color', array(
        'default' => '#0e59f2',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_post_category_hover_color', array(
        'label' => __('رنگ هاور دسته بندی های مقاله', 'skill'),
        'description' => __('رنگ هاور دسته بندی های مقاله را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 8
    )));

    $wp_customize->add_setting('skill_post_breadcrumbs_color', array(
        'default' => '#464644',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_post_breadcrumbs_color', array(
        'label' => __('رنگ ناوبری مقاله', 'skill'),
        'description' => __('رنگ ناوبری مقاله را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 8
    )));

    $wp_customize->add_setting('skill_post_breadcrumbs_links_color', array(
        'default' => '#464644',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_post_breadcrumbs_links_color', array(
        'label' => __('رنگ لینک های ناوبری مقاله', 'skill'),
        'description' => __('رنگ لینک های ناوبری مقاله را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 8
    )));

    $wp_customize->add_setting('skill_post_breadcrumbs_hover_color', array(
        'default' => '#0e59f2',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_post_breadcrumbs_hover_color', array(
        'label' => __('رنگ هاور ناوبری مقاله', 'skill'),
        'description' => __('رنگ هاور ناوبری مقاله را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 8
    )));

    $wp_customize->add_setting('skill_post_social_share_color', array(
        'default' => '#464644',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_post_social_share_color', array(
        'label' => __('رنگ اشتراک گذاری مقاله', 'skill'),
        'description' => __('رنگ اشتراک گذاری مقاله را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 8
    )));

    $wp_customize->add_setting('skill_post_tags_label_color', array(
        'default' => '#464644',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_post_tags_label_color', array(
        'label' => __('رنگ برچسب مقاله', 'skill'),
        'description' => __('رنگ برچسب مقاله را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 8
    )));

    $wp_customize->add_setting('skill_post_tags_border_color', array(
        'default' => '#ddddddc4',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_post_tags_border_color', array(
        'label' => __('رنگ بردر برچسب مقاله', 'skill'),
        'description' => __('رنگ بردر برچسب مقاله را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 8
    )));

    $wp_customize->add_setting('skill_post_tags_color', array(
        'default' => '#464644',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_post_tags_color', array(
        'label' => __('رنگ برچسب مقاله', 'skill'),
        'description' => __('رنگ برچسب مقاله را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 8
    )));

    $wp_customize->add_setting('skill_post_tags_hover_border_color', array(
        'default' => '#0e59f2',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_post_tags_hover_border_color', array(
        'label' => __('رنگ هاور بردر برچسب مقاله', 'skill'),
        'description' => __('رنگ هاور بردر برچسب مقاله را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 8
    )));

    $wp_customize->add_setting('skill_post_tags_hover_color', array(
        'default' => '#0e59f2',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_post_tags_hover_color', array(
        'label' => __('رنگ هاور برچسب مقاله', 'skill'),
        'description' => __('رنگ هاور برچسب مقاله را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 8
    )));
    //    end setting color single blog

    //    setting color footer
    $wp_customize->add_setting('skill_footer_bg_color', array(
        'default' => '#f3f3f3',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_footer_bg_color', array(
        'label' => __('رنگ بک گراند فوتر', 'skill'),
        'description' => __('رنگ بک گراند فوتر را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 9
    )));

    $wp_customize->add_setting('skill_footer_text_color', array(
        'default' => '#464644',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_footer_text_color', array(
        'label' => __('رنگ متن فوتر', 'skill'),
        'description' => __('رنگ متن فوتر را انتخاب کنید', 'skill'),
        'section' => 'skill_content_background',
        'priority' => 9
    )));
    //    end setting color footer
    //    end settings content background

    //    settings preload
    $wp_customize->add_section('skill_preload_settings', array(
        'title' => __('پیش‌بارگذاری سایت', 'skill'),
        'description' => __('تنظیمات مربوط به پیش‌بارگذاری و صفحه لودینگ', 'skill'),
        'priority' => 5,
        'panel' => 'skill_theme_option'
    ));

    $wp_customize->add_setting('skill_enable_preload', array(
        'default' => true,
        'sanitize_callback' => 'skill_sanitize_checkbox'
    ));

    $wp_customize->add_control('skill_enable_preload', array(
        'label' => __('فعال کردن پیش‌بارگذاری', 'skill'),
        'description' => __('صفحه پیش‌بارگذاری هنگام ورود به سایت نمایش داده شود', 'skill'),
        'section' => 'skill_preload_settings',
        'type' => 'checkbox',
        'priority' => 1
    ));

    $wp_customize->add_setting('skill_preload_spinner_type', array(
        'default' => 'circle',
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('skill_preload_spinner_type', array(
        'label' => __('نوع اسپینر بارگذاری', 'skill'),
        'section' => 'skill_preload_settings',
        'type' => 'select',
        'choices' => array(
            'circle' => __('حلقه چرخان', 'skill'),
            'dots' => __('نقاط متحرک', 'skill'),
            'bar' => __('نوار پیشرفت', 'skill'),
            'custom' => __('سفارشی', 'skill')
        ),
        'priority' => 2
    ));

    $wp_customize->add_setting('skill_preload_spinner_color', array(
        'default' => '#0e59f2',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_preload_spinner_color', array(
        'label' => __('رنگ اسپینر', 'skill'),
        'section' => 'skill_preload_settings',
        'priority' => 3
    )));

    $wp_customize->add_setting('skill_preload_custom_image', array(
        'default' => '',
        'sanitize_callback' => 'esc_url_raw'
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'skill_preload_custom_image', array(
        'label' => __('تصویر سفارشی پیش‌بارگذاری', 'skill'),
        'description' => __('در صورت انتخاب نوع سفارشی، این تصویر نمایش داده می‌شود', 'skill'),
        'section' => 'skill_preload_settings',
        'priority' => 4,
        'active_callback' => 'skill_is_custom_preload'
    )));

    $wp_customize->add_setting('skill_preload_duration', array(
        'default' => 2000,
        'sanitize_callback' => 'absint'
    ));

    $wp_customize->add_control('skill_preload_duration', array(
        'label' => __('مدت زمان نمایش (میلی‌ثانیه)', 'skill'),
        'description' => __('حداقل 1000 میلی‌ثانیه (1 ثانیه) توصیه می‌شود', 'skill'),
        'section' => 'skill_preload_settings',
        'type' => 'number',
        'input_attrs' => array(
            'min' => 1000,
            'max' => 10000,
            'step' => 500
        ),
        'priority' => 5
    ));

    $wp_customize->add_setting('skill_preload_resources', array(
        'default' => '',
        'sanitize_callback' => 'sanitize_textarea_field'
    ));
    //    end settings preload

    //    settings single weblog
    $wp_customize->add_section('skill_single_post_settings', array(
        'title' => __('تنظیمات صفحه وبلاگ', 'skill'),
        'description' => __('تنظیمات اختصاصی صفحات تک مطالب', 'skill'),
        'priority' => 6,
        'panel' => 'skill_theme_option'
    ));

    $wp_customize->add_setting('skill_single_show_thumbnail', array(
        'default' => true,
        'sanitize_callback' => 'skill_sanitize_checkbox'
    ));

    $wp_customize->add_control('skill_single_show_thumbnail', array(
        'label' => __('نمایش تصویر شاخص', 'skill'),
        'section' => 'skill_single_post_settings',
        'type' => 'checkbox',
        'priority' => 1
    ));

    $wp_customize->add_setting('skill_single_thumbnail_size', array(
        'default' => 'large',
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('skill_single_thumbnail_size', array(
        'label' => __('سایز تصویر شاخص', 'skill'),
        'section' => 'skill_single_post_settings',
        'type' => 'select',
        'choices' => array(
            'thumbnail' => __('بند انگشتی', 'skill'),
            'medium' => __('متوسط', 'skill'),
            'large' => __('بزرگ', 'skill'),
            'full' => __('سایز اصلی', 'skill')
        ),
        'priority' => 2
    ));

    $wp_customize->add_setting('skill_single_show_date', array(
        'default' => true,
        'sanitize_callback' => 'skill_sanitize_checkbox'
    ));

    $wp_customize->add_control('skill_single_show_date', array(
        'label' => __('نمایش تاریخ انتشار', 'skill'),
        'section' => 'skill_single_post_settings',
        'type' => 'checkbox',
        'priority' => 3
    ));

    $wp_customize->add_setting('skill_single_show_author', array(
        'default' => true,
        'sanitize_callback' => 'skill_sanitize_checkbox'
    ));

    $wp_customize->add_control('skill_single_show_author', array(
        'label' => __('نمایش نام نویسنده', 'skill'),
        'section' => 'skill_single_post_settings',
        'type' => 'checkbox',
        'priority' => 4
    ));

    $wp_customize->add_setting('skill_single_show_category', array(
        'default' => true,
        'sanitize_callback' => 'skill_sanitize_checkbox'
    ));

    $wp_customize->add_control('skill_single_show_category', array(
        'label' => __('نمایش دسته‌بندی', 'skill'),
        'section' => 'skill_single_post_settings',
        'type' => 'checkbox',
        'priority' => 5
    ));

    $wp_customize->add_setting('skill_single_show_breadcrumb', array(
        'default' => true,
        'sanitize_callback' => 'skill_sanitize_checkbox'
    ));

    $wp_customize->add_control('skill_single_show_breadcrumb', array(
        'label' => __('نمایش ناوبری', 'skill'),
        'section' => 'skill_single_post_settings',
        'type' => 'checkbox',
        'priority' => 6
    ));

    $wp_customize->add_setting('skill_single_show_tags', array(
        'default' => true,
        'sanitize_callback' => 'skill_sanitize_checkbox'
    ));

    $wp_customize->add_control('skill_single_show_tags', array(
        'label' => __('نمایش تگ‌ها', 'skill'),
        'section' => 'skill_single_post_settings',
        'type' => 'checkbox',
        'priority' => 7
    ));

    $wp_customize->add_setting('skill_single_show_social', array(
        'default' => true,
        'sanitize_callback' => 'skill_sanitize_checkbox'
    ));

    $wp_customize->add_control('skill_single_show_social', array(
        'label' => __('نمایش دکمه‌های اشتراک‌گذاری', 'skill'),
        'section' => 'skill_single_post_settings',
        'type' => 'checkbox',
        'priority' => 8
    ));

    $wp_customize->add_setting('skill_single_show_comments', array(
        'default' => true,
        'sanitize_callback' => 'skill_sanitize_checkbox'
    ));

    $wp_customize->add_control('skill_single_show_comments', array(
        'label' => __('نمایش بخش نظرات', 'skill'),
        'section' => 'skill_single_post_settings',
        'type' => 'checkbox',
        'priority' => 9
    ));

    $wp_customize->add_setting('skill_single_show_related', array(
        'default' => true,
        'sanitize_callback' => 'skill_sanitize_checkbox'
    ));

    $wp_customize->add_control('skill_single_show_related', array(
        'label' => __('نمایش مطالب مرتبط', 'skill'),
        'section' => 'skill_single_post_settings',
        'type' => 'checkbox',
        'priority' => 10
    ));

    $wp_customize->add_setting('skill_single_related_count', array(
        'default' => 3,
        'sanitize_callback' => 'absint'
    ));

    $wp_customize->add_control('skill_single_related_count', array(
        'label' => __('تعداد مطالب مرتبط', 'skill'),
        'section' => 'skill_single_post_settings',
        'type' => 'number',
        'input_attrs' => array(
            'min' => 1,
            'max' => 6,
            'step' => 1
        ),
        'priority' => 11,
        'active_callback' => 'skill_single_show_related_callback'
    ));

    $wp_customize->add_setting('skill_single_show_author_box', array(
        'default' => true,
        'sanitize_callback' => 'skill_sanitize_checkbox'
    ));

    $wp_customize->add_control('skill_single_show_author_box', array(
        'label' => __('نمایش باکس نویسنده', 'skill'),
        'section' => 'skill_single_post_settings',
        'type' => 'checkbox',
        'priority' => 12
    ));
    //    end settings single weblog

    //    settings blog archive
    $wp_customize->add_section('skill_blog_archive_settings', array(
        'title' => __('تنظیمات آرشیو وبلاگ', 'skill'),
        'description' => __('تنظیمات نمایش مطالب در صفحه آرشیو وبلاگ', 'skill'),
        'priority' => 6.5,
        'panel' => 'skill_theme_option'
    ));

    $wp_customize->add_setting('skill_blog_archive_enable_category_filter', array(
        'default' => false,
        'sanitize_callback' => 'skill_sanitize_checkbox'
    ));

    $wp_customize->add_control('skill_blog_archive_enable_category_filter', array(
        'label' => __('فیلتر بر اساس دسته‌بندی', 'skill'),
        'description' => __('فعال‌سازی نمایش فقط مطالب دسته‌بندی‌های انتخاب شده', 'skill'),
        'section' => 'skill_blog_archive_settings',
        'type' => 'checkbox',
        'priority' => 1
    ));

    // Add individual category checkboxes
    $categories = get_categories(array(
        'hide_empty' => false,
        'orderby' => 'name',
        'order' => 'ASC'
    ));
    
    $priority = 2;
    foreach ($categories as $category) {
        $wp_customize->add_setting('skill_blog_archive_category_' . $category->term_id, array(
            'default' => false,
            'sanitize_callback' => 'skill_sanitize_checkbox'
        ));

        $wp_customize->add_control('skill_blog_archive_category_' . $category->term_id, array(
            'label' => $category->name,
            'section' => 'skill_blog_archive_settings',
            'type' => 'checkbox',
            'priority' => $priority
        ));
        $priority++;
    }

    $wp_customize->add_setting('skill_blog_archive_posts_per_page', array(
        'default' => get_option('posts_per_page'),
        'sanitize_callback' => 'absint'
    ));

    $wp_customize->add_control('skill_blog_archive_posts_per_page', array(
        'label' => __('تعداد مطالب در هر صفحه', 'skill'),
        'description' => __('تعداد مطالب نمایش داده شده در هر صفحه آرشیو', 'skill'),
        'section' => 'skill_blog_archive_settings',
        'type' => 'number',
        'input_attrs' => array(
            'min' => 1,
            'max' => 50,
            'step' => 1
        ),
        'priority' => 3
    ));

    $wp_customize->add_setting('skill_blog_archive_show_excerpt', array(
        'default' => true,
        'sanitize_callback' => 'skill_sanitize_checkbox'
    ));

    $wp_customize->add_control('skill_blog_archive_show_excerpt', array(
        'label' => __('نمایش خلاصه مطلب', 'skill'),
        'description' => __('نمایش خلاصه مطلب در کارت‌های آرشیو', 'skill'),
        'section' => 'skill_blog_archive_settings',
        'type' => 'checkbox',
        'priority' => 4
    ));

    $wp_customize->add_setting('skill_blog_archive_excerpt_length', array(
        'default' => 20,
        'sanitize_callback' => 'absint'
    ));

    $wp_customize->add_control('skill_blog_archive_excerpt_length', array(
        'label' => __('طول خلاصه مطلب', 'skill'),
        'description' => __('تعداد کلمات نمایش داده شده در خلاصه مطلب', 'skill'),
        'section' => 'skill_blog_archive_settings',
        'type' => 'number',
        'input_attrs' => array(
            'min' => 5,
            'max' => 100,
            'step' => 1
        ),
        'priority' => 5
    ));
    //    end settings blog archive

    //    settings page 404
    $wp_customize->add_section('skill_404_settings', array(
        'title' => __('تنظیمات صفحه 404', 'skill'),
        'description' => __('شخصی‌سازی صفحه خطای 404', 'skill'),
        'priority' => 7,
        'panel' => 'skill_theme_option'
    ));

    $wp_customize->add_setting('skill_404_title', array(
        'default' => __('متاسفانه صفحه مورد نظر یافت نشد!', 'skill'),
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('skill_404_title', array(
        'label' => __('عنوان صفحه 404', 'skill'),
        'section' => 'skill_404_settings',
        'type' => 'text',
        'priority' => 1
    ));

    $wp_customize->add_setting('skill_404_subtitle', array(
        'default' => __('صفحه‌ای که به دنبال آن هستید وجود ندارد یا منتقل شده است.', 'skill'),
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('skill_404_subtitle', array(
        'label' => __('توضیحات صفحه 404', 'skill'),
        'section' => 'skill_404_settings',
        'type' => 'textarea',
        'priority' => 2
    ));

    $wp_customize->add_setting('skill_404_button_text', array(
        'default' => __('بازگشت به صفحه اصلی', 'skill'),
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('skill_404_button_text', array(
        'label' => __('متن دکمه بازگشت', 'skill'),
        'section' => 'skill_404_settings',
        'type' => 'text',
        'priority' => 2
    ));

    $wp_customize->add_setting('skill_404_image', array(
        'default' => get_template_directory_uri() . '/assets/images/404.png',
        'sanitize_callback' => 'esc_url_raw'
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'skill_404_image', array(
        'label' => __('تصویر صفحه 404', 'skill'),
        'description' => __('تصویر مورد نظر خود را برای صفحه 404 آپلود کنید', 'skill'),
        'section' => 'skill_404_settings',
        'priority' => 3
    )));
    //    end settings page 404

    //    settings single project
    $wp_customize->add_section('skill_project_settings', array(
        'title' => __('تنظیمات صفحه پروژه', 'skill'),
        'description' => __('شخصی‌سازی صفحات تک پروژه‌ها', 'skill'),
        'priority' => 8,
        'panel' => 'skill_theme_option'
    ));

    $wp_customize->add_setting('skill_project_show_thumbnail', array(
        'default' => true,
        'sanitize_callback' => 'skill_sanitize_checkbox'
    ));

    $wp_customize->add_control('skill_project_show_thumbnail', array(
        'label' => __('نمایش تصویر شاخص پروژه', 'skill'),
        'section' => 'skill_project_settings',
        'type' => 'checkbox',
        'priority' => 1
    ));

    $wp_customize->add_setting('skill_project_show_meta', array(
        'default' => true,
        'sanitize_callback' => 'skill_sanitize_checkbox'
    ));

    $wp_customize->add_control('skill_project_show_meta', array(
        'label' => __('نمایش متادیتاهای پروژه', 'skill'),
        'section' => 'skill_project_settings',
        'type' => 'checkbox',
        'priority' => 3
    ));

    $wp_customize->add_setting('skill_project_show_technologies', array(
        'default' => true,
        'sanitize_callback' => 'skill_sanitize_checkbox'
    ));

    $wp_customize->add_control('skill_project_show_technologies', array(
        'label' => __('نمایش تکنولوژی‌های استفاده شده', 'skill'),
        'section' => 'skill_project_settings',
        'type' => 'checkbox',
        'priority' => 4
    ));

    $wp_customize->add_setting('skill_project_show_details', array(
        'default' => true,
        'sanitize_callback' => 'skill_sanitize_checkbox'
    ));

    $wp_customize->add_control('skill_project_show_details', array(
        'label' => __('نمایش جزئیات پروژه', 'skill'),
        'section' => 'skill_project_settings',
        'type' => 'checkbox',
        'priority' => 5
    ));

    $wp_customize->add_setting('skill_project_show_categories', array(
        'default' => true,
        'sanitize_callback' => 'skill_sanitize_checkbox'
    ));

    $wp_customize->add_control('skill_project_show_categories', array(
        'label' => __('نمایش دسته‌بندی‌های پروژه', 'skill'),
        'section' => 'skill_project_settings',
        'type' => 'checkbox',
        'priority' => 6
    ));

    $wp_customize->add_setting('skill_project_show_comments', array(
        'default' => false,
        'sanitize_callback' => 'skill_sanitize_checkbox'
    ));

    $wp_customize->add_control('skill_project_show_comments', array(
        'label' => __('نمایش بخش نظرات', 'skill'),
        'section' => 'skill_project_settings',
        'type' => 'checkbox',
        'priority' => 7
    ));

    $wp_customize->add_setting('skill_project_tech_bg', array(
        'default' => '#0e59f2',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_project_tech_bg', array(
        'label' => __('رنگ زمینه تکنولوژی‌ها', 'skill'),
        'section' => 'skill_project_settings',
        'priority' => 10
    )));

    $wp_customize->add_setting('skill_project_tech_text', array(
        'default' => '#ffffff',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_project_tech_text', array(
        'label' => __('رنگ متن تکنولوژی‌ها', 'skill'),
        'section' => 'skill_project_settings',
        'priority' => 11
    )));

    $wp_customize->add_setting('skill_project_cat_bg', array(
        'default' => '#f0f0f0',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_project_cat_bg', array(
        'label' => __('رنگ زمینه دسته‌بندی‌ها', 'skill'),
        'section' => 'skill_project_settings',
        'priority' => 12
    )));

    $wp_customize->add_setting('skill_project_cat_text', array(
        'default' => '#333333',
        'sanitize_callback' => 'sanitize_hex_color'
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'skill_project_cat_text', array(
        'label' => __('رنگ متن دسته‌بندی‌ها', 'skill'),
        'section' => 'skill_project_settings',
        'priority' => 13
    )));
    //    end settings single project

    //    settings add fonts
    $wp_customize->add_section('skill_font_settings', array(
        'title' => __('تنظیمات فونت', 'skill'),
        'description' => __('مدیریت فونت‌های سایت', 'skill'),
        'priority' => 9,
        'panel' => 'skill_theme_option'
    ));

    $wp_customize->add_setting('skill_primary_font', array(
        'default' => 'iranyekan',
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('skill_primary_font', array(
        'label' => __('فونت اصلی سایت', 'skill'),
        'section' => 'skill_font_settings',
        'type' => 'select',
        'choices' => array(
            'iranyekan' => __('ایران یکان', 'skill'),
            'dana' => __('دانا', 'skill'),
            'kalameh' => __('کلمه', 'skill'),
            'yekanbakh' => __('یکان بخ', 'skill'),
        ),
        'priority' => 1
    ));

    // Add separate font settings for headings and body text
    $wp_customize->add_setting('skill_headings_font', array(
        'default' => 'iranyekan',
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('skill_headings_font', array(
        'label' => __('فونت عناوین (h1, h2, h3, h4, h5, h6)', 'skill'),
        'description' => __('فونت مورد نظر برای عناوین سایت را انتخاب کنید', 'skill'),
        'section' => 'skill_font_settings',
        'type' => 'select',
        'choices' => array(
            'iranyekan' => __('ایران یکان', 'skill'),
            'dana' => __('دانا', 'skill'),
            'kalameh' => __('کلمه', 'skill'),
            'yekanbakh' => __('یکان بخ', 'skill'),
        ),
        'priority' => 2
    ));

    $wp_customize->add_setting('skill_body_font', array(
        'default' => 'iranyekan',
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('skill_body_font', array(
        'label' => __('فونت متن‌ها', 'skill'),
        'description' => __('فونت مورد نظر برای متن‌های سایت را انتخاب کنید', 'skill'),
        'section' => 'skill_font_settings',
        'type' => 'select',
        'choices' => array(
            'iranyekan' => __('ایران یکان', 'skill'),
            'dana' => __('دانا', 'skill'),
            'kalameh' => __('کلمه', 'skill'),
            'yekanbakh' => __('یکان بخ', 'skill'),
        ),
        'priority' => 3
    ));

    $wp_customize->add_setting('skill_headings_font_weight', array(
        'default' => '700',
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('skill_headings_font_weight', array(
        'label' => __('وزن فونت عناوین', 'skill'),
        'description' => __('وزن فونت مورد نظر برای عناوین', 'skill'),
        'section' => 'skill_font_settings',
        'type' => 'select',
        'choices' => array(
            '100' => __('نازک (100)', 'skill'),
            '300' => __('سبک (300)', 'skill'),
            '400' => __('نرمال (400)', 'skill'),
            '500' => __('متوسط (500)', 'skill'),
            '700' => __('ضخیم (700)', 'skill'),
            '900' => __('خیلی ضخیم (900)', 'skill')
        ),
        'priority' => 4
    ));

    $wp_customize->add_setting('skill_font_weight', array(
        'default' => '400',
        'sanitize_callback' => 'sanitize_text_field'
    ));

    $wp_customize->add_control('skill_font_weight', array(
        'label' => __('وزن فونت متن‌ها', 'skill'),
        'description' => __('وزن فونت مورد نظر برای متن‌های سایت', 'skill'),
        'section' => 'skill_font_settings',
        'type' => 'select',
        'choices' => array(
            '100' => __('نازک (100)', 'skill'),
            '300' => __('سبک (300)', 'skill'),
            '400' => __('نرمال (400)', 'skill'),
            '500' => __('متوسط (500)', 'skill'),
            '700' => __('ضخیم (700)', 'skill'),
            '900' => __('خیلی ضخیم (900)', 'skill')
        ),
        'priority' => 5
    ));

    $wp_customize->add_setting('skill_base_font_size', array(
        'default' => '16',
        'sanitize_callback' => 'absint'
    ));

    $wp_customize->add_control('skill_base_font_size', array(
        'label' => __('سایز پایه فونت (px)', 'skill'),
        'section' => 'skill_font_settings',
        'type' => 'number',
        'input_attrs' => array(
            'min' => 12,
            'max' => 20,
            'step' => 1
        ),
        'priority' => 6
    ));
    //    end settings add fonts


}

function skill_add_fonts_to_head() {
    $primary_font = get_theme_mod('skill_primary_font', 'iranyekan');
    $headings_font = get_theme_mod('skill_headings_font', 'iranyekan');
    $body_font = get_theme_mod('skill_body_font', 'iranyekan');
    $font_weight = get_theme_mod('skill_font_weight', '400');
    $headings_font_weight = get_theme_mod('skill_headings_font_weight', '700');

    echo '<style id="skill-font-styles">';
    echo ':root { --skill-base-font-size: ' . get_theme_mod('skill_base_font_size', '16') . 'px; }';
    echo 'body { font-size: var(--skill-base-font-size); }';

    // Apply body font
    $body_font_family = skill_get_font_family_css($body_font);
    echo 'body, p, div, span, a, li, td, th, input, textarea, select, button, .button { font-family: ' . $body_font_family . ';  }';

    // Apply headings font with higher specificity
    $headings_font_family = skill_get_font_family_css($headings_font);
    echo 'h1, h2, h3, h4, h5, h6, .entry-title, .post-title, .widget-title, .site-title { font-family: ' . $headings_font_family . ' !important; }';
    echo 'h1, h2, h3, h4, h5, h6 { font-family: ' . $headings_font_family . ' !important; }';
    echo '.entry-title, .post-title, .widget-title, .site-title { font-family: ' . $headings_font_family . ' !important; }';

    echo '</style>';
}
// Disabled: Elementor controls fonts
add_action('wp_head', 'skill_add_fonts_to_head', 5);

function is_custom_font_selected($control) {
    return 'custom' === $control->manager->get_setting('skill_primary_font')->value();
}

function skill_apply_font_styles() {
    echo '<style id="skill-additional-font-styles">
        /* Apply font to text elements except icons and headings */
        body,
        p, div, a, li, td, th,
        .site-title,
        .widget-title,
        .entry-title,
        .post-title,
        .main-navigation a,
        button,
        input[type="button"],
        input[type="reset"],
        input[type="submit"],
        .button,
        .wp-block-button__link,
        .elementor-widget-container,
        .elementor-text-editor,
        .elementor-widget-text-editor,
        .elementor-widget-heading,
        .elementor-button-text,
        .skill_content,
        .my_info,
        .content_boxs,
        .project-title,
        .categories-title,
        .info_post,
        .post_meta,
        .breadcrumbs,
        .desc_single,
        .label_post,
        .project-details-list,
        .woocommerce-loop-product__title,
        .product_meta,
        .woocommerce-Tabs-panel--description,
        .woocommerce-Tabs-panel--additional_information,
        .woocommerce table.shop_attributes,
        .woocommerce #reviews #comments,
        section.up-sells.upsells.products,
        footer p {
            font-family: inherit !important;
        }
        
        /* Exclude icons from font inheritance */
        i, .fas, .far, .fab, .fa,
        [class*="fa-"],
        [class*="fas-"],
        [class*="far-"],
        [class*="fab-"],
        .menu-item i,
        .social ul li i,
        .skill_boxes i,
        .content_boxs i,
        .post_meta i,
        .skill_blog_link_info_share .social i,
        .woocommerce-loop-product__title i,
        .elementor-icon i {
            font-family: "Font Awesome 5 Free", "Font Awesome 5 Brands", "Font Awesome 5 Regular", "FontAwesome" !important;
        }
        
        body {           
            line-height: 1.6;
        }                
    </style>';
}
// Disabled: Elementor controls fonts
add_action('wp_head', 'skill_apply_font_styles', 6);

function skill_elementor_font_fix() {
    echo '<style id="skill-elementor-font-fix">
        /* Apply font to all Elementor text elements */
        .elementor-widget-container,
        .elementor-text-editor,
        .elementor-widget-text-editor,
        .elementor-widget-heading,
        .elementor-button-text,
        .elementor-button,
        .elementor-widget-text-editor p,
        .elementor-widget-text-editor h1,
        .elementor-widget-text-editor h2,
        .elementor-widget-text-editor h3,
        .elementor-widget-text-editor h4,
        .elementor-widget-text-editor h5,
        .elementor-widget-text-editor h6,
        .elementor-widget-text-editor span,
        .elementor-widget-text-editor div,
        .elementor-widget-text-editor a,
        .elementor-widget-text-editor li {
            font-family: inherit !important;
        }
        
        /* Exclude Elementor icons from font inheritance */
        .elementor-icon i,
        .elementor-widget-icon i,
        .elementor-widget-icon .fas,
        .elementor-widget-icon .far,
        .elementor-widget-icon .fab {
            font-family: "Font Awesome 5 Free", "Font Awesome 5 Brands", "Font Awesome 5 Regular", "FontAwesome" !important;
        }
    </style>';
}
// Disabled: Elementor controls fonts
add_action('wp_head', 'skill_elementor_font_fix', 20);

function skill_comprehensive_font_application() {
    $primary_font = get_theme_mod('skill_primary_font', 'iranyekan');
    $headings_font = get_theme_mod('skill_headings_font', 'iranyekan');
    $body_font = get_theme_mod('skill_body_font', 'iranyekan');
    $font_weight = get_theme_mod('skill_font_weight', '400');
    $headings_font_weight = get_theme_mod('skill_headings_font_weight', '700');
    
    // Debug: Log font settings
    if (current_user_can('administrator')) {
        error_log('Skill Theme Font Debug - Body Font: ' . $body_font . ', Headings Font: ' . $headings_font);
    }
    
    $body_font_family = skill_get_font_family_css($body_font);
    $headings_font_family = skill_get_font_family_css($headings_font);
    
    echo '<style id="skill-comprehensive-font-application">
        /* Apply body font to all text elements */
        html, body,
        p, div, a, li, ul, ol,
        td, th, table,
        label, input, textarea, select,
        button, .button,
        .site-description,
        .widget-content,
        .entry-content,
        .post-content,
        .main-navigation a,
        .breadcrumbs, .breadcrumb,
        .pagination, .page-numbers,
        .comment-content, .comment-author,
        .author-box, .author-name,
        .related-posts,
        .woocommerce-loop-product__title,
        .woocommerce-product-details__short-description,
        .woocommerce-Tabs-panel,
        .woocommerce table.shop_attributes,
        .woocommerce #reviews #comments,
        .woocommerce-MyAccount-content,
        .woocommerce-customer-details,
        .woocommerce-order-details,
        .woocommerce-order-received,
        .woocommerce-checkout,
        .woocommerce-cart,
        .woocommerce-account,
        .woocommerce-login,
        .woocommerce-register,
        .woocommerce-lost-password,
        .woocommerce-reset-password,
        .woocommerce-edit-account,
        .woocommerce-edit-address,
        .woocommerce-view-order,
        .woocommerce-downloads,
        .woocommerce-orders,
        .woocommerce-payment-methods,
        .woocommerce-payment-method,
        .woocommerce-payment-method__label,
        .woocommerce-payment-method__description {
            font-family: ' . $body_font_family . ' !important;
        }
        
        /* Apply headings font to headings with higher specificity */
        h1, h2, h3, h4, h5, h6,
        .site-title,
        .widget-title,
        .entry-title,
        .post-title,
        .related-posts h3 {
            font-family: ' . $headings_font_family . ' !important;
        }
        
        /* Additional specific heading selectors for better coverage */
        h1 { font-family: ' . $headings_font_family . ' !important; }
        h2 { font-family: ' . $headings_font_family . ' !important; }
        h3 { font-family: ' . $headings_font_family . ' !important; }
        h4 { font-family: ' . $headings_font_family . ' !important; }
        h5 { font-family: ' . $headings_font_family . ' !important; }
        h6 { font-family: ' . $headings_font_family . ' !important; }
        
        /* Elementor specific heading selectors */
        .elementor-widget-heading .elementor-heading-title,
        .elementor-widget-text-editor h1,
        .elementor-widget-text-editor h2,
        .elementor-widget-text-editor h3,
        .elementor-widget-text-editor h4,
        .elementor-widget-text-editor h5,
        .elementor-widget-text-editor h6 {
            font-family: ' . $headings_font_family . ' !important;
        }
        
        /* Exclude all icon elements from font inheritance */
        i, .fas, .far, .fab, .fa,
        [class*="fa-"],
        [class*="fas-"],
        [class*="far-"],
        [class*="fab-"],
        .menu-item i,
        .social ul li i,
        .skill_boxes i,
        .content_boxs i,
        .post_meta i,
        .skill_blog_link_info_share .social i,
        .woocommerce-loop-product__title i,
        .elementor-icon i,
        .elementor-widget-icon i,
        .elementor-widget-icon .fas,
        .elementor-widget-icon .far,
        .elementor-widget-icon .fab,
        .elementor-widget-icon .fa,
        .elementor-widget-icon [class*="fa-"],
        .elementor-widget-icon [class*="fas-"],
        .elementor-widget-icon [class*="far-"],
        .elementor-widget-icon [class*="fab-"],
        .elementor-widget-icon [class*="fa-"],
        .woocommerce-payment-method__icon,
        .woocommerce-payment-method__icon img,
        .woocommerce-payment-method__icon svg,
        .woocommerce-payment-method__icon i,
        .woocommerce-payment-method__icon .fas,
        .woocommerce-payment-method__icon .far,
        .woocommerce-payment-method__icon .fab,
        .woocommerce-payment-method__icon .fa,
        .woocommerce-payment-method__icon [class*="fa-"],
        .woocommerce-payment-method__icon [class*="fas-"],
        .woocommerce-payment-method__icon [class*="far-"],
        .woocommerce-payment-method__icon [class*="fab-"],
        .woocommerce-payment-method__icon [class*="fa-"] {
            font-family: "Font Awesome 5 Free", "Font Awesome 5 Brands", "Font Awesome 5 Regular", "FontAwesome" !important;
        }
        
        /* Additional specific exclusions for icons */
        .menu ul li,
        .my_avatar p,
        .links a,
        .links span,
        .information .personal h6,
        .number_project #count1,
        .number_project #count2,
        .number_project #count3,
        .services span,
        .skill_box p,
        .pricing_box h6,
        .pricing_box ins,
        .pricing_box h5,
        .skill_order a,
        .avatar .name,
        .comment_skill,
        .title_job,
        .title_job span,
        .language h5,
        .content_project span,
        .content_box del,
        .content_box ins,
        .content_box span,
        .content_box p,
        .content_box a,
        .content_box i,
        .skill_cat,
        .post_meta span,
        .post_meta span a,
        .breadcrumbs,
        .skill_links-back .breadcrumbs a,
        .desc_single p,
        .desc_single ul li,
        .label_post a,
        .content_boxs span,
        .content_boxs p,
        .content_boxs a,
        .content_boxs,
        .project-details-list,
        .woocommerce-loop-product__title,
        .variations > tbody > tr > th.label,
        .product_meta,
        .woocommerce table.shop_attributes,
        footer p {
            font-family: ' . $body_font_family . ' !important;
        }
        
        /* Apply headings font to specific heading elements */
        .my_avatar h4,
        .info_about_us h1,
        .info_about_us h1 span,
        .skill_box h5,
        .content_box h5,
        .info_post h1,
        .content_boxs h5,
        .project-title,
        .categories-title,
        .project-category-badge,
        .woocommerce-Tabs-panel--description h2,
        .woocommerce-Tabs-panel--additional_information h2,
        .woocommerce #reviews #comments h2,
        section.up-sells.upsells.products h2 {
            font-family: ' . $headings_font_family . ' !important;
        }
    </style>';
}
// Disabled: fonts are controlled via Elementor only
add_action('wp_head', 'skill_comprehensive_font_application', 25);

// Add a function to force apply Yekan Bakh font if selected
function skill_force_yekanbakh_application() {
    $body_font = get_theme_mod('skill_body_font', 'iranyekan');
    $headings_font = get_theme_mod('skill_headings_font', 'iranyekan');
    
    if ($body_font === 'yekanbakh' || $headings_font === 'yekanbakh') {
        echo '<style id="skill-force-yekanbakh">
            /* Force Yekan Bakh font application - Exclude icons */
            body, p, a, li, td, th, input, textarea, select, button, .button {
                font-family: "Yekan Bakh FaNum", tahoma, sans-serif !important;
            }
            
            /* Apply to div and span but exclude icon containers */
            div:not([class*="icon"]):not([class*="fa-"]):not([class*="fas-"]):not([class*="far-"]):not([class*="fab-"]),
            span:not([class*="icon"]):not([class*="fa-"]):not([class*="fas-"]):not([class*="far-"]):not([class*="fab-"]) {
                font-family: "Yekan Bakh FaNum", tahoma, sans-serif !important;
            }
            
            h1, h2, h3, h4, h5, h6 {
                font-family: "Yekan Bakh FaNum", tahoma, sans-serif !important;
            }
            
            /* Elementor specific */
            .elementor-heading-title,
            .elementor-widget-heading .elementor-heading-title,
            .elementor-text-editor,
            .elementor-widget-text-editor {
                font-family: "Yekan Bakh FaNum", tahoma, sans-serif !important;
            }
            
            /* Exclude all icon elements from font inheritance */
            i, .fas, .far, .fab, .fa,
            [class*="fa-"],
            [class*="fas-"],
            [class*="far-"],
            [class*="fab-"],
            .menu-item i,
            .social ul li i,
            .skill_boxes i,
            .content_boxs i,
            .post_meta i,
            .skill_blog_link_info_share .social i,
            .woocommerce-loop-product__title i,
            .elementor-icon i,
            .elementor-widget-icon i,
            .elementor-widget-icon .fas,
            .elementor-widget-icon .far,
            .elementor-widget-icon .fab,
            .elementor-widget-icon .fa,
            .elementor-widget-icon [class*="fa-"],
            .elementor-widget-icon [class*="fas-"],
            .elementor-widget-icon [class*="far-"],
            .elementor-widget-icon [class*="fab-"],
            .woocommerce-payment-method__icon,
            .woocommerce-payment-method__icon img,
            .woocommerce-payment-method__icon svg,
            .woocommerce-payment-method__icon i,
            .woocommerce-payment-method__icon .fas,
            .woocommerce-payment-method__icon .far,
            .woocommerce-payment-method__icon .fab,
            .woocommerce-payment-method__icon .fa,
            .woocommerce-payment-method__icon [class*="fa-"],
            .woocommerce-payment-method__icon [class*="fas-"],
            .woocommerce-payment-method__icon [class*="far-"],
            .woocommerce-payment-method__icon [class*="fab-"] {
                font-family: "Font Awesome 5 Free", "Font Awesome 5 Brands", "Font Awesome 5 Regular", "FontAwesome" !important;
            }
        </style>';
    }
}
// Disabled: fonts are controlled via Elementor only
add_action('wp_head', 'skill_force_yekanbakh_application', 100);

// Add high-priority font application at the end of head
function skill_high_priority_font_application() {
    $headings_font = get_theme_mod('skill_headings_font', 'iranyekan');
    $body_font = get_theme_mod('skill_body_font', 'iranyekan');
    $font_weight = get_theme_mod('skill_font_weight', '400');
    $headings_font_weight = get_theme_mod('skill_headings_font_weight', '700');
    
    $body_font_family = skill_get_font_family_css($body_font);
    $headings_font_family = skill_get_font_family_css($headings_font);
    
    echo '<style id="skill-high-priority-fonts">
        /* High priority font application for headings */
        h1, h2, h3, h4, h5, h6 {
            font-family: ' . $headings_font_family . ' !important;
        }
        
        /* High priority font application for body text - Exclude icons */
        body, p, a, li, td, th, input, textarea, select, button, .button {
            font-family: ' . $body_font_family . ' !important;
        }
        
        /* Apply to div and span but exclude icon containers */
        div:not([class*="icon"]):not([class*="fa-"]):not([class*="fas-"]):not([class*="far-"]):not([class*="fab-"]),
        span:not([class*="icon"]):not([class*="fa-"]):not([class*="fas-"]):not([class*="far-"]):not([class*="fab-"]) {
            font-family: ' . $body_font_family . ' !important;
        }
        
        /* Elementor specific high priority */
        .elementor-heading-title,
        .elementor-widget-heading .elementor-heading-title {
            font-family: ' . $headings_font_family . ' !important;
        }
        
        .elementor-text-editor,
        .elementor-widget-text-editor {
            font-family: ' . $body_font_family . ' !important;
        }
        
        /* Exclude all icon elements from font inheritance */
        i, .fas, .far, .fab, .fa,
        [class*="fa-"],
        [class*="fas-"],
        [class*="far-"],
        [class*="fab-"],
        .menu-item i,
        .social ul li i,
        .skill_boxes i,
        .content_boxs i,
        .post_meta i,
        .skill_blog_link_info_share .social i,
        .woocommerce-loop-product__title i,
        .elementor-icon i,
        .elementor-widget-icon i,
        .elementor-widget-icon .fas,
        .elementor-widget-icon .far,
        .elementor-widget-icon .fab,
        .elementor-widget-icon .fa,
        .elementor-widget-icon [class*="fa-"],
        .elementor-widget-icon [class*="fas-"],
        .elementor-widget-icon [class*="far-"],
        .elementor-widget-icon [class*="fab-"] {
            font-family: "Font Awesome 5 Free", "Font Awesome 5 Brands", "Font Awesome 5 Regular", "FontAwesome" !important;
        }
    </style>';
}
// Disabled: fonts are controlled via Elementor only
add_action('wp_head', 'skill_high_priority_font_application', 99);

// Add font application at the end of body as well
function skill_footer_font_application() {
    $headings_font = get_theme_mod('skill_headings_font', 'iranyekan');
    $body_font = get_theme_mod('skill_body_font', 'iranyekan');
    $font_weight = get_theme_mod('skill_font_weight', '400');
    $headings_font_weight = get_theme_mod('skill_headings_font_weight', '700');
    
    $body_font_family = skill_get_font_family_css($body_font);
    $headings_font_family = skill_get_font_family_css($headings_font);
    
    echo '<style id="skill-footer-fonts">
        /* Final font application for headings */
        h1, h2, h3, h4, h5, h6 {
            font-family: ' . $headings_font_family . ' !important;
        }
        
        /* Final font application for body text - Exclude icons */
        body, p, a, li, td, th, input, textarea, select, button, .button {
            font-family: ' . $body_font_family . ' !important;
        }
        
        /* Apply to div and span but exclude icon containers */
        div:not([class*="icon"]):not([class*="fa-"]):not([class*="fas-"]):not([class*="far-"]):not([class*="fab-"]),
        span:not([class*="icon"]):not([class*="fa-"]):not([class*="fas-"]):not([class*="far-"]):not([class*="fab-"]) {
            font-family: ' . $body_font_family . ' !important;
        }
        
        /* Exclude all icon elements from font inheritance */
        i, .fas, .far, .fab, .fa,
        [class*="fa-"],
        [class*="fas-"],
        [class*="far-"],
        [class*="fab-"],
        .menu-item i,
        .social ul li i,
        .skill_boxes i,
        .content_boxs i,
        .post_meta i,
        .skill_blog_link_info_share .social i,
        .woocommerce-loop-product__title i,
        .elementor-icon i,
        .elementor-widget-icon i,
        .elementor-widget-icon .fas,
        .elementor-widget-icon .far,
        .elementor-widget-icon .fab,
        .elementor-widget-icon .fa,
        .elementor-widget-icon [class*="fa-"],
        .elementor-widget-icon [class*="fas-"],
        .elementor-widget-icon [class*="far-"],
        .elementor-widget-icon [class*="fab-"] {
            font-family: "Font Awesome 5 Free", "Font Awesome 5 Brands", "Font Awesome 5 Regular", "FontAwesome" !important;
        }
    </style>';
}
// Disabled: fonts are controlled via Elementor only
add_action('wp_footer', 'skill_footer_font_application', 99);

// Add inline styles to ensure fonts are applied
function skill_inline_font_styles() {
    $headings_font = get_theme_mod('skill_headings_font', 'iranyekan');
    $body_font = get_theme_mod('skill_body_font', 'iranyekan');
    $font_weight = get_theme_mod('skill_font_weight', '400');
    $headings_font_weight = get_theme_mod('skill_headings_font_weight', '700');
    
    $body_font_family = skill_get_font_family_css($body_font);
    $headings_font_family = skill_get_font_family_css($headings_font);
    
    echo '<script>
        document.addEventListener("DOMContentLoaded", function() {
            // Apply fonts to headings
            var headings = document.querySelectorAll("h1, h2, h3, h4, h5, h6");
            headings.forEach(function(heading) {
                heading.style.fontFamily = "' . $headings_font_family . '";
                heading.style.fontWeight = "' . $headings_font_weight . '";
            });
            
            // Apply fonts to body text - Exclude icons
            var bodyElements = document.querySelectorAll("body, p, a, li, td, th, input, textarea, select, button, .button");
            bodyElements.forEach(function(element) {
                element.style.fontFamily = "' . $body_font_family . '";
                element.style.fontWeight = "' . $font_weight . '";
            });
            
            // Apply to div and span but exclude icon containers
            var divElements = document.querySelectorAll("div:not([class*=\"icon\"]):not([class*=\"fa-\"]):not([class*=\"fas-\"]):not([class*=\"far-\"]):not([class*=\"fab-\"])");
            divElements.forEach(function(element) {
                element.style.fontFamily = "' . $body_font_family . '";
                element.style.fontWeight = "' . $font_weight . '";
            });
            
            var spanElements = document.querySelectorAll("span:not([class*=\"icon\"]):not([class*=\"fa-\"]):not([class*=\"fas-\"]):not([class*=\"far-\"]):not([class*=\"fab-\"])");
            spanElements.forEach(function(element) {
                element.style.fontFamily = "' . $body_font_family . '";
                element.style.fontWeight = "' . $font_weight . '";
            });
            
            // Ensure icons keep their font
            var iconElements = document.querySelectorAll("i, .fas, .far, .fab, .fa, [class*=\"fa-\"], [class*=\"fas-\"], [class*=\"far-\"], [class*=\"fab-\"]");
            iconElements.forEach(function(element) {
                element.style.fontFamily = "Font Awesome 5 Free, Font Awesome 5 Brands, Font Awesome 5 Regular, FontAwesome";
            });
        });
    </script>';
}
// Disabled: fonts are controlled via Elementor only
add_action('wp_footer', 'skill_inline_font_styles', 100);

// Add a function to ensure icons always have the correct font
function skill_icon_font_protection() {
    echo '<style id="skill-icon-font-protection">
        /* Protect all icon elements from font inheritance */
        i, .fas, .far, .fab, .fa,
        [class*="fa-"],
        [class*="fas-"],
        [class*="far-"],
        [class*="fab-"],
        .menu-item i,
        .social ul li i,
        .skill_boxes i,
        .content_boxs i,
        .post_meta i,
        .skill_blog_link_info_share .social i,
        .woocommerce-loop-product__title i,
        .elementor-icon i,
        .elementor-widget-icon i,
        .elementor-widget-icon .fas,
        .elementor-widget-icon .far,
        .elementor-widget-icon .fab,
        .elementor-widget-icon .fa,
        .elementor-widget-icon [class*="fa-"],
        .elementor-widget-icon [class*="fas-"],
        .elementor-widget-icon [class*="far-"],
        .elementor-widget-icon [class*="fab-"],
        .woocommerce-payment-method__icon,
        .woocommerce-payment-method__icon img,
        .woocommerce-payment-method__icon svg,
        .woocommerce-payment-method__icon i,
        .woocommerce-payment-method__icon .fas,
        .woocommerce-payment-method__icon .far,
        .woocommerce-payment-method__icon .fab,
        .woocommerce-payment-method__icon .fa,
        .woocommerce-payment-method__icon [class*="fa-"],
        .woocommerce-payment-method__icon [class*="fas-"],
        .woocommerce-payment-method__icon [class*="far-"],
        .woocommerce-payment-method__icon [class*="fab-"],
        .eicon,
        [class*="eicon-"],
        .elementor-icon,
        .elementor-widget-icon {
            font-family: "Font Awesome 5 Free", "Font Awesome 5 Brands", "Font Awesome 5 Regular", "FontAwesome", "eicons" !important;
        }
        
        /* Additional protection for specific icon containers */
        .icon,
        .fa-icon,
        .fas-icon,
        .far-icon,
        .fab-icon {
            font-family: "Font Awesome 5 Free", "Font Awesome 5 Brands", "Font Awesome 5 Regular", "FontAwesome", "eicons" !important;
        }
    </style>';
}
// Keep icon protection to avoid icon font issues
// Disabled: Elementor controls fonts
add_action('wp_head', 'skill_icon_font_protection', 999);

// Elementor font override function is defined later in the file

function skill_project_show_related_callback($control) {
    return $control->manager->get_setting('skill_project_show_related')->value();
}

function skill_single_show_related_callback($control) {
    return $control->manager->get_setting('skill_single_show_related')->value();
}

function skill_single_post_styles() {
    echo '<style id="skill-single-post-styles">
        
        .author-box {
            background-color: #f8f9fa;
            border-radius: 8px;
            border: 1px solid #eee;
        }
        
        .author-avatar img {
            border-radius: 50%;
            border: 3px solid #fff;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
               
        .related-posts .card {
            transition: transform 0.3s ease;
            border: none;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }
        
        .related-posts .card:hover {
            transform: translateY(-5px);
        }
        
        .related-posts .card-img-top {
            height: 180px;
            object-fit: cover;
        }
        
        .related-posts .card-title {
            font-size: 1.1rem;
            margin-bottom: 0.75rem;
        }
        
        .related-posts .card-footer {
            background: transparent;
            border-top: none;
        }
    </style>';
}
add_action('wp_head', 'skill_single_post_styles');

function skill_is_custom_preload($control) {
    return 'custom' === $control->manager->get_setting('skill_preload_spinner_type')->value();
}

function skill_preload_implementation() {
    if (!get_theme_mod('skill_enable_preload', true)) {
        return;
    }

    $spinner_type = get_theme_mod('skill_preload_spinner_type', 'circle');
    $spinner_color = get_theme_mod('skill_preload_spinner_color', '#0e59f2');
    $custom_image = get_theme_mod('skill_preload_custom_image', '');
    $duration = get_theme_mod('skill_preload_duration', 2000);
    $resources = get_theme_mod('skill_preload_resources', '');

    echo '<style id="skill-preload-styles">';
    echo '
    .skill-preload-overlay {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: #fff;
        z-index: 9999;
        display: flex;
        justify-content: center;
        align-items: center;
        transition: opacity 0.5s ease;
    }
    body.skill-loaded .skill-preload-overlay {
        opacity: 0;
        pointer-events: none;
    }';

    if ($spinner_type === 'circle') {
        echo '
        .skill-preload-spinner {
            width: 50px;
            height: 50px;
            border: 5px solid #f3f3f3;
            border-top: 5px solid ' . esc_attr($spinner_color) . ';
            border-radius: 50%;
            animation: skill-spin 1s linear infinite;
        }
        @keyframes skill-spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }';
    } elseif ($spinner_type === 'dots') {
        echo '
        .skill-preload-dots {
            display: flex;
            gap: 10px;
        }
        .skill-preload-dots div {
            width: 20px;
            height: 20px;
            border-radius: 50%;
            background: ' . esc_attr($spinner_color) . ';
            animation: skill-bounce 1.4s infinite ease-in-out both;
        }
        .skill-preload-dots div:nth-child(1) {
            animation-delay: -0.32s;
        }
        .skill-preload-dots div:nth-child(2) {
            animation-delay: -0.16s;
        }
        @keyframes skill-bounce {
            0%, 80%, 100% { transform: scale(0); }
            40% { transform: scale(1); }
        }';
    } elseif ($spinner_type === 'bar') {
        echo '
        .skill-preload-bar-container {
            width: 200px;
            height: 10px;
            background: #f3f3f3;
            border-radius: 5px;
            overflow: hidden;
        }
        .skill-preload-bar {
            height: 100%;
            width: 0;
            background: ' . esc_attr($spinner_color) . ';
            animation: skill-progress 2s ease-in-out infinite;
        }
        @keyframes skill-progress {
            0% { width: 0; margin-left: 0; }
            50% { width: 100%; margin-left: 0; }
            100% { width: 0; margin-left: 100%; }
        }';
    }
    echo '</style>';


    ?>
    <script>
        document.addEventListener('DOMContentLoaded', function() {

            var overlay = document.createElement('div');
            overlay.className = 'skill-preload-overlay';

            <?php if ($spinner_type === 'custom' && $custom_image): ?>
            overlay.innerHTML = '<img src="<?php echo esc_url($custom_image); ?>" alt="Loading..." style="max-width: 100px;">';
            <?php elseif ($spinner_type === 'circle'): ?>
            overlay.innerHTML = '<div class="skill-preload-spinner"></div>';
            <?php elseif ($spinner_type === 'dots'): ?>
            overlay.innerHTML = '<div class="skill-preload-dots"><div></div><div></div><div></div></div>';
            <?php elseif ($spinner_type === 'bar'): ?>
            overlay.innerHTML = '<div class="skill-preload-bar-container"><div class="skill-preload-bar"></div></div>';
            <?php endif; ?>

            document.body.appendChild(overlay);


            function preloadResources() {
                <?php

                if (!empty($resources)) {
                    $resources = explode("\n", $resources);
                    foreach ($resources as $resource) {
                        $resource = trim($resource);
                        if (!empty($resource)) {
                            echo "preloadResource('" . esc_js($resource) . "');";
                        }
                    }
                }
                ?>
            }

            function preloadResource(url, as) {
                if (!url) return;

                var link = document.createElement('link');
                link.rel = 'preload';
                link.href = url;
                link.as = as || getResourceType(url);
                document.head.appendChild(link);
            }

            function getResourceType(url) {
                if (url.match(/\.(jpe?g|png|gif|webp|svg)/i)) return 'image';
                if (url.match(/\.(woff2?|ttf|eot)/i)) return 'font';
                if (url.match(/\.js/i)) return 'script';
                if (url.match(/\.css/i)) return 'style';
                return 'fetch';
            }

            preloadResources();

            setTimeout(function() {
                document.body.classList.add('skill-loaded');
                setTimeout(function() {
                    overlay.remove();
                }, 500);
            }, <?php echo absint($duration); ?>);
        });
    </script>
    <?php
}

add_action('wp_head', 'skill_preload_implementation', 1);

//    settings background
function skill_custom_background_css() {
    // Background settings for body
    $background_mode = get_theme_mod('skill_background_mode', 'static');
    $animated_preset = get_theme_mod('skill_animated_gradient_preset', 'aurora');
    $animated_speed = absint(get_theme_mod('skill_animated_gradient_speed', 20));
    $background_image = get_theme_mod('skill_background_image', '');
    $background_color = get_theme_mod('skill_background_color', '#ffffff');
    $background_repeat = get_theme_mod('skill_background_repeat', 'no-repeat');
    $background_size = get_theme_mod('skill_background_size', 'cover');
    $background_position = get_theme_mod('skill_background_position', 'center center');

    // Content background colors
    $content_bg_color = get_theme_mod('skill_content_bg_color', '#ffffff');
    $myinfo_bg_color = get_theme_mod('skill_myinfo_bg_color', '#ffffff');
    $menu_bg_color = get_theme_mod('skill_menu_bg_color', '#ffffff');
    $menu_item_bg_color = get_theme_mod('skill_menu_item_bg_color', '#fbfbfb');
    $menu_item_icon_color = get_theme_mod('skill_menu_item_icons_color', '#464644');
    $menu_item_active_color = get_theme_mod('skill_menu_item_active_color', '#0e59f2');
    $menu_item_tooltip_bg_color = get_theme_mod('skill_menu_item_tooltip_color', '#0e59f2');
    $menu_item_tooltip_color = get_theme_mod('skill_menu_item_tooltip_hover_color', '#ffffff');
    $menu_scrollbar_bg_color = get_theme_mod('skill_scrollbar_color', '#464644');
    $menu_scrollbar_color = get_theme_mod('skill_scrollbar_background_color', '#0e59f2');
    $menu_scrollbar_hover_color = get_theme_mod('skill_scrollbar_hover_color', '#6b6b6b');
    $scrollbar_width = get_theme_mod('skill_scrollbar_width', 5);
    $menu_my_info_color = get_theme_mod('skill_my_info_color', '#0e59f2');
    $menu_my_info_name_color = get_theme_mod('skill_my_info_name_color', '#383838');
    $menu_my_info_links_color = get_theme_mod('skill_my_info_links_color', '#464644');
    $menu_social_border_color = get_theme_mod('skill_social_border_name_color', '#dddddd');
    $menu_social_border_hover_color = get_theme_mod('skill_social_border_hover_color', '#0e59f2');
    $menu_social_color = get_theme_mod('skill_social_color', '#464644');
    $menu_social_hover_icon_color = get_theme_mod('skill_social_hover_icon_color', '#0e59f2');
    $menu_woo_cart_color = get_theme_mod('skill_woo_cart_color', '#ddddddc4');
    $menu_woo_cart_text_color = get_theme_mod('skill_woo_cart_text_color', '#464644');
    $menu_woo_cart_count_color = get_theme_mod('skill_woo_cart_count_color', '#dddddd');
    $menu_cart_count_color = get_theme_mod('skill_cart_count_color', '#464644');
    $menu_woo_cart_hover_color = get_theme_mod('skill_woo_cart_hover_color', '#0e59f2');
    $menu_woo_cart_hover_count_color = get_theme_mod('skill_woo_cart_hover_count_color', '#ffffff');
    $menu_woo_breadcrumb_color = get_theme_mod('skill_woo_breadcrumb_color', '#464644');
    $menu_woo_breadcrumb_hover_color = get_theme_mod('skill_woo_breadcrumb_hover_color', '#0e59f2');
    $menu_woo_title_page_shop_color = get_theme_mod('skill_woo_title_page_shop_color', '#ddddddc4');
    $menu_woo_title_page_color = get_theme_mod('skill_woo_title_page_color', '#464644');
    $menu_woo_result_count_color = get_theme_mod('skill_woo_result_count_color', '#464644');
    $menu_woo_page_numbers_color = get_theme_mod('skill_woo_page_numbers_color', '#dddddd');
    $menu_woo_page_numbers_bg_color = get_theme_mod('skill_woo_page_numbers_bg_color', '#f3f3f3ab');
    $menu_woo_page_numbers_number_color = get_theme_mod('skill_woo_page_numbers_number_color', '#464644');
    $menu_border_title_blog_color = get_theme_mod('skill_border_title_page_blog_color', '#ddddddc4');
    $menu_title_blog_color = get_theme_mod('skill_title_page_blog_color', '#333333');
    $menu_link_article_blog_color = get_theme_mod('skill_link_article_blog_color', '#464644');
    $menu_title_article_blog_color = get_theme_mod('skill_title_article_blog_color', '#464644');
    $menu_border_date_article_blog_color = get_theme_mod('skill_border_date_article_blog_color', '#dddddd');
    $menu_date_article_blog_color = get_theme_mod('skill_date_article_blog_color', '#333333');
    $menu_decs_article_blog_color = get_theme_mod('skill_decs_article_blog_color', '#464644');
    $menu_read_more_hover_article_blog_color = get_theme_mod('skill_read_more_hover_article_blog_color', '#0e59f2');
    $menu_icon_article_blog_color = get_theme_mod('skill_icon_article_blog_color', '#464644');
    $menu_title_project_color = get_theme_mod('skill_title_project_color', '#1e293b');
    $menu_categori_project_color = get_theme_mod('skill_categori_project_color', '#1e293b');
    $menu_title_categori_project_color = get_theme_mod('skill_title_categori_project_color', '#1e293b');
    $menu_border_title_categori_project_color = get_theme_mod('skill_border_title_categori_project_color', '#e2e8f0');
    $menu_border_hover_categori_project_color = get_theme_mod('skill_border_hover_categori_project_color', '#7c3aed');
    $menu_post_title_color = get_theme_mod('skill_post_title_color', '#464644');
    $menu_post_icons_color = get_theme_mod('skill_post_icon_color', '#464644');
    $menu_post_meta_color = get_theme_mod('skill_post_meta_color', '#464644');
    $menu_post_category_color = get_theme_mod('skill_post_category_color', '#464644');
    $menu_post_category_hover_color = get_theme_mod('skill_post_category_hover_color', '#0e59f2');
    $menu_post_breadcrumbs_color = get_theme_mod('skill_post_breadcrumbs_color', '#464644');
    $menu_post_breadcrumbs_links_color = get_theme_mod('skill_post_breadcrumbs_links_color', '#464644');
    $menu_post_breadcrumbs_hover_color = get_theme_mod('skill_post_breadcrumbs_hover_color', '#0e59f2');
    $menu_post_social_share_color = get_theme_mod('skill_post_social_share_color', '#464644');
    $menu_post_tags_label_color = get_theme_mod('skill_post_tags_label_color', '#464644');
    $menu_post_tags_border_color = get_theme_mod('skill_post_tags_border_color', '#ddddddc4');
    $menu_post_tags_color = get_theme_mod('skill_post_tags_color', '#464644');
    $menu_post_tags_hover_border_color = get_theme_mod('skill_post_tags_hover_border_color', '#0e59f2');
    $menu_post_tags_hover_color = get_theme_mod('skill_post_tags_hover_color', '#0e59f2');
    $menu_list_project_color = get_theme_mod('skill_list_project_color', '#1e293b');
    $menu_title_product_shop_color = get_theme_mod('skill_woo_title_product_color', '#464644');
    $menu_product_variable_color = get_theme_mod('skill_woo_product_variable_color', '#464644');
    $menu_product_meta_color = get_theme_mod('skill_woo_product_meta_color', '#464644');
    $menu_product_description_color = get_theme_mod('skill_woo_product_description_color', '#464644');
    $menu_footer_bg_color = get_theme_mod('skill_footer_bg_color', '#f3f3f3');
    $menu_footer_text_color = get_theme_mod('skill_footer_text_color', '#464644');

    echo '<style type="text/css">
        body.bg-skill {
            background-color: '.esc_attr($background_color).';
            
            ::-webkit-scrollbar {
        width: ' . esc_attr($scrollbar_width) . 'px;
        }
            ';


    if ($background_mode === 'animated_gradient') {
        $gradient = '';
        $bg_size = '400% 400%';
        switch ($animated_preset) {
            case 'neon':
                $gradient = 'linear-gradient(135deg, #00f5d4, #00bbf9, #f15bb5, #fee440, #00f5d4)';
                $bg_size = '500% 500%';
                break;
            case 'sunset':
                $gradient = 'linear-gradient(135deg, #ff7e5f, #feb47b, #ff416c, #ff4b2b)';
                break;
            case 'ocean':
                $gradient = 'linear-gradient(135deg, #00c6ff, #0072ff, #00f5d4)';
                break;
            case 'pastel':
                $gradient = 'linear-gradient(135deg, #fbc2eb 0%, #a6c1ee 100%)';
                $bg_size = '300% 300%';
                break;
            case 'cyber':
                $gradient = 'linear-gradient(135deg, #0f0c29, #302b63, #e70faa)';
                break;
            case 'tropical':
                $gradient = 'linear-gradient(135deg, #00C9FF 0%, #92FE9D 100%)';
                break;
            case 'midnight':
                $gradient = 'linear-gradient(135deg, #232526, #414345, #141E30, #243B55)';
                break;
            case 'sunrise':
                $gradient = 'linear-gradient(135deg, #ff512f, #f09819, #f953c6, #b91d73)';
                break;
            case 'lava':
                $gradient = 'radial-gradient(circle at 20% 20%, #ff6a00 0%, transparent 60%), radial-gradient(circle at 80% 30%, #ee0979 0%, transparent 55%), radial-gradient(circle at 50% 80%, #ff6a88 0%, transparent 55%), linear-gradient(120deg, #1f1c2c, #928dab)';
                $bg_size = '200% 200%';
                break;
            case 'prism':
                $gradient = 'linear-gradient(135deg, #12c2e9, #c471ed, #f64f59)';
                break;
            case 'aurora_blur':
                // Layered blurred blobs on a dark base
                $gradient = 'radial-gradient(1200px 800px at 10% 20%, rgba(0,255,163,0.35) 0%, rgba(0,255,163,0) 60%), radial-gradient(1000px 900px at 85% 10%, rgba(220,31,255,0.35) 0%, rgba(220,31,255,0) 60%), radial-gradient(900px 700px at 50% 95%, rgba(0,194,255,0.35) 0%, rgba(0,194,255,0) 60%), linear-gradient(120deg, #0b1021 0%, #191e39 50%, #0b0f1e 100%)';
                $bg_size = '200% 200%';
                break;
            case 'mesh':
                // Modern mesh gradient
                $gradient = 'radial-gradient(800px 500px at 10% 10%, #ff9a9e 0%, transparent 60%), radial-gradient(800px 600px at 90% 15%, #fad0c4 0%, transparent 60%), radial-gradient(900px 600px at 20% 90%, #a18cd1 0%, transparent 60%), radial-gradient(800px 500px at 85% 85%, #fbc2eb 0%, transparent 60%), linear-gradient(120deg, #1a1a2e, #16213e)';
                $bg_size = '240% 240%';
                break;
            case 'conic':
                // Conic sweep rotation
                $gradient = 'conic-gradient(from 0deg, #12c2e9, #c471ed, #f64f59, #12c2e9)';
                $bg_size = '200% 200%';
                break;
            case 'wave':
                // Layered waves with soft colors
                $gradient = 'radial-gradient(1000px 600px at 0% 50%, rgba(0,153,255,0.35) 0%, rgba(0,153,255,0) 60%), radial-gradient(900px 600px at 100% 50%, rgba(255,20,147,0.35) 0%, rgba(255,20,147,0) 60%), linear-gradient(135deg, #0f2027, #203a43, #2c5364)';
                $bg_size = '300% 300%';
                break;
            case 'grid_neon':
                // Neon grid illusion via repeating linear gradients
                $gradient = 'repeating-linear-gradient(0deg, rgba(255,255,255,0.05) 0px, rgba(255,255,255,0.05) 1px, transparent 1px, transparent 50px), repeating-linear-gradient(90deg, rgba(255,255,255,0.05) 0px, rgba(255,255,255,0.05) 1px, transparent 1px, transparent 50px), radial-gradient(1200px 800px at 20% 20%, rgba(0,245,212,0.2) 0%, transparent 60%), radial-gradient(1200px 800px at 80% 20%, rgba(220,31,255,0.2) 0%, transparent 60%), linear-gradient(120deg, #0a0f1f, #111a3a)';
                $bg_size = '200% 200%';
                break;
            case 'plasma':
                // Vivid plasma field
                $gradient = 'radial-gradient(900px 700px at 30% 20%, rgba(255,0,128,0.35) 0%, rgba(255,0,128,0) 60%), radial-gradient(900px 700px at 70% 80%, rgba(0,255,200,0.35) 0%, rgba(0,255,200,0) 60%), radial-gradient(900px 700px at 80% 25%, rgba(0,120,255,0.35) 0%, rgba(0,120,255,0) 60%), linear-gradient(120deg, #0b0014, #1a0b2e 50%, #00131a)';
                $bg_size = '260% 260%';
                break;
            case 'aurora':
            default:
                $gradient = 'radial-gradient(circle at 10% 20%, #00FFA3 0%, transparent 60%), radial-gradient(circle at 90% 10%, #DC1FFF 0%, transparent 60%), radial-gradient(circle at 50% 90%, #00C2FF 0%, transparent 60%), radial-gradient(circle at 80% 70%, #FFD300 0%, transparent 55%), linear-gradient(120deg, #0f0c29 0%, #302b63 50%, #24243e 100%)';
                $bg_size = '220% 220%';
                break;
        }

        echo '
            background-image: ' . $gradient . ';
            background-repeat: no-repeat;
            background-attachment: fixed;
            background-size: ' . $bg_size . ';
            background-position: 0% 50%;
            animation: ' . ( in_array($animated_preset, array('conic','grid_neon')) ? 'skillRotate' : 'skillGradientShift' ) . ' ' . ( $animated_speed > 0 ? esc_attr($animated_speed) : 20 ) . 's ' . ( $animated_preset === 'grid_neon' ? 'linear' : 'ease' ) . ' infinite;
        ';
    } elseif ($background_image) {
        echo '
            background-image: url("'.esc_url($background_image).'");
            background-repeat: '.esc_attr($background_repeat).';
            background-size: '.esc_attr($background_size).';
            background-position: '.esc_attr($background_position).';';
    }

    echo '}' . ( $background_mode === 'animated_gradient' ? '
        @keyframes skillGradientShift {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }
        @keyframes skillRotate {
            0% { background-position: 50% 50%; transform: rotate(0deg); }
            100% { background-position: 50% 50%; transform: rotate(360deg); }
        }
    ' : '' ) . '
        
        .skill_content {
            background-color: '.esc_attr($content_bg_color).' !important;
        }
        
        .my_info {
            background-color: '.esc_attr($myinfo_bg_color).' !important;
        }
        
        .menu {
            background-color: '.esc_attr($menu_bg_color).' !important;
        }
        
        .menu-item {
            background-color: '.esc_attr($menu_item_bg_color).' !important;
        }
        
        .menu-item i {
            color: '.esc_attr($menu_item_icon_color).' !important;
        }
        
        .menu-item:hover i {
            color: '.esc_attr($menu_item_active_color).' !important;
        }
        
        .menu-item.active i {
            color: '.esc_attr($menu_item_active_color).' !important;
        }
        
        .mouse-follow-tooltip {
            background-color: '.esc_attr($menu_item_tooltip_bg_color).' !important;
        }
        
        .mouse-follow-tooltip {
            color: '.esc_attr($menu_item_tooltip_color).' !important;
        }
        
        ::-webkit-scrollbar-track {
            background-color: '.esc_attr($menu_scrollbar_bg_color).' !important;
        }
        
        ::-webkit-scrollbar-thumb {
            background-color: '.esc_attr($menu_scrollbar_color).' !important;
        }
        
        ::-webkit-scrollbar-thumb:hover {
            background-color: '.esc_attr($menu_scrollbar_hover_color).' !important;
        }
        
        .my_avatar p {
            color: '.esc_attr($menu_my_info_color).' !important;
        }
        
        .my_avatar h4 {
            color: '.esc_attr($menu_my_info_name_color).' !important;
        }
        
        .links a {
            color: '.esc_attr($menu_my_info_links_color).' !important;
        }
        
        .social ul li i {
            border-color: '.esc_attr($menu_social_border_color).' !important;
        }
        
        .social ul li:hover i {
            border-color: '.esc_attr($menu_social_border_hover_color).' !important;
        }
        
        .social ul li i {
            color: '.esc_attr($menu_social_color ).' !important;
        }
        
        .social ul li:hover i {
            color: '.esc_attr($menu_social_hover_icon_color ).' !important;
        }
        
        .skill_cart {
            border-color: '.esc_attr($menu_woo_cart_color ).' !important;
        }
        
        .skill_cart {
            color: '.esc_attr($menu_woo_cart_text_color ).' !important;
        }
        
        .skill_cart span.cart_count {
            background-color: '.esc_attr($menu_woo_cart_count_color ).' !important;
        }
        
        .skill_cart span.cart_count {
            color: '.esc_attr($menu_cart_count_color ).' !important;
        }
        
        .skill_cart:hover {
            border-color: '.esc_attr($menu_woo_cart_hover_color ).' !important;
        }
        
        .skill_cart:hover .cart_count {
            background-color: '.esc_attr($menu_woo_cart_hover_color ).' !important;
        }
        
        .skill_cart:hover .cart_count {
            color: '.esc_attr($menu_woo_cart_hover_count_color ).' !important;
        }
        
        .woocommerce .woocommerce-breadcrumb {
            color: '.esc_attr($menu_woo_breadcrumb_color ).' !important;
        }
        
        .woocommerce-breadcrumb a {
            color: '.esc_attr($menu_woo_breadcrumb_color ).' !important;
        }
        
        .woocommerce-breadcrumb a:hover {
            color: '.esc_attr($menu_woo_breadcrumb_hover_color).' !important;
        }
        
        .page-title {
            border-color: '.esc_attr($menu_woo_title_page_shop_color).' !important;
            color: '.esc_attr($menu_woo_title_page_color).' !important;
        }
        
        .woocommerce .woocommerce-result-count {           
            color: '.esc_attr($menu_woo_result_count_color).' !important;
        }
        
        .page-numbers {           
            border-color: '.esc_attr($menu_woo_page_numbers_color).' !important;
        }
        
        .page-numbers span {           
            background-color: '.esc_attr($menu_woo_page_numbers_bg_color).' !important;
            color: '.esc_attr($menu_woo_page_numbers_number_color).' !important;
        }
        
        .services span {           
            border-color: '.esc_attr($menu_border_title_blog_color).' !important;
            color: '.esc_attr($menu_title_blog_color).' !important;
        }
        
        .content_boxs h5 {           
            color: '.esc_attr($menu_title_article_blog_color).' !important;
        }
        
        .content_boxs a {           
            color: '.esc_attr($menu_link_article_blog_color).' !important;
        }
        
        .content_boxs span {           
            border-color: '.esc_attr($menu_border_date_article_blog_color).' !important;
            color: '.esc_attr($menu_date_article_blog_color).' !important;
        }
        
        .content_boxs p {           
            color: '.esc_attr($menu_decs_article_blog_color).' !important;
        }
        
        .container_boxe .boxes:hover .content_boxs a {           
            color: '.esc_attr($menu_read_more_hover_article_blog_color).' !important;
        }
        
        .container_boxe .boxes:hover .content_boxs a i {           
            color: '.esc_attr($menu_read_more_hover_article_blog_color).' !important;
        }
        
        .content_boxs i {           
            color: '.esc_attr($menu_icon_article_blog_color).' !important;
        }
        
        .project-title {           
            color: '.esc_attr($menu_title_project_color).' !important;
        }
        
        .categories-title {           
            color: '.esc_attr($menu_categori_project_color).' !important;
        }
        
        .project-category-badge {           
            color: '.esc_attr($menu_title_categori_project_color).' !important;
            border-color: '.esc_attr($menu_border_title_categori_project_color).' !important;
        }
        
        .project-category-badge:hover {           
            border-color: '.esc_attr($menu_border_hover_categori_project_color).' !important;
        }
        
        .info_post h1 {           
            color: '.esc_attr($menu_post_title_color).' !important;
        }
        
        .post_meta i {           
            color: '.esc_attr($menu_post_icons_color).' !important;
        }
        
        .post_meta span {           
            color: '.esc_attr($menu_post_meta_color).' !important;
        }
        
        .post_meta span a {           
            color: '.esc_attr($menu_post_category_color).' !important;
        }
        
        .post_meta span a:hover {           
            color: '.esc_attr($menu_post_category_hover_color).' !important;
        }
        
        .breadcrumbs {           
            color: '.esc_attr($menu_post_breadcrumbs_color).' !important;
        }
        
        .skill_links-back .breadcrumbs a {           
            color: '.esc_attr($menu_post_breadcrumbs_links_color).' !important;
        }
        
        .skill_links-back .breadcrumbs a:hover {           
            color: '.esc_attr($menu_post_breadcrumbs_hover_color).' !important;
        }
        
        .skill_blog_link_info_share .social span {           
            color: '.esc_attr($menu_post_social_share_color).' !important;
        }
        
        .label_post {           
            color: '.esc_attr($menu_post_tags_label_color).' !important;
        }
        
        .label_post a {           
            border-color: '.esc_attr($menu_post_tags_border_color).' !important;
            color: '.esc_attr($menu_post_tags_color).' !important;
        }
        
        .label_post a:hover {           
            border-color: '.esc_attr($menu_post_tags_hover_border_color).' !important;
            color: '.esc_attr($menu_post_tags_hover_color).' !important;
        }
        
        .project-details-list {           
            color: '.esc_attr($menu_list_project_color).' !important;
        }
        
        .woocommerce-loop-product__title {           
            color: '.esc_attr($menu_title_product_shop_color).' !important;
        }
        
        .variations > tbody > tr > th.label {           
            color: '.esc_attr($menu_product_variable_color).' !important;
        }
        
        .product_meta {           
            color: '.esc_attr($menu_product_meta_color).' !important;
        }
        
        .woocommerce-Tabs-panel--description h2, section.related.products h2,
        .woocommerce-Tabs-panel--additional_information h2,
        .woocommerce table.shop_attributes,
        .woocommerce #reviews #comments h2,
        section.up-sells.upsells.products h2 {           
            color: '.esc_attr($menu_product_description_color).' !important;
        }
        
        footer {           
            background-color: '.esc_attr($menu_footer_bg_color).' !important;
        }
        
        footer p {           
            color: '.esc_attr($menu_footer_text_color).' !important;
        }
    </style>';
}

add_action('wp_head', 'skill_custom_background_css');

// Active callbacks for Customizer controls
function skill_is_animated_gradient_selected() {
    return get_theme_mod('skill_background_mode', 'static') === 'animated_gradient';
}

function skill_is_static_background_selected() {
    return get_theme_mod('skill_background_mode', 'static') === 'static';
}
//    end settings background

add_action('customize_register', 'skill_theme_options');

// Apply theme font ONLY to sidebar area (kept isolated from Elementor)
function skill_sidebar_font_styles() {
    $body_font = get_theme_mod('skill_body_font', 'iranyekan');
    $font_weight = get_theme_mod('skill_font_weight', '400');
    $body_font_family = skill_get_font_family_css($body_font);

    echo '<style id="skill-sidebar-font-styles">'
        . '.my_info, .my_info p, .my_info a, .my_info span, .my_info li, .my_info div {'
        . ' font-family: ' . $body_font_family . ' !important;'
        . ' }'
        // Protect icons in sidebar from font override
        . '.my_info i, .my_info .fa, .my_info .fas, .my_info .far, .my_info .fab, .my_info [class*="fa-"], .my_info .eicon, .my_info [class*="eicon-"] {'
        . ' font-family: "Font Awesome 5 Free", "Font Awesome 5 Brands", "Font Awesome 5 Regular", "FontAwesome", "eicons" !important;'
        . ' }'
        . '</style>';
}
add_action('wp_head', 'skill_sidebar_font_styles', 30);

function skill_elementor_font_override() {
    $primary_font = get_theme_mod('skill_primary_font', 'iranyekan');
    $headings_font = get_theme_mod('skill_headings_font', 'iranyekan');
    $body_font = get_theme_mod('skill_body_font', 'iranyekan');
    $font_weight = get_theme_mod('skill_font_weight', '400');
    $headings_font_weight = get_theme_mod('skill_headings_font_weight', '700');
    
    $body_font_family = skill_get_font_family_css($body_font);
    $headings_font_family = skill_get_font_family_css($headings_font);
    
    echo '<style id="skill-elementor-font-override">
        /* Comprehensive Elementor font application */
        
        /* Apply body font to all Elementor text elements */
        .elementor-widget-container,
        .elementor-text-editor,
        .elementor-text-editor *:not(i[class*="fa"]):not(i[class*="fas"]):not(i[class*="far"]):not(i[class*="fab"]):not([class*="fa-"]):not([class*="fas-"]):not([class*="far-"]):not([class*="fab-"]),
        .elementor-widget-text-editor,
        .elementor-button-text,
        .elementor-button,
        .elementor-widget-text-editor p,
        .elementor-widget-text-editor span:not([class*="fa"]):not([class*="fas"]):not([class*="far"]):not([class*="fab"]),
        .elementor-widget-text-editor div:not([class*="fa"]):not([class*="fas"]):not([class*="far"]):not([class*="fab"]),
        .elementor-widget-text-editor a,
        .elementor-widget-text-editor li,
        .elementor-widget-text-editor strong,
        .elementor-widget-text-editor b,
        .elementor-widget-text-editor em,
        .elementor-widget-text-editor blockquote,
        .elementor-widget-text-editor blockquote *:not(i[class*="fa"]):not(i[class*="fas"]):not(i[class*="far"]):not(i[class*="fab"]),
        .elementor-widget-text-editor ul,
        .elementor-widget-text-editor ul *:not(i[class*="fa"]):not(i[class*="fas"]):not(i[class*="far"]):not(i[class*="fab"]),
        .elementor-widget-text-editor ol,
        .elementor-widget-text-editor ol *:not(i[class*="fa"]):not(i[class*="fas"]):not(i[class*="far"]):not(i[class*="fab"]),
        .elementor-widget-text-editor table,
        .elementor-widget-text-editor table *:not(i[class*="fa"]):not(i[class*="fas"]):not(i[class*="far"]):not(i[class*="fab"]),
        .elementor-widget-text-editor .elementor-text-editor,
        .elementor-widget-text-editor .elementor-text-editor *:not(i[class*="fa"]):not(i[class*="fas"]):not(i[class*="far"]):not(i[class*="fab"]) {
            font-family: ' . $body_font_family . ' !important;
        }
        
        /* Apply headings font to Elementor headings */
        .elementor-heading-title,
        .elementor-widget-heading .elementor-heading-title,
        .elementor-widget-text-editor h1,
        .elementor-widget-text-editor h2,
        .elementor-widget-text-editor h3,
        .elementor-widget-text-editor h4,
        .elementor-widget-text-editor h5,
        .elementor-widget-text-editor h6,
        .elementor-widget-text-editor .elementor-heading-title,
        .elementor-widget-text-editor .elementor-heading-title * {
            font-family: ' . $headings_font_family . ' !important;
        }
        
        /* Maximum specificity for Elementor elements */
        html body .elementor-widget-container,
        html body .elementor-text-editor,
        html body .elementor-text-editor *:not(i[class*="fa"]):not(i[class*="fas"]):not(i[class*="far"]):not(i[class*="fab"]):not([class*="fa-"]):not([class*="fas-"]):not([class*="far-"]):not([class*="fab-"]),
        html body .elementor-heading-title,
        html body .elementor-widget-text-editor,
        html body .elementor-widget-heading,
        html body .elementor-button-text,
        html body .elementor-button {
            font-family: ' . $body_font_family . ' !important;
        }
        
        html body .elementor-heading-title,
        html body .elementor-widget-heading .elementor-heading-title,
        html body .elementor-widget-text-editor h1,
        html body .elementor-widget-text-editor h2,
        html body .elementor-widget-text-editor h3,
        html body .elementor-widget-text-editor h4,
        html body .elementor-widget-text-editor h5,
        html body .elementor-widget-text-editor h6 {
            font-family: ' . $headings_font_family . ' !important;
        }
        
        /* Ultra-specific Elementor heading selectors to override Elementor styles */
        html body .elementor .elementor-widget-heading .elementor-heading-title,
        html body .elementor .elementor-widget-text-editor h1,
        html body .elementor .elementor-widget-text-editor h2,
        html body .elementor .elementor-widget-text-editor h3,
        html body .elementor .elementor-widget-text-editor h4,
        html body .elementor .elementor-widget-text-editor h5,
        html body .elementor .elementor-widget-text-editor h6,
        html body .elementor-widget-heading .elementor-heading-title,
        html body .elementor-widget-text-editor h1,
        html body .elementor-widget-text-editor h2,
        html body .elementor-widget-text-editor h3,
        html body .elementor-widget-text-editor h4,
        html body .elementor-widget-text-editor h5,
        html body .elementor-widget-text-editor h6,
        html body .elementor-text-editor h1,
        html body .elementor-text-editor h2,
        html body .elementor-text-editor h3,
        html body .elementor-text-editor h4,
        html body .elementor-text-editor h5,
        html body .elementor-text-editor h6 {
            font-family: ' . $headings_font_family . ' !important;
        }
        
        /* Protect all icon elements in Elementor */
        .elementor-icon i,
        .elementor-widget-icon i,
        .elementor-widget-icon .fas,
        .elementor-widget-icon .far,
        .elementor-widget-icon .fab,
        .elementor-widget-icon [class*="fa-"],
        .elementor-widget-icon [class*="fas-"],
        .elementor-widget-icon [class*="far-"],
        .elementor-widget-icon [class*="fab-"],
        .elementor-text-editor i[class*="fa"],
        .elementor-text-editor i[class*="fas"],
        .elementor-text-editor i[class*="far"],
        .elementor-text-editor i[class*="fab"],
        .elementor-text-editor [class*="fa-"],
        .elementor-text-editor [class*="fas-"],
        .elementor-text-editor [class*="far-"],
        .elementor-text-editor [class*="fab-"],
        .elementor-widget-text-editor i[class*="fa"],
        .elementor-widget-text-editor i[class*="fas"],
        .elementor-widget-text-editor i[class*="far"],
        .elementor-widget-text-editor i[class*="fab"],
        .elementor-widget-text-editor [class*="fa-"],
        .elementor-widget-text-editor [class*="fas-"],
        .elementor-widget-text-editor [class*="far-"],
        .elementor-widget-text-editor [class*="fab-"],
        .elementor-heading-title i[class*="fa"],
        .elementor-heading-title i[class*="fas"],
        .elementor-heading-title i[class*="far"],
        .elementor-heading-title i[class*="fab"],
        .elementor-heading-title [class*="fa-"],
        .elementor-heading-title [class*="fas-"],
        .elementor-heading-title [class*="far-"],
        .elementor-heading-title [class*="fab-"] {
            font-family: "Font Awesome 5 Free", "Font Awesome 5 Brands", "Font Awesome 5 Regular", "FontAwesome", "eicons" !important;
        }
        
        /* Additional Elementor specific selectors */
        .elementor-widget-text-editor .elementor-text-editor,
        .elementor-widget-text-editor .elementor-text-editor *:not(i[class*="fa"]):not(i[class*="fas"]):not(i[class*="far"]):not(i[class*="fab"]):not([class*="fa-"]):not([class*="fas-"]):not([class*="far-"]):not([class*="fab-"]) {
            font-family: ' . $body_font_family . ' !important;
        }
    </style>';
}
// Disabled: Elementor controls fonts
add_action('wp_head', 'skill_elementor_font_override', 999);

// Add JavaScript to force apply fonts to Elementor elements
function skill_elementor_font_js() {
    $body_font = get_theme_mod('skill_body_font', 'iranyekan');
    $headings_font = get_theme_mod('skill_headings_font', 'iranyekan');
    $font_weight = get_theme_mod('skill_font_weight', '400');
    $headings_font_weight = get_theme_mod('skill_headings_font_weight', '700');
    
    $body_font_family = skill_get_font_family_css($body_font);
    $headings_font_family = skill_get_font_family_css($headings_font);
    
    echo '<script>
        document.addEventListener("DOMContentLoaded", function() {
            // Function to apply fonts to Elementor elements
            function applyElementorFonts() {
                // Apply body font to Elementor text elements
                var elementorTextElements = document.querySelectorAll(".elementor-widget-container, .elementor-text-editor, .elementor-widget-text-editor");
                elementorTextElements.forEach(function(element) {
                    var textElements = element.querySelectorAll("p, span, div, a, li, strong, b, em, blockquote, ul, ol, table");
                    textElements.forEach(function(textElement) {
                        // Skip if it\'s an icon
                        if (!textElement.classList.contains("fa") && 
                            !textElement.classList.contains("fas") && 
                            !textElement.classList.contains("far") && 
                            !textElement.classList.contains("fab") &&
                            !textElement.className.includes("fa-") &&
                            !textElement.className.includes("fas-") &&
                            !textElement.className.includes("far-") &&
                            !textElement.className.includes("fab-")) {
                            textElement.style.fontFamily = "' . $body_font_family . '";
                            textElement.style.fontWeight = "' . $font_weight . '";
                        }
                    });
                });
                
                // Apply headings font to Elementor headings with maximum specificity
                var elementorHeadings = document.querySelectorAll(".elementor-heading-title, .elementor-widget-heading .elementor-heading-title, .elementor .elementor-widget-heading .elementor-heading-title");
                elementorHeadings.forEach(function(heading) {
                    heading.style.fontFamily = "' . $headings_font_family . '";
                    heading.style.fontWeight = "' . $headings_font_weight . '";
                });
                
                // Apply headings font to h1-h6 in Elementor text editor with maximum specificity
                var elementorTextHeadings = document.querySelectorAll(".elementor-widget-text-editor h1, .elementor-widget-text-editor h2, .elementor-widget-text-editor h3, .elementor-widget-text-editor h4, .elementor-widget-text-editor h5, .elementor-widget-text-editor h6, .elementor .elementor-widget-text-editor h1, .elementor .elementor-widget-text-editor h2, .elementor .elementor-widget-text-editor h3, .elementor .elementor-widget-text-editor h4, .elementor .elementor-widget-text-editor h5, .elementor .elementor-widget-text-editor h6, .elementor-text-editor h1, .elementor-text-editor h2, .elementor-text-editor h3, .elementor-text-editor h4, .elementor-text-editor h5, .elementor-text-editor h6");
                elementorTextHeadings.forEach(function(heading) {
                    heading.style.fontFamily = "' . $headings_font_family . '";
                    heading.style.fontWeight = "' . $headings_font_weight . '";
                });
                
                // Force apply to any remaining Elementor headings
                var allElementorHeadings = document.querySelectorAll(".elementor h1, .elementor h2, .elementor h3, .elementor h4, .elementor h5, .elementor h6");
                allElementorHeadings.forEach(function(heading) {
                    heading.style.fontFamily = "' . $headings_font_family . '";
                    heading.style.fontWeight = "' . $headings_font_weight . '";
                });
            }
            
            // Apply fonts immediately
            applyElementorFonts();
            
            // Apply fonts after a short delay to catch dynamically loaded content
            setTimeout(applyElementorFonts, 100);
            setTimeout(applyElementorFonts, 500);
            setTimeout(applyElementorFonts, 1000);
            
            // Apply fonts when Elementor frontend is ready
            if (typeof elementorFrontend !== "undefined") {
                elementorFrontend.hooks.addAction("frontend/element_ready/global", function() {
                    setTimeout(applyElementorFonts, 100);
                });
            }
            
            // Apply fonts more frequently to catch all Elementor content
            setInterval(applyElementorFonts, 2000);
        });
    </script>';
}
// Disabled: Elementor controls fonts
add_action('wp_footer', 'skill_elementor_font_js', 999);

// Add additional JavaScript specifically for Elementor headings
function skill_elementor_headings_js() {
    $headings_font = get_theme_mod('skill_headings_font', 'iranyekan');
    $headings_font_weight = get_theme_mod('skill_headings_font_weight', '700');
    $headings_font_family = skill_get_font_family_css($headings_font);
    
    echo '<script>
        document.addEventListener("DOMContentLoaded", function() {
            function applyElementorHeadingsFont() {
                // Target all possible Elementor heading selectors
                var headingSelectors = [
                    ".elementor-heading-title",
                    ".elementor-widget-heading .elementor-heading-title", 
                    ".elementor .elementor-widget-heading .elementor-heading-title",
                    ".elementor-widget-text-editor h1",
                    ".elementor-widget-text-editor h2", 
                    ".elementor-widget-text-editor h3",
                    ".elementor-widget-text-editor h4",
                    ".elementor-widget-text-editor h5",
                    ".elementor-widget-text-editor h6",
                    ".elementor .elementor-widget-text-editor h1",
                    ".elementor .elementor-widget-text-editor h2",
                    ".elementor .elementor-widget-text-editor h3", 
                    ".elementor .elementor-widget-text-editor h4",
                    ".elementor .elementor-widget-text-editor h5",
                    ".elementor .elementor-widget-text-editor h6",
                    ".elementor-text-editor h1",
                    ".elementor-text-editor h2",
                    ".elementor-text-editor h3",
                    ".elementor-text-editor h4", 
                    ".elementor-text-editor h5",
                    ".elementor-text-editor h6",
                    ".elementor h1",
                    ".elementor h2",
                    ".elementor h3",
                    ".elementor h4",
                    ".elementor h5", 
                    ".elementor h6"
                ];
                
                headingSelectors.forEach(function(selector) {
                    var headings = document.querySelectorAll(selector);
                    headings.forEach(function(heading) {
                        heading.style.fontFamily = "' . $headings_font_family . '";
                        heading.style.fontWeight = "' . $headings_font_weight . '";
                    });
                });
            }
            
            // Apply immediately
            applyElementorHeadingsFont();
            
            // Apply with delays
            setTimeout(applyElementorHeadingsFont, 100);
            setTimeout(applyElementorHeadingsFont, 500);
            setTimeout(applyElementorHeadingsFont, 1000);
            setTimeout(applyElementorHeadingsFont, 2000);
            
            // Apply continuously
            setInterval(applyElementorHeadingsFont, 3000);
            
            // Apply when Elementor content changes
            if (typeof elementorFrontend !== "undefined") {
                elementorFrontend.hooks.addAction("frontend/element_ready/global", function() {
                    setTimeout(applyElementorHeadingsFont, 100);
                });
            }
        });
    </script>';
}
// Disabled: Elementor controls fonts
add_action('wp_footer', 'skill_elementor_headings_js', 1000);
add_action('wp_footer', 'skill_elementor_font_js', 999);

// Add ultimate JavaScript function for Elementor fonts
function skill_elementor_ultimate_js() {
    $body_font = get_theme_mod('skill_body_font', 'iranyekan');
    $headings_font = get_theme_mod('skill_headings_font', 'iranyekan');
    $font_weight = get_theme_mod('skill_font_weight', '400');
    $headings_font_weight = get_theme_mod('skill_headings_font_weight', '700');
    
    $body_font_family = skill_get_font_family_css($body_font);
    $headings_font_family = skill_get_font_family_css($headings_font);
    
    echo '<script>
        (function() {
            function applyUltimateElementorFonts() {
                // Apply body font to all Elementor elements
                var allElementorElements = document.querySelectorAll(".elementor *");
                allElementorElements.forEach(function(element) {
                    // Skip if it\'s an icon
                    if (!element.classList.contains("fa") && 
                        !element.classList.contains("fas") && 
                        !element.classList.contains("far") && 
                        !element.classList.contains("fab") &&
                        !element.className.includes("fa-") &&
                        !element.className.includes("fas-") &&
                        !element.className.includes("far-") &&
                        !element.className.includes("fab-")) {
                        element.style.setProperty("font-family", "' . $body_font_family . '", "important");
                    }
                });
                
                // Apply headings font to all Elementor headings
                var headingSelectors = [
                    ".elementor h1", ".elementor h2", ".elementor h3", 
                    ".elementor h4", ".elementor h5", ".elementor h6",
                    ".elementor .elementor-heading-title",
                    ".elementor .elementor-widget-heading .elementor-heading-title",
                    ".elementor .elementor-widget-text-editor h1",
                    ".elementor .elementor-widget-text-editor h2",
                    ".elementor .elementor-widget-text-editor h3",
                    ".elementor .elementor-widget-text-editor h4",
                    ".elementor .elementor-widget-text-editor h5",
                    ".elementor .elementor-widget-text-editor h6",
                    ".elementor .elementor-text-editor h1",
                    ".elementor .elementor-text-editor h2",
                    ".elementor .elementor-text-editor h3",
                    ".elementor .elementor-text-editor h4",
                    ".elementor .elementor-text-editor h5",
                    ".elementor .elementor-text-editor h6"
                ];
                
                headingSelectors.forEach(function(selector) {
                    var headings = document.querySelectorAll(selector);
                    headings.forEach(function(heading) {
                        heading.style.setProperty("font-family", "' . $headings_font_family . '", "important");
                    });
                });
                
                // Ensure icons keep their font
                var iconElements = document.querySelectorAll(".elementor i[class*=\"fa\"], .elementor i[class*=\"fas\"], .elementor i[class*=\"far\"], .elementor i[class*=\"fab\"], .elementor [class*=\"fa-\"], .elementor [class*=\"fas-\"], .elementor [class*=\"far-\"], .elementor [class*=\"fab-\"]");
                iconElements.forEach(function(icon) {
                    icon.style.setProperty("font-family", "Font Awesome 5 Free, Font Awesome 5 Brands, Font Awesome 5 Regular, FontAwesome, eicons", "important");
                });
            }
            
            // Apply immediately when script loads
            applyUltimateElementorFonts();
            
            // Apply when DOM is ready
            if (document.readyState === "loading") {
                document.addEventListener("DOMContentLoaded", applyUltimateElementorFonts);
            } else {
                applyUltimateElementorFonts();
            }
            
            // Apply with multiple delays
            setTimeout(applyUltimateElementorFonts, 100);
            setTimeout(applyUltimateElementorFonts, 500);
            setTimeout(applyUltimateElementorFonts, 1000);
            setTimeout(applyUltimateElementorFonts, 2000);
            setTimeout(applyUltimateElementorFonts, 5000);
            
            // Apply continuously
            setInterval(applyUltimateElementorFonts, 3000);
            
            // Apply when Elementor frontend is ready
            if (typeof elementorFrontend !== "undefined") {
                elementorFrontend.hooks.addAction("frontend/element_ready/global", function() {
                    setTimeout(applyUltimateElementorFonts, 100);
                });
            }
            
            // Apply on window load
            window.addEventListener("load", applyUltimateElementorFonts);
            
            // Apply on any DOM changes
            var observer = new MutationObserver(function(mutations) {
                mutations.forEach(function(mutation) {
                    if (mutation.type === "childList") {
                        setTimeout(applyUltimateElementorFonts, 100);
                    }
                });
            });
            
            observer.observe(document.body, {
                childList: true,
                subtree: true
            });
        })();
    </script>';
}
// Disabled: Elementor controls fonts
add_action('wp_footer', 'skill_elementor_ultimate_js', 9999);

// Add footer styles with maximum priority
function skill_elementor_footer_styles() {
    $body_font = get_theme_mod('skill_body_font', 'iranyekan');
    $headings_font = get_theme_mod('skill_headings_font', 'iranyekan');
    $font_weight = get_theme_mod('skill_font_weight', '400');
    $headings_font_weight = get_theme_mod('skill_headings_font_weight', '700');
    
    $body_font_family = skill_get_font_family_css($body_font);
    $headings_font_family = skill_get_font_family_css($headings_font);
    
    echo '<style id="skill-elementor-footer-styles">
        /* Footer styles for Elementor with maximum priority */
         {
            font-family: ' . $body_font_family . ' !important;
        }
        
        .elementor h1,
        .elementor h2,
        .elementor h3,
        .elementor h4,
        .elementor h5,
        .elementor h6,
        .elementor .elementor-heading-title,
        .elementor .elementor-widget-heading .elementor-heading-title,
        .elementor .elementor-widget-text-editor h1,
        .elementor .elementor-widget-text-editor h2,
        .elementor .elementor-widget-text-editor h3,
        .elementor .elementor-widget-text-editor h4,
        .elementor .elementor-widget-text-editor h5,
        .elementor .elementor-widget-text-editor h6,
        .elementor .elementor-text-editor h1,
        .elementor .elementor-text-editor h2,
        .elementor .elementor-text-editor h3,
        .elementor .elementor-text-editor h4,
        .elementor .elementor-text-editor h5,
        .elementor .elementor-text-editor h6 {
            font-family: ' . $headings_font_family . ' !important;
        }
        
        /* Protect icons */
        .elementor i[class*="fa"],
        .elementor i[class*="fas"],
        .elementor i[class*="far"],
        .elementor i[class*="fab"],
        .elementor [class*="fa-"],
        .elementor [class*="fas-"],
        .elementor [class*="far-"],
        .elementor [class*="fab-"] {
            font-family: "Font Awesome 5 Free", "Font Awesome 5 Brands", "Font Awesome 5 Regular", "FontAwesome", "eicons" !important;
        }
    </style>';
}
// Disabled: Elementor controls fonts
add_action('wp_footer', 'skill_elementor_footer_styles', 99999);

// Add footer styles with maximum priority
function skill_elementor_footer_styles_ultimate() {
    $body_font = get_theme_mod('skill_body_font', 'iranyekan');
    $headings_font = get_theme_mod('skill_headings_font', 'iranyekan');
    $font_weight = get_theme_mod('skill_font_weight', '400');
    $headings_font_weight = get_theme_mod('skill_headings_font_weight', '700');
    
    $body_font_family = skill_get_font_family_css($body_font);
    $headings_font_family = skill_get_font_family_css($headings_font);
    
    echo '<style id="skill-elementor-footer-styles-ultimate">
        /* Ultimate footer styles for Elementor */
         {
            font-family: ' . $body_font_family . ' !important;
        }
        
        .elementor h1,
        .elementor h2,
        .elementor h3,
        .elementor h4,
        .elementor h5,
        .elementor h6,
        .elementor .elementor-heading-title,
        .elementor .elementor-widget-heading .elementor-heading-title,
        .elementor .elementor-widget-text-editor h1,
        .elementor .elementor-widget-text-editor h2,
        .elementor .elementor-widget-text-editor h3,
        .elementor .elementor-widget-text-editor h4,
        .elementor .elementor-widget-text-editor h5,
        .elementor .elementor-widget-text-editor h6,
        .elementor .elementor-text-editor h1,
        .elementor .elementor-text-editor h2,
        .elementor .elementor-text-editor h3,
        .elementor .elementor-text-editor h4,
        .elementor .elementor-text-editor h5,
        .elementor .elementor-text-editor h6 {
            font-family: ' . $headings_font_family . ' !important;
        }
        
        /* Protect icons */
        .elementor i[class*="fa"],
        .elementor i[class*="fas"],
        .elementor i[class*="far"],
        .elementor i[class*="fab"],
        .elementor [class*="fa-"],
        .elementor [class*="fas-"],
        .elementor [class*="far-"],
        .elementor [class*="fab-"] {
            font-family: "Font Awesome 5 Free", "Font Awesome 5 Brands", "Font Awesome 5 Regular", "FontAwesome", "eicons" !important;
        }
    </style>';
}
// Disabled: Elementor controls fonts
add_action('wp_footer', 'skill_elementor_footer_styles_ultimate', 999999);

// Add footer styles with maximum priority
function skill_elementor_footer_styles_ultimate_final() {
    $body_font = get_theme_mod('skill_body_font', 'iranyekan');
    $headings_font = get_theme_mod('skill_headings_font', 'iranyekan');
    $font_weight = get_theme_mod('skill_font_weight', '400');
    $headings_font_weight = get_theme_mod('skill_headings_font_weight', '700');
    
    $body_font_family = skill_get_font_family_css($body_font);
    $headings_font_family = skill_get_font_family_css($headings_font);
    
    echo '<style id="skill-elementor-footer-styles-ultimate-final">
        /* Ultimate final footer styles for Elementor */
         {
            font-family: ' . $body_font_family . ' !important;
        }
        
        .elementor h1,
        .elementor h2,
        .elementor h3,
        .elementor h4,
        .elementor h5,
        .elementor h6,
        .elementor .elementor-heading-title,
        .elementor .elementor-widget-heading .elementor-heading-title,
        .elementor .elementor-widget-text-editor h1,
        .elementor .elementor-widget-text-editor h2,
        .elementor .elementor-widget-text-editor h3,
        .elementor .elementor-widget-text-editor h4,
        .elementor .elementor-widget-text-editor h5,
        .elementor .elementor-widget-text-editor h6,
        .elementor .elementor-text-editor h1,
        .elementor .elementor-text-editor h2,
        .elementor .elementor-text-editor h3,
        .elementor .elementor-text-editor h4,
        .elementor .elementor-text-editor h5,
        .elementor .elementor-text-editor h6 {
            font-family: ' . $headings_font_family . ' !important;
        }
        
        /* Protect icons */
        .elementor i[class*="fa"],
        .elementor i[class*="fas"],
        .elementor i[class*="far"],
        .elementor i[class*="fab"],
        .elementor [class*="fa-"],
        .elementor [class*="fas-"],
        .elementor [class*="far-"],
        .elementor [class*="fab-"] {
            font-family: "Font Awesome 5 Free", "Font Awesome 5 Brands", "Font Awesome 5 Regular", "FontAwesome", "eicons" !important;
        }
    </style>';
}
// Disabled: Elementor controls fonts
add_action('wp_footer', 'skill_elementor_footer_styles_ultimate_final', 9999999);

// Add footer styles with maximum priority
function skill_elementor_footer_styles_ultimate_final_last() {
    $body_font = get_theme_mod('skill_body_font', 'iranyekan');
    $headings_font = get_theme_mod('skill_headings_font', 'iranyekan');
    $font_weight = get_theme_mod('skill_font_weight', '400');
    $headings_font_weight = get_theme_mod('skill_headings_font_weight', '700');
    
    $body_font_family = skill_get_font_family_css($body_font);
    $headings_font_family = skill_get_font_family_css($headings_font);
    
    echo '<style id="skill-elementor-footer-styles-ultimate-final-last">
        /* Ultimate final last footer styles for Elementor */
         {
            font-family: ' . $body_font_family . ' !important;
        }
        
        .elementor h1,
        .elementor h2,
        .elementor h3,
        .elementor h4,
        .elementor h5,
        .elementor h6,
        .elementor .elementor-heading-title,
        .elementor .elementor-widget-heading .elementor-heading-title,
        .elementor .elementor-widget-text-editor h1,
        .elementor .elementor-widget-text-editor h2,
        .elementor .elementor-widget-text-editor h3,
        .elementor .elementor-widget-text-editor h4,
        .elementor .elementor-widget-text-editor h5,
        .elementor .elementor-widget-text-editor h6,
        .elementor .elementor-text-editor h1,
        .elementor .elementor-text-editor h2,
        .elementor .elementor-text-editor h3,
        .elementor .elementor-text-editor h4,
        .elementor .elementor-text-editor h5,
        .elementor .elementor-text-editor h6 {
            font-family: ' . $headings_font_family . ' !important;
        }
        
        /* Protect icons */
        .elementor i[class*="fa"],
        .elementor i[class*="fas"],
        .elementor i[class*="far"],
        .elementor i[class*="fab"],
        .elementor [class*="fa-"],
        .elementor [class*="fas-"],
        .elementor [class*="far-"],
        .elementor [class*="fab-"] {
            font-family: "Font Awesome 5 Free", "Font Awesome 5 Brands", "Font Awesome 5 Regular", "FontAwesome", "eicons" !important;
        }
    </style>';
}
add_action('wp_footer', 'skill_elementor_footer_styles_ultimate_final_last', 99999999);

// Add footer styles with maximum priority
function skill_elementor_footer_styles_ultimate_final_last_absolute() {
    $body_font = get_theme_mod('skill_body_font', 'iranyekan');
    $headings_font = get_theme_mod('skill_headings_font', 'iranyekan');
    $font_weight = get_theme_mod('skill_font_weight', '400');
    $headings_font_weight = get_theme_mod('skill_headings_font_weight', '700');
    
    $body_font_family = skill_get_font_family_css($body_font);
    $headings_font_family = skill_get_font_family_css($headings_font);
    
    echo '<style id="skill-elementor-footer-styles-ultimate-final-last-absolute">
        /* Ultimate final last absolute footer styles for Elementor */
         {
            font-family: ' . $body_font_family . ' !important;
        }
        
        .elementor h1,
        .elementor h2,
        .elementor h3,
        .elementor h4,
        .elementor h5,
        .elementor h6,
        .elementor .elementor-heading-title,
        .elementor .elementor-widget-heading .elementor-heading-title,
        .elementor .elementor-widget-text-editor h1,
        .elementor .elementor-widget-text-editor h2,
        .elementor .elementor-widget-text-editor h3,
        .elementor .elementor-widget-text-editor h4,
        .elementor .elementor-widget-text-editor h5,
        .elementor .elementor-widget-text-editor h6,
        .elementor .elementor-text-editor h1,
        .elementor .elementor-text-editor h2,
        .elementor .elementor-text-editor h3,
        .elementor .elementor-text-editor h4,
        .elementor .elementor-text-editor h5,
        .elementor .elementor-text-editor h6 {
            font-family: ' . $headings_font_family . ' !important;
        }
        
        /* Protect icons */
        .elementor i[class*="fa"],
        .elementor i[class*="fas"],
        .elementor i[class*="far"],
        .elementor i[class*="fab"],
        .elementor [class*="fa-"],
        .elementor [class*="fas-"],
        .elementor [class*="far-"],
        .elementor [class*="fab-"] {
            font-family: "Font Awesome 5 Free", "Font Awesome 5 Brands", "Font Awesome 5 Regular", "FontAwesome", "eicons" !important;
        }
    </style>';
}
add_action('wp_footer', 'skill_elementor_footer_styles_ultimate_final_last_absolute', 999999999);

// Add footer styles with maximum priority
function skill_elementor_footer_styles_ultimate_final_last_absolute_final() {
    $body_font = get_theme_mod('skill_body_font', 'iranyekan');
    $headings_font = get_theme_mod('skill_headings_font', 'iranyekan');
    $font_weight = get_theme_mod('skill_font_weight', '400');
    $headings_font_weight = get_theme_mod('skill_headings_font_weight', '700');
    
    $body_font_family = skill_get_font_family_css($body_font);
    $headings_font_family = skill_get_font_family_css($headings_font);
    
    echo '<style id="skill-elementor-footer-styles-ultimate-final-last-absolute-final">
        /* Ultimate final last absolute final footer styles for Elementor */
        {
            font-family: ' . $body_font_family . ' !important;
        }
        
        .elementor h1,
        .elementor h2,
        .elementor h3,
        .elementor h4,
        .elementor h5,
        .elementor h6,
        .elementor .elementor-heading-title,
        .elementor .elementor-widget-heading .elementor-heading-title,
        .elementor .elementor-widget-text-editor h1,
        .elementor .elementor-widget-text-editor h2,
        .elementor .elementor-widget-text-editor h3,
        .elementor .elementor-widget-text-editor h4,
        .elementor .elementor-widget-text-editor h5,
        .elementor .elementor-widget-text-editor h6,
        .elementor .elementor-text-editor h1,
        .elementor .elementor-text-editor h2,
        .elementor .elementor-text-editor h3,
        .elementor .elementor-text-editor h4,
        .elementor .elementor-text-editor h5,
        .elementor .elementor-text-editor h6 {
            font-family: ' . $headings_font_family . ' !important;
        }
        
        /* Protect icons */
        .elementor i[class*="fa"],
        .elementor i[class*="fas"],
        .elementor i[class*="far"],
        .elementor i[class*="fab"],
        .elementor [class*="fa-"],
        .elementor [class*="fas-"],
        .elementor [class*="far-"],
        .elementor [class*="fab-"] {
            font-family: "Font Awesome 5 Free", "Font Awesome 5 Brands", "Font Awesome 5 Regular", "FontAwesome", "eicons" !important;
        }
    </style>';
}
add_action('wp_footer', 'skill_elementor_footer_styles_ultimate_final_last_absolute_final', 9999999999);

// Add specific function for Kalameh font with maximum priority
function skill_kalameh_font_ultimate_priority() {
    $headings_font = get_theme_mod('skill_headings_font', 'iranyekan');
    $body_font = get_theme_mod('skill_body_font', 'iranyekan');
    
    // Only apply if Kalameh is selected
    if ($headings_font === 'kalameh' || $body_font === 'kalameh') {
        echo '<style id="skill-kalameh-ultimate-priority">
            /* Ultimate priority for Kalameh font */
             {
                font-family: "KalamehWebFaNum", tahoma, sans-serif !important;
            }
            
            .elementor h1,
            .elementor h2,
            .elementor h3,
            .elementor h4,
            .elementor h5,
            .elementor h6,
            .elementor .elementor-heading-title,
            .elementor .elementor-widget-heading .elementor-heading-title,
            .elementor .elementor-widget-text-editor h1,
            .elementor .elementor-widget-text-editor h2,
            .elementor .elementor-widget-text-editor h3,
            .elementor .elementor-widget-text-editor h4,
            .elementor .elementor-widget-text-editor h5,
            .elementor .elementor-widget-text-editor h6,
            .elementor .elementor-text-editor h1,
            .elementor .elementor-text-editor h2,
            .elementor .elementor-text-editor h3,
            .elementor .elementor-text-editor h4,
            .elementor .elementor-text-editor h5,
            .elementor .elementor-text-editor h6 {
                font-family: "KalamehWebFaNum", tahoma, sans-serif !important;
            }
            
            /* Protect icons */
            .elementor i[class*="fa"],
            .elementor i[class*="fas"],
            .elementor i[class*="far"],
            .elementor i[class*="fab"],
            .elementor [class*="fa-"],
            .elementor [class*="fas-"],
            .elementor [class*="far-"],
            .elementor [class*="fab-"] {
                font-family: "Font Awesome 5 Free", "Font Awesome 5 Brands", "Font Awesome 5 Regular", "FontAwesome", "eicons" !important;
            }
        </style>';
    }
}
// Disabled: fonts are controlled via Elementor only
add_action('wp_head', 'skill_kalameh_font_ultimate_priority', 99999999999);

// Add JavaScript function specifically for Kalameh font
function skill_kalameh_font_js() {
    $headings_font = get_theme_mod('skill_headings_font', 'iranyekan');
    $body_font = get_theme_mod('skill_body_font', 'iranyekan');
    
    // Only apply if Kalameh is selected
    if ($headings_font === 'kalameh' || $body_font === 'kalameh') {
        echo '<script>
            (function() {
                function applyKalamehFont() {
                    // Apply Kalameh font to all Elementor elements
                    var allElementorElements = document.querySelectorAll(".elementor *");
                    allElementorElements.forEach(function(element) {
                        // Skip if it\'s an icon
                        if (!element.classList.contains("fa") && 
                            !element.classList.contains("fas") && 
                            !element.classList.contains("far") && 
                            !element.classList.contains("fab") &&
                            !element.className.includes("fa-") &&
                            !element.className.includes("fas-") &&
                            !element.className.includes("far-") &&
                            !element.className.includes("fab-")) {
                            element.style.setProperty("font-family", "KalamehWebFaNum, tahoma, sans-serif", "important");
                        }
                    });
                    
                    // Apply Kalameh font to all Elementor headings
                    var headingSelectors = [
                        ".elementor h1", ".elementor h2", ".elementor h3", 
                        ".elementor h4", ".elementor h5", ".elementor h6",
                        ".elementor .elementor-heading-title",
                        ".elementor .elementor-widget-heading .elementor-heading-title",
                        ".elementor .elementor-widget-text-editor h1",
                        ".elementor .elementor-widget-text-editor h2",
                        ".elementor .elementor-widget-text-editor h3",
                        ".elementor .elementor-widget-text-editor h4",
                        ".elementor .elementor-widget-text-editor h5",
                        ".elementor .elementor-widget-text-editor h6",
                        ".elementor .elementor-text-editor h1",
                        ".elementor .elementor-text-editor h2",
                        ".elementor .elementor-text-editor h3",
                        ".elementor .elementor-text-editor h4",
                        ".elementor .elementor-text-editor h5",
                        ".elementor .elementor-text-editor h6"
                    ];
                    
                    headingSelectors.forEach(function(selector) {
                        var headings = document.querySelectorAll(selector);
                        headings.forEach(function(heading) {
                            heading.style.setProperty("font-family", "KalamehWebFaNum, tahoma, sans-serif", "important");
                        });
                    });
                    
                    // Ensure icons keep their font
                    var iconElements = document.querySelectorAll(".elementor i[class*=\"fa\"], .elementor i[class*=\"fas\"], .elementor i[class*=\"far\"], .elementor i[class*=\"fab\"], .elementor [class*=\"fa-\"], .elementor [class*=\"fas-\"], .elementor [class*=\"far-\"], .elementor [class*=\"fab-\"]");
                    iconElements.forEach(function(icon) {
                        icon.style.setProperty("font-family", "Font Awesome 5 Free, Font Awesome 5 Brands, Font Awesome 5 Regular, FontAwesome, eicons", "important");
                    });
                }
                
                // Apply immediately when script loads
                applyKalamehFont();
                
                // Apply when DOM is ready
                if (document.readyState === "loading") {
                    document.addEventListener("DOMContentLoaded", applyKalamehFont);
                } else {
                    applyKalamehFont();
                }
                
                // Apply with multiple delays
                setTimeout(applyKalamehFont, 100);
                setTimeout(applyKalamehFont, 500);
                setTimeout(applyKalamehFont, 1000);
                setTimeout(applyKalamehFont, 2000);
                setTimeout(applyKalamehFont, 5000);
                
                // Apply continuously
                setInterval(applyKalamehFont, 3000);
                
                // Apply when Elementor frontend is ready
                if (typeof elementorFrontend !== "undefined") {
                    elementorFrontend.hooks.addAction("frontend/element_ready/global", function() {
                        setTimeout(applyKalamehFont, 100);
                    });
                }
                
                // Apply on window load
                window.addEventListener("load", applyKalamehFont);
                
                // Apply on any DOM changes
                var observer = new MutationObserver(function(mutations) {
                    mutations.forEach(function(mutation) {
                        if (mutation.type === "childList") {
                            setTimeout(applyKalamehFont, 100);
                        }
                    });
                });
                
                observer.observe(document.body, {
                    childList: true,
                    subtree: true
                });
            })();
        </script>';
    }
}
// Disabled: fonts are controlled via Elementor only
add_action('wp_footer', 'skill_kalameh_font_js', 99999999999);

// Add footer styles specifically for Kalameh font
function skill_kalameh_font_footer_styles() {
    $headings_font = get_theme_mod('skill_headings_font', 'iranyekan');
    $body_font = get_theme_mod('skill_body_font', 'iranyekan');
    
    // Only apply if Kalameh is selected
    if ($headings_font === 'kalameh' || $body_font === 'kalameh') {
        echo '<style id="skill-kalameh-footer-styles">
            /* Footer styles for Kalameh font with maximum priority */
             {
                font-family: "KalamehWebFaNum", tahoma, sans-serif !important;
            }
            
            .elementor h1,
            .elementor h2,
            .elementor h3,
            .elementor h4,
            .elementor h5,
            .elementor h6,
            .elementor .elementor-heading-title,
            .elementor .elementor-widget-heading .elementor-heading-title,
            .elementor .elementor-widget-text-editor h1,
            .elementor .elementor-widget-text-editor h2,
            .elementor .elementor-widget-text-editor h3,
            .elementor .elementor-widget-text-editor h4,
            .elementor .elementor-widget-text-editor h5,
            .elementor .elementor-widget-text-editor h6,
            .elementor .elementor-text-editor h1,
            .elementor .elementor-text-editor h2,
            .elementor .elementor-text-editor h3,
            .elementor .elementor-text-editor h4,
            .elementor .elementor-text-editor h5,
            .elementor .elementor-text-editor h6 {
                font-family: "KalamehWebFaNum", tahoma, sans-serif !important;
            }
            
            /* Protect icons */
            .elementor i[class*="fa"],
            .elementor i[class*="fas"],
            .elementor i[class*="far"],
            .elementor i[class*="fab"],
            .elementor [class*="fa-"],
            .elementor [class*="fas-"],
            .elementor [class*="far-"],
            .elementor [class*="fab-"] {
                font-family: "Font Awesome 5 Free", "Font Awesome 5 Brands", "Font Awesome 5 Regular", "FontAwesome", "eicons" !important;
            }
        </style>';
    }
}
// Disabled: fonts are controlled via Elementor only
add_action('wp_footer', 'skill_kalameh_font_footer_styles', 999999999999);

// Add head styles specifically for Kalameh font
function skill_kalameh_font_head_styles() {
    $headings_font = get_theme_mod('skill_headings_font', 'iranyekan');
    $body_font = get_theme_mod('skill_body_font', 'iranyekan');
    
    // Only apply if Kalameh is selected
    if ($headings_font === 'kalameh' || $body_font === 'kalameh') {
        echo '<style id="skill-kalameh-head-styles">
            /* Head styles for Kalameh font with maximum priority */
             {
                font-family: "KalamehWebFaNum", tahoma, sans-serif !important;
            }
            
            .elementor h1,
            .elementor h2,
            .elementor h3,
            .elementor h4,
            .elementor h5,
            .elementor h6,
            .elementor .elementor-heading-title,
            .elementor .elementor-widget-heading .elementor-heading-title,
            .elementor .elementor-widget-text-editor h1,
            .elementor .elementor-widget-text-editor h2,
            .elementor .elementor-widget-text-editor h3,
            .elementor .elementor-widget-text-editor h4,
            .elementor .elementor-widget-text-editor h5,
            .elementor .elementor-widget-text-editor h6,
            .elementor .elementor-text-editor h1,
            .elementor .elementor-text-editor h2,
            .elementor .elementor-text-editor h3,
            .elementor .elementor-text-editor h4,
            .elementor .elementor-text-editor h5,
            .elementor .elementor-text-editor h6 {
                font-family: "KalamehWebFaNum", tahoma, sans-serif !important;
            }
            
            /* Protect icons */
            .elementor i[class*="fa"],
            .elementor i[class*="fas"],
            .elementor i[class*="far"],
            .elementor i[class*="fab"],
            .elementor [class*="fa-"],
            .elementor [class*="fas-"],
            .elementor [class*="far-"],
            .elementor [class*="fab-"] {
                font-family: "Font Awesome 5 Free", "Font Awesome 5 Brands", "Font Awesome 5 Regular", "FontAwesome", "eicons" !important;
            }
        </style>';
    }
}
// Disabled: fonts are controlled via Elementor only
add_action('wp_head', 'skill_kalameh_font_head_styles', 9999999999999);

// Add footer styles specifically for Kalameh font with ultimate priority
function skill_kalameh_font_footer_styles_ultimate() {
    $headings_font = get_theme_mod('skill_headings_font', 'iranyekan');
    $body_font = get_theme_mod('skill_body_font', 'iranyekan');
    
    // Only apply if Kalameh is selected
    if ($headings_font === 'kalameh' || $body_font === 'kalameh') {
        echo '<style id="skill-kalameh-footer-styles-ultimate">
            /* Ultimate footer styles for Kalameh font */
             {
                font-family: "KalamehWebFaNum", tahoma, sans-serif !important;
            }
            
            .elementor h1,
            .elementor h2,
            .elementor h3,
            .elementor h4,
            .elementor h5,
            .elementor h6,
            .elementor .elementor-heading-title,
            .elementor .elementor-widget-heading .elementor-heading-title,
            .elementor .elementor-widget-text-editor h1,
            .elementor .elementor-widget-text-editor h2,
            .elementor .elementor-widget-text-editor h3,
            .elementor .elementor-widget-text-editor h4,
            .elementor .elementor-widget-text-editor h5,
            .elementor .elementor-widget-text-editor h6,
            .elementor .elementor-text-editor h1,
            .elementor .elementor-text-editor h2,
            .elementor .elementor-text-editor h3,
            .elementor .elementor-text-editor h4,
            .elementor .elementor-text-editor h5,
            .elementor .elementor-text-editor h6 {
                font-family: "KalamehWebFaNum", tahoma, sans-serif !important;
            }
            
            /* Protect icons */
            .elementor i[class*="fa"],
            .elementor i[class*="fas"],
            .elementor i[class*="far"],
            .elementor i[class*="fab"],
            .elementor [class*="fa-"],
            .elementor [class*="fas-"],
            .elementor [class*="far-"],
            .elementor [class*="fab-"] {
                font-family: "Font Awesome 5 Free", "Font Awesome 5 Brands", "Font Awesome 5 Regular", "FontAwesome", "eicons" !important;
            }
        </style>';
    }
}
// Disabled: fonts are controlled via Elementor only
add_action('wp_footer', 'skill_kalameh_font_footer_styles_ultimate', 99999999999999);

// Add head styles specifically for Kalameh font with ultimate priority
function skill_kalameh_font_head_styles_ultimate() {
    $headings_font = get_theme_mod('skill_headings_font', 'iranyekan');
    $body_font = get_theme_mod('skill_body_font', 'iranyekan');
    
    // Only apply if Kalameh is selected
    if ($headings_font === 'kalameh' || $body_font === 'kalameh') {
        echo '<style id="skill-kalameh-head-styles-ultimate">
            /* Ultimate head styles for Kalameh font */
            {
                font-family: "KalamehWebFaNum", tahoma, sans-serif !important;
            }
            
            .elementor h1,
            .elementor h2,
            .elementor h3,
            .elementor h4,
            .elementor h5,
            .elementor h6,
            .elementor .elementor-heading-title,
            .elementor .elementor-widget-heading .elementor-heading-title,
            .elementor .elementor-widget-text-editor h1,
            .elementor .elementor-widget-text-editor h2,
            .elementor .elementor-widget-text-editor h3,
            .elementor .elementor-widget-text-editor h4,
            .elementor .elementor-widget-text-editor h5,
            .elementor .elementor-widget-text-editor h6,
            .elementor .elementor-text-editor h1,
            .elementor .elementor-text-editor h2,
            .elementor .elementor-text-editor h3,
            .elementor .elementor-text-editor h4,
            .elementor .elementor-text-editor h5,
            .elementor .elementor-text-editor h6 {
                font-family: "KalamehWebFaNum", tahoma, sans-serif !important;
            }
            
            /* Protect icons */
            .elementor i[class*="fa"],
            .elementor i[class*="fas"],
            .elementor i[class*="far"],
            .elementor i[class*="fab"],
            .elementor [class*="fa-"],
            .elementor [class*="fas-"],
            .elementor [class*="far-"],
            .elementor [class*="fab-"] {
                font-family: "Font Awesome 5 Free", "Font Awesome 5 Brands", "Font Awesome 5 Regular", "FontAwesome", "eicons" !important;
            }
        </style>';
    }
}
// Disabled: fonts are controlled via Elementor only
add_action('wp_head', 'skill_kalameh_font_head_styles_ultimate', 999999999999999);

// Add ultra-high priority function specifically for Elementor headings
function skill_elementor_headings_ultra_priority() {
    $headings_font = get_theme_mod('skill_headings_font', 'iranyekan');
    $headings_font_weight = get_theme_mod('skill_headings_font_weight', '700');
    $headings_font_family = skill_get_font_family_css($headings_font);
    
    echo '<style id="skill-elementor-headings-ultra-priority">
        /* Ultra-high priority Elementor heading selectors */
        html body .elementor .elementor-widget-heading .elementor-heading-title,
        html body .elementor .elementor-widget-text-editor h1,
        html body .elementor .elementor-widget-text-editor h2,
        html body .elementor .elementor-widget-text-editor h3,
        html body .elementor .elementor-widget-text-editor h4,
        html body .elementor .elementor-widget-text-editor h5,
        html body .elementor .elementor-widget-text-editor h6,
        html body .elementor-widget-heading .elementor-heading-title,
        html body .elementor-widget-text-editor h1,
        html body .elementor-widget-text-editor h2,
        html body .elementor-widget-text-editor h3,
        html body .elementor-widget-text-editor h4,
        html body .elementor-widget-text-editor h5,
        html body .elementor-widget-text-editor h6,
        html body .elementor-text-editor h1,
        html body .elementor-text-editor h2,
        html body .elementor-text-editor h3,
        html body .elementor-text-editor h4,
        html body .elementor-text-editor h5,
        html body .elementor-text-editor h6,
        html body .elementor h1,
        html body .elementor h2,
        html body .elementor h3,
        html body .elementor h4,
        html body .elementor h5,
        html body .elementor h6 {
            font-family: ' . $headings_font_family . ' !important;
        }
    </style>';
}
// Disabled: fonts are controlled via Elementor only
add_action('wp_head', 'skill_elementor_headings_ultra_priority', 1000);

// Add ultimate priority function for Elementor fonts
function skill_elementor_ultimate_font_priority() {
    $body_font = get_theme_mod('skill_body_font', 'iranyekan');
    $headings_font = get_theme_mod('skill_headings_font', 'iranyekan');
    $font_weight = get_theme_mod('skill_font_weight', '400');
    $headings_font_weight = get_theme_mod('skill_headings_font_weight', '700');
    
    $body_font_family = skill_get_font_family_css($body_font);
    $headings_font_family = skill_get_font_family_css($headings_font);
    
    echo '<style id="skill-elementor-ultimate-priority">
        /* Ultimate priority Elementor font application */
         {
            font-family: ' . $body_font_family . ' !important;
        }
        
        /* Ultimate priority for Elementor headings */
        html body .elementor h1,
        html body .elementor h2,
        html body .elementor h3,
        html body .elementor h4,
        html body .elementor h5,
        html body .elementor h6,
        html body .elementor .elementor-heading-title,
        html body .elementor .elementor-widget-heading .elementor-heading-title,
        html body .elementor .elementor-widget-text-editor h1,
        html body .elementor .elementor-widget-text-editor h2,
        html body .elementor .elementor-widget-text-editor h3,
        html body .elementor .elementor-widget-text-editor h4,
        html body .elementor .elementor-widget-text-editor h5,
        html body .elementor .elementor-widget-text-editor h6,
        html body .elementor .elementor-text-editor h1,
        html body .elementor .elementor-text-editor h2,
        html body .elementor .elementor-text-editor h3,
        html body .elementor .elementor-text-editor h4,
        html body .elementor .elementor-text-editor h5,
        html body .elementor .elementor-text-editor h6 {
            font-family: ' . $headings_font_family . ' !important;
        }
        
        /* Protect icons from font inheritance */
        html body .elementor i[class*="fa"],
        html body .elementor i[class*="fas"],
        html body .elementor i[class*="far"],
        html body .elementor i[class*="fab"],
        html body .elementor [class*="fa-"],
        html body .elementor [class*="fas-"],
        html body .elementor [class*="far-"],
        html body .elementor [class*="fab-"],
        html body .elementor .elementor-icon i,
        html body .elementor .elementor-widget-icon i {
            font-family: "Font Awesome 5 Free", "Font Awesome 5 Brands", "Font Awesome 5 Regular", "FontAwesome", "eicons" !important;
        }
    </style>';
}
// Disabled: fonts are controlled via Elementor only
add_action('wp_head', 'skill_elementor_ultimate_font_priority', 9999);

// Add inline styles with maximum priority
function skill_elementor_inline_styles() {
    $body_font = get_theme_mod('skill_body_font', 'iranyekan');
    $headings_font = get_theme_mod('skill_headings_font', 'iranyekan');
    $font_weight = get_theme_mod('skill_font_weight', '400');
    $headings_font_weight = get_theme_mod('skill_headings_font_weight', '700');
    
    $body_font_family = skill_get_font_family_css($body_font);
    $headings_font_family = skill_get_font_family_css($headings_font);
    
    echo '<style id="skill-elementor-inline-styles">
        /* Inline styles for Elementor with maximum priority */
         {
            font-family: ' . $body_font_family . ' !important;
        }
        
        .elementor h1,
        .elementor h2,
        .elementor h3,
        .elementor h4,
        .elementor h5,
        .elementor h6,
        .elementor .elementor-heading-title,
        .elementor .elementor-widget-heading .elementor-heading-title,
        .elementor .elementor-widget-text-editor h1,
        .elementor .elementor-widget-text-editor h2,
        .elementor .elementor-widget-text-editor h3,
        .elementor .elementor-widget-text-editor h4,
        .elementor .elementor-widget-text-editor h5,
        .elementor .elementor-widget-text-editor h6,
        .elementor .elementor-text-editor h1,
        .elementor .elementor-text-editor h2,
        .elementor .elementor-text-editor h3,
        .elementor .elementor-text-editor h4,
        .elementor .elementor-text-editor h5,
        .elementor .elementor-text-editor h6 {
            font-family: ' . $headings_font_family . ' !important;
        }
        
        /* Protect icons */
        .elementor i[class*="fa"],
        .elementor i[class*="fas"],
        .elementor i[class*="far"],
        .elementor i[class*="fab"],
        .elementor [class*="fa-"],
        .elementor [class*="fas-"],
        .elementor [class*="far-"],
        .elementor [class*="fab-"] {
            font-family: "Font Awesome 5 Free", "Font Awesome 5 Brands", "Font Awesome 5 Regular", "FontAwesome", "eicons" !important;
        }
    </style>';
}
// Disabled: fonts are controlled via Elementor only
add_action('wp_head', 'skill_elementor_inline_styles', 99999);

// Add head styles with maximum priority
function skill_elementor_head_styles() {
    $body_font = get_theme_mod('skill_body_font', 'iranyekan');
    $headings_font = get_theme_mod('skill_headings_font', 'iranyekan');
    $font_weight = get_theme_mod('skill_font_weight', '400');
    $headings_font_weight = get_theme_mod('skill_headings_font_weight', '700');
    
    $body_font_family = skill_get_font_family_css($body_font);
    $headings_font_family = skill_get_font_family_css($headings_font);
    
    echo '<style id="skill-elementor-head-styles">
        /* Head styles for Elementor with maximum priority */
         {
            font-family: ' . $body_font_family . ' !important;
        }
        
        .elementor h1,
        .elementor h2,
        .elementor h3,
        .elementor h4,
        .elementor h5,
        .elementor h6,
        .elementor .elementor-heading-title,
        .elementor .elementor-widget-heading .elementor-heading-title,
        .elementor .elementor-widget-text-editor h1,
        .elementor .elementor-widget-text-editor h2,
        .elementor .elementor-widget-text-editor h3,
        .elementor .elementor-widget-text-editor h4,
        .elementor .elementor-widget-text-editor h5,
        .elementor .elementor-widget-text-editor h6,
        .elementor .elementor-text-editor h1,
        .elementor .elementor-text-editor h2,
        .elementor .elementor-text-editor h3,
        .elementor .elementor-text-editor h4,
        .elementor .elementor-text-editor h5,
        .elementor .elementor-text-editor h6 {
            font-family: ' . $headings_font_family . ' !important;
        }
        
        /* Protect icons */
        .elementor i[class*="fa"],
        .elementor i[class*="fas"],
        .elementor i[class*="far"],
        .elementor i[class*="fab"],
        .elementor [class*="fa-"],
        .elementor [class*="fas-"],
        .elementor [class*="far-"],
        .elementor [class*="fab-"] {
            font-family: "Font Awesome 5 Free", "Font Awesome 5 Brands", "Font Awesome 5 Regular", "FontAwesome", "eicons" !important;
        }
    </style>';
}
// Disabled: fonts are controlled via Elementor only
add_action('wp_head', 'skill_elementor_head_styles', 999999);

// Add head styles with maximum priority
function skill_elementor_head_styles_ultimate() {
    $body_font = get_theme_mod('skill_body_font', 'iranyekan');
    $headings_font = get_theme_mod('skill_headings_font', 'iranyekan');
    $font_weight = get_theme_mod('skill_font_weight', '400');
    $headings_font_weight = get_theme_mod('skill_headings_font_weight', '700');
    
    $body_font_family = skill_get_font_family_css($body_font);
    $headings_font_family = skill_get_font_family_css($headings_font);
    
    echo '<style id="skill-elementor-head-styles-ultimate">
        /* Ultimate head styles for Elementor */
         {
            font-family: ' . $body_font_family . ' !important;
        }
        
        .elementor h1,
        .elementor h2,
        .elementor h3,
        .elementor h4,
        .elementor h5,
        .elementor h6,
        .elementor .elementor-heading-title,
        .elementor .elementor-widget-heading .elementor-heading-title,
        .elementor .elementor-widget-text-editor h1,
        .elementor .elementor-widget-text-editor h2,
        .elementor .elementor-widget-text-editor h3,
        .elementor .elementor-widget-text-editor h4,
        .elementor .elementor-widget-text-editor h5,
        .elementor .elementor-widget-text-editor h6,
        .elementor .elementor-text-editor h1,
        .elementor .elementor-text-editor h2,
        .elementor .elementor-text-editor h3,
        .elementor .elementor-text-editor h4,
        .elementor .elementor-text-editor h5,
        .elementor .elementor-text-editor h6 {
            font-family: ' . $headings_font_family . ' !important;
        }
        
        /* Protect icons */
        .elementor i[class*="fa"],
        .elementor i[class*="fas"],
        .elementor i[class*="far"],
        .elementor i[class*="fab"],
        .elementor [class*="fa-"],
        .elementor [class*="fas-"],
        .elementor [class*="far-"],
        .elementor [class*="fab-"] {
            font-family: "Font Awesome 5 Free", "Font Awesome 5 Brands", "Font Awesome 5 Regular", "FontAwesome", "eicons" !important;
        }
    </style>';
}
// Disabled: fonts are controlled via Elementor only
add_action('wp_head', 'skill_elementor_head_styles_ultimate', 9999999);

// Add head styles with maximum priority
function skill_elementor_head_styles_ultimate_final() {
    $body_font = get_theme_mod('skill_body_font', 'iranyekan');
    $headings_font = get_theme_mod('skill_headings_font', 'iranyekan');
    $font_weight = get_theme_mod('skill_font_weight', '400');
    $headings_font_weight = get_theme_mod('skill_headings_font_weight', '700');
    
    $body_font_family = skill_get_font_family_css($body_font);
    $headings_font_family = skill_get_font_family_css($headings_font);
    
    echo '<style id="skill-elementor-head-styles-ultimate-final">
        /* Ultimate final head styles for Elementor */
         {
            font-family: ' . $body_font_family . ' !important;
        }
        
        .elementor h1,
        .elementor h2,
        .elementor h3,
        .elementor h4,
        .elementor h5,
        .elementor h6,
        .elementor .elementor-heading-title,
        .elementor .elementor-widget-heading .elementor-heading-title,
        .elementor .elementor-widget-text-editor h1,
        .elementor .elementor-widget-text-editor h2,
        .elementor .elementor-widget-text-editor h3,
        .elementor .elementor-widget-text-editor h4,
        .elementor .elementor-widget-text-editor h5,
        .elementor .elementor-widget-text-editor h6,
        .elementor .elementor-text-editor h1,
        .elementor .elementor-text-editor h2,
        .elementor .elementor-text-editor h3,
        .elementor .elementor-text-editor h4,
        .elementor .elementor-text-editor h5,
        .elementor .elementor-text-editor h6 {
            font-family: ' . $headings_font_family . ' !important;
        }
        
        /* Protect icons */
        .elementor i[class*="fa"],
        .elementor i[class*="fas"],
        .elementor i[class*="far"],
        .elementor i[class*="fab"],
        .elementor [class*="fa-"],
        .elementor [class*="fas-"],
        .elementor [class*="far-"],
        .elementor [class*="fab-"] {
            font-family: "Font Awesome 5 Free", "Font Awesome 5 Brands", "Font Awesome 5 Regular", "FontAwesome", "eicons" !important;
        }
    </style>';
}
// Disabled: fonts are controlled via Elementor only
add_action('wp_head', 'skill_elementor_head_styles_ultimate_final', 99999999);

// Add head styles with maximum priority
function skill_elementor_head_styles_ultimate_final_last() {
    $body_font = get_theme_mod('skill_body_font', 'iranyekan');
    $headings_font = get_theme_mod('skill_headings_font', 'iranyekan');
    $font_weight = get_theme_mod('skill_font_weight', '400');
    $headings_font_weight = get_theme_mod('skill_headings_font_weight', '700');
    
    $body_font_family = skill_get_font_family_css($body_font);
    $headings_font_family = skill_get_font_family_css($headings_font);
    
    echo '<style id="skill-elementor-head-styles-ultimate-final-last">
        /* Ultimate final last head styles for Elementor */
         {
            font-family: ' . $body_font_family . ' !important;
        }
        
        .elementor h1,
        .elementor h2,
        .elementor h3,
        .elementor h4,
        .elementor h5,
        .elementor h6,
        .elementor .elementor-heading-title,
        .elementor .elementor-widget-heading .elementor-heading-title,
        .elementor .elementor-widget-text-editor h1,
        .elementor .elementor-widget-text-editor h2,
        .elementor .elementor-widget-text-editor h3,
        .elementor .elementor-widget-text-editor h4,
        .elementor .elementor-widget-text-editor h5,
        .elementor .elementor-widget-text-editor h6,
        .elementor .elementor-text-editor h1,
        .elementor .elementor-text-editor h2,
        .elementor .elementor-text-editor h3,
        .elementor .elementor-text-editor h4,
        .elementor .elementor-text-editor h5,
        .elementor .elementor-text-editor h6 {
            font-family: ' . $headings_font_family . ' !important;
        }
        
        /* Protect icons */
        .elementor i[class*="fa"],
        .elementor i[class*="fas"],
        .elementor i[class*="far"],
        .elementor i[class*="fab"],
        .elementor [class*="fa-"],
        .elementor [class*="fas-"],
        .elementor [class*="far-"],
        .elementor [class*="fab-"] {
            font-family: "Font Awesome 5 Free", "Font Awesome 5 Brands", "Font Awesome 5 Regular", "FontAwesome", "eicons" !important;
        }
    </style>';
}
// Disabled: fonts are controlled via Elementor only
add_action('wp_head', 'skill_elementor_head_styles_ultimate_final_last', 999999999);

// Add head styles with maximum priority
function skill_elementor_head_styles_ultimate_final_last_absolute() {
    $body_font = get_theme_mod('skill_body_font', 'iranyekan');
    $headings_font = get_theme_mod('skill_headings_font', 'iranyekan');
    $font_weight = get_theme_mod('skill_font_weight', '400');
    $headings_font_weight = get_theme_mod('skill_headings_font_weight', '700');
    
    $body_font_family = skill_get_font_family_css($body_font);
    $headings_font_family = skill_get_font_family_css($headings_font);
    
    echo '<style id="skill-elementor-head-styles-ultimate-final-last-absolute">
        /* Ultimate final last absolute head styles for Elementor */
         {
            font-family: ' . $body_font_family . ' !important;
        }
        
        .elementor h1,
        .elementor h2,
        .elementor h3,
        .elementor h4,
        .elementor h5,
        .elementor h6,
        .elementor .elementor-heading-title,
        .elementor .elementor-widget-heading .elementor-heading-title,
        .elementor .elementor-widget-text-editor h1,
        .elementor .elementor-widget-text-editor h2,
        .elementor .elementor-widget-text-editor h3,
        .elementor .elementor-widget-text-editor h4,
        .elementor .elementor-widget-text-editor h5,
        .elementor .elementor-widget-text-editor h6,
        .elementor .elementor-text-editor h1,
        .elementor .elementor-text-editor h2,
        .elementor .elementor-text-editor h3,
        .elementor .elementor-text-editor h4,
        .elementor .elementor-text-editor h5,
        .elementor .elementor-text-editor h6 {
            font-family: ' . $headings_font_family . ' !important;
        }
        
        /* Protect icons */
        .elementor i[class*="fa"],
        .elementor i[class*="fas"],
        .elementor i[class*="far"],
        .elementor i[class*="fab"],
        .elementor [class*="fa-"],
        .elementor [class*="fas-"],
        .elementor [class*="far-"],
        .elementor [class*="fab-"] {
            font-family: "Font Awesome 5 Free", "Font Awesome 5 Brands", "Font Awesome 5 Regular", "FontAwesome", "eicons" !important;
        }
    </style>';
}
// Disabled: fonts are controlled via Elementor only
add_action('wp_head', 'skill_elementor_head_styles_ultimate_final_last_absolute', 9999999999);

// Clear Elementor cache when fonts are changed
function skill_clear_elementor_cache_on_font_change() {
    if (class_exists('\Elementor\Plugin')) {
        \Elementor\Plugin::$instance->files_manager->clear_cache();
    }
    
    // Also clear WordPress cache
    if (function_exists('wp_cache_flush')) {
        wp_cache_flush();
    }
    
    // Clear any other caches
    if (function_exists('w3tc_flush_all')) {
        w3tc_flush_all();
    }
    
    if (function_exists('wp_rocket_clean_domain')) {
        wp_rocket_clean_domain();
    }
}

// Hook to clear cache when customizer is saved
function skill_customizer_save_action() {
    skill_clear_elementor_cache_on_font_change();
}
add_action('customize_save_after', 'skill_customizer_save_action');

add_action('customize_register', 'skill_theme_options');

// Apply fonts with maximum priority
function skill_apply_fonts_with_maximum_priority() {
    $primary_font = get_theme_mod('skill_primary_font', 'iranyekan');
    $headings_font = get_theme_mod('skill_headings_font', 'iranyekan');
    $body_font = get_theme_mod('skill_body_font', 'iranyekan');
    $font_weight = get_theme_mod('skill_font_weight', '400');
    $headings_font_weight = get_theme_mod('skill_headings_font_weight', '700');
    
    $body_font_family = skill_get_font_family_css($body_font);
    $headings_font_family = skill_get_font_family_css($headings_font);
    
    echo '<style id="skill-maximum-priority-fonts">
        /* Maximum priority font application for Elementor */
        html body .elementor-widget-container,
        html body .elementor-text-editor,
        html body .elementor-text-editor *:not(i[class*="fa"]):not(i[class*="fas"]):not(i[class*="far"]):not(i[class*="fab"]):not([class*="fa-"]):not([class*="fas-"]):not([class*="far-"]):not([class*="fab-"]),
        html body .elementor-heading-title,
        html body .elementor-widget-text-editor,
        html body .elementor-widget-heading,
        html body .elementor-button-text,
        html body .elementor-button,
        html body .elementor-widget-text-editor p,
        html body .elementor-widget-text-editor span:not([class*="fa"]):not([class*="fas"]):not([class*="far"]):not([class*="fab"]),
        html body .elementor-widget-text-editor div:not([class*="fa"]):not([class*="fas"]):not([class*="far"]):not([class*="fab"]),
        html body .elementor-widget-text-editor a,
        html body .elementor-widget-text-editor li,
        html body .elementor-widget-text-editor strong,
        html body .elementor-widget-text-editor b,
        html body .elementor-widget-text-editor em,
        html body .elementor-widget-text-editor blockquote,
        html body .elementor-widget-text-editor blockquote *:not(i[class*="fa"]):not(i[class*="fas"]):not(i[class*="far"]):not(i[class*="fab"]),
        html body .elementor-widget-text-editor ul,
        html body .elementor-widget-text-editor ul *:not(i[class*="fa"]):not(i[class*="fas"]):not(i[class*="far"]):not(i[class*="fab"]),
        html body .elementor-widget-text-editor ol,
        html body .elementor-widget-text-editor ol *:not(i[class*="fa"]):not(i[class*="fas"]):not(i[class*="far"]):not(i[class*="fab"]),
        html body .elementor-widget-text-editor table,
        html body .elementor-widget-text-editor table *:not(i[class*="fa"]):not(i[class*="fas"]):not(i[class*="far"]):not(i[class*="fab"]),
        html body .elementor-widget-text-editor .elementor-text-editor,
        html body .elementor-widget-text-editor .elementor-text-editor *:not(i[class*="fa"]):not(i[class*="fas"]):not(i[class*="far"]):not(i[class*="fab"]) {
            font-family: ' . $body_font_family . ' !important;
        }
        
        /* Apply headings font to Elementor headings with maximum priority */
        html body .elementor-heading-title,
        html body .elementor-widget-heading .elementor-heading-title,
        html body .elementor-widget-text-editor h1,
        html body .elementor-widget-text-editor h2,
        html body .elementor-widget-text-editor h3,
        html body .elementor-widget-text-editor h4,
        html body .elementor-widget-text-editor h5,
        html body .elementor-widget-text-editor h6,
        html body .elementor-widget-text-editor .elementor-heading-title,
        html body .elementor-widget-text-editor .elementor-heading-title * {
            font-family: ' . $headings_font_family . ' !important;
        }
        
        /* Exclude icons from font inheritance with maximum priority */
        html body .elementor-icon i,
        html body .elementor-widget-icon i,
        html body .elementor-widget-icon .fas,
        html body .elementor-widget-icon .far,
        html body .elementor-widget-icon .fab,
        html body .elementor-widget-icon [class*="fa-"],
        html body .elementor-widget-icon [class*="fas-"],
        html body .elementor-widget-icon [class*="far-"],
        html body .elementor-widget-icon [class*="fab-"],
        html body .elementor-text-editor i[class*="fa"],
        html body .elementor-text-editor i[class*="fas"],
        html body .elementor-text-editor i[class*="far"],
        html body .elementor-text-editor i[class*="fab"],
        html body .elementor-text-editor [class*="fa-"],
        html body .elementor-text-editor [class*="fas-"],
        html body .elementor-text-editor [class*="far-"],
        html body .elementor-text-editor [class*="fab-"] {
            font-family: "Font Awesome 5 Free", "Font Awesome 5 Brands", "Font Awesome 5 Regular", "FontAwesome" !important;
        }
    </style>';
}
// Disabled: fonts are controlled via Elementor only
add_action('wp_head', 'skill_apply_fonts_with_maximum_priority', 1000);

add_action('customize_register', 'skill_theme_options');