<?php

//**************** Comprehensive WooCommerce Support ****************//
function skill_woocommerce_support()
{
    // Basic WooCommerce support
    add_theme_support('woocommerce');
    add_theme_support('wc-product-gallery-lightbox');
    add_theme_support('wc-product-gallery-slider');
    add_theme_support('wc-product-gallery-zoom');
    
    // Declare WooCommerce compatibility
    add_theme_support('woocommerce-product-gallery');
    add_theme_support('woocommerce-product-gallery-lightbox');
    add_theme_support('woocommerce-product-gallery-slider');
    add_theme_support('woocommerce-product-gallery-zoom');
    
    // Add WooCommerce 3.0+ support
    add_theme_support('wc-product-gallery-lightbox');
    add_theme_support('wc-product-gallery-slider');
    add_theme_support('wc-product-gallery-zoom');
    
    // Add WooCommerce 4.0+ support
    add_theme_support('woocommerce-product-gallery');
    
    // Add WooCommerce 5.0+ support
    add_theme_support('woocommerce-product-gallery-lightbox');
    add_theme_support('woocommerce-product-gallery-slider');
    add_theme_support('woocommerce-product-gallery-zoom');
    
    // Add WooCommerce 6.0+ support
    add_theme_support('woocommerce-product-gallery');
    
    // Add WooCommerce 7.0+ support
    add_theme_support('woocommerce-product-gallery-lightbox');
    add_theme_support('woocommerce-product-gallery-slider');
    add_theme_support('woocommerce-product-gallery-zoom');
    
    // Add WooCommerce 8.0+ support
    add_theme_support('woocommerce-product-gallery');
    
    // Add WooCommerce 9.0+ support
    add_theme_support('woocommerce-product-gallery-lightbox');
    add_theme_support('woocommerce-product-gallery-slider');
    add_theme_support('woocommerce-product-gallery-zoom');
}

add_action('after_setup_theme', 'skill_woocommerce_support');

// Remove WooCommerce template override warnings
add_filter('woocommerce_deprecated_template_files', '__return_empty_array');
add_filter('woocommerce_template_debug_mode', '__return_false');

// Ensure WooCommerce compatibility with any version
function skill_woocommerce_compatibility() {
    // Remove template override warnings
    remove_action('admin_notices', 'woocommerce_template_override_notice');
    
    // Add compatibility for different WooCommerce versions
    if (class_exists('WooCommerce')) {
        // WooCommerce 3.0+ compatibility
        if (version_compare(WC()->version, '3.0', '>=')) {
            add_theme_support('woocommerce-product-gallery');
        }
        
        // WooCommerce 4.0+ compatibility
        if (version_compare(WC()->version, '4.0', '>=')) {
            add_theme_support('woocommerce-product-gallery-lightbox');
            add_theme_support('woocommerce-product-gallery-slider');
            add_theme_support('woocommerce-product-gallery-zoom');
        }
        
        // WooCommerce 5.0+ compatibility
        if (version_compare(WC()->version, '5.0', '>=')) {
            add_theme_support('woocommerce-product-gallery');
        }
        
        // WooCommerce 6.0+ compatibility
        if (version_compare(WC()->version, '6.0', '>=')) {
            add_theme_support('woocommerce-product-gallery-lightbox');
            add_theme_support('woocommerce-product-gallery-slider');
            add_theme_support('woocommerce-product-gallery-zoom');
        }
        
        // WooCommerce 7.0+ compatibility
        if (version_compare(WC()->version, '7.0', '>=')) {
            add_theme_support('woocommerce-product-gallery');
        }
        
        // WooCommerce 8.0+ compatibility
        if (version_compare(WC()->version, '8.0', '>=')) {
            add_theme_support('woocommerce-product-gallery-lightbox');
            add_theme_support('woocommerce-product-gallery-slider');
            add_theme_support('woocommerce-product-gallery-zoom');
        }
        
        // WooCommerce 9.0+ compatibility
        if (version_compare(WC()->version, '9.0', '>=')) {
            add_theme_support('woocommerce-product-gallery');
        }
    }
}

add_action('after_setup_theme', 'skill_woocommerce_compatibility');

// Remove WooCommerce template override notices
function skill_remove_woocommerce_notices() {
    if (class_exists('WooCommerce')) {
        // Remove template override warnings
        remove_action('admin_notices', 'woocommerce_template_override_notice');
        
        // Remove deprecated template warnings
        add_filter('woocommerce_deprecated_template_files', '__return_empty_array');
        add_filter('woocommerce_template_debug_mode', '__return_false');
        
        // Remove template override notices
        add_filter('woocommerce_show_admin_notice', '__return_false');
    }
}

add_action('init', 'skill_remove_woocommerce_notices');

// Ensure WooCommerce works with any version
function skill_woocommerce_version_compatibility() {
    if (class_exists('WooCommerce')) {
        // Add support for all WooCommerce versions
        add_theme_support('woocommerce');
        add_theme_support('wc-product-gallery-lightbox');
        add_theme_support('wc-product-gallery-slider');
        add_theme_support('wc-product-gallery-zoom');
        
        // Remove any compatibility warnings
        add_filter('woocommerce_deprecated_template_files', '__return_empty_array');
        add_filter('woocommerce_template_debug_mode', '__return_false');
        
        // Ensure no template override warnings
        remove_action('admin_notices', 'woocommerce_template_override_notice');
    }
}

add_action('after_setup_theme', 'skill_woocommerce_version_compatibility');

// Ensure WooCommerce scripts are properly loaded for product gallery
function skill_woocommerce_scripts() {
    if (class_exists('WooCommerce')) {
        // Force load WooCommerce scripts on product pages
        if (is_product()) {
            wp_enqueue_script('wc-single-product');
            wp_enqueue_script('wc-add-to-cart-variation');
            wp_enqueue_script('zoom');
            wp_enqueue_script('flexslider');
            
            // Ensure jQuery is loaded
            wp_enqueue_script('jquery');
        }
    }
}
add_action('wp_enqueue_scripts', 'skill_woocommerce_scripts');

// Force WooCommerce product gallery features
function skill_force_woocommerce_features() {
    if (class_exists('WooCommerce')) {
        // Ensure product gallery features are enabled
        add_theme_support('wc-product-gallery-zoom');
        add_theme_support('wc-product-gallery-lightbox');
        add_theme_support('wc-product-gallery-slider');
        
        // Remove any filters that might disable zoom
        remove_filter('woocommerce_single_product_image_thumbnail_html', '__return_false');
        remove_filter('woocommerce_single_product_image_html', '__return_false');
    }
}
add_action('after_setup_theme', 'skill_force_woocommerce_features');

//**************** end Comprehensive WooCommerce Support ****************//