<?php
/*
Template Name: post Landing
Template Post Type: post
*/
?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php wp_title('-','true','right'); bloginfo('name'); ?></title>
    <link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/assets/css/all.css">
    <link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/assets/css/swiper-bundle.min.css">
    <link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/assets/css/bootstrap.rtl.min.css">
    <link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/assets/fonts/iranyekan.css">
    <link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/assets/fonts/dana/dana.css">
    <link rel="icon" href="<?php bloginfo('template_url'); ?>/assets/images/icon.png">
    <link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/style.css">
    <link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/assets/css/style.css">
    <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>

<!-- Custom header -->
<?php
$header_id = get_post_meta(get_the_ID(), '_skill_custom_header', true);
if ($header_id) {
    echo '<div class="custom-landing-header">';
    echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display($header_id);
    echo '</div>';
}
?>

<!-- the content -->
<div id="landing-wrapper">
    <?php while (have_posts()) : the_post(); ?>
        <?php the_content(); ?>
    <?php endwhile; ?>
</div>

<!-- Custom footer -->
<?php
$footer_id = get_post_meta(get_the_ID(), '_skill_custom_footer', true);
if ($footer_id) {
    echo '<div class="custom-landing-footer">';
    echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display($footer_id);
    echo '</div>';
}
?>

<script src="<?php bloginfo('template_url'); ?>/assets/js/jquery-3.7.1.min.js"></script>
<script src="<?php bloginfo('template_url'); ?>/assets/js/bootstrap.min.js"></script>
<script src="<?php bloginfo('template_url'); ?>/assets/js/swiper-bundle.min.js"></script>
<script src="<?php bloginfo('template_url'); ?>/assets/js/main.js"></script>
<?php wp_footer(); ?>
</body>
</html>